/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.model.AdaptableList;

public class WizardCollectionElement
extends AdaptableList
implements IPluginContribution {
    private String id;
    private String pluginId;
    private String name;
    private WizardCollectionElement parent;
    private AdaptableList wizards = new AdaptableList();
    static /* synthetic */ Class class$org$eclipse$ui$model$IWorkbenchAdapter;

    public WizardCollectionElement(String id, String pluginId, String name, WizardCollectionElement parent) {
        this.name = name;
        this.id = id;
        this.pluginId = pluginId;
        this.parent = parent;
    }

    public AdaptableList add(IAdaptable a) {
        if (a instanceof WorkbenchWizardElement) {
            this.wizards.add(a);
        } else {
            super.add(a);
        }
        return this;
    }

    public WizardCollectionElement findChildCollection(IPath searchPath) {
        Object[] children = this.getChildren(null);
        String searchString = searchPath.segment(0);
        for (int i = 0; i < children.length; ++i) {
            WizardCollectionElement currentCategory = (WizardCollectionElement)children[i];
            if (!currentCategory.getLabel(null).equals(searchString)) continue;
            if (searchPath.segmentCount() == 1) {
                return currentCategory;
            }
            return currentCategory.findChildCollection(searchPath.removeFirstSegments(1));
        }
        return null;
    }

    public WorkbenchWizardElement findWizard(String searchId, boolean recursive) {
        Object[] wizards = this.getWizards();
        for (int i = 0; i < wizards.length; ++i) {
            WorkbenchWizardElement currentWizard = (WorkbenchWizardElement)wizards[i];
            if (!currentWizard.getID().equals(searchId)) continue;
            return currentWizard;
        }
        if (!recursive) {
            return null;
        }
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            WizardCollectionElement child = (WizardCollectionElement)iterator.next();
            WorkbenchWizardElement result = child.findWizard(searchId, true);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == (class$org$eclipse$ui$model$IWorkbenchAdapter == null ? (class$org$eclipse$ui$model$IWorkbenchAdapter = WizardCollectionElement.class$("org.eclipse.ui.model.IWorkbenchAdapter")) : class$org$eclipse$ui$model$IWorkbenchAdapter)) {
            return this;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String getId() {
        return this.id;
    }

    public String getLabel(Object o) {
        return this.name;
    }

    public Object getParent(Object o) {
        return this.parent;
    }

    public IPath getPath() {
        if (this.parent == null) {
            return new Path("");
        }
        return this.parent.getPath().append(this.name);
    }

    public Object[] getWizards() {
        return this.wizards.getChildren();
    }

    public boolean isEmpty() {
        return this.size() == 0 && this.wizards.size() == 0;
    }

    public void setId(String newId) {
        this.id = newId;
    }

    public void setWizards(AdaptableList value) {
        this.wizards = value;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("WizardCollection, ");
        buf.append(this.children.size());
        buf.append(" children, ");
        buf.append(this.wizards.size());
        buf.append(" wizards");
        return buf.toString();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_FOLDER");
    }

    public boolean fromPlugin() {
        return this.pluginId != null;
    }

    public String getLocalId() {
        return this.getId();
    }

    public String getPluginId() {
        return this.pluginId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

