/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.decorators.OverlayCache;

class DecorationResult {
    private List prefixes;
    private List suffixes;
    private ImageDescriptor[] descriptors;

    DecorationResult(List prefixList, List suffixList, ImageDescriptor[] imageDescriptors) {
        this.prefixes = prefixList;
        this.suffixes = suffixList;
        if (this.hasOverlays(imageDescriptors)) {
            this.descriptors = imageDescriptors;
        }
    }

    private boolean hasOverlays(ImageDescriptor[] imageDescriptors) {
        for (int i = 0; i < imageDescriptors.length; ++i) {
            if (imageDescriptors[i] == null) continue;
            return true;
        }
        return false;
    }

    Image decorateWithOverlays(Image image, OverlayCache overlayCache) {
        if (image == null || this.descriptors == null) {
            return image;
        }
        return overlayCache.applyDescriptors(image, this.descriptors);
    }

    String decorateWithText(String text) {
        if (this.prefixes.isEmpty() && this.suffixes.isEmpty()) {
            return text;
        }
        StringBuffer result = new StringBuffer();
        ListIterator prefixIterator = this.prefixes.listIterator();
        while (prefixIterator.hasNext()) {
            result.append(prefixIterator.next());
        }
        result.append(text);
        ListIterator suffixIterator = this.suffixes.listIterator();
        while (suffixIterator.hasNext()) {
            result.append(suffixIterator.next());
        }
        return result.toString();
    }

    ImageDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    List getPrefixes() {
        return this.prefixes;
    }

    List getSuffixes() {
        return this.suffixes;
    }
}

