/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands.ws;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.CommandEvent;
import org.eclipse.ui.commands.CommandManagerEvent;
import org.eclipse.ui.commands.ICommand;
import org.eclipse.ui.commands.ICommandListener;
import org.eclipse.ui.commands.ICommandManager;
import org.eclipse.ui.commands.ICommandManagerListener;
import org.eclipse.ui.commands.IKeySequenceBinding;
import org.eclipse.ui.commands.NotDefinedException;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.part.ViewPart;

public class CommandsView
extends ViewPart {
    private ICommandListener commandListener = new ICommandListener(){

        public void commandChanged(CommandEvent commandEvent) {
            CommandsView.this.tableViewer.refresh();
        }
    };
    private ICommandManager commandManager;
    private ICommandManagerListener commandManagerListener = new ICommandManagerListener(){

        public void commandManagerChanged(CommandManagerEvent commandManagerEvent) {
            CommandsView.this.tableViewer.refresh();
        }
    };
    private Table table;
    private TableViewer tableViewer;

    public void dispose() {
        this.commandManager.removeCommandManagerListener(this.commandManagerListener);
        this.table.dispose();
    }

    public void createPartControl(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        parent.setLayout((Layout)gridLayout);
        this.table = new Table(parent, 68352);
        this.table.setHeaderVisible(true);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 200;
        this.table.setLayoutData((Object)gridData);
        TableColumn tableColumnId = new TableColumn(this.table, 0, 0);
        tableColumnId.setResizable(true);
        tableColumnId.setText("ID");
        tableColumnId.setWidth(200);
        TableColumn tableColumnName = new TableColumn(this.table, 0, 1);
        tableColumnName.setResizable(true);
        tableColumnName.setText("Name");
        tableColumnName.setWidth(200);
        TableColumn tableColumnKeySequences = new TableColumn(this.table, 0, 2);
        tableColumnKeySequences.setResizable(true);
        tableColumnKeySequences.setText("Key Sequences");
        tableColumnKeySequences.setWidth(200);
        this.commandManager = PlatformUI.getWorkbench().getCommandSupport().getCommandManager();
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new CommandContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new CommandLabelProvider());
        this.tableViewer.setInput(new Object());
        this.commandManager.addCommandManagerListener(this.commandManagerListener);
        this.tableViewer.refresh();
    }

    public void setFocus() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.setFocus();
        }
    }

    private final class CommandLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private CommandLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ICommand command = (ICommand)element;
            if (columnIndex == 0) {
                return command.getId();
            }
            if (columnIndex == 1) {
                try {
                    return command.getName();
                }
                catch (NotDefinedException eNotDefined) {
                    return "<not defined>";
                }
            }
            if (columnIndex == 2) {
                StringBuffer stringBuffer = new StringBuffer();
                List keySequenceBindings = command.getKeySequenceBindings();
                for (int i = 0; i < keySequenceBindings.size(); ++i) {
                    IKeySequenceBinding keySequenceBinding = (IKeySequenceBinding)keySequenceBindings.get(i);
                    KeySequence keySequence = keySequenceBinding.getKeySequence();
                    if (i >= 1) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(keySequence.format());
                }
                return stringBuffer.toString();
            }
            return null;
        }
    }

    private final class CommandContentProvider
    implements IStructuredContentProvider {
        private SortedSet commands = new TreeSet();

        private CommandContentProvider() {
        }

        public void dispose() {
            Iterator iterator = this.commands.iterator();
            while (iterator.hasNext()) {
                ICommand command = (ICommand)iterator.next();
                command.removeCommandListener(CommandsView.this.commandListener);
            }
            this.commands.clear();
        }

        public Object[] getElements(Object inputElement) {
            HashSet definedCommandIds = new HashSet(CommandsView.this.commandManager.getDefinedCommandIds());
            Iterator iterator = this.commands.iterator();
            while (iterator.hasNext()) {
                ICommand command = (ICommand)iterator.next();
                if (definedCommandIds.remove(command.getId())) continue;
                command.removeCommandListener(CommandsView.this.commandListener);
                this.commands.remove(command);
            }
            iterator = definedCommandIds.iterator();
            while (iterator.hasNext()) {
                String commandId = (String)iterator.next();
                ICommand command = CommandsView.this.commandManager.getCommand(commandId);
                command.addCommandListener(CommandsView.this.commandListener);
                this.commands.add(command);
            }
            return this.commands.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

