/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.commands.IHandler;
import org.eclipse.ui.internal.commands.ActiveKeyConfigurationDefinition;
import org.eclipse.ui.internal.commands.CategoryDefinition;
import org.eclipse.ui.internal.commands.CommandDefinition;
import org.eclipse.ui.internal.commands.KeyConfigurationDefinition;
import org.eclipse.ui.internal.commands.KeySequenceBindingDefinition;
import org.eclipse.ui.internal.commands.ws.HandlerProxy;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.keys.KeySequence;
import org.eclipse.ui.keys.KeyStroke;
import org.eclipse.ui.keys.ParseException;
import org.eclipse.ui.keys.SWTKeySupport;

final class Persistence {
    private static Map stringToValueMap = new TreeMap();
    private static final String ALT = "Alt";
    private static final String COMMAND = "Command";
    private static final String CTRL = "Ctrl";
    private static final String MODIFIER_SEPARATOR = "+";
    static final String PACKAGE_BASE = "commands";
    static final String PACKAGE_PREFIX = "org.eclipse.ui";
    static final String PACKAGE_FULL = "org.eclipse.ui.commands";
    private static final String SHIFT = "Shift";
    static final String TAG_ACTIVE_KEY_CONFIGURATION = "activeKeyConfiguration";
    static final String TAG_CATEGORY = "category";
    static final String TAG_CATEGORY_ID = "categoryId";
    static final String TAG_COMMAND = "command";
    static final String TAG_COMMAND_ID = "commandId";
    static final String TAG_CONTEXT_ID = "contextId";
    static final String TAG_DESCRIPTION = "description";
    static final String TAG_HANDLER = "handlerSubmission";
    static final String TAG_ID = "id";
    static final String TAG_KEY_CONFIGURATION = "keyConfiguration";
    static final String TAG_KEY_CONFIGURATION_ID = "keyConfigurationId";
    static final String TAG_KEY_SEQUENCE = "keySequence";
    static final String TAG_KEY_SEQUENCE_BINDING = "keyBinding";
    static final String TAG_LOCALE = "locale";
    static final String TAG_NAME = "name";
    static final String TAG_PARENT_ID = "parentId";
    static final String TAG_PLATFORM = "platform";
    static final String TAG_SOURCE_ID = "sourceId";
    static /* synthetic */ Class class$org$eclipse$ui$internal$commands$ActiveKeyConfigurationDefinition;
    static /* synthetic */ Class class$org$eclipse$ui$internal$commands$CategoryDefinition;
    static /* synthetic */ Class class$org$eclipse$ui$internal$commands$CommandDefinition;
    static /* synthetic */ Class class$org$eclipse$ui$internal$commands$KeyConfigurationDefinition;
    static /* synthetic */ Class class$org$eclipse$ui$internal$commands$KeySequenceBindingDefinition;

    private static KeySequence deprecatedSequenceToKeySequence(int[] sequence) {
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>();
        for (int i = 0; i < sequence.length; ++i) {
            keyStrokes.add(Persistence.deprecatedStrokeToKeyStroke(sequence[i]));
        }
        return KeySequence.getInstance(keyStrokes);
    }

    private static KeyStroke deprecatedStrokeToKeyStroke(int stroke) {
        return SWTKeySupport.convertAcceleratorToKeyStroke(stroke);
    }

    private static int[] parseDeprecatedSequence(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int length = stringTokenizer.countTokens();
        int[] strokes = new int[length];
        for (int i = 0; i < length; ++i) {
            strokes[i] = Persistence.parseDeprecatedStroke(stringTokenizer.nextToken());
        }
        return strokes;
    }

    private static int parseDeprecatedStroke(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, MODIFIER_SEPARATOR, true);
        while (stringTokenizer.hasMoreTokens()) {
            list.add(stringTokenizer.nextToken());
        }
        int size = list.size();
        int value = 0;
        if (size % 2 == 1) {
            String token = (String)list.get(size - 1);
            Integer integer = (Integer)stringToValueMap.get(token.toUpperCase());
            if (integer != null) {
                value = integer;
            } else if (token.length() == 1) {
                value = token.toUpperCase().charAt(0);
            }
            if (value != 0) {
                for (int i = 0; i < size - 1; ++i) {
                    token = (String)list.get(i);
                    if (i % 2 == 0) {
                        if (token.equalsIgnoreCase(CTRL)) {
                            if ((value & 0x40000) != 0) {
                                return 0;
                            }
                            value |= 0x40000;
                            continue;
                        }
                        if (token.equalsIgnoreCase(ALT)) {
                            if ((value & 0x10000) != 0) {
                                return 0;
                            }
                            value |= 0x10000;
                            continue;
                        }
                        if (token.equalsIgnoreCase(SHIFT)) {
                            if ((value & 0x20000) != 0) {
                                return 0;
                            }
                            value |= 0x20000;
                            continue;
                        }
                        if (token.equalsIgnoreCase(COMMAND)) {
                            if ((value & 0x400000) != 0) {
                                return 0;
                            }
                            value |= 0x400000;
                            continue;
                        }
                        return 0;
                    }
                    if (MODIFIER_SEPARATOR.equals(token)) continue;
                    return 0;
                }
            }
        }
        return value;
    }

    static ActiveKeyConfigurationDefinition readActiveKeyConfigurationDefinition(IMemento memento, String sourceIdOverride) {
        String sourceId;
        if (memento == null) {
            throw new NullPointerException();
        }
        String keyConfigurationId = memento.getString(TAG_KEY_CONFIGURATION_ID);
        if (keyConfigurationId == null) {
            keyConfigurationId = memento.getString("value");
        }
        String string = sourceId = sourceIdOverride != null ? sourceIdOverride : memento.getString(TAG_SOURCE_ID);
        if (sourceIdOverride == null && sourceId == null) {
            sourceId = memento.getString("plugin");
        }
        return new ActiveKeyConfigurationDefinition(keyConfigurationId, sourceId);
    }

    static List readActiveKeyConfigurationDefinitions(IMemento memento, String name, String sourceIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<ActiveKeyConfigurationDefinition> list = new ArrayList<ActiveKeyConfigurationDefinition>(mementos.length);
        for (int i = 0; i < mementos.length; ++i) {
            list.add(Persistence.readActiveKeyConfigurationDefinition(mementos[i], sourceIdOverride));
        }
        return list;
    }

    static CategoryDefinition readCategoryDefinition(IMemento memento, String sourceIdOverride) {
        String sourceId;
        if (memento == null) {
            throw new NullPointerException();
        }
        String description = memento.getString(TAG_DESCRIPTION);
        String id = memento.getString(TAG_ID);
        String name = memento.getString(TAG_NAME);
        String string = sourceId = sourceIdOverride != null ? sourceIdOverride : memento.getString(TAG_SOURCE_ID);
        if (sourceIdOverride == null && sourceId == null) {
            sourceId = memento.getString("plugin");
        }
        return new CategoryDefinition(description, id, name, sourceId);
    }

    static List readCategoryDefinitions(IMemento memento, String name, String sourceIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<CategoryDefinition> list = new ArrayList<CategoryDefinition>(mementos.length);
        for (int i = 0; i < mementos.length; ++i) {
            list.add(Persistence.readCategoryDefinition(mementos[i], sourceIdOverride));
        }
        return list;
    }

    static CommandDefinition readCommandDefinition(IMemento memento, String sourceIdOverride) {
        String sourceId;
        if (memento == null) {
            throw new NullPointerException();
        }
        String categoryId = memento.getString(TAG_CATEGORY_ID);
        if (categoryId == null) {
            categoryId = memento.getString(TAG_CATEGORY);
        }
        String description = memento.getString(TAG_DESCRIPTION);
        String id = memento.getString(TAG_ID);
        String name = memento.getString(TAG_NAME);
        String string = sourceId = sourceIdOverride != null ? sourceIdOverride : memento.getString(TAG_SOURCE_ID);
        if (sourceIdOverride == null && sourceId == null) {
            sourceId = memento.getString("plugin");
        }
        return new CommandDefinition(categoryId, description, id, name, sourceId);
    }

    static List readCommandDefinitions(IMemento memento, String name, String sourceIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<CommandDefinition> list = new ArrayList<CommandDefinition>(mementos.length);
        for (int i = 0; i < mementos.length; ++i) {
            list.add(Persistence.readCommandDefinition(mementos[i], sourceIdOverride));
        }
        return list;
    }

    private static int[] readDeprecatedSequence(IMemento memento) {
        if (memento == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren("stroke");
        if (mementos == null) {
            throw new NullPointerException();
        }
        int[] strokes = new int[mementos.length];
        for (int i = 0; i < mementos.length; ++i) {
            strokes[i] = Persistence.readDeprecatedStroke(mementos[i]);
        }
        return strokes;
    }

    private static int readDeprecatedStroke(IMemento memento) {
        if (memento == null) {
            throw new NullPointerException();
        }
        Integer value = memento.getInteger("value");
        return value != null ? value : 0;
    }

    static IHandler readHandlerSubmissionDefinition(IConfigurationElement configurationElement) {
        String commandId = configurationElement.getAttribute(TAG_COMMAND_ID);
        return new HandlerProxy(commandId, configurationElement);
    }

    static KeyConfigurationDefinition readKeyConfigurationDefinition(IMemento memento, String sourceIdOverride) {
        String sourceId;
        if (memento == null) {
            throw new NullPointerException();
        }
        String description = memento.getString(TAG_DESCRIPTION);
        String id = memento.getString(TAG_ID);
        String name = memento.getString(TAG_NAME);
        String parentId = memento.getString(TAG_PARENT_ID);
        if (parentId == null) {
            parentId = memento.getString("parent");
        }
        String string = sourceId = sourceIdOverride != null ? sourceIdOverride : memento.getString(TAG_SOURCE_ID);
        if (sourceIdOverride == null && sourceId == null) {
            sourceId = memento.getString("plugin");
        }
        return new KeyConfigurationDefinition(description, id, name, parentId, sourceId);
    }

    static List readKeyConfigurationDefinitions(IMemento memento, String name, String sourceIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<KeyConfigurationDefinition> list = new ArrayList<KeyConfigurationDefinition>(mementos.length);
        for (int i = 0; i < mementos.length; ++i) {
            list.add(Persistence.readKeyConfigurationDefinition(mementos[i], sourceIdOverride));
        }
        return list;
    }

    static KeySequenceBindingDefinition readKeySequenceBindingDefinition(IMemento memento, String sourceIdOverride) {
        String sourceId;
        String keyConfigurationId;
        String commandId;
        if (memento == null) {
            throw new NullPointerException();
        }
        String contextId = memento.getString(TAG_CONTEXT_ID);
        if (contextId == null) {
            contextId = memento.getString("scope");
        }
        if ("org.eclipse.ui.globalScope".equals(contextId)) {
            contextId = null;
        }
        if ((commandId = memento.getString(TAG_COMMAND_ID)) == null) {
            commandId = memento.getString(TAG_COMMAND);
        }
        if (commandId == null) {
            commandId = memento.getString(TAG_ID);
        }
        if ((keyConfigurationId = memento.getString(TAG_KEY_CONFIGURATION_ID)) == null) {
            keyConfigurationId = memento.getString("configuration");
        }
        KeySequence keySequence = null;
        String keySequenceAsString = memento.getString(TAG_KEY_SEQUENCE);
        if (keySequenceAsString != null) {
            try {
                keySequence = KeySequence.getInstance(keySequenceAsString);
            }
            catch (ParseException eParse) {}
        } else {
            IMemento mementoSequence = memento.getChild("sequence");
            if (mementoSequence != null) {
                keySequence = Persistence.deprecatedSequenceToKeySequence(Persistence.readDeprecatedSequence(mementoSequence));
            } else {
                String string = memento.getString("string");
                if (string != null) {
                    keySequence = Persistence.deprecatedSequenceToKeySequence(Persistence.parseDeprecatedSequence(string));
                }
            }
        }
        String locale = memento.getString(TAG_LOCALE);
        String platform = memento.getString(TAG_PLATFORM);
        String string = sourceId = sourceIdOverride != null ? sourceIdOverride : memento.getString(TAG_SOURCE_ID);
        if (sourceIdOverride == null && sourceId == null) {
            sourceId = memento.getString("plugin");
        }
        if (contextId == null) {
            contextId = "org.eclipse.ui.contexts.window";
        }
        return new KeySequenceBindingDefinition(contextId, commandId, keyConfigurationId, keySequence, locale, platform, sourceId);
    }

    static List readKeySequenceBindingDefinitions(IMemento memento, String name, String sourceIdOverride) {
        if (memento == null || name == null) {
            throw new NullPointerException();
        }
        IMemento[] mementos = memento.getChildren(name);
        if (mementos == null) {
            throw new NullPointerException();
        }
        ArrayList<KeySequenceBindingDefinition> list = new ArrayList<KeySequenceBindingDefinition>(mementos.length);
        for (int i = 0; i < mementos.length; ++i) {
            list.add(Persistence.readKeySequenceBindingDefinition(mementos[i], sourceIdOverride));
        }
        return list;
    }

    static void writeActiveKeyConfigurationDefinition(IMemento memento, ActiveKeyConfigurationDefinition activeKeyConfigurationDefinition) {
        if (memento == null || activeKeyConfigurationDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_KEY_CONFIGURATION_ID, activeKeyConfigurationDefinition.getKeyConfigurationId());
        memento.putString(TAG_SOURCE_ID, activeKeyConfigurationDefinition.getSourceId());
    }

    static void writeActiveKeyConfigurationDefinitions(IMemento memento, String name, List activeKeyConfigurationDefinitions) {
        if (memento == null || name == null || activeKeyConfigurationDefinitions == null) {
            throw new NullPointerException();
        }
        activeKeyConfigurationDefinitions = new ArrayList(activeKeyConfigurationDefinitions);
        Iterator iterator = activeKeyConfigurationDefinitions.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), class$org$eclipse$ui$internal$commands$ActiveKeyConfigurationDefinition == null ? Persistence.class$("org.eclipse.ui.internal.commands.ActiveKeyConfigurationDefinition") : class$org$eclipse$ui$internal$commands$ActiveKeyConfigurationDefinition);
        }
        iterator = activeKeyConfigurationDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeActiveKeyConfigurationDefinition(memento.createChild(name), (ActiveKeyConfigurationDefinition)iterator.next());
        }
    }

    static void writeCategoryDefinition(IMemento memento, CategoryDefinition categoryDefinition) {
        if (memento == null || categoryDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_DESCRIPTION, categoryDefinition.getDescription());
        memento.putString(TAG_ID, categoryDefinition.getId());
        memento.putString(TAG_NAME, categoryDefinition.getName());
        memento.putString(TAG_SOURCE_ID, categoryDefinition.getSourceId());
    }

    static void writeCategoryDefinitions(IMemento memento, String name, List categoryDefinitions) {
        if (memento == null || name == null || categoryDefinitions == null) {
            throw new NullPointerException();
        }
        categoryDefinitions = new ArrayList(categoryDefinitions);
        Iterator iterator = categoryDefinitions.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), class$org$eclipse$ui$internal$commands$CategoryDefinition == null ? Persistence.class$("org.eclipse.ui.internal.commands.CategoryDefinition") : class$org$eclipse$ui$internal$commands$CategoryDefinition);
        }
        iterator = categoryDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeCategoryDefinition(memento.createChild(name), (CategoryDefinition)iterator.next());
        }
    }

    static void writeCommandDefinition(IMemento memento, CommandDefinition commandDefinition) {
        if (memento == null || commandDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_CATEGORY_ID, commandDefinition.getCategoryId());
        memento.putString(TAG_DESCRIPTION, commandDefinition.getDescription());
        memento.putString(TAG_ID, commandDefinition.getId());
        memento.putString(TAG_NAME, commandDefinition.getName());
        memento.putString(TAG_SOURCE_ID, commandDefinition.getSourceId());
    }

    static void writeCommandDefinitions(IMemento memento, String name, List commandDefinitions) {
        if (memento == null || name == null || commandDefinitions == null) {
            throw new NullPointerException();
        }
        commandDefinitions = new ArrayList(commandDefinitions);
        Iterator iterator = commandDefinitions.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), class$org$eclipse$ui$internal$commands$CommandDefinition == null ? Persistence.class$("org.eclipse.ui.internal.commands.CommandDefinition") : class$org$eclipse$ui$internal$commands$CommandDefinition);
        }
        iterator = commandDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeCommandDefinition(memento.createChild(name), (CommandDefinition)iterator.next());
        }
    }

    static void writeKeyConfigurationDefinition(IMemento memento, KeyConfigurationDefinition keyConfigurationDefinition) {
        if (memento == null || keyConfigurationDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_DESCRIPTION, keyConfigurationDefinition.getDescription());
        memento.putString(TAG_ID, keyConfigurationDefinition.getId());
        memento.putString(TAG_NAME, keyConfigurationDefinition.getName());
        memento.putString(TAG_PARENT_ID, keyConfigurationDefinition.getParentId());
        memento.putString(TAG_SOURCE_ID, keyConfigurationDefinition.getSourceId());
    }

    static void writeKeyConfigurationDefinitions(IMemento memento, String name, List keyConfigurationDefinitions) {
        if (memento == null || name == null || keyConfigurationDefinitions == null) {
            throw new NullPointerException();
        }
        keyConfigurationDefinitions = new ArrayList(keyConfigurationDefinitions);
        Iterator iterator = keyConfigurationDefinitions.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), class$org$eclipse$ui$internal$commands$KeyConfigurationDefinition == null ? Persistence.class$("org.eclipse.ui.internal.commands.KeyConfigurationDefinition") : class$org$eclipse$ui$internal$commands$KeyConfigurationDefinition);
        }
        iterator = keyConfigurationDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeKeyConfigurationDefinition(memento.createChild(name), (KeyConfigurationDefinition)iterator.next());
        }
    }

    static void writeKeySequenceBindingDefinition(IMemento memento, KeySequenceBindingDefinition keySequenceBindingDefinition) {
        if (memento == null || keySequenceBindingDefinition == null) {
            throw new NullPointerException();
        }
        memento.putString(TAG_CONTEXT_ID, keySequenceBindingDefinition.getContextId());
        memento.putString(TAG_COMMAND_ID, keySequenceBindingDefinition.getCommandId());
        memento.putString(TAG_KEY_CONFIGURATION_ID, keySequenceBindingDefinition.getKeyConfigurationId());
        memento.putString(TAG_KEY_SEQUENCE, keySequenceBindingDefinition.getKeySequence() != null ? keySequenceBindingDefinition.getKeySequence().toString() : null);
        memento.putString(TAG_LOCALE, keySequenceBindingDefinition.getLocale());
        memento.putString(TAG_PLATFORM, keySequenceBindingDefinition.getPlatform());
        memento.putString(TAG_SOURCE_ID, keySequenceBindingDefinition.getSourceId());
    }

    static void writeKeySequenceBindingDefinitions(IMemento memento, String name, List keySequenceBindingDefinitions) {
        if (memento == null || name == null || keySequenceBindingDefinitions == null) {
            throw new NullPointerException();
        }
        keySequenceBindingDefinitions = new ArrayList(keySequenceBindingDefinitions);
        Iterator iterator = keySequenceBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Util.assertInstance(iterator.next(), class$org$eclipse$ui$internal$commands$KeySequenceBindingDefinition == null ? Persistence.class$("org.eclipse.ui.internal.commands.KeySequenceBindingDefinition") : class$org$eclipse$ui$internal$commands$KeySequenceBindingDefinition);
        }
        iterator = keySequenceBindingDefinitions.iterator();
        while (iterator.hasNext()) {
            Persistence.writeKeySequenceBindingDefinition(memento.createChild(name), (KeySequenceBindingDefinition)iterator.next());
        }
    }

    private Persistence() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        stringToValueMap.put("BACKSPACE", new Integer(8));
        stringToValueMap.put("TAB", new Integer(9));
        stringToValueMap.put("RETURN", new Integer(13));
        stringToValueMap.put("ENTER", new Integer(13));
        stringToValueMap.put("ESCAPE", new Integer(27));
        stringToValueMap.put("ESC", new Integer(27));
        stringToValueMap.put("DELETE", new Integer(127));
        stringToValueMap.put("SPACE", new Integer(32));
        stringToValueMap.put("ARROW_UP", new Integer(0x1000001));
        stringToValueMap.put("ARROW_DOWN", new Integer(0x1000002));
        stringToValueMap.put("ARROW_LEFT", new Integer(0x1000003));
        stringToValueMap.put("ARROW_RIGHT", new Integer(0x1000004));
        stringToValueMap.put("PAGE_UP", new Integer(0x1000005));
        stringToValueMap.put("PAGE_DOWN", new Integer(0x1000006));
        stringToValueMap.put("HOME", new Integer(0x1000007));
        stringToValueMap.put("END", new Integer(0x1000008));
        stringToValueMap.put("INSERT", new Integer(0x1000009));
        stringToValueMap.put("F1", new Integer(0x100000A));
        stringToValueMap.put("F2", new Integer(0x100000B));
        stringToValueMap.put("F3", new Integer(0x100000C));
        stringToValueMap.put("F4", new Integer(0x100000D));
        stringToValueMap.put("F5", new Integer(0x100000E));
        stringToValueMap.put("F6", new Integer(0x100000F));
        stringToValueMap.put("F7", new Integer(0x1000010));
        stringToValueMap.put("F8", new Integer(0x1000011));
        stringToValueMap.put("F9", new Integer(0x1000012));
        stringToValueMap.put("F10", new Integer(0x1000013));
        stringToValueMap.put("F11", new Integer(0x1000014));
        stringToValueMap.put("F12", new Integer(0x1000015));
    }
}

