/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import org.eclipse.core.internal.localstore.CoreFileSystemLibrary;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.localstore.FileSystemStore;
import org.eclipse.core.internal.properties.PropertyManager;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ILock;

class ResourceTree
implements IResourceTree {
    private ILock lock;
    private MultiStatus multistatus;
    private int updateFlags;
    private boolean isValid = true;

    public ResourceTree(ILock lock, MultiStatus status, int updateFlags) {
        this.lock = lock;
        this.multistatus = status;
        this.updateFlags = updateFlags;
    }

    void makeInvalid() {
        this.isValid = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToLocalHistory(IFile file) {
        Assert.isLegal(this.isValid);
        try {
            this.lock.acquire();
            if (!file.exists()) {
                return;
            }
            IPath path = file.getLocation();
            if (path == null || !path.toFile().exists()) {
                return;
            }
            long lastModified = this.internalComputeTimestamp(path.toOSString());
            ((Resource)((Object)file)).getLocalManager().getHistoryStore().addState(file.getFullPath(), path, lastModified, false);
        }
        finally {
            this.lock.release();
        }
    }

    private void copyLocalHistory(IResource source, IResource destination) {
        ((Resource)destination).getLocalManager().getHistoryStore().copyHistory(source.getFullPath(), destination.getFullPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void movedFile(IFile source, IFile destination) {
        Assert.isLegal(this.isValid);
        try {
            ResourceStatus status;
            String message;
            this.lock.acquire();
            if (!source.exists()) {
                return;
            }
            if (destination.exists()) {
                String message2 = Policy.bind("resources.mustNotExist", destination.getFullPath().toString());
                ResourceStatus status2 = new ResourceStatus(4, destination.getFullPath(), message2);
                this.failed(status2);
            }
            PropertyManager propertyManager = ((Resource)((Object)source)).getPropertyManager();
            try {
                propertyManager.copy(source, destination, 0);
                propertyManager.deleteProperties(source, 0);
            }
            catch (CoreException e) {
                String message3 = Policy.bind("resources.errorPropertiesMove", source.getFullPath().toString(), destination.getFullPath().toString());
                ResourceStatus status3 = new ResourceStatus(4, source.getFullPath(), message3, e);
                this.failed(status3);
            }
            Workspace workspace = (Workspace)source.getWorkspace();
            try {
                workspace.move((Resource)((Object)source), destination.getFullPath(), 0, this.updateFlags, false);
            }
            catch (CoreException e) {
                message = Policy.bind("resources.errorMoving", source.getFullPath().toString(), destination.getFullPath().toString());
                status = new ResourceStatus(4, source.getFullPath(), message, e);
                this.failed(status);
            }
            try {
                workspace.getMarkerManager().moved(source, destination, 0);
            }
            catch (CoreException e) {
                message = Policy.bind("resources.errorMarkersDelete", source.getFullPath().toString());
                status = new ResourceStatus(4, source.getFullPath(), message, e);
                this.failed(status);
            }
            this.copyLocalHistory(source, destination);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void movedFolderSubtree(IFolder source, IFolder destination) {
        Assert.isLegal(this.isValid);
        try {
            ResourceStatus status;
            String message;
            this.lock.acquire();
            if (!source.exists()) {
                return;
            }
            if (destination.exists()) {
                String message2 = Policy.bind("resources.mustNotExist", destination.getFullPath().toString());
                ResourceStatus status2 = new ResourceStatus(4, destination.getFullPath(), message2);
                this.failed(status2);
                return;
            }
            int depth = 2;
            PropertyManager propertyManager = ((Resource)((Object)source)).getPropertyManager();
            try {
                propertyManager.copy(source, destination, depth);
                propertyManager.deleteProperties(source, depth);
            }
            catch (CoreException e) {
                String message3 = Policy.bind("resources.errorPropertiesMove", source.getFullPath().toString(), destination.getFullPath().toString());
                ResourceStatus status3 = new ResourceStatus(4, source.getFullPath(), message3, e);
                this.failed(status3);
            }
            Workspace workspace = (Workspace)source.getWorkspace();
            try {
                workspace.move((Resource)((Object)source), destination.getFullPath(), depth, this.updateFlags, false);
            }
            catch (CoreException e) {
                message = Policy.bind("resources.errorMoving", source.getFullPath().toString(), destination.getFullPath().toString());
                status = new ResourceStatus(4, source.getFullPath(), message, e);
                this.failed(status);
            }
            try {
                workspace.getMarkerManager().moved(source, destination, depth);
            }
            catch (CoreException e) {
                message = Policy.bind("resources.errorMarkersDelete", source.getFullPath().toString());
                status = new ResourceStatus(4, source.getFullPath(), message, e);
                this.failed(status);
            }
            this.copyLocalHistory(source, destination);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean movedProjectSubtree(IProject project, IProjectDescription destDescription) {
        Assert.isLegal(this.isValid);
        try {
            ResourceStatus status;
            String message;
            this.lock.acquire();
            if (!project.exists()) {
                boolean bl = true;
                return bl;
            }
            Project source = (Project)project;
            Project destination = (Project)source.getWorkspace().getRoot().getProject(destDescription.getName());
            Workspace workspace = (Workspace)source.getWorkspace();
            int depth = 2;
            if (this.isNameChange(source, destDescription)) {
                ResourceStatus status2;
                String message2;
                if (destination.exists()) {
                    String message3 = Policy.bind("resources.mustNotExist", destination.getFullPath().toString());
                    ResourceStatus status3 = new ResourceStatus(4, destination.getFullPath(), message3);
                    this.failed(status3);
                    boolean bl = false;
                    return bl;
                }
                try {
                    source.getPropertyManager().closePropertyStore(source);
                }
                catch (CoreException e) {
                    message = Policy.bind("properties.couldNotClose", source.getFullPath().toString());
                    status = new ResourceStatus(4, source.getFullPath(), message, e);
                    this.failed(status);
                }
                java.io.File oldMetaArea = workspace.getMetaArea().locationFor(source).toFile();
                java.io.File newMetaArea = workspace.getMetaArea().locationFor(destination).toFile();
                try {
                    source.getLocalManager().getStore().move(oldMetaArea, newMetaArea, false, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    message2 = Policy.bind("resources.moveMeta", oldMetaArea.toString(), newMetaArea.toString());
                    status2 = new ResourceStatus(568, destination.getFullPath(), message2, e);
                    this.failed(status2);
                }
                try {
                    workspace.move(source, destination.getFullPath(), depth, this.updateFlags, true);
                }
                catch (CoreException e) {
                    message2 = Policy.bind("resources.errorMoving", source.getFullPath().toString(), destination.getFullPath().toString());
                    status2 = new ResourceStatus(4, source.getFullPath(), message2, e);
                    this.failed(status2);
                }
                ProjectInfo info = (ProjectInfo)destination.getResourceInfo(false, true);
                info.clearNatures();
                info.setBuilders(null);
                info.setPropertyStore(null);
                try {
                    workspace.getMarkerManager().moved(source, destination, depth);
                }
                catch (CoreException e) {
                    String message4 = Policy.bind("resources.errorMarkersMove", source.getFullPath().toString(), destination.getFullPath().toString());
                    ResourceStatus status4 = new ResourceStatus(4, source.getFullPath(), message4, e);
                    this.failed(status4);
                }
                this.copyLocalHistory(source, destination);
            }
            try {
                ((ProjectDescription)destDescription).setLinkDescriptions(destination.internalGetDescription().getLinks());
                destination.internalSetDescription(destDescription, true);
                destination.writeDescription(1);
            }
            catch (CoreException e) {
                message = Policy.bind("resources.projectDesc");
                status = new ResourceStatus(4, destination.getFullPath(), message, e);
                this.failed(status);
            }
            try {
                workspace.getMetaArea().writePrivateDescription(destination);
            }
            catch (CoreException e) {
                this.failed(e.getStatus());
            }
            try {
                destination.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                message = Policy.bind("resources.errorRefresh", destination.getFullPath().toString());
                status = new ResourceStatus(4, destination.getFullPath(), message, e);
                this.failed(status);
                boolean bl = false;
                this.lock.release();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    protected IStatus getStatus() {
        return this.multistatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimestamp(IFile file) {
        Assert.isLegal(this.isValid);
        try {
            this.lock.acquire();
            if (!file.exists()) {
                long l = 0L;
                return l;
            }
            ResourceInfo info = ((File)file).getResourceInfo(false, false);
            long l = info == null ? 0L : info.getLocalSyncInfo();
            return l;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletedFile(IFile file) {
        Assert.isLegal(this.isValid);
        try {
            this.lock.acquire();
            if (!file.exists()) {
                return;
            }
            try {
                ((Resource)((Object)file)).deleteResource(true, null);
            }
            catch (CoreException e) {
                String message = Policy.bind("resources.errorDeleting", file.getFullPath().toString());
                ResourceStatus status = new ResourceStatus(4, file.getFullPath(), message, e);
                this.failed(status);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletedFolder(IFolder folder) {
        Assert.isLegal(this.isValid);
        try {
            this.lock.acquire();
            if (!folder.exists()) {
                return;
            }
            try {
                ((Resource)((Object)folder)).deleteResource(true, null);
            }
            catch (CoreException e) {
                String message = Policy.bind("resources.errorDeleting", folder.getFullPath().toString());
                ResourceStatus status = new ResourceStatus(4, folder.getFullPath(), message, e);
                this.failed(status);
            }
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletedProject(IProject target) {
        Assert.isLegal(this.isValid);
        try {
            ResourceStatus status;
            String message;
            this.lock.acquire();
            if (!target.exists()) {
                return;
            }
            Project project = (Project)target;
            Workspace workspace = (Workspace)project.getWorkspace();
            try {
                project.deleteResource(false, null);
            }
            catch (CoreException e) {
                message = Policy.bind("resources.errorDeleting", project.getFullPath().toString());
                status = new ResourceStatus(4, project.getFullPath(), message, e);
                this.failed(status);
            }
            try {
                workspace.getMetaArea().delete(project);
            }
            catch (CoreException e) {
                message = Policy.bind("resources.deleteMeta", project.getFullPath().toString());
                status = new ResourceStatus(569, project.getFullPath(), message, e);
                this.failed(status);
            }
            try {
                project.clearHistory(null);
            }
            catch (CoreException e) {
                message = Policy.bind("history.problemsRemoving", project.getFullPath().toString());
                status = new ResourceStatus(273, project.getFullPath(), message, e);
                this.failed(status);
            }
        }
        finally {
            this.lock.release();
        }
    }

    public void failed(IStatus reason) {
        Assert.isLegal(this.isValid);
        this.multistatus.add(reason);
    }

    private boolean isNameChange(IProject project, IProjectDescription description) {
        return !project.getName().equals(description.getName());
    }

    private boolean isContentChange(IProject project, IProjectDescription destinationDescription) {
        ProjectDescription sourceDescription = ((Project)project).internalGetDescription();
        if (sourceDescription.getLocation() == null || destinationDescription.getLocation() == null) {
            return true;
        }
        return !sourceDescription.getLocation().equals(destinationDescription.getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSynchronized(IResource resource, int depth) {
        try {
            this.lock.acquire();
            boolean bl = ((Resource)resource).getLocalManager().isSynchronized(resource, depth);
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long computeTimestamp(IFile file) {
        Assert.isLegal(this.isValid);
        try {
            this.lock.acquire();
            if (!file.getProject().exists()) {
                long l = 0L;
                return l;
            }
            long l = this.internalComputeTimestamp(file.getLocation().toOSString());
            return l;
        }
        finally {
            this.lock.release();
        }
    }

    protected long internalComputeTimestamp(String location) {
        return CoreFileSystemLibrary.getLastModified(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void standardDeleteFile(IFile file, int updateFlags, IProgressMonitor monitor) {
        Assert.isLegal(this.isValid);
        try {
            this.lock.acquire();
            this.internalDeleteFile(file, updateFlags, monitor);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalDeleteFile(IFile file, int updateFlags, IProgressMonitor monitor) {
        try {
            boolean inSync;
            boolean force;
            String message = Policy.bind("resources.deleting", file.getFullPath().toString());
            monitor.beginTask(message, Policy.totalWork);
            if (!file.exists()) {
                boolean bl = true;
                return bl;
            }
            if (file.isLinked()) {
                this.deletedFile(file);
                boolean bl = true;
                return bl;
            }
            java.io.File fileOnDisk = file.getLocation().toFile();
            if (!fileOnDisk.exists()) {
                this.deletedFile(file);
                boolean bl = true;
                return bl;
            }
            boolean keepHistory = (updateFlags & 2) != 0;
            boolean bl = force = (updateFlags & 1) != 0;
            if (keepHistory) {
                this.addToLocalHistory(file);
            }
            monitor.worked(Policy.totalWork / 4);
            if (!force && !(inSync = this.isSynchronized(file, 0)) && file.getLocation().toFile().exists()) {
                message = Policy.bind("localstore.resourceIsOutOfSync", file.getFullPath().toString());
                ResourceStatus status = new ResourceStatus(274, file.getFullPath(), message);
                this.failed(status);
                boolean bl2 = false;
                return bl2;
            }
            monitor.worked(Policy.totalWork / 4);
            boolean success = fileOnDisk.delete();
            monitor.worked(Policy.totalWork / 4);
            if (success) {
                this.deletedFile(file);
                boolean status = true;
                return status;
            }
            message = Policy.bind("resources.couldnotDelete", file.getLocation().toOSString());
            ResourceStatus status = new ResourceStatus(273, file.getFullPath(), message);
            this.failed(status);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void standardDeleteFolder(IFolder folder, int updateFlags, IProgressMonitor monitor) {
        Assert.isLegal(this.isValid);
        try {
            boolean success;
            boolean keepHistory;
            boolean force;
            this.lock.acquire();
            String message = Policy.bind("resources.deleting", folder.getFullPath().toString());
            monitor.beginTask(message, Policy.totalWork);
            if (!folder.exists()) {
                return;
            }
            if (folder.isLinked()) {
                this.deletedFolder(folder);
                return;
            }
            java.io.File folderOnDisk = folder.getLocation().toFile();
            if (!folderOnDisk.exists()) {
                this.deletedFolder(folder);
                return;
            }
            boolean bl = force = (updateFlags & 1) != 0;
            if (!force && !this.isSynchronized(folder, 2)) {
                this.internalDeleteFolder(folder, updateFlags, monitor);
                return;
            }
            boolean bl2 = keepHistory = (updateFlags & 2) != 0;
            if (keepHistory) {
                this.addToLocalHistory(folder, 2);
            }
            try {
                FileSystemResourceManager localManager = ((Folder)folder).getLocalManager();
                localManager.delete(folder, force, true, false, monitor);
                java.io.File folderLocation = folder.getLocation().toFile();
                success = Workspace.clear(folderLocation);
            }
            catch (CoreException ce) {
                message = Policy.bind("localstore.couldnotDelete", folder.getFullPath().toString());
                MultiStatus status = new MultiStatus("org.eclipse.core.resources", 273, message, (Throwable)ce);
                if (ce.getStatus() != null) {
                    status.merge(ce.getStatus());
                }
                this.failed((IStatus)status);
                this.lock.release();
                monitor.done();
                return;
            }
            if (success) {
                this.deletedFolder(folder);
            } else {
                message = Policy.bind("resources.couldnotDelete", folder.getLocation().toOSString());
                ResourceStatus status = new ResourceStatus(273, folder.getFullPath(), message);
                this.failed(status);
            }
        }
        finally {
            this.lock.release();
            monitor.done();
        }
    }

    private void addToLocalHistory(IResource root, int depth) {
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) {
                if (resource.getType() == 1) {
                    ResourceTree.this.addToLocalHistory((IFile)resource);
                }
                return true;
            }
        };
        try {
            root.accept(visitor, depth, false);
        }
        catch (CoreException e) {
            // empty catch block
        }
    }

    private boolean internalDeleteFolder(IFolder folder, int updateFlags, IProgressMonitor monitor) {
        IResource[] members = null;
        try {
            members = folder.members(2);
        }
        catch (CoreException e) {
            String message = Policy.bind("resources.errorMembers", folder.getFullPath().toString());
            ResourceStatus status = new ResourceStatus(4, folder.getFullPath(), message, e);
            this.failed(status);
            return false;
        }
        boolean deletedChildren = true;
        block6: for (int i = 0; i < members.length; ++i) {
            IResource child = members[i];
            switch (child.getType()) {
                case 1: {
                    deletedChildren &= this.internalDeleteFile((IFile)child, updateFlags, Policy.subMonitorFor(monitor, Policy.totalWork / members.length));
                    continue block6;
                }
                case 2: {
                    deletedChildren &= this.internalDeleteFolder((IFolder)child, updateFlags, Policy.subMonitorFor(monitor, Policy.totalWork / members.length));
                }
            }
        }
        if (!deletedChildren) {
            return false;
        }
        java.io.File folderOnDisk = folder.getLocation().toFile();
        boolean success = folderOnDisk.delete();
        if (!success && !folderOnDisk.exists()) {
            success = true;
        }
        if (success) {
            this.deletedFolder(folder);
            return true;
        }
        String message = Policy.bind("resources.couldnotDelete", folder.getLocation().toOSString());
        ResourceStatus status = new ResourceStatus(273, folder.getFullPath(), message);
        this.failed(status);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void standardDeleteProject(IProject project, int updateFlags, IProgressMonitor monitor) {
        Assert.isLegal(this.isValid);
        try {
            this.lock.acquire();
            message = Policy.bind("resources.deleting", project.getFullPath().toString());
            monitor.beginTask(message, Policy.totalWork);
            if (!project.exists()) {
                return;
            }
            v0 = alwaysDeleteContent = (updateFlags & 4) != 0;
            force = alwaysDeleteContent != false ? true : (updateFlags & 1) != 0;
            neverDeleteContent = (updateFlags & 8) != 0;
            success = true;
            if (alwaysDeleteContent || project.isOpen() && !neverDeleteContent) {
                if (!force && !this.isSynchronized(project, 2)) {
                    success = this.internalDeleteProject(project, updateFlags, monitor);
                    if (success) {
                        this.deletedProject(project);
                    } else {
                        message = Policy.bind("resources.couldnotDelete", project.getLocation().toOSString());
                        status = new ResourceStatus(273, project.getFullPath(), message);
                        this.failed(status);
                    }
                    return;
                }
                description = ((Project)project).internalGetDescription();
                defaultLocation = description == null || description.getLocation() == null;
                projectLocation = project.getLocation().toFile();
                if (project.isOpen()) {
                    try {
                        localManager = ((Project)project).getLocalManager();
                        localManager.delete(project, force, false, false, Policy.subMonitorFor(monitor, Policy.totalWork * 3 / 4));
                        if (!defaultLocation) ** GOTO lbl44
                        success = Workspace.clear(projectLocation);
                    }
                    catch (CoreException ce) {
                        message = Policy.bind("localstore.couldnotDelete", project.getFullPath().toString());
                        status = new MultiStatus("org.eclipse.core.resources", 273, message, (Throwable)ce);
                        if (ce.getStatus() != null) {
                            status.merge(ce.getStatus());
                        }
                        this.failed((IStatus)status);
                        this.lock.release();
                        monitor.done();
                        return;
                    }
                } else {
                    success = defaultLocation != false ? Workspace.clear(projectLocation) : Workspace.clearChildren(projectLocation);
                    monitor.worked(Policy.totalWork * 3 / 4);
                }
            }
lbl44:
            // 5 sources

            if (success) {
                this.deletedProject(project);
            } else {
                message = Policy.bind("localstore.couldnotDelete", project.getFullPath().toString());
                status = new ResourceStatus(273, project.getFullPath(), message);
                this.failed(status);
            }
        }
        finally {
            this.lock.release();
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveProjectContent(IProject source, IProjectDescription destDescription, int updateFlags, IProgressMonitor monitor) throws CoreException {
        try {
            String message = Policy.bind("resources.moving", source.getFullPath().toString());
            monitor.beginTask(message, 10);
            IProjectDescription srcDescription = source.getDescription();
            if (srcDescription.getLocation() != null && srcDescription.getLocation().equals(destDescription)) {
                return;
            }
            IPath srcLocation = source.getLocation();
            IPath destLocation = destDescription.getLocation();
            if (destLocation == null) {
                destLocation = Platform.getLocation().append(destDescription.getName());
            }
            java.io.File destinationFile = destLocation.toFile();
            try {
                this.moveInFileSystem(srcLocation.toFile(), destinationFile, updateFlags, monitor);
            }
            catch (CoreException ce) {
                boolean failedDeletingSource;
                boolean bl = failedDeletingSource = ce instanceof ResourceException && ce.getStatus().getCode() == 273 && destinationFile.exists();
                if (!failedDeletingSource) {
                    throw ce;
                }
                this.failed(ce.getStatus());
            }
            monitor.worked(9);
            if ((updateFlags & 0x20) == 0) {
                IResource[] children = source.members();
                for (int i = 0; i < children.length; ++i) {
                    if (!children[i].isLinked()) continue;
                    message = Policy.bind("resources.moving", children[i].getFullPath().toString());
                    monitor.subTask(message);
                    java.io.File sourceFile = children[i].getLocation().toFile();
                    java.io.File destFile = destLocation.append(children[i].getName()).toFile();
                    try {
                        this.moveInFileSystem(sourceFile, destFile, updateFlags, Policy.monitorFor(null));
                        continue;
                    }
                    catch (CoreException ce) {
                        this.failed(ce.getStatus());
                    }
                }
            }
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void standardMoveFile(IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
        Assert.isLegal(this.isValid);
        try {
            block12: {
                boolean isDeep;
                this.lock.acquire();
                String message = Policy.bind("resources.moving", source.getFullPath().toString());
                monitor.subTask(message);
                if (!source.exists() || destination.exists() || !destination.getParent().isAccessible()) {
                    throw new IllegalArgumentException();
                }
                boolean force = (updateFlags & 1) != 0;
                boolean keepHistory = (updateFlags & 2) != 0;
                boolean bl = isDeep = (updateFlags & 0x20) == 0;
                if (!force && !this.isSynchronized(source, 2)) {
                    message = Policy.bind("localstore.resourceIsOutOfSync", source.getFullPath().toString());
                    ResourceStatus status = new ResourceStatus(274, source.getFullPath(), message);
                    this.failed(status);
                    return;
                }
                monitor.worked(Policy.totalWork / 4);
                if (keepHistory) {
                    this.addToLocalHistory(source);
                }
                monitor.worked(Policy.totalWork / 4);
                if (!isDeep && source.isLinked()) {
                    this.movedFile(source, destination);
                    return;
                }
                java.io.File sourceFile = source.getLocation().toFile();
                java.io.File destFile = destination.getLocation().toFile();
                try {
                    this.moveInFileSystem(sourceFile, destFile, updateFlags, monitor);
                }
                catch (CoreException e) {
                    boolean failedDeletingSource;
                    this.failed(e.getStatus());
                    boolean bl2 = failedDeletingSource = e instanceof ResourceException && e.getStatus().getCode() == 273 && destFile.exists();
                    if (failedDeletingSource) break block12;
                    this.lock.release();
                    monitor.done();
                    return;
                }
            }
            this.movedFile(source, destination);
            this.updateMovedFileTimestamp(destination, this.computeTimestamp(destination));
            monitor.worked(Policy.totalWork / 4);
            return;
        }
        finally {
            this.lock.release();
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void standardMoveFolder(IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
        Assert.isLegal(this.isValid);
        try {
            java.io.File destinationFile;
            boolean isDeep;
            String message;
            block14: {
                boolean keepHistory;
                boolean force;
                this.lock.acquire();
                message = Policy.bind("resources.moving", source.getFullPath().toString());
                monitor.subTask(message);
                if (!source.exists() || destination.exists() || !destination.getParent().isAccessible()) {
                    throw new IllegalArgumentException();
                }
                boolean bl = force = (updateFlags & 1) != 0;
                if (!force && !this.isSynchronized(source, 2)) {
                    message = Policy.bind("localstore.resourceIsOutOfSync", source.getFullPath().toString());
                    ResourceStatus status = new ResourceStatus(4, source.getFullPath(), message);
                    this.failed(status);
                    return;
                }
                boolean bl2 = keepHistory = (updateFlags & 2) != 0;
                if (keepHistory) {
                    this.addToLocalHistory(source, 2);
                }
                boolean bl3 = isDeep = (updateFlags & 0x20) == 0;
                if (!isDeep && source.isLinked()) {
                    this.movedFolderSubtree(source, destination);
                    return;
                }
                java.io.File sourceFile = source.getLocation().toFile();
                destinationFile = destination.getLocation().toFile();
                try {
                    this.moveInFileSystem(sourceFile, destinationFile, updateFlags, monitor);
                }
                catch (CoreException e) {
                    boolean failedDeletingSource;
                    this.failed(e.getStatus());
                    boolean bl4 = failedDeletingSource = e instanceof ResourceException && e.getStatus().getCode() == 273 && destinationFile.exists();
                    if (failedDeletingSource) break block14;
                    this.lock.release();
                    monitor.done();
                    return;
                }
            }
            boolean success = destinationFile.exists();
            if (success) {
                this.movedFolderSubtree(source, destination);
                this.updateTimestamps(destination, isDeep);
            } else {
                message = Policy.bind("localstore.couldNotCreateFolder", destination.getLocation().toOSString());
                ResourceStatus status = new ResourceStatus(272, destination.getFullPath(), message);
                this.failed(status);
            }
        }
        finally {
            this.lock.release();
            monitor.done();
        }
    }

    private void updateTimestamps(IResource root, final boolean isDeep) {
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) {
                boolean isLinked = resource.isLinked();
                if (isLinked && !isDeep) {
                    return false;
                }
                if (resource.getType() == 1) {
                    IFile file = (IFile)resource;
                    ResourceTree.this.updateMovedFileTimestamp(file, ResourceTree.this.computeTimestamp(file));
                } else if (isLinked) {
                    ResourceInfo info = ((Resource)resource).getResourceInfo(false, true);
                    info.clear(65536);
                }
                return true;
            }
        };
        try {
            root.accept(visitor, 2, 2);
        }
        catch (CoreException e) {
            // empty catch block
        }
    }

    private boolean internalDeleteProject(IProject project, int updateFlags, IProgressMonitor monitor) {
        boolean success;
        IResource[] members = null;
        try {
            members = project.members(2);
        }
        catch (CoreException e) {
            String message = Policy.bind("resources.errorMembers", project.getFullPath().toString());
            ResourceStatus status = new ResourceStatus(4, project.getFullPath(), message, e);
            this.failed(status);
            return false;
        }
        boolean deletedChildren = true;
        block6: for (int i = 0; i < members.length; ++i) {
            IResource child = members[i];
            switch (child.getType()) {
                case 1: {
                    if (child.getName().equals(".project")) continue block6;
                    deletedChildren &= this.internalDeleteFile((IFile)child, updateFlags, Policy.subMonitorFor(monitor, Policy.totalWork / members.length));
                    continue block6;
                }
                case 2: {
                    deletedChildren &= this.internalDeleteFolder((IFolder)child, updateFlags, Policy.subMonitorFor(monitor, Policy.totalWork / members.length));
                }
            }
        }
        if (deletedChildren) {
            IResource file = project.findMember(".project");
            if (file == null) {
                IPath location = project.getFile(".project").getLocation();
                if (location != null) {
                    location.toFile().delete();
                }
            } else {
                if (file.getType() != 1) {
                    String message = Policy.bind("resources.couldnotDelete", file.getFullPath().toString());
                    ResourceStatus status = new ResourceStatus(273, file.getFullPath(), message);
                    this.failed(status);
                    return false;
                }
                boolean deletedProjectFile = this.internalDeleteFile((IFile)file, updateFlags, Policy.monitorFor(null));
                if (!deletedProjectFile) {
                    String message = Policy.bind("resources.couldnotDelete", file.getFullPath().toString());
                    ResourceStatus status = new ResourceStatus(273, file.getFullPath(), message);
                    this.failed(status);
                    return false;
                }
            }
        } else {
            return false;
        }
        java.io.File root = project.getLocation().toFile();
        ProjectDescription description = ((Project)project).internalGetDescription();
        if (description == null || description.getLocation() == null) {
            success = root.delete();
            if (!success && !root.exists()) {
                success = true;
            }
        } else {
            String[] children = root.list();
            boolean bl = success = children == null || children.length == 0;
        }
        if (success) {
            this.deletedProject(project);
            return true;
        }
        String message = Policy.bind("resources.couldnotDelete", project.getLocation().toOSString());
        ResourceStatus status = new ResourceStatus(273, project.getFullPath(), message);
        this.failed(status);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void standardMoveProject(IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        Assert.isLegal(this.isValid);
        try {
            boolean force;
            this.lock.acquire();
            String message = Policy.bind("resources.moving", source.getFullPath().toString());
            monitor.beginTask(message, Policy.totalWork);
            if (!source.isAccessible()) {
                throw new IllegalArgumentException();
            }
            if (!this.isContentChange(source, description)) {
                this.movedProjectSubtree(source, description);
                return;
            }
            boolean bl = force = (updateFlags & 1) != 0;
            if (!force && !this.isSynchronized(source, 2)) {
                message = Policy.bind("localstore.resourceIsOutOfSync", source.getFullPath().toString());
                ResourceStatus status = new ResourceStatus(274, source.getFullPath(), message);
                this.failed(status);
                return;
            }
            try {
                this.moveProjectContent(source, description, updateFlags, Policy.subMonitorFor(monitor, Policy.totalWork * 3 / 4));
            }
            catch (CoreException e) {
                message = Policy.bind("localstore.couldNotMove", source.getFullPath().toString());
                ResourceStatus status = new ResourceStatus(4, source.getFullPath(), message, e);
                this.failed(status);
                this.lock.release();
                monitor.done();
                return;
            }
            this.movedProjectSubtree(source, description);
            monitor.worked(Policy.totalWork * 1 / 8);
            boolean isDeep = (updateFlags & 0x20) == 0;
            this.updateTimestamps(source.getWorkspace().getRoot().getProject(description.getName()), isDeep);
            monitor.worked(Policy.totalWork * 1 / 8);
        }
        finally {
            this.lock.release();
            monitor.done();
        }
    }

    private void moveInFileSystem(java.io.File source, java.io.File destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        Assert.isLegal(this.isValid);
        FileSystemStore store = ((Resource)((Object)ResourcesPlugin.getWorkspace().getRoot())).getLocalManager().getStore();
        boolean force = (updateFlags & 1) != 0;
        store.move(source, destination, force, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMovedFileTimestamp(IFile file, long timestamp) {
        Assert.isLegal(this.isValid);
        try {
            this.lock.acquire();
            if (!file.exists()) {
                return;
            }
            ResourceInfo info = ((Resource)((Object)file)).getResourceInfo(false, true);
            ((Resource)((Object)file)).getLocalManager().updateLocalSync(info, timestamp);
            info.clear(65536);
        }
        finally {
            this.lock.release();
        }
    }
}

