/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.localstore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.internal.localstore.CoreFileSystemLibrary;
import org.eclipse.core.internal.localstore.ILocalStoreConstants;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;

public class FileSystemStore
implements ILocalStoreConstants {
    private final byte[] buffer = new byte[8192];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(File source, File destination, int depth, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(Policy.bind("localstore.copying", source.getAbsolutePath()), 1);
            Policy.checkCanceled(monitor);
            if (source.isDirectory()) {
                this.copyDirectory(source, destination, depth, Policy.subMonitorFor(monitor, 1));
            } else {
                this.copyFile(source, destination, Policy.subMonitorFor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyDirectory(File source, File destination, int depth, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String[] children = source.list();
            if (children == null) {
                children = new String[]{};
            }
            monitor.beginTask(Policy.bind("localstore.copying", source.getAbsolutePath()), children.length);
            this.writeFolder(destination);
            if (depth == 0) {
                return;
            }
            if (depth == 1) {
                depth = 0;
            }
            for (int i = 0; i < children.length; ++i) {
                this.copy(new File(source, children[i]), new File(destination, children[i]), depth, Policy.subMonitorFor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(File target, File destination, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            int totalWork = 1 + (int)target.length() / 8192;
            monitor.beginTask(Policy.bind("localstore.copying", target.getAbsolutePath()), totalWork);
            try {
                this.write(destination, this.read(target), false, monitor);
            }
            catch (CoreException e) {
                if (!destination.isDirectory()) {
                    destination.delete();
                }
                throw e;
            }
            long stat = CoreFileSystemLibrary.getStat(target.getAbsolutePath());
            long lastModified = CoreFileSystemLibrary.getLastModified(stat);
            destination.setLastModified(lastModified);
            CoreFileSystemLibrary.copyAttributes(target.getAbsolutePath(), destination.getAbsolutePath(), false);
        }
        finally {
            monitor.done();
        }
    }

    protected OutputStream createStream(File target, boolean append) throws CoreException {
        String path = target.getAbsolutePath();
        try {
            return new FileOutputStream(path, append);
        }
        catch (FileNotFoundException e) {
            String message;
            int code = 272;
            String parent = target.getParent();
            if (parent != null && CoreFileSystemLibrary.isReadOnly(parent)) {
                message = Policy.bind("localstore.readOnlyParent", path);
                code = 277;
            } else {
                message = target.isDirectory() ? Policy.bind("localstore.notAFile", path) : Policy.bind("localstore.couldNotWrite", path);
            }
            throw new ResourceException(code, (IPath)new Path(path), message, e);
        }
    }

    public void delete(File target) throws CoreException {
        if (!Workspace.clear(target)) {
            String message = Policy.bind("localstore.couldnotDelete", target.getAbsolutePath());
            throw new ResourceException(273, (IPath)new Path(target.getAbsolutePath()), message, null);
        }
    }

    public boolean delete(File root, MultiStatus status) {
        return this.delete(root, root.getAbsolutePath(), status);
    }

    protected boolean delete(File root, String filePath, MultiStatus status) {
        String[] list;
        boolean failedRecursive = false;
        if (root.isDirectory() && (list = root.list()) != null) {
            int parentLength = filePath.length();
            int imax = list.length;
            for (int i = 0; i < imax; ++i) {
                StringBuffer childBuffer = new StringBuffer(parentLength + list[i].length() + 1);
                childBuffer.append(filePath);
                childBuffer.append(File.separatorChar);
                childBuffer.append(list[i]);
                String childName = childBuffer.toString();
                failedRecursive = !this.delete(new File(childName), childName, status) || failedRecursive;
            }
        }
        boolean failedThis = false;
        try {
            if (!failedRecursive && root.exists()) {
                failedThis = !root.delete();
            }
        }
        catch (Exception e) {
            String message = Policy.bind("localstore.couldnotDelete", root.getAbsolutePath());
            status.add((IStatus)new ResourceStatus(273, (IPath)new Path(root.getAbsolutePath()), message, e));
            return false;
        }
        if (failedThis) {
            String message = null;
            message = CoreFileSystemLibrary.isReadOnly(root.getAbsolutePath()) ? Policy.bind("localstore.couldnotDeleteReadOnly", root.getAbsolutePath()) : Policy.bind("localstore.couldnotDelete", root.getAbsolutePath());
            status.add((IStatus)new ResourceStatus(273, (IPath)new Path(root.getAbsolutePath()), message, null));
        }
        return !failedRecursive && !failedThis;
    }

    /*
     * Loose catch block
     */
    public int getEncoding(File target) throws CoreException {
        int n;
        InputStream input;
        block27: {
            block25: {
                int n2;
                block26: {
                    int third;
                    int second;
                    int first;
                    block23: {
                        int n3;
                        block24: {
                            block21: {
                                int n4;
                                block22: {
                                    block19: {
                                        int n5;
                                        block20: {
                                            block17: {
                                                int n6;
                                                block18: {
                                                    input = null;
                                                    input = this.read(target);
                                                    first = input.read() & 0xFF;
                                                    second = input.read() & 0xFF;
                                                    if (first != -1 && second != -1) break block17;
                                                    n6 = 0;
                                                    Object var8_11 = null;
                                                    if (input == null) break block18;
                                                    try {
                                                        input.close();
                                                    }
                                                    catch (IOException e2) {
                                                        // empty catch block
                                                    }
                                                }
                                                return n6;
                                            }
                                            if (first != 254 || second != 255) break block19;
                                            n5 = 4;
                                            Object var8_12 = null;
                                            if (input == null) break block20;
                                            try {
                                                input.close();
                                            }
                                            catch (IOException e2) {
                                                // empty catch block
                                            }
                                        }
                                        return n5;
                                    }
                                    if (first != 255 || second != 254) break block21;
                                    n4 = 5;
                                    Object var8_13 = null;
                                    if (input == null) break block22;
                                    try {
                                        input.close();
                                    }
                                    catch (IOException e2) {
                                        // empty catch block
                                    }
                                }
                                return n4;
                            }
                            third = input.read() & 0xFF;
                            if (third != -1) break block23;
                            n3 = 0;
                            Object var8_14 = null;
                            if (input == null) break block24;
                            try {
                                input.close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                        }
                        return n3;
                    }
                    if (first != 239 || second != 187 || third != 191) break block25;
                    n2 = 3;
                    Object var8_15 = null;
                    if (input == null) break block26;
                    try {
                        input.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                return n2;
            }
            n = 0;
            Object var8_16 = null;
            if (input == null) break block27;
            try {
                input.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        return n;
        catch (IOException e) {
            try {
                String message = Policy.bind("localstore.couldNotRead", target.getAbsolutePath());
                throw new ResourceException(271, (IPath)new Path(target.getAbsolutePath()), message, e);
            }
            catch (Throwable throwable) {
                block28: {
                    Object var8_17 = null;
                    if (input == null) break block28;
                    try {
                        input.close();
                    }
                    catch (IOException e2) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void move(File source, File destination, boolean force, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            block21: {
                boolean canceled;
                block20: {
                    monitor.beginTask(Policy.bind("localstore.moving", source.getAbsolutePath()), 2);
                    boolean sourceEqualsDest = false;
                    try {
                        sourceEqualsDest = source.getCanonicalFile().equals(destination.getCanonicalFile());
                    }
                    catch (IOException e) {
                        String message = Policy.bind("localstore.couldNotMove", source.getAbsolutePath());
                        throw new ResourceException(new ResourceStatus(272, (IPath)new Path(source.getAbsolutePath()), message, e));
                    }
                    if (!sourceEqualsDest && !force && destination.exists()) {
                        String message = Policy.bind("localstore.resourceExists", destination.getAbsolutePath());
                        throw new ResourceException(268, (IPath)new Path(destination.getAbsolutePath()), message, null);
                    }
                    if (source.renameTo(destination)) {
                        if (!sourceEqualsDest && source.exists()) {
                            if (destination.exists()) {
                                Workspace.clear(destination);
                                String message = Policy.bind("localstore.couldnotDelete", source.getAbsolutePath());
                                throw new ResourceException(new ResourceStatus(273, (IPath)new Path(source.getAbsolutePath()), message, null));
                            }
                        } else {
                            if (destination.exists()) {
                                return;
                            }
                            String message = Policy.bind("localstore.failedMove", source.getAbsolutePath(), destination.getAbsolutePath());
                            throw new ResourceException(new ResourceStatus(272, (IPath)new Path(source.getAbsolutePath()), message, null));
                        }
                    }
                    if (sourceEqualsDest) {
                        String message = Policy.bind("localstore.couldNotMove", source.getAbsolutePath());
                        throw new ResourceException(new ResourceStatus(272, (IPath)new Path(source.getAbsolutePath()), message, null));
                    }
                    boolean success = false;
                    canceled = false;
                    try {
                        try {
                            this.copy(source, destination, 2, Policy.subMonitorFor(monitor, 1));
                            success = true;
                        }
                        catch (OperationCanceledException e) {
                            canceled = true;
                            throw e;
                        }
                        Object var10_14 = null;
                        if (!success) break block20;
                    }
                    catch (Throwable throwable) {
                        Object var10_15 = null;
                        if (success) {
                            String message = Policy.bind("localstore.deleteProblemDuringMove");
                            MultiStatus result = new MultiStatus("org.eclipse.core.resources", 273, message, null);
                            if (this.delete(source, result)) throw throwable;
                            throw new ResourceException((IStatus)result);
                        }
                        if (canceled) throw throwable;
                        String message = Policy.bind("localstore.couldNotMove", source.getAbsolutePath());
                        throw new ResourceException(new ResourceStatus(272, (IPath)new Path(source.getAbsolutePath()), message, null));
                    }
                    String message = Policy.bind("localstore.deleteProblemDuringMove");
                    MultiStatus result = new MultiStatus("org.eclipse.core.resources", 273, message, null);
                    if (!this.delete(source, result)) {
                        throw new ResourceException((IStatus)result);
                    }
                    break block21;
                }
                if (!canceled) {
                    String message = Policy.bind("localstore.couldNotMove", source.getAbsolutePath());
                    throw new ResourceException(new ResourceStatus(272, (IPath)new Path(source.getAbsolutePath()), message, null));
                }
            }
            monitor.worked(1);
            return;
        }
        finally {
            monitor.done();
        }
    }

    public InputStream read(File target) throws CoreException {
        try {
            return new FileInputStream(target);
        }
        catch (FileNotFoundException e) {
            String message = !target.exists() ? Policy.bind("localstore.fileNotFound", target.getAbsolutePath()) : (target.isDirectory() ? Policy.bind("localstore.notAFile", target.getAbsolutePath()) : Policy.bind("localstore.couldNotRead", target.getAbsolutePath()));
            throw new ResourceException(271, (IPath)new Path(target.getAbsolutePath()), message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferStreams(InputStream source, OutputStream destination, String path, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            byte[] byArray = this.buffer;
            synchronized (this.buffer) {
                while (true) {
                    int bytesRead = -1;
                    try {
                        bytesRead = source.read(this.buffer);
                    }
                    catch (IOException e) {
                        String msg = Policy.bind("localstore.failedReadDuringWrite", new String[]{path});
                        Path p = path == null ? null : new Path(path);
                        throw new ResourceException(271, (IPath)p, msg, e);
                    }
                    if (bytesRead == -1) break;
                    try {
                        destination.write(this.buffer, 0, bytesRead);
                    }
                    catch (IOException e) {
                        String msg = Policy.bind("localstore.couldNotWrite", new String[]{path});
                        Path p = path == null ? null : new Path(path);
                        throw new ResourceException(272, (IPath)p, msg, e);
                    }
                    monitor.worked(1);
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                Object var12_14 = null;
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            try {
                source.close();
            }
            catch (IOException e) {
            }
            finally {
                try {
                    destination.close();
                }
                catch (IOException e) {}
            }
            throw throwable;
        }
        {
            try {
                source.close();
            }
            catch (IOException e) {
            }
            finally {
                try {
                    destination.close();
                }
                catch (IOException e) {}
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File target, InputStream content, boolean append, IProgressMonitor monitor) throws CoreException {
        try {
            String path = target.getAbsolutePath();
            this.writeFolder(target.getParentFile());
            this.transferStreams(content, this.createStream(target, append), path, monitor);
        }
        finally {
            try {
                content.close();
            }
            catch (IOException e) {}
        }
    }

    public void writeFolder(File target) throws CoreException {
        if (!target.exists()) {
            target.mkdirs();
        }
        if (!target.isDirectory()) {
            String path = target.getAbsolutePath();
            int code = 272;
            String message = Policy.bind("localstore.couldNotCreateFolder", path);
            String parent = target.getParent();
            if (parent != null && CoreFileSystemLibrary.isReadOnly(parent)) {
                message = Policy.bind("localstore.readOnlyParent", path);
                code = 277;
            }
            throw new ResourceException(code, (IPath)new Path(path), message, null);
        }
    }
}

