/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import java.util.Vector;
import org.eclipse.core.internal.indexing.Convert;
import org.eclipse.core.internal.indexing.IndexAnchor;
import org.eclipse.core.internal.indexing.IndexCursor;
import org.eclipse.core.internal.indexing.IndexedStore;
import org.eclipse.core.internal.indexing.IndexedStoreException;
import org.eclipse.core.internal.indexing.Insertable;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectID;

public class Index {
    private IndexedStore store;
    private ObjectAddress anchorAddress;

    private Index() {
    }

    Index(IndexedStore store, ObjectAddress anchorAddress) {
        this.store = store;
        this.anchorAddress = anchorAddress;
    }

    public synchronized int getNumberOfEntries() throws IndexedStoreException {
        IndexAnchor anchor = this.store.acquireAnchor(this.anchorAddress);
        int n = anchor.getNumberOfEntries();
        anchor.release();
        return n;
    }

    public synchronized int getNumberOfNodes() throws IndexedStoreException {
        IndexAnchor anchor = this.store.acquireAnchor(this.anchorAddress);
        int n = anchor.getNumberOfNodes();
        anchor.release();
        return n;
    }

    public synchronized Vector getObjectIdentifiersMatching(byte[] key) throws IndexedStoreException {
        IndexCursor cursor = this.open();
        cursor.find(key);
        Vector<ObjectID> vector = new Vector<ObjectID>(20);
        while (cursor.keyMatches(key)) {
            vector.addElement(cursor.getValueAsObjectID());
            cursor.next();
        }
        cursor.close();
        return vector;
    }

    public synchronized Vector getObjectIdentifiersMatching(String key) throws IndexedStoreException {
        return this.getObjectIdentifiersMatching(Convert.toUTF8(key));
    }

    public synchronized Vector getObjectIdentifiersMatching(Insertable key) throws IndexedStoreException {
        return this.getObjectIdentifiersMatching(key.toByteArray());
    }

    public synchronized void insert(byte[] key, byte[] value) throws IndexedStoreException {
        if (key.length > 1024) {
            throw new IndexedStoreException(1);
        }
        if (value.length > 2048) {
            throw new IndexedStoreException(3);
        }
        IndexAnchor anchor = this.store.acquireAnchor(this.anchorAddress);
        anchor.insert(key, value);
        anchor.release();
    }

    public synchronized void insert(byte[] key, String value) throws IndexedStoreException {
        this.insert(key, Convert.toUTF8(value));
    }

    public synchronized void insert(byte[] key, Insertable value) throws IndexedStoreException {
        this.insert(key, value.toByteArray());
    }

    public synchronized void insert(String key, byte[] value) throws IndexedStoreException {
        this.insert(Convert.toUTF8(key), value);
    }

    public synchronized void insert(String key, String value) throws IndexedStoreException {
        this.insert(Convert.toUTF8(key), Convert.toUTF8(value));
    }

    public synchronized void insert(String key, Insertable value) throws IndexedStoreException {
        this.insert(Convert.toUTF8(key), value.toByteArray());
    }

    public synchronized void insert(Insertable key, byte[] value) throws IndexedStoreException {
        this.insert(key.toByteArray(), value);
    }

    public synchronized void insert(Insertable key, String value) throws IndexedStoreException {
        this.insert(key.toByteArray(), Convert.toUTF8(value));
    }

    public synchronized void insert(Insertable key, Insertable value) throws IndexedStoreException {
        this.insert(key.toByteArray(), value.toByteArray());
    }

    public synchronized IndexCursor open() throws IndexedStoreException {
        IndexCursor c = new IndexCursor(this.store, this.anchorAddress);
        return c;
    }

    public synchronized void removeAllEqual(byte[] key) throws IndexedStoreException {
        IndexCursor c = this.open();
        c.find(key);
        while (c.keyEquals(key)) {
            c.removeEntry();
        }
        c.close();
    }

    public synchronized void removeAllMatching(byte[] keyPrefix) throws IndexedStoreException {
        IndexCursor c = this.open();
        c.find(keyPrefix);
        while (c.keyMatches(keyPrefix)) {
            c.removeEntry();
        }
        c.close();
    }
}

