/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.net;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class TelnetTask
extends Task {
    private String userid = null;
    private String password = null;
    private String server = null;
    private int port = 23;
    private AntTelnetClient telnet = null;
    private Vector telnetTasks = new Vector();
    private boolean addCarriageReturn = false;
    private Integer defaultTimeout = null;

    public void execute() throws BuildException {
        if (this.server == null) {
            throw new BuildException("No Server Specified");
        }
        if (this.userid == null && this.password != null) {
            throw new BuildException("No Userid Specified");
        }
        if (this.password == null && this.userid != null) {
            throw new BuildException("No Password Specified");
        }
        this.telnet = new AntTelnetClient();
        try {
            this.telnet.connect(this.server, this.port);
        }
        catch (IOException e) {
            throw new BuildException("Can't connect to " + this.server);
        }
        if (this.userid != null && this.password != null) {
            this.login();
        }
        Enumeration tasksToRun = this.telnetTasks.elements();
        while (tasksToRun != null && tasksToRun.hasMoreElements()) {
            TelnetSubTask task = (TelnetSubTask)tasksToRun.nextElement();
            if (task instanceof TelnetRead && this.defaultTimeout != null) {
                ((TelnetRead)task).setDefaultTimeout(this.defaultTimeout);
            }
            task.execute(this.telnet);
        }
    }

    private void login() {
        if (this.addCarriageReturn) {
            this.telnet.sendString("\n", true);
        }
        this.telnet.waitForString("ogin:");
        this.telnet.sendString(this.userid, true);
        this.telnet.waitForString("assword:");
        this.telnet.sendString(this.password, false);
    }

    public void setUserid(String u) {
        this.userid = u;
    }

    public void setPassword(String p) {
        this.password = p;
    }

    public void setServer(String m) {
        this.server = m;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public void setInitialCR(boolean b) {
        this.addCarriageReturn = b;
    }

    public void setTimeout(Integer i) {
        this.defaultTimeout = i;
    }

    public TelnetSubTask createRead() {
        TelnetRead task = new TelnetRead();
        this.telnetTasks.addElement(task);
        return task;
    }

    public TelnetSubTask createWrite() {
        TelnetWrite task = new TelnetWrite();
        this.telnetTasks.addElement(task);
        return task;
    }

    public class AntTelnetClient
    extends TelnetClient {
        public void waitForString(String s) {
            this.waitForString(s, null);
        }

        /*
         * Unable to fully structure code
         */
        public void waitForString(String s, Integer timeout) {
            is = this.getInputStream();
            try {
                block8: {
                    block7: {
                        sb = new StringBuffer();
                        if (timeout != null && timeout != 0) break block7;
                        while (sb.toString().indexOf(s) == -1) {
                            sb.append((char)is.read());
                        }
                        break block8;
                    }
                    endTime = Calendar.getInstance();
                    endTime.add(13, timeout);
                    ** GOTO lbl22
                    {
                        Thread.sleep(250L);
                        do {
                            if (Calendar.getInstance().before(endTime) && is.available() == 0) continue block4;
                            if (is.available() == 0) {
                                TelnetTask.this.log("Read before running into timeout: " + sb.toString(), 4);
                                throw new BuildException("Response timed-out waiting for \"" + s + '\"', TelnetTask.this.getLocation());
                            }
                            sb.append((char)is.read());
lbl22:
                            // 2 sources

                        } while (sb.toString().indexOf(s) == -1);
                    }
                }
                TelnetTask.this.log(sb.toString(), 2);
            }
            catch (BuildException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e, TelnetTask.this.getLocation());
            }
        }

        public void sendString(String s, boolean echoString) {
            OutputStream os = this.getOutputStream();
            try {
                os.write((s + "\n").getBytes());
                if (echoString) {
                    TelnetTask.this.log(s, 2);
                }
                os.flush();
            }
            catch (Exception e) {
                throw new BuildException((Throwable)e, TelnetTask.this.getLocation());
            }
        }
    }

    public class TelnetRead
    extends TelnetSubTask {
        private Integer timeout = null;

        public void execute(AntTelnetClient telnet) throws BuildException {
            telnet.waitForString(this.taskString, this.timeout);
        }

        public void setTimeout(Integer i) {
            this.timeout = i;
        }

        public void setDefaultTimeout(Integer defaultTimeout) {
            if (this.timeout == null) {
                this.timeout = defaultTimeout;
            }
        }
    }

    public class TelnetWrite
    extends TelnetSubTask {
        private boolean echoString = true;

        public void execute(AntTelnetClient telnet) throws BuildException {
            telnet.sendString(this.taskString, this.echoString);
        }

        public void setEcho(boolean b) {
            this.echoString = b;
        }
    }

    public class TelnetSubTask {
        protected String taskString = "";

        public void execute(AntTelnetClient telnet) throws BuildException {
            throw new BuildException("Shouldn't be able instantiate a SubTask directly");
        }

        public void addText(String s) {
            this.setString(TelnetTask.this.getProject().replaceProperties(s));
        }

        public void setString(String s) {
            this.taskString = this.taskString + s;
        }
    }
}

