/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.SourceRange;
import org.eclipse.jdt.internal.core.util.ReferenceInfoAdapter;
import org.eclipse.jdt.internal.core.util.Util;

public class SourceMapper
extends ReferenceInfoAdapter
implements ISourceElementRequestor,
SuffixConstants {
    public static boolean VERBOSE = false;
    private static final FilenameFilter FILENAME_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.endsWith(".JAVA") || name.endsWith(".java");
        }
    };
    protected HashSet rootPaths;
    protected BinaryType fType;
    protected IPath sourcePath;
    protected String rootPath;
    protected static String[] fgEmptyStringArray = new String[0];
    protected HashMap fParameterNames;
    protected HashMap fSourceRanges;
    public static SourceRange fgUnknownRange = new SourceRange(-1, 0);
    protected int[] fMemberDeclarationStart;
    protected SourceRange[] fMemberNameRange;
    protected String[] fMemberName;
    protected char[][][] fMethodParameterNames;
    protected char[][][] fMethodParameterTypes;
    protected IJavaElement searchedElement;
    private HashMap importsTable;
    private HashMap importsCounterTable;
    IType[] types;
    int[] typeDeclarationStarts;
    SourceRange[] typeNameRanges;
    int typeDepth;
    int anonymousCounter;
    int anonymousClassName;
    String encoding;
    Map options;
    private boolean areRootPathsComputed = false;

    public SourceMapper() {
    }

    public SourceMapper(IPath sourcePath, String rootPath, Map options) {
        this.options = options;
        try {
            this.encoding = ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset();
        }
        catch (CoreException e) {
            // empty catch block
        }
        if (rootPath != null) {
            this.rootPaths = new HashSet();
            this.rootPaths.add(rootPath);
        }
        this.sourcePath = sourcePath;
        this.fSourceRanges = new HashMap();
        this.fParameterNames = new HashMap();
        this.importsTable = new HashMap();
        this.importsCounterTable = new HashMap();
    }

    public void acceptImport(int declarationStart, int declarationEnd, char[] name, boolean onDemand, int modifiers) {
        int importsCounter;
        Object imports = (char[][])this.importsTable.get(this.fType);
        if (imports == null) {
            imports = new char[5][];
            importsCounter = 0;
        } else {
            importsCounter = (Integer)this.importsCounterTable.get(this.fType);
        }
        if (((char[][])imports).length == importsCounter) {
            Object object = imports;
            char[][] cArrayArray = new char[importsCounter * 2][];
            imports = cArrayArray;
            System.arraycopy(object, 0, cArrayArray, 0, importsCounter);
        }
        if (onDemand) {
            int nameLength = name.length;
            char[] cArray = name;
            name = new char[nameLength + 2];
            System.arraycopy(cArray, 0, name, 0, nameLength);
            name[nameLength] = 46;
            name[nameLength + 1] = 42;
        }
        imports[importsCounter++] = name;
        this.importsTable.put(this.fType, imports);
        this.importsCounterTable.put(this.fType, new Integer(importsCounter));
    }

    public void acceptLineSeparatorPositions(int[] positions) {
    }

    public void acceptPackage(int declarationStart, int declarationEnd, char[] name) {
    }

    public void acceptProblem(IProblem problem) {
    }

    public void close() {
        this.fSourceRanges = null;
        this.fParameterNames = null;
    }

    private String[] convertTypeNamesToSigs(char[][] typeNames) {
        if (typeNames == null) {
            return fgEmptyStringArray;
        }
        int n = typeNames.length;
        if (n == 0) {
            return fgEmptyStringArray;
        }
        String[] typeSigs = new String[n];
        for (int i = 0; i < n; ++i) {
            String typeSig = Signature.createTypeSignature(typeNames[i], false);
            int lastIndex = typeSig.lastIndexOf(46);
            if (lastIndex == -1) {
                typeSigs[i] = typeSig;
                continue;
            }
            int arrayEnd = 0;
            while (typeSig.charAt(arrayEnd) == '[') {
                ++arrayEnd;
            }
            typeSigs[i] = typeSig.substring(0, arrayEnd) + 'Q' + typeSig.substring(lastIndex + 1, typeSig.length());
        }
        return typeSigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeAllRootPaths(IPackageFragmentRoot root) {
        File file;
        Object target;
        if (this.rootPaths == null) {
            this.rootPaths = new HashSet();
        }
        long time = 0L;
        if (VERBOSE) {
            System.out.println("compute all root paths for " + root.getElementName());
            time = System.currentTimeMillis();
        }
        HashSet<String> firstLevelPackageNames = new HashSet<String>();
        boolean containsADefaultPackage = false;
        if (root.isArchive()) {
            JarPackageFragmentRoot jarPackageFragmentRoot = (JarPackageFragmentRoot)root;
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            ZipFile zip = null;
            try {
                zip = manager.getZipFile(jarPackageFragmentRoot.getPath());
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (entry.isDirectory()) continue;
                    int index = entryName.indexOf(47);
                    if (index != -1 && org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(entryName)) {
                        String firstLevelPackageName = entryName.substring(0, index);
                        IStatus status = JavaConventions.validatePackageName(firstLevelPackageName);
                        if (!status.isOK() && status.getSeverity() != 2) continue;
                        firstLevelPackageNames.add(firstLevelPackageName);
                        continue;
                    }
                    if (!org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(entryName)) continue;
                    containsADefaultPackage = true;
                }
            }
            catch (CoreException e) {
            }
            finally {
                manager.closeZipFile(zip);
            }
        } else {
            target = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), root.getPath(), true);
            if (target instanceof IResource) {
                IResource resource = (IResource)target;
                if (resource instanceof IContainer) {
                    try {
                        IResource[] members = ((IContainer)resource).members();
                        int max = members.length;
                        for (int i = 0; i < max; ++i) {
                            IResource member = members[i];
                            if (member.getType() == 2) {
                                firstLevelPackageNames.add(member.getName());
                                continue;
                            }
                            if (!org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(member.getName())) continue;
                            containsADefaultPackage = true;
                        }
                    }
                    catch (CoreException e) {}
                }
            } else if (target instanceof File && (file = (File)target).isDirectory()) {
                File[] files = file.listFiles();
                int max = files.length;
                for (int i = 0; i < max; ++i) {
                    File currentFile = files[i];
                    if (currentFile.isDirectory()) {
                        firstLevelPackageNames.add(currentFile.getName());
                        continue;
                    }
                    if (!org.eclipse.jdt.internal.compiler.util.Util.isClassFileName(currentFile.getName())) continue;
                    containsADefaultPackage = true;
                }
            }
        }
        if (org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(this.sourcePath.lastSegment())) {
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            ZipFile zip = null;
            try {
                zip = manager.getZipFile(this.sourcePath);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                block15: while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) continue;
                    Path path = new Path(entry.getName());
                    int segmentCount = path.segmentCount();
                    if (segmentCount > 1) {
                        int max = path.segmentCount() - 1;
                        for (int i = 0; i < max; ++i) {
                            if (firstLevelPackageNames.contains(path.segment(i))) {
                                this.rootPaths.add(path.uptoSegment(i).toString());
                                continue block15;
                            }
                            if (i != max - 1 || !containsADefaultPackage) continue;
                            this.rootPaths.add(path.uptoSegment(max).toString());
                        }
                        continue;
                    }
                    if (!containsADefaultPackage) continue;
                    this.rootPaths.add("");
                }
            }
            catch (CoreException e) {
            }
            finally {
                manager.closeZipFile(zip);
            }
        } else {
            target = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.sourcePath, true);
            if (target instanceof IResource) {
                if (target instanceof IContainer) {
                    this.computeRootPath((IContainer)target, firstLevelPackageNames, containsADefaultPackage);
                }
            } else if (target instanceof File && (file = (File)target).isDirectory()) {
                this.computeRootPath(file, firstLevelPackageNames, containsADefaultPackage);
            }
        }
        if (VERBOSE) {
            System.out.println("Found " + this.rootPaths.size() + " root paths");
            System.out.println("Spent " + (System.currentTimeMillis() - time) + "ms");
        }
        this.areRootPathsComputed = true;
    }

    private void computeRootPath(File directory, HashSet firstLevelPackageNames, boolean hasDefaultPackage) {
        File[] files = directory.listFiles();
        boolean hasSubDirectories = false;
        int max = files.length;
        for (int i = 0; i < max; ++i) {
            File parentDir;
            File file = files[i];
            if (file.isDirectory()) {
                hasSubDirectories = true;
                if (firstLevelPackageNames.contains(file.getName())) {
                    Path fullPath = new Path(file.getParentFile().getPath());
                    IPath rootPathEntry = fullPath.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
                    this.rootPaths.add(rootPathEntry.toString());
                    break;
                }
                this.computeRootPath(file, firstLevelPackageNames, hasDefaultPackage);
                continue;
            }
            if (i != max - 1 || hasSubDirectories || !hasDefaultPackage || (parentDir = file.getParentFile()).list(FILENAME_FILTER).length == 0) continue;
            Path fullPath = new Path(parentDir.getPath());
            IPath rootPathEntry = fullPath.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
            this.rootPaths.add(rootPathEntry.toString());
        }
    }

    private void computeRootPath(IContainer container, HashSet firstLevelPackageNames, boolean hasDefaultPackage) {
        try {
            IResource[] resources = container.members();
            boolean hasSubDirectories = false;
            int max = resources.length;
            for (int i = 0; i < max; ++i) {
                IResource resource = resources[i];
                if (resource.getType() == 2) {
                    hasSubDirectories = true;
                    if (firstLevelPackageNames.contains(resource.getName())) {
                        IPath fullPath = container.getFullPath();
                        IPath rootPathEntry = fullPath.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
                        this.rootPaths.add(rootPathEntry.toString());
                        break;
                    }
                    this.computeRootPath((IContainer)((IFolder)resource), firstLevelPackageNames, hasDefaultPackage);
                }
                if (i != max - 1 || hasSubDirectories || !hasDefaultPackage) continue;
                boolean hasJavaSourceFile = false;
                for (int j = 0; j < max; ++j) {
                    if (!org.eclipse.jdt.internal.compiler.util.Util.isJavaFileName(resources[i].getName())) continue;
                    hasJavaSourceFile = true;
                    break;
                }
                if (!hasJavaSourceFile) continue;
                IPath fullPath = container.getFullPath();
                IPath rootPathEntry = fullPath.removeFirstSegments(this.sourcePath.segmentCount()).setDevice(null);
                this.rootPaths.add(rootPathEntry.toString());
            }
        }
        catch (CoreException e) {
            // empty catch block
        }
    }

    public void enterClass(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[] superclass, char[][] superinterfaces) {
        ++this.typeDepth;
        if (this.typeDepth == this.types.length) {
            this.types = new IType[this.typeDepth * 2];
            System.arraycopy(this.types, 0, this.types, 0, this.typeDepth);
            this.typeNameRanges = new SourceRange[this.typeDepth * 2];
            System.arraycopy(this.typeNameRanges, 0, this.typeNameRanges, 0, this.typeDepth);
            this.typeDeclarationStarts = new int[this.typeDepth * 2];
            System.arraycopy(this.typeDeclarationStarts, 0, this.typeDeclarationStarts, 0, this.typeDepth);
            this.fMemberName = new String[this.typeDepth * 2];
            System.arraycopy(this.fMemberName, 0, this.fMemberName, 0, this.typeDepth);
            this.fMemberDeclarationStart = new int[this.typeDepth * 2];
            System.arraycopy(this.fMemberDeclarationStart, 0, this.fMemberDeclarationStart, 0, this.typeDepth);
            this.fMemberNameRange = new SourceRange[this.typeDepth * 2];
            System.arraycopy(this.fMemberNameRange, 0, this.fMemberNameRange, 0, this.typeDepth);
            char[][][] cArrayArray = new char[this.typeDepth * 2][][];
            this.fMethodParameterTypes = cArrayArray;
            System.arraycopy(this.fMethodParameterTypes, 0, cArrayArray, 0, this.typeDepth);
            char[][][] cArrayArray2 = new char[this.typeDepth * 2][][];
            this.fMethodParameterNames = cArrayArray2;
            System.arraycopy(this.fMethodParameterNames, 0, cArrayArray2, 0, this.typeDepth);
        }
        if (name.length == 0) {
            ++this.anonymousCounter;
            this.types[this.typeDepth] = this.anonymousCounter == this.anonymousClassName ? this.getType(this.fType.getElementName()) : this.getType(new String(name));
        } else {
            this.types[this.typeDepth] = this.getType(new String(name));
        }
        this.typeNameRanges[this.typeDepth] = new SourceRange(nameSourceStart, nameSourceEnd - nameSourceStart + 1);
        this.typeDeclarationStarts[this.typeDepth] = declarationStart;
    }

    public void enterCompilationUnit() {
    }

    public void enterConstructor(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
        this.enterMethod(declarationStart, modifiers, null, name, nameSourceStart, nameSourceEnd, parameterTypes, parameterNames, exceptionTypes);
    }

    public void enterField(int declarationStart, int modifiers, char[] type, char[] name, int nameSourceStart, int nameSourceEnd) {
        if (this.typeDepth >= 0) {
            this.fMemberDeclarationStart[this.typeDepth] = declarationStart;
            this.fMemberNameRange[this.typeDepth] = new SourceRange(nameSourceStart, nameSourceEnd - nameSourceStart + 1);
            this.fMemberName[this.typeDepth] = new String(name);
        }
    }

    public void enterInitializer(int declarationSourceStart, int modifiers) {
    }

    public void enterInterface(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] superinterfaces) {
        this.enterClass(declarationStart, modifiers, name, nameSourceStart, nameSourceEnd, null, superinterfaces);
    }

    public void enterMethod(int declarationStart, int modifiers, char[] returnType, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
        if (this.typeDepth >= 0) {
            this.fMemberName[this.typeDepth] = new String(name);
            this.fMemberNameRange[this.typeDepth] = new SourceRange(nameSourceStart, nameSourceEnd - nameSourceStart + 1);
            this.fMemberDeclarationStart[this.typeDepth] = declarationStart;
            this.fMethodParameterTypes[this.typeDepth] = parameterTypes;
            this.fMethodParameterNames[this.typeDepth] = parameterNames;
        }
    }

    public void exitClass(int declarationEnd) {
        if (this.typeDepth >= 0) {
            IType currentType = this.types[this.typeDepth];
            this.setSourceRange(currentType, new SourceRange(this.typeDeclarationStarts[this.typeDepth], declarationEnd - this.typeDeclarationStarts[this.typeDepth] + 1), this.typeNameRanges[this.typeDepth]);
            --this.typeDepth;
        }
    }

    public void exitCompilationUnit(int declarationEnd) {
    }

    public void exitConstructor(int declarationEnd) {
        this.exitMethod(declarationEnd);
    }

    public void exitField(int initializationStart, int declarationEnd, int declarationSourceEnd) {
        if (this.typeDepth >= 0) {
            IType currentType = this.types[this.typeDepth];
            this.setSourceRange(currentType.getField(this.fMemberName[this.typeDepth]), new SourceRange(this.fMemberDeclarationStart[this.typeDepth], declarationEnd - this.fMemberDeclarationStart[this.typeDepth] + 1), this.fMemberNameRange[this.typeDepth]);
        }
    }

    public void exitInitializer(int declarationEnd) {
    }

    public void exitInterface(int declarationEnd) {
        this.exitClass(declarationEnd);
    }

    public void exitMethod(int declarationEnd) {
        if (this.typeDepth >= 0) {
            IType currentType = this.types[this.typeDepth];
            SourceRange sourceRange = new SourceRange(this.fMemberDeclarationStart[this.typeDepth], declarationEnd - this.fMemberDeclarationStart[this.typeDepth] + 1);
            IMethod method = currentType.getMethod(this.fMemberName[this.typeDepth], this.convertTypeNamesToSigs(this.fMethodParameterTypes[this.typeDepth]));
            this.setSourceRange(method, sourceRange, this.fMemberNameRange[this.typeDepth]);
            this.setMethodParameterNames(method, this.fMethodParameterNames[this.typeDepth]);
        }
    }

    public char[] findSource(IType type) {
        if (!type.isBinary()) {
            return null;
        }
        BinaryType parent = (BinaryType)type.getDeclaringType();
        BinaryType declType = (BinaryType)type;
        while (parent != null) {
            declType = parent;
            parent = (BinaryType)declType.getDeclaringType();
        }
        IBinaryType info = null;
        try {
            info = (IBinaryType)declType.getElementInfo();
        }
        catch (JavaModelException e) {
            return null;
        }
        String simpleSourceFileName = this.findSourceFileName(type, info);
        if (simpleSourceFileName == null) {
            return null;
        }
        return this.findSource(type, simpleSourceFileName);
    }

    public char[] findSource(IType type, String simpleSourceFileName) {
        long time = 0L;
        if (VERBOSE) {
            time = System.currentTimeMillis();
        }
        String name = simpleSourceFileName;
        IPackageFragment pkgFrag = type.getPackageFragment();
        if (!pkgFrag.isDefaultPackage()) {
            String pkg = pkgFrag.getElementName().replace('.', '/');
            name = pkg + '/' + name;
        }
        char[] source = null;
        if (!this.areRootPathsComputed) {
            this.computeAllRootPaths((IPackageFragmentRoot)type.getPackageFragment().getParent());
        }
        if (this.rootPath != null) {
            source = this.getSourceForRootPath(this.rootPath, name);
        }
        if (source == null && this.rootPaths != null) {
            Iterator iterator = this.rootPaths.iterator();
            while (iterator.hasNext()) {
                String currentRootPath = (String)iterator.next();
                if (currentRootPath.equals(this.rootPath) || (source = this.getSourceForRootPath(currentRootPath, name)) == null) continue;
                this.rootPath = currentRootPath;
                break;
            }
        }
        if (VERBOSE) {
            System.out.println("spent " + (System.currentTimeMillis() - time) + "ms for " + type.getElementName());
        }
        return source;
    }

    public String findSourceFileName(IType type, IBinaryType info) {
        char[] sourceFileName = info.sourceFileName();
        if (sourceFileName == null) {
            if (info.isMember()) {
                IType enclosingType = type.getDeclaringType();
                if (enclosingType == null) {
                    return null;
                }
                while (enclosingType.getDeclaringType() != null) {
                    enclosingType = enclosingType.getDeclaringType();
                }
                return enclosingType.getElementName() + ".java";
            }
            if (info.isLocal() || info.isAnonymous()) {
                String typeQualifiedName = type.getTypeQualifiedName();
                int dollar = typeQualifiedName.indexOf(36);
                if (dollar == -1) {
                    return type.getElementName() + ".java";
                }
                return typeQualifiedName.substring(0, dollar) + ".java";
            }
            return type.getElementName() + ".java";
        }
        return new String(sourceFileName);
    }

    private char[] getSourceForRootPath(String currentRootPath, String name) {
        String newFullName = !currentRootPath.equals("") ? (currentRootPath.endsWith("/") ? currentRootPath + name : currentRootPath + '/' + name) : name;
        return this.findSource(newFullName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public char[] findSource(String fullName) {
        char[] source = null;
        if (org.eclipse.jdt.internal.compiler.util.Util.isArchiveFileName(this.sourcePath.lastSegment())) {
            ZipEntry entry = null;
            ZipFile zip = null;
            JavaModelManager manager = JavaModelManager.getJavaModelManager();
            try {
                zip = manager.getZipFile(this.sourcePath);
                entry = zip.getEntry(fullName);
                if (entry == null) return source;
                source = this.readSource(entry, zip);
                return source;
            }
            catch (CoreException e) {
                char[] cArray = null;
                return cArray;
            }
            finally {
                manager.closeZipFile(zip);
            }
        } else {
            Object target = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.sourcePath, true);
            if (target instanceof IResource) {
                if (!(target instanceof IContainer)) return source;
                IResource res = ((IContainer)target).findMember(fullName);
                if (!(res instanceof IFile)) return source;
                try {
                    return Util.getResourceContentsAsCharArray((IFile)res);
                }
                catch (JavaModelException e) {}
                return source;
            } else {
                if (!(target instanceof File)) return source;
                File file = (File)target;
                if (!file.isDirectory()) return source;
                File sourceFile = new File(file, fullName);
                if (!sourceFile.isFile()) return source;
                try {
                    return org.eclipse.jdt.internal.compiler.util.Util.getFileCharContent(sourceFile, this.encoding);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        return source;
    }

    public SourceRange getNameRange(IJavaElement element) {
        SourceRange[] ranges;
        if (element.getElementType() == 9 && ((IMember)element).isBinary()) {
            IJavaElement[] el = this.getUnqualifiedMethodHandle((IMethod)element, false);
            element = el[1] != null && this.fSourceRanges.get(el[0]) == null ? this.getUnqualifiedMethodHandle((IMethod)element, true)[0] : el[0];
        }
        if ((ranges = (SourceRange[])this.fSourceRanges.get(element)) == null) {
            return fgUnknownRange;
        }
        return ranges[1];
    }

    public char[][] getMethodParameterNames(IMethod method) {
        char[][] parameterNames;
        if (method.isBinary()) {
            IJavaElement[] el = this.getUnqualifiedMethodHandle(method, false);
            method = el[1] != null && this.fParameterNames.get(el[0]) == null ? (IMethod)this.getUnqualifiedMethodHandle(method, true)[0] : (IMethod)el[0];
        }
        if ((parameterNames = (char[][])this.fParameterNames.get(method)) == null) {
            return null;
        }
        return parameterNames;
    }

    public SourceRange getSourceRange(IJavaElement element) {
        SourceRange[] ranges;
        if (element.getElementType() == 9 && ((IMember)element).isBinary()) {
            IJavaElement[] el = this.getUnqualifiedMethodHandle((IMethod)element, false);
            element = el[1] != null && this.fSourceRanges.get(el[0]) == null ? this.getUnqualifiedMethodHandle((IMethod)element, true)[0] : el[0];
        }
        if ((ranges = (SourceRange[])this.fSourceRanges.get(element)) == null) {
            return fgUnknownRange;
        }
        return ranges[0];
    }

    protected IType getType(String typeName) {
        if (this.fType.getElementName().equals(typeName)) {
            return this.fType;
        }
        return this.fType.getType(typeName);
    }

    protected IJavaElement[] getUnqualifiedMethodHandle(IMethod method, boolean noDollar) {
        boolean hasDollar = false;
        String[] qualifiedParameterTypes = method.getParameterTypes();
        String[] unqualifiedParameterTypes = new String[qualifiedParameterTypes.length];
        for (int i = 0; i < qualifiedParameterTypes.length; ++i) {
            StringBuffer unqualifiedName = new StringBuffer();
            String qualifiedName = qualifiedParameterTypes[i];
            int count = 0;
            while (qualifiedName.charAt(count) == '[') {
                unqualifiedName.append('[');
                ++count;
            }
            if (qualifiedName.charAt(count) == 'L') {
                unqualifiedName.append('Q');
                String simpleName = Signature.getSimpleName(qualifiedName.substring(count + 1));
                if (!noDollar) {
                    if (!hasDollar && simpleName.indexOf(36) != -1) {
                        hasDollar = true;
                    }
                    unqualifiedName.append(simpleName);
                } else {
                    unqualifiedName.append(CharOperation.lastSegment(simpleName.toCharArray(), '$'));
                }
            } else {
                unqualifiedName.append(qualifiedName.substring(count, qualifiedName.length()));
            }
            unqualifiedParameterTypes[i] = unqualifiedName.toString();
        }
        IJavaElement[] result = new IJavaElement[2];
        result[0] = ((IType)method.getParent()).getMethod(method.getElementName(), unqualifiedParameterTypes);
        if (hasDollar) {
            result[1] = result[0];
        }
        return result;
    }

    public void mapSource(IType type, char[] contents) {
        this.mapSource(type, contents, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ISourceRange mapSource(IType type, char[] contents, IJavaElement elementToFind) {
        HashMap oldSourceRanges;
        block13: {
            this.fType = (BinaryType)type;
            if (this.fSourceRanges.get(type) != null) {
                return elementToFind != null ? this.getNameRange(elementToFind) : null;
            }
            this.importsTable.remove(this.fType);
            this.importsCounterTable.remove(this.fType);
            this.searchedElement = elementToFind;
            this.types = new IType[1];
            this.typeDeclarationStarts = new int[1];
            this.typeNameRanges = new SourceRange[1];
            this.typeDepth = -1;
            this.fMemberDeclarationStart = new int[1];
            this.fMemberName = new String[1];
            this.fMemberNameRange = new SourceRange[1];
            this.fMethodParameterTypes = new char[1][][];
            this.fMethodParameterNames = new char[1][][];
            this.anonymousCounter = 0;
            oldSourceRanges = (HashMap)this.fSourceRanges.clone();
            try {
                SourceRange range;
                DefaultProblemFactory factory = new DefaultProblemFactory();
                SourceElementParser parser = null;
                boolean isAnonymousClass = false;
                char[] fullName = null;
                this.anonymousClassName = 0;
                try {
                    IBinaryType binType = (IBinaryType)this.fType.getElementInfo();
                    isAnonymousClass = binType.isAnonymous();
                    fullName = binType.getName();
                }
                catch (JavaModelException e) {
                    // empty catch block
                }
                if (isAnonymousClass) {
                    String eltName = this.fType.getElementName();
                    eltName = eltName.substring(eltName.lastIndexOf(36) + 1, eltName.length());
                    try {
                        this.anonymousClassName = Integer.parseInt(eltName);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                boolean doFullParse = this.hasToRetrieveSourceRangesForLocalClass(fullName);
                parser = new SourceElementParser(this, factory, new CompilerOptions(this.options), doFullParse);
                IJavaElement javaElement = this.fType.getCompilationUnit();
                if (javaElement == null) {
                    javaElement = this.fType.getParent();
                }
                parser.parseCompilationUnit(new BasicCompilationUnit(contents, (char[][])null, type.getElementName() + ".java", javaElement), doFullParse);
                if (elementToFind == null) break block13;
                SourceRange sourceRange = range = this.getNameRange(elementToFind);
                Object var14_17 = null;
                if (elementToFind != null) {
                    this.fSourceRanges = oldSourceRanges;
                }
                this.fType = null;
                this.searchedElement = null;
                this.types = null;
                this.typeDeclarationStarts = null;
                this.typeNameRanges = null;
                this.typeDepth = -1;
                return sourceRange;
            }
            catch (Throwable throwable) {
                Object var14_19 = null;
                if (elementToFind != null) {
                    this.fSourceRanges = oldSourceRanges;
                }
                this.fType = null;
                this.searchedElement = null;
                this.types = null;
                this.typeDeclarationStarts = null;
                this.typeNameRanges = null;
                this.typeDepth = -1;
                throw throwable;
            }
        }
        ISourceRange iSourceRange = null;
        Object var14_18 = null;
        if (elementToFind != null) {
            this.fSourceRanges = oldSourceRanges;
        }
        this.fType = null;
        this.searchedElement = null;
        this.types = null;
        this.typeDeclarationStarts = null;
        this.typeNameRanges = null;
        this.typeDepth = -1;
        return iSourceRange;
    }

    private char[] readSource(ZipEntry entry, ZipFile zip) {
        try {
            byte[] bytes = org.eclipse.jdt.internal.compiler.util.Util.getZipEntryByteContent(entry, zip);
            if (bytes != null) {
                return org.eclipse.jdt.internal.compiler.util.Util.bytesToChar(bytes, this.encoding);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    protected void setMethodParameterNames(IMethod method, char[][] parameterNames) {
        if (parameterNames == null) {
            parameterNames = CharOperation.NO_CHAR_CHAR;
        }
        this.fParameterNames.put(method, parameterNames);
    }

    protected void setSourceRange(IJavaElement element, SourceRange sourceRange, SourceRange nameRange) {
        this.fSourceRanges.put(element, new SourceRange[]{sourceRange, nameRange});
    }

    public char[][] getImports(BinaryType type) {
        Object imports = (char[][])this.importsTable.get(type);
        if (imports != null) {
            int importsCounter = (Integer)this.importsCounterTable.get(type);
            if (((char[][])imports).length != importsCounter) {
                char[][] cArray = imports;
                char[][] cArrayArray = new char[importsCounter][];
                imports = cArrayArray;
                System.arraycopy(cArray, 0, cArrayArray, 0, importsCounter);
            }
            this.importsTable.put(type, imports);
        }
        return imports;
    }

    private boolean hasToRetrieveSourceRangesForLocalClass(char[] eltName) {
        if (eltName == null) {
            return false;
        }
        int index = 0;
        int dollarIndex = CharOperation.indexOf('$', eltName, index);
        if (dollarIndex != -1) {
            index = dollarIndex + 1;
            if ((dollarIndex = CharOperation.indexOf('$', eltName, index)) == -1) {
                dollarIndex = eltName.length;
            }
            if (dollarIndex != -1) {
                for (int i = index; i < dollarIndex; ++i) {
                    if (Character.isDigit(eltName[i])) continue;
                    index = dollarIndex + 1;
                    i = dollarIndex;
                    if (index > eltName.length) {
                        return false;
                    }
                    dollarIndex = CharOperation.indexOf('$', eltName, index);
                    if (dollarIndex != -1) continue;
                    dollarIndex = eltName.length;
                }
                return true;
            }
        }
        return false;
    }
}

