/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class FieldReference
extends Reference
implements InvocationSite {
    public Expression receiver;
    public char[] token;
    public FieldBinding binding;
    public FieldBinding codegenBinding;
    public long nameSourcePosition;
    MethodBinding syntheticReadAccessor;
    MethodBinding syntheticWriteAccessor;
    public TypeBinding receiverType;

    public FieldReference(char[] source, long pos) {
        this.token = source;
        this.nameSourcePosition = pos;
        this.sourceStart = (int)(pos >>> 32);
        this.sourceEnd = (int)(pos & 0xFFFFFFFFL);
        this.bits |= 1;
    }

    public FlowInfo analyseAssignment(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean isCompound) {
        if (isCompound) {
            if (this.binding.isBlankFinal() && this.receiver.isThis() && currentScope.allowBlankFinalFieldAssignment(this.binding) && !flowInfo.isDefinitelyAssigned(this.binding)) {
                currentScope.problemReporter().uninitializedBlankFinalField(this.binding, this);
            }
            this.manageSyntheticReadAccessIfNecessary(currentScope, flowInfo);
        }
        flowInfo = this.receiver.analyseCode(currentScope, flowContext, flowInfo, !this.binding.isStatic()).unconditionalInits();
        if (assignment.expression != null) {
            flowInfo = assignment.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        }
        this.manageSyntheticWriteAccessIfNecessary(currentScope, flowInfo);
        if (this.binding.isFinal()) {
            if (this.binding.isBlankFinal() && !isCompound && this.receiver.isThis() && !(this.receiver instanceof QualifiedThisReference) && (this.receiver.bits & 0x1FE00000) == 0 && currentScope.allowBlankFinalFieldAssignment(this.binding)) {
                if (flowInfo.isPotentiallyAssigned(this.binding)) {
                    currentScope.problemReporter().duplicateInitializationOfBlankFinalField(this.binding, this);
                } else {
                    flowContext.recordSettingFinal(this.binding, this, flowInfo);
                }
                flowInfo.markAsDefinitelyAssigned(this.binding);
            } else {
                currentScope.problemReporter().cannotAssignToFinalField(this.binding, this);
            }
        }
        return flowInfo;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.analyseCode(currentScope, flowContext, flowInfo, true);
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, boolean valueRequired) {
        this.receiver.analyseCode(currentScope, flowContext, flowInfo, !this.binding.isStatic());
        if (valueRequired) {
            this.manageSyntheticReadAccessIfNecessary(currentScope, flowInfo);
        }
        return flowInfo;
    }

    public FieldBinding fieldBinding() {
        return this.binding;
    }

    public void generateAssignment(BlockScope currentScope, CodeStream codeStream, Assignment assignment, boolean valueRequired) {
        this.receiver.generateCode(currentScope, codeStream, !this.codegenBinding.isStatic());
        assignment.expression.generateCode(currentScope, codeStream, true);
        this.fieldStore(codeStream, this.codegenBinding, this.syntheticWriteAccessor, valueRequired);
        if (valueRequired) {
            codeStream.generateImplicitConversion(assignment.implicitConversion);
        }
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        int pc = codeStream.position;
        if (this.constant != NotAConstant) {
            if (valueRequired) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
        } else {
            boolean isStatic = this.codegenBinding.isStatic();
            this.receiver.generateCode(currentScope, codeStream, !isStatic);
            if (valueRequired) {
                if (this.codegenBinding.constant == NotAConstant) {
                    if (this.codegenBinding.declaringClass == null) {
                        codeStream.arraylength();
                    } else if (this.syntheticReadAccessor == null) {
                        if (isStatic) {
                            codeStream.getstatic(this.codegenBinding);
                        } else {
                            codeStream.getfield(this.codegenBinding);
                        }
                    } else {
                        codeStream.invokestatic(this.syntheticReadAccessor);
                    }
                    codeStream.generateImplicitConversion(this.implicitConversion);
                } else {
                    if (!isStatic) {
                        codeStream.invokeObjectGetClass();
                        codeStream.pop();
                    }
                    codeStream.generateConstant(this.codegenBinding.constant, this.implicitConversion);
                }
            } else if (!isStatic) {
                codeStream.invokeObjectGetClass();
                codeStream.pop();
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateCompoundAssignment(BlockScope currentScope, CodeStream codeStream, Expression expression, int operator, int assignmentImplicitConversion, boolean valueRequired) {
        boolean isStatic = this.codegenBinding.isStatic();
        this.receiver.generateCode(currentScope, codeStream, !isStatic);
        if (isStatic) {
            if (this.syntheticReadAccessor == null) {
                codeStream.getstatic(this.codegenBinding);
            } else {
                codeStream.invokestatic(this.syntheticReadAccessor);
            }
        } else {
            codeStream.dup();
            if (this.syntheticReadAccessor == null) {
                codeStream.getfield(this.codegenBinding);
            } else {
                codeStream.invokestatic(this.syntheticReadAccessor);
            }
        }
        int operationTypeID = this.implicitConversion >> 4;
        if (operationTypeID == 11) {
            codeStream.generateStringAppend(currentScope, null, expression);
        } else {
            codeStream.generateImplicitConversion(this.implicitConversion);
            if (expression == IntLiteral.One) {
                codeStream.generateConstant(expression.constant, this.implicitConversion);
            } else {
                expression.generateCode(currentScope, codeStream, true);
            }
            codeStream.sendOperator(operator, operationTypeID);
            codeStream.generateImplicitConversion(assignmentImplicitConversion);
        }
        this.fieldStore(codeStream, this.codegenBinding, this.syntheticWriteAccessor, valueRequired);
    }

    public void generatePostIncrement(BlockScope currentScope, CodeStream codeStream, CompoundAssignment postIncrement, boolean valueRequired) {
        boolean isStatic = this.codegenBinding.isStatic();
        this.receiver.generateCode(currentScope, codeStream, !isStatic);
        if (isStatic) {
            if (this.syntheticReadAccessor == null) {
                codeStream.getstatic(this.codegenBinding);
            } else {
                codeStream.invokestatic(this.syntheticReadAccessor);
            }
        } else {
            codeStream.dup();
            if (this.syntheticReadAccessor == null) {
                codeStream.getfield(this.codegenBinding);
            } else {
                codeStream.invokestatic(this.syntheticReadAccessor);
            }
        }
        if (valueRequired) {
            if (isStatic) {
                if (this.codegenBinding.type == BaseTypes.LongBinding || this.codegenBinding.type == BaseTypes.DoubleBinding) {
                    codeStream.dup2();
                } else {
                    codeStream.dup();
                }
            } else if (this.codegenBinding.type == BaseTypes.LongBinding || this.codegenBinding.type == BaseTypes.DoubleBinding) {
                codeStream.dup2_x1();
            } else {
                codeStream.dup_x1();
            }
        }
        codeStream.generateConstant(postIncrement.expression.constant, this.implicitConversion);
        codeStream.sendOperator(postIncrement.operator, this.codegenBinding.type.id);
        codeStream.generateImplicitConversion(postIncrement.assignmentImplicitConversion);
        this.fieldStore(codeStream, this.codegenBinding, this.syntheticWriteAccessor, false);
    }

    public static final Constant getConstantFor(FieldBinding binding, Reference reference, boolean isImplicit, Scope referenceScope) {
        if (binding.declaringClass == null) {
            return NotAConstant;
        }
        if (!binding.isFinal()) {
            binding.constant = NotAConstant;
            return binding.constant;
        }
        if (binding.constant != null) {
            if (isImplicit || reference instanceof QualifiedNameReference && binding == ((QualifiedNameReference)reference).binding) {
                return binding.constant;
            }
            return NotAConstant;
        }
        SourceTypeBinding typeBinding = (SourceTypeBinding)binding.declaringClass;
        TypeDeclaration typeDecl = typeBinding.scope.referenceContext;
        FieldDeclaration fieldDecl = typeDecl.declarationOf(binding);
        fieldDecl.resolve(binding.isStatic() ? typeDecl.staticInitializerScope : typeDecl.initializerScope);
        if (isImplicit || reference instanceof QualifiedNameReference && binding == ((QualifiedNameReference)reference).binding) {
            return binding.constant;
        }
        return NotAConstant;
    }

    public boolean isSuperAccess() {
        return this.receiver.isSuper();
    }

    public boolean isTypeAccess() {
        return this.receiver != null && this.receiver.isTypeReference();
    }

    public void manageSyntheticReadAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        if (this.binding.isPrivate()) {
            if (currentScope.enclosingSourceType() != this.binding.declaringClass && this.binding.constant == NotAConstant) {
                this.syntheticReadAccessor = ((SourceTypeBinding)this.binding.declaringClass).addSyntheticMethod(this.binding, true);
                currentScope.problemReporter().needToEmulateFieldReadAccess(this.binding, this);
                return;
            }
        } else {
            if (this.receiver instanceof QualifiedSuperReference) {
                SourceTypeBinding destinationType = (SourceTypeBinding)((QualifiedSuperReference)this.receiver).currentCompatibleType;
                this.syntheticReadAccessor = destinationType.addSyntheticMethod(this.binding, true);
                currentScope.problemReporter().needToEmulateFieldReadAccess(this.binding, this);
                return;
            }
            if (this.binding.isProtected() && (this.bits & 0x1FE0) != 0) {
                SourceTypeBinding enclosingSourceType = currentScope.enclosingSourceType();
                if (this.binding.declaringClass.getPackage() != enclosingSourceType.getPackage()) {
                    SourceTypeBinding currentCompatibleType = (SourceTypeBinding)enclosingSourceType.enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                    this.syntheticReadAccessor = currentCompatibleType.addSyntheticMethod(this.binding, true);
                    currentScope.problemReporter().needToEmulateFieldReadAccess(this.binding, this);
                    return;
                }
            }
        }
        if (this.binding.declaringClass != this.receiverType && !this.receiverType.isArrayType() && this.binding.declaringClass != null && this.binding.constant == NotAConstant && (currentScope.environment().options.targetJDK >= 0x2E0000L && this.binding.declaringClass.id != 1 || !this.binding.declaringClass.canBeSeenBy(currentScope))) {
            this.codegenBinding = currentScope.enclosingSourceType().getUpdatedFieldBinding(this.binding, (ReferenceBinding)this.receiverType);
        }
    }

    public void manageSyntheticWriteAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        if (this.binding.isPrivate()) {
            if (currentScope.enclosingSourceType() != this.binding.declaringClass) {
                this.syntheticWriteAccessor = ((SourceTypeBinding)this.binding.declaringClass).addSyntheticMethod(this.binding, false);
                currentScope.problemReporter().needToEmulateFieldWriteAccess(this.binding, this);
                return;
            }
        } else {
            if (this.receiver instanceof QualifiedSuperReference) {
                SourceTypeBinding destinationType = (SourceTypeBinding)((QualifiedSuperReference)this.receiver).currentCompatibleType;
                this.syntheticWriteAccessor = destinationType.addSyntheticMethod(this.binding, false);
                currentScope.problemReporter().needToEmulateFieldWriteAccess(this.binding, this);
                return;
            }
            if (this.binding.isProtected() && (this.bits & 0x1FE0) != 0) {
                SourceTypeBinding enclosingSourceType = currentScope.enclosingSourceType();
                if (this.binding.declaringClass.getPackage() != enclosingSourceType.getPackage()) {
                    SourceTypeBinding currentCompatibleType = (SourceTypeBinding)enclosingSourceType.enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                    this.syntheticWriteAccessor = currentCompatibleType.addSyntheticMethod(this.binding, false);
                    currentScope.problemReporter().needToEmulateFieldWriteAccess(this.binding, this);
                    return;
                }
            }
        }
        if (this.binding.declaringClass != this.receiverType && !this.receiverType.isArrayType() && this.binding.declaringClass != null && this.binding.constant == NotAConstant && (currentScope.environment().options.targetJDK >= 0x2E0000L && this.binding.declaringClass.id != 1 || !this.binding.declaringClass.canBeSeenBy(currentScope))) {
            this.codegenBinding = currentScope.enclosingSourceType().getUpdatedFieldBinding(this.binding, (ReferenceBinding)this.receiverType);
        }
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        return this.receiver.printExpression(0, output).append('.').append(this.token);
    }

    public TypeBinding resolveType(BlockScope scope) {
        boolean receiverCast = false;
        if (this.receiver instanceof CastExpression) {
            this.receiver.bits |= 0x20;
            receiverCast = true;
        }
        this.receiverType = this.receiver.resolveType(scope);
        if (this.receiverType == null) {
            this.constant = NotAConstant;
            return null;
        }
        if (receiverCast && ((CastExpression)this.receiver).expression.resolvedType == this.receiverType) {
            scope.problemReporter().unnecessaryCast((CastExpression)this.receiver);
        }
        this.codegenBinding = this.binding = scope.getField(this.receiverType, this.token, this);
        if (!this.binding.isValidBinding()) {
            this.constant = NotAConstant;
            scope.problemReporter().invalidField(this, this.receiverType);
            return null;
        }
        if (this.isFieldUseDeprecated(this.binding, scope, (this.bits & 0x2000) != 0)) {
            scope.problemReporter().deprecatedField(this.binding, this);
        }
        boolean isImplicitThisRcv = this.receiver.isImplicitThis();
        this.constant = FieldReference.getConstantFor(this.binding, this, isImplicitThisRcv, scope);
        if (!isImplicitThisRcv) {
            this.constant = NotAConstant;
        }
        if (this.binding.isStatic()) {
            if (!(isImplicitThisRcv || this.receiver.isSuper() || this.receiver instanceof NameReference && (((NameReference)this.receiver).bits & 4) != 0)) {
                scope.problemReporter().nonStaticAccessToStaticField(this, this.binding);
            }
            if (!isImplicitThisRcv && this.binding.declaringClass != this.receiverType) {
                scope.problemReporter().indirectAccessToStaticField(this, this.binding);
            }
        }
        this.resolvedType = this.binding.type;
        return this.resolvedType;
    }

    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    public void setDepth(int depth) {
        this.bits &= 0xFFFFE01F;
        if (depth > 0) {
            this.bits |= (depth & 0xFF) << 5;
        }
    }

    public void setFieldIndex(int index) {
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.receiver.traverse(visitor, scope);
        }
        visitor.endVisit(this, scope);
    }
}

