/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class RemoveFromClasspathAction
extends SelectionDispatchAction {
    public RemoveFromClasspathAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("RemoveFromClasspathAction.Remove"));
        this.setToolTipText(ActionMessages.getString("RemoveFromClasspathAction.tooltip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.removefromclasspath_action_context");
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(RemoveFromClasspathAction.checkEnabled(selection));
    }

    private static boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            if (RemoveFromClasspathAction.canRemove(iter.next())) continue;
            return false;
        }
        return true;
    }

    public void run(final IStructuredSelection selection) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(new IWorkspaceRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(IProgressMonitor pm) throws CoreException {
                    try {
                        IPackageFragmentRoot[] roots = RemoveFromClasspathAction.getRootsToRemove(selection);
                        pm.beginTask(ActionMessages.getString("RemoveFromClasspathAction.Removing"), roots.length);
                        for (int i = 0; i < roots.length; ++i) {
                            int jCoreFlags = 3;
                            roots[i].delete(0, jCoreFlags, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                        }
                    }
                    finally {
                        pm.done();
                    }
                }
            }));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.getString("RemoveFromClasspathAction.exception_dialog_title"), ActionMessages.getString("RemoveFromClasspathAction.Problems_occurred"));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static IPackageFragmentRoot[] getRootsToRemove(IStructuredSelection selection) {
        ArrayList result = new ArrayList(selection.size());
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!RemoveFromClasspathAction.canRemove(element)) continue;
            result.add(element);
        }
        return result.toArray(new IPackageFragmentRoot[result.size()]);
    }

    private static boolean canRemove(Object element) {
        if (!(element instanceof IPackageFragmentRoot)) {
            return false;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)element;
        try {
            IClasspathEntry cpe = root.getRawClasspathEntry();
            return cpe != null && cpe.getEntryKind() != 5;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return false;
        }
    }
}

