/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.internal.corext.codemanipulation.AddCustomConstructorOperation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.dialogs.SourceActionDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.IVisibilityChangeListener;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jdt.internal.ui.util.ElementValidator;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLabels;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;

public class GenerateNewConstructorUsingFieldsAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;
    private static final String DIALOG_TITLE = ActionMessages.getString("GenerateConstructorUsingFieldsAction.error.title");
    private static final int UP_INDEX = 0;
    private static final int DOWN_INDEX = 1;
    static /* synthetic */ Class class$org$eclipse$jface$text$IRewriteTarget;

    public GenerateNewConstructorUsingFieldsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("GenerateConstructorUsingFieldsAction.label"));
        this.setDescription(ActionMessages.getString("GenerateConstructorUsingFieldsAction.description"));
        this.setToolTipText(ActionMessages.getString("GenerateConstructorUsingFieldsAction.tooltip"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.create_new_constructor_action_context");
    }

    public GenerateNewConstructorUsingFieldsAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.checkEnabledEditor());
    }

    private static String getDialogTitle() {
        return DIALOG_TITLE;
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.filterNotPresentException((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (this.getSelectedFields(selection) != null) {
            return true;
        }
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            IType type = (IType)selection.getFirstElement();
            return type.getCompilationUnit() != null && type.isClass() && !type.isLocal();
        }
        return selection.size() == 1 && selection.getFirstElement() instanceof ICompilationUnit;
    }

    public void run(IStructuredSelection selection) {
        try {
            IType selectionType = this.getSelectedType(selection);
            if (selectionType == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)GenerateNewConstructorUsingFieldsAction.getDialogTitle(), (String)ActionMessages.getString("GenerateConstructorUsingFieldsAction.not_applicable"));
                return;
            }
            IField[] selectedFields = this.getSelectedFields(selection);
            if (GenerateNewConstructorUsingFieldsAction.canRunOn(selectedFields)) {
                this.run(selectedFields[0].getDeclaringType(), selectedFields, false);
                return;
            }
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IType) {
                this.run((IType)firstElement, new IField[0], false);
            } else if (firstElement instanceof ICompilationUnit) {
                IType type = ((ICompilationUnit)firstElement).findPrimaryType();
                if (type.isInterface()) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)GenerateNewConstructorUsingFieldsAction.getDialogTitle(), (String)ActionMessages.getString("GenerateConstructorUsingFieldsAction.interface_not_applicable"));
                    return;
                }
                this.run(((ICompilationUnit)firstElement).findPrimaryType(), new IField[0], false);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), GenerateNewConstructorUsingFieldsAction.getDialogTitle(), ActionMessages.getString("GenerateConstructorUsingFieldsAction.error.actionfailed"));
        }
    }

    private IType getSelectedType(IStructuredSelection selection) throws JavaModelException {
        Object[] elements = selection.toArray();
        if (elements.length == 1 && elements[0] instanceof IType) {
            IType type = (IType)elements[0];
            if (type.getCompilationUnit() != null && type.isClass()) {
                return type;
            }
        } else if (elements[0] instanceof ICompilationUnit) {
            ICompilationUnit cu = (ICompilationUnit)elements[0];
            IType type = cu.findPrimaryType();
            if (type != null && !type.isInterface()) {
                return type;
            }
        } else if (elements[0] instanceof IField) {
            return ((IField)elements[0]).getCompilationUnit().findPrimaryType();
        }
        return null;
    }

    private static boolean canRunOn(IField[] fields) {
        return fields != null && fields.length > 0;
    }

    private IField[] getSelectedFields(IStructuredSelection selection) {
        List elements = selection.toList();
        int nElements = elements.size();
        if (nElements > 0) {
            IField[] res = new IField[nElements];
            ICompilationUnit cu = null;
            for (int i = 0; i < nElements; ++i) {
                IField fld;
                block7: {
                    Object curr = elements.get(i);
                    if (curr instanceof IField) {
                        fld = (IField)curr;
                        if (i == 0 ? (cu = fld.getCompilationUnit()) == null : !cu.equals(fld.getCompilationUnit())) {
                            return null;
                        }
                        try {
                            if (fld.getDeclaringType().isInterface()) {
                                return null;
                            }
                            break block7;
                        }
                        catch (JavaModelException e) {
                            JavaPlugin.log(e);
                            return null;
                        }
                    }
                    return null;
                }
                res[i] = fld;
            }
            return res;
        }
        return null;
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        try {
            IType type;
            IJavaElement[] elements = SelectionConverter.codeResolve(this.fEditor);
            if (elements.length == 1 && elements[0] instanceof IField) {
                IField field = (IField)elements[0];
                this.run(field.getDeclaringType(), new IField[]{field}, false);
                return;
            }
            IJavaElement element = SelectionConverter.getElementAtOffset(this.fEditor);
            if (element != null && (type = (IType)element.getAncestor(7)) != null && type.getFields().length > 0) {
                this.run(type, new IField[0], true);
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)GenerateNewConstructorUsingFieldsAction.getDialogTitle(), (String)ActionMessages.getString("GenerateConstructorUsingFieldsAction.not_applicable"));
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), GenerateNewConstructorUsingFieldsAction.getDialogTitle(), ActionMessages.getString("GenerateConstructorUsingFieldsAction.error.actionfailed"));
        }
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(IType type, IField[] preselected, boolean activatedFromEditor) throws CoreException {
        if (!ElementValidator.check((IJavaElement)type, this.getShell(), GenerateNewConstructorUsingFieldsAction.getDialogTitle(), activatedFromEditor)) {
            return;
        }
        if (!ActionUtil.isProcessable(this.getShell(), type)) {
            return;
        }
        IField[] constructorFields = type.getFields();
        ArrayList<IField> constructorFieldsList = new ArrayList<IField>();
        for (int i = 0; i < constructorFields.length; ++i) {
            boolean isStatic = Flags.isStatic((int)constructorFields[i].getFlags());
            boolean isFinal = Flags.isFinal((int)constructorFields[i].getFlags());
            if (isStatic) continue;
            if (isFinal) {
                try {
                    IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
                    scanner.setSource(constructorFields[i].getSource().toCharArray());
                    TokenScanner tokenScanner = new TokenScanner(scanner);
                    tokenScanner.getTokenStartOffset(167, 0);
                }
                catch (JavaModelException e) {
                }
                catch (CoreException e) {
                    constructorFieldsList.add(constructorFields[i]);
                }
                continue;
            }
            constructorFieldsList.add(constructorFields[i]);
        }
        if (constructorFieldsList.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)GenerateNewConstructorUsingFieldsAction.getDialogTitle(), (String)ActionMessages.getString("GenerateConstructorUsingFieldsAction.typeContainsNoFields.message"));
            return;
        }
        IMethod[] superConstructors = GenerateNewConstructorUsingFieldsAction.getSuperConstructors(type);
        if (superConstructors.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)GenerateNewConstructorUsingFieldsAction.getDialogTitle(), (String)ActionMessages.getString("GenerateConstructorUsingFieldsAction.error.nothing_found"));
            return;
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        GenerateConstructorUsingFieldsContentProvider contentProvider = new GenerateConstructorUsingFieldsContentProvider(constructorFieldsList);
        GenerateConstructorUsingFieldsSelectionDialog dialog = new GenerateConstructorUsingFieldsSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, contentProvider, this.fEditor, type, superConstructors);
        dialog.setCommentString(ActionMessages.getString("SourceActionDialog.createConstructorComment"));
        dialog.setTitle(ActionMessages.getString("GenerateConstructorUsingFieldsAction.dialog.title"));
        dialog.setInitialSelections(preselected);
        dialog.setContainerMode(true);
        dialog.setSize(60, 18);
        dialog.setInput(new Object());
        dialog.setMessage(ActionMessages.getString("GenerateConstructorUsingFieldsAction.dialog.label"));
        dialog.setValidator(GenerateNewConstructorUsingFieldsAction.createValidator(constructorFieldsList.size(), dialog, type));
        int dialogResult = dialog.open();
        if (dialogResult == 0) {
            IRewriteTarget target;
            Object[] checkedElements = dialog.getResult();
            if (checkedElements == null) {
                return;
            }
            ArrayList<Object> result = new ArrayList<Object>(checkedElements.length);
            for (int i = 0; i < checkedElements.length; ++i) {
                Object curr = checkedElements[i];
                if (!(curr instanceof IField)) continue;
                result.add(curr);
            }
            IEditorPart editor = EditorUtility.openInEditor(type.getCompilationUnit());
            IField[] workingCopyFields = result.toArray(new IField[result.size()]);
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings();
            settings.createComments = dialog.getGenerateComment();
            IJavaElement elementPosition = dialog.getElementPosition();
            IMethod selectedConstructor = dialog.getSuperConstructorChoice();
            IRewriteTarget iRewriteTarget = editor != null ? (IRewriteTarget)editor.getAdapter(class$org$eclipse$jface$text$IRewriteTarget == null ? (class$org$eclipse$jface$text$IRewriteTarget = GenerateNewConstructorUsingFieldsAction.class$("org.eclipse.jface.text.IRewriteTarget")) : class$org$eclipse$jface$text$IRewriteTarget) : (target = null);
            if (target != null) {
                target.beginCompoundChange();
            }
            try {
                Object context;
                AddCustomConstructorOperation op = new AddCustomConstructorOperation(type, settings, workingCopyFields, false, elementPosition, selectedConstructor);
                op.setVisbility(dialog.getVisibilityModifier());
                if (selectedConstructor.getParameterNames().length == 0) {
                    op.setOmitSuper(dialog.isOmitSuper());
                }
                if ((context = JavaPlugin.getActiveWorkbenchWindow()) == null) {
                    context = new BusyIndicatorRunnableContext();
                }
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, op.getScheduleRule()), op.getScheduleRule());
                IMethod res = op.getCreatedConstructor();
                JavaModelUtil.reconcile(res.getCompilationUnit());
                EditorUtility.revealInEditor(editor, (IJavaElement)res);
            }
            catch (InvocationTargetException e) {
                ExceptionHandler.handle(e, this.getShell(), GenerateNewConstructorUsingFieldsAction.getDialogTitle(), ActionMessages.getString("GenerateConstructorUsingFieldsAction.error.actionfailed"));
            }
            catch (InterruptedException e) {
            }
            finally {
                if (target != null) {
                    target.endCompoundChange();
                }
            }
        }
    }

    private static IMethod[] getSuperConstructors(IType type) throws CoreException {
        ArrayList<IMethod> constructorMethods = new ArrayList<IMethod>();
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        IType supertype = hierarchy.getSuperclass(type);
        if (supertype != null) {
            IMethod curr;
            IMethod[] superMethods = supertype.getMethods();
            boolean constuctorFound = false;
            for (int i = 0; i < superMethods.length; ++i) {
                curr = superMethods[i];
                if (!curr.isConstructor()) continue;
                constuctorFound = true;
                if (!JavaModelUtil.isVisibleInHierarchy((IMember)curr, type.getPackageFragment())) continue;
                constructorMethods.add(curr);
            }
            if (!constuctorFound) {
                IType objectType = type.getJavaProject().findType("java.lang.Object");
                curr = objectType.getMethod("Object", new String[0]);
                constructorMethods.add(curr);
            }
        }
        return constructorMethods.toArray(new IMethod[constructorMethods.size()]);
    }

    private static ISelectionStatusValidator createValidator(int entries, GenerateConstructorUsingFieldsSelectionDialog dialog, IType type) {
        GenerateConstructorUsingFieldsValidator validator = new GenerateConstructorUsingFieldsValidator(entries, dialog, type);
        return validator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class GenerateConstructorUsingFieldsContentProvider
    implements ITreeContentProvider {
        private List fFieldsList;
        private static final Object[] EMPTY = new Object[0];

        public GenerateConstructorUsingFieldsContentProvider(List fieldList) {
            this.fFieldsList = fieldList;
        }

        public Object[] getChildren(Object parentElement) {
            return EMPTY;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.fFieldsList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        private List moveUp(List elements, List move) {
            int nElements = elements.size();
            ArrayList res = new ArrayList(nElements);
            Object floating = null;
            for (int i = 0; i < nElements; ++i) {
                Object curr = elements.get(i);
                if (move.contains(curr)) {
                    res.add(curr);
                    continue;
                }
                if (floating != null) {
                    res.add(floating);
                }
                floating = curr;
            }
            if (floating != null) {
                res.add(floating);
            }
            return res;
        }

        private List reverse(List p) {
            ArrayList reverse = new ArrayList(p.size());
            for (int i = p.size() - 1; i >= 0; --i) {
                reverse.add(p.get(i));
            }
            return reverse;
        }

        public void setElements(List elements, CheckboxTreeViewer tree) {
            this.fFieldsList = new ArrayList(elements);
            if (tree != null) {
                tree.refresh();
            }
        }

        public void up(List checkedElements, CheckboxTreeViewer tree) {
            if (checkedElements.size() > 0) {
                this.setElements(this.moveUp(this.fFieldsList, checkedElements), tree);
                tree.reveal(checkedElements.get(0));
            }
            tree.setSelection((ISelection)new StructuredSelection(checkedElements));
        }

        public void down(List checkedElements, CheckboxTreeViewer tree) {
            if (checkedElements.size() > 0) {
                this.setElements(this.reverse(this.moveUp(this.reverse(this.fFieldsList), checkedElements)), tree);
                tree.reveal(checkedElements.get(checkedElements.size() - 1));
            }
            tree.setSelection((ISelection)new StructuredSelection(checkedElements));
        }

        public boolean canMoveUp(List selectedElements) {
            int nSelected = selectedElements.size();
            int nElements = this.fFieldsList.size();
            for (int i = 0; i < nElements && nSelected > 0; --nSelected, ++i) {
                if (selectedElements.contains(this.fFieldsList.get(i))) continue;
                return true;
            }
            return false;
        }

        public boolean canMoveDown(List selectedElements) {
            int nSelected = selectedElements.size();
            for (int i = this.fFieldsList.size() - 1; i >= 0 && nSelected > 0; --nSelected, --i) {
                if (selectedElements.contains(this.fFieldsList.get(i))) continue;
                return true;
            }
            return false;
        }

        public List getFieldsList() {
            return this.fFieldsList;
        }
    }

    private static class GenerateConstructorUsingFieldsSelectionDialog
    extends SourceActionDialog {
        private GenerateConstructorUsingFieldsContentProvider fContentProvider;
        private int fSuperIndex;
        private int fWidth = 60;
        private int fHeight = 18;
        protected Button[] fButtonControls;
        private boolean[] fButtonsEnabled;
        private boolean fOmitSuper;
        private IMethod[] fSuperConstructors;
        private IDialogSettings fGenConstructorSettings;
        protected CheckboxTreeViewer fTreeViewer;
        private GenerateConstructorUsingFieldsTreeViewerAdapter fTreeViewerAdapter;
        private static final int UP_BUTTON = 1025;
        private static final int DOWN_BUTTON = 1026;
        private final String SETTINGS_SECTION = "GenerateConstructorUsingFieldsSelectionDialog";
        private final String OMIT_SUPER = "OmitCallToSuper";
        private Button fOmitSuperButton;

        public GenerateConstructorUsingFieldsSelectionDialog(Shell parent, ILabelProvider labelProvider, GenerateConstructorUsingFieldsContentProvider contentProvider, CompilationUnitEditor editor, IType type, IMethod[] superConstructors) throws JavaModelException {
            super(parent, labelProvider, contentProvider, editor, type, true);
            this.fContentProvider = contentProvider;
            this.fTreeViewerAdapter = new GenerateConstructorUsingFieldsTreeViewerAdapter();
            this.fSuperConstructors = superConstructors;
            IDialogSettings dialogSettings = JavaPlugin.getDefault().getDialogSettings();
            this.fGenConstructorSettings = dialogSettings.getSection("GenerateConstructorUsingFieldsSelectionDialog");
            if (this.fGenConstructorSettings == null) {
                this.fGenConstructorSettings = dialogSettings.addNewSection("GenerateConstructorUsingFieldsSelectionDialog");
                this.fGenConstructorSettings.put("OmitCallToSuper", false);
            }
            this.fOmitSuper = this.fGenConstructorSettings.getBoolean("OmitCallToSuper");
        }

        protected Composite createVisibilityControlAndModifiers(Composite parent, IVisibilityChangeListener visibilityChangeListener, int[] availableVisibilities, int correctVisibility) {
            Composite visibilityComposite = this.createVisibilityControl(parent, visibilityChangeListener, availableVisibilities, correctVisibility);
            return visibilityComposite;
        }

        protected Control createDialogArea(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            GridData gd = null;
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            Composite classConstructorComposite = this.addSuperClassConstructorChoices(composite);
            gd = new GridData(1808);
            classConstructorComposite.setLayoutData((Object)gd);
            Composite inner = new Composite(composite, 0);
            GridLayout innerLayout = new GridLayout();
            innerLayout.numColumns = 2;
            innerLayout.marginHeight = 0;
            innerLayout.marginWidth = 0;
            inner.setLayout((Layout)innerLayout);
            Label messageLabel = this.createMessageArea(inner);
            if (messageLabel != null) {
                gd = new GridData(256);
                gd.horizontalSpan = 2;
                messageLabel.setLayoutData((Object)gd);
            }
            this.fTreeViewer = this.createTreeViewer(inner);
            gd = new GridData(1808);
            gd.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
            gd.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
            this.fTreeViewer.getControl().setLayoutData((Object)gd);
            this.fTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
            this.fTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this.fTreeViewerAdapter);
            Composite buttonComposite = this.createSelectionButtons(inner);
            gd = new GridData(272);
            buttonComposite.setLayoutData((Object)gd);
            gd = new GridData(1808);
            inner.setLayoutData((Object)gd);
            Composite entryComposite = this.createEntryPtCombo(composite);
            entryComposite.setLayoutData((Object)new GridData(768));
            Composite commentComposite = this.createCommentSelection(composite);
            commentComposite.setLayoutData((Object)new GridData(768));
            Composite overrideSuperComposite = this.createOmitSuper(composite);
            overrideSuperComposite.setLayoutData((Object)new GridData(768));
            gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            GenerateConstructorUsingFieldsSelectionDialog.applyDialogFont((Control)composite);
            return composite;
        }

        protected Composite createOmitSuper(Composite composite) {
            Composite omitSuperComposite = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            omitSuperComposite.setLayout((Layout)layout);
            this.fOmitSuperButton = new Button(omitSuperComposite, 32);
            this.fOmitSuperButton.setText(ActionMessages.getString("GenerateConstructorUsingFieldsSelectionDialog.omit.super"));
            this.fOmitSuperButton.setLayoutData((Object)new GridData(256));
            this.fOmitSuperButton.addSelectionListener(new SelectionListener(this){
                private final /* synthetic */ GenerateConstructorUsingFieldsSelectionDialog this$0;
                {
                    this.this$0 = this$0;
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = ((Button)e.widget).getSelection();
                    this.this$0.setOmitSuper(isSelected);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fOmitSuperButton.setSelection(this.isOmitSuper());
            this.fOmitSuperButton.setEnabled(this.getSuperConstructorChoice().getNumberOfParameters() == 0);
            GridData gd = new GridData(256);
            gd.horizontalSpan = 2;
            this.fOmitSuperButton.setLayoutData((Object)gd);
            return omitSuperComposite;
        }

        protected Composite createSelectionButtons(Composite composite) {
            Composite buttonComposite = super.createSelectionButtons(composite);
            GridLayout layout = new GridLayout();
            buttonComposite.setLayout((Layout)layout);
            this.createUpDownButtons(buttonComposite);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 1;
            return buttonComposite;
        }

        private void createUpDownButtons(Composite buttonComposite) {
            int numButtons = 2;
            this.fButtonControls = new Button[numButtons];
            this.fButtonsEnabled = new boolean[numButtons];
            this.fButtonControls[0] = this.createButton(buttonComposite, 1025, ActionMessages.getString("GenerateConstructorUsingFieldsSelectionDialog.up_button"), false);
            this.fButtonControls[1] = this.createButton(buttonComposite, 1026, ActionMessages.getString("GenerateConstructorUsingFieldsSelectionDialog.down_button"), false);
            boolean defaultState = false;
            this.fButtonControls[0].setEnabled(defaultState);
            this.fButtonControls[1].setEnabled(defaultState);
            this.fButtonsEnabled[0] = defaultState;
            this.fButtonsEnabled[1] = defaultState;
        }

        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            switch (buttonId) {
                case 1025: {
                    this.fContentProvider.up(this.getElementList(), this.getTreeViewer());
                    this.updateOKStatus();
                    break;
                }
                case 1026: {
                    this.fContentProvider.down(this.getElementList(), this.getTreeViewer());
                    this.updateOKStatus();
                }
            }
        }

        private List getElementList() {
            IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
            List elements = selection.toList();
            ArrayList elementList = new ArrayList();
            for (int i = 0; i < elements.size(); ++i) {
                elementList.add(elements.get(i));
            }
            return elementList;
        }

        protected Composite createEntryPtCombo(Composite composite) {
            Composite entryComposite = super.createEntryPtCombo(composite);
            this.addVisibilityAndModifiersChoices(entryComposite);
            return entryComposite;
        }

        private Composite addSuperClassConstructorChoices(Composite composite) {
            Label label = new Label(composite, 0);
            label.setText(ActionMessages.getString("GenerateConstructorUsingFieldsSelectionDialog.sort_constructor_choices.label"));
            GridData gd = new GridData(768);
            label.setLayoutData((Object)gd);
            Combo combo = new Combo(composite, 8);
            for (int i = 0; i < this.fSuperConstructors.length; ++i) {
                combo.add(JavaElementLabels.getElementLabel((IJavaElement)this.fSuperConstructors[i], 1));
            }
            combo.setText(combo.getItem(0));
            combo.setLayoutData((Object)new GridData(768));
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(this, combo){
                private final /* synthetic */ Combo val$combo;
                private final /* synthetic */ GenerateConstructorUsingFieldsSelectionDialog this$0;
                {
                    this.this$0 = this$0;
                    this.val$combo = val$combo;
                }

                public void widgetSelected(SelectionEvent e) {
                    GenerateConstructorUsingFieldsSelectionDialog.access$102(this.this$0, this.val$combo.getSelectionIndex());
                    GenerateConstructorUsingFieldsSelectionDialog.access$200(this.this$0).setEnabled(this.this$0.getSuperConstructorChoice().getNumberOfParameters() == 0);
                    GenerateConstructorUsingFieldsSelectionDialog.access$300(this.this$0);
                }
            });
            return composite;
        }

        public CheckboxTreeViewer getTreeViewer() {
            return this.fTreeViewer;
        }

        public IMethod getSuperConstructorChoice() {
            return this.fSuperConstructors[this.fSuperIndex];
        }

        public void setOmitSuper(boolean omitSuper) {
            if (this.fOmitSuper != omitSuper) {
                this.fOmitSuper = omitSuper;
                this.fGenConstructorSettings.put("OmitCallToSuper", omitSuper);
            }
        }

        public boolean isOmitSuper() {
            return this.fOmitSuper;
        }

        static /* synthetic */ int access$102(GenerateConstructorUsingFieldsSelectionDialog x0, int x1) {
            x0.fSuperIndex = x1;
            return x0.fSuperIndex;
        }

        static /* synthetic */ Button access$200(GenerateConstructorUsingFieldsSelectionDialog x0) {
            return x0.fOmitSuperButton;
        }

        static /* synthetic */ void access$300(GenerateConstructorUsingFieldsSelectionDialog x0) {
            x0.updateOKStatus();
        }

        private class GenerateConstructorUsingFieldsTreeViewerAdapter
        implements ISelectionChangedListener,
        IDoubleClickListener {
            private GenerateConstructorUsingFieldsTreeViewerAdapter() {
            }

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)GenerateConstructorUsingFieldsSelectionDialog.this.fTreeViewer.getSelection();
                List selectedList = selection.toList();
                GenerateConstructorUsingFieldsContentProvider cp = (GenerateConstructorUsingFieldsContentProvider)GenerateConstructorUsingFieldsSelectionDialog.this.getContentProvider();
                GenerateConstructorUsingFieldsSelectionDialog.this.fButtonControls[0].setEnabled(cp.canMoveUp(selectedList));
                GenerateConstructorUsingFieldsSelectionDialog.this.fButtonControls[1].setEnabled(cp.canMoveDown(selectedList));
            }

            public void doubleClick(DoubleClickEvent event) {
            }
        }
    }

    private static class GenerateConstructorUsingFieldsValidator
    implements ISelectionStatusValidator {
        private static int fEntries;
        private IType fType;
        private GenerateConstructorUsingFieldsSelectionDialog fDialog;
        List fExistingSigs;

        GenerateConstructorUsingFieldsValidator(int entries) {
            fEntries = entries;
            this.fType = null;
        }

        GenerateConstructorUsingFieldsValidator(int entries, GenerateConstructorUsingFieldsSelectionDialog dialog, IType type) {
            fEntries = entries;
            this.fDialog = dialog;
            this.fType = type;
            this.fExistingSigs = this.getExistingConstructorSignatures();
        }

        public IStatus validate(Object[] selection) {
            StringBuffer buffer = new StringBuffer();
            buffer.append('(');
            IMethod chosenSuper = this.fDialog.getSuperConstructorChoice();
            try {
                int i;
                String[] superParamTypes = chosenSuper.getParameterTypes();
                for (i = 0; i < superParamTypes.length; ++i) {
                    buffer.append(superParamTypes[i]);
                }
                for (i = 0; i < selection.length; ++i) {
                    if (!(selection[i] instanceof IField)) continue;
                    buffer.append(((IField)selection[i]).getTypeSignature());
                }
            }
            catch (JavaModelException e) {
                // empty catch block
            }
            buffer.append(")V");
            if (this.fExistingSigs.contains(buffer.toString())) {
                return new StatusInfo(2, ActionMessages.getString("GenerateConstructorUsingFieldsAction.error.duplicate_constructor"));
            }
            int fieldCount = this.countSelectedFields(selection);
            String message = ActionMessages.getFormattedString("GenerateConstructorUsingFieldsAction.fields_selected", new Object[]{String.valueOf(fieldCount), String.valueOf(fEntries)});
            return new StatusInfo(1, message);
        }

        private int countSelectedFields(Object[] selection) {
            int count = 0;
            for (int i = 0; i < selection.length; ++i) {
                if (!(selection[i] instanceof IField)) continue;
                ++count;
            }
            return count;
        }

        private List getExistingConstructorSignatures() {
            ArrayList<String> constructorMethods = new ArrayList<String>();
            try {
                IMethod[] methods = this.fType.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    IMethod curr = methods[i];
                    if (!curr.isConstructor()) continue;
                    constructorMethods.add(curr.getSignature());
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            return constructorMethods;
        }
    }
}

