/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.typehierarchy;

import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class SelectionProviderMediator
implements IPostSelectionProvider {
    private StructuredViewer[] fViewers;
    private StructuredViewer fViewerInFocus;
    private ListenerList fSelectionChangedListeners;
    private ListenerList fPostSelectionChangedListeners;

    public SelectionProviderMediator(StructuredViewer[] viewers) {
        Assert.isNotNull((Object)viewers);
        this.fViewers = viewers;
        InternalListener listener = new InternalListener();
        this.fSelectionChangedListeners = new ListenerList(4);
        this.fPostSelectionChangedListeners = new ListenerList(4);
        this.fViewerInFocus = null;
        for (int i = 0; i < this.fViewers.length; ++i) {
            StructuredViewer viewer = this.fViewers[i];
            viewer.addSelectionChangedListener((ISelectionChangedListener)listener);
            viewer.addPostSelectionChangedListener((ISelectionChangedListener)new InternalPostSelectionListener());
            Control control = viewer.getControl();
            control.addFocusListener((FocusListener)listener);
        }
    }

    private void doFocusChanged(Widget control) {
        for (int i = 0; i < this.fViewers.length; ++i) {
            if (this.fViewers[i].getControl() != control) continue;
            this.propagateFocusChanged(this.fViewers[i]);
            return;
        }
    }

    final void doPostSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider provider = event.getSelectionProvider();
        if (provider == this.fViewerInFocus) {
            this.firePostSelectionChanged();
        }
    }

    final void doSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider provider = event.getSelectionProvider();
        if (provider == this.fViewerInFocus) {
            this.fireSelectionChanged();
        }
    }

    final void propagateFocusChanged(StructuredViewer viewer) {
        if (viewer != this.fViewerInFocus) {
            this.fViewerInFocus = viewer;
            this.fireSelectionChanged();
            this.firePostSelectionChanged();
        }
    }

    private void fireSelectionChanged() {
        if (this.fSelectionChangedListeners != null) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            Object[] listeners = this.fSelectionChangedListeners.getListeners();
            for (int i = 0; i < listeners.length; ++i) {
                ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
                listener.selectionChanged(event);
            }
        }
    }

    private void firePostSelectionChanged() {
        if (this.fPostSelectionChangedListeners != null) {
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
            Object[] listeners = this.fPostSelectionChangedListeners.getListeners();
            for (int i = 0; i < listeners.length; ++i) {
                ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
                listener.selectionChanged(event);
            }
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.remove((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostSelectionChangedListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostSelectionChangedListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        if (this.fViewerInFocus != null) {
            return this.fViewerInFocus.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        if (this.fViewerInFocus != null) {
            this.fViewerInFocus.setSelection(selection);
        }
    }

    public StructuredViewer getViewerInFocus() {
        return this.fViewerInFocus;
    }

    private class InternalPostSelectionListener
    implements ISelectionChangedListener {
        private InternalPostSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            SelectionProviderMediator.this.doPostSelectionChanged(event);
        }
    }

    private class InternalListener
    implements ISelectionChangedListener,
    FocusListener {
        private InternalListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            SelectionProviderMediator.this.doSelectionChanged(event);
        }

        public void focusGained(FocusEvent e) {
            SelectionProviderMediator.this.doFocusChanged(e.widget);
        }

        public void focusLost(FocusEvent e) {
        }
    }
}

