/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.swt.graphics.Image;

public class CorrectMainTypeNameProposal
extends ASTRewriteCorrectionProposal {
    private String fOldName;
    private String fNewName;

    public CorrectMainTypeNameProposal(ICompilationUnit cu, String oldTypeName, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, (Image)null);
        this.fNewName = Signature.getQualifier((String)cu.getElementName());
        this.setDisplayName(CorrectionMessages.getFormattedString("ReorgCorrectionsSubProcessor.renametype.description", this.fNewName));
        this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
        this.fOldName = oldTypeName;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        char[] content = this.getCompilationUnit().getBuffer().getCharacters();
        ASTParser astParser = ASTParser.newParser((int)2);
        astParser.setSource(content);
        astParser.setUnitName(this.fOldName + ".java");
        astParser.setProject(this.getCompilationUnit().getJavaProject());
        astParser.setResolveBindings(true);
        CompilationUnit astRoot = (CompilationUnit)astParser.createAST(null);
        AST ast = astRoot.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        TypeDeclaration decl = this.findTypeDeclaration(astRoot.types(), this.fOldName);
        if (decl != null) {
            SimpleName[] sameNodes = LinkedNodeFinder.findByNode((ASTNode)astRoot, decl.getName());
            for (int i = 0; i < sameNodes.length; ++i) {
                rewrite.replace((ASTNode)sameNodes[i], (ASTNode)ast.newSimpleName(this.fNewName), null);
            }
        }
        return rewrite;
    }

    private TypeDeclaration findTypeDeclaration(List types, String name) {
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            TypeDeclaration decl = (TypeDeclaration)iter.next();
            if (!name.equals(decl.getName().getIdentifier())) continue;
            return decl;
        }
        return null;
    }
}

