/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class JavaIndenter {
    private IDocument fDocument;
    private int fIndent;
    private int fAlign;
    private int fPosition;
    private int fPreviousPos;
    private int fToken;
    private int fLine;
    private JavaHeuristicScanner fScanner;

    public JavaIndenter(IDocument document, JavaHeuristicScanner scanner) {
        Assert.isNotNull((Object)document);
        Assert.isNotNull((Object)scanner);
        this.fDocument = document;
        this.fScanner = scanner;
    }

    public StringBuffer getReferenceIndentation(int offset) {
        return this.getReferenceIndentation(offset, false);
    }

    private StringBuffer getReferenceIndentation(int offset, boolean assumeOpeningBrace) {
        int unit = assumeOpeningBrace ? this.findReferencePosition(offset, 1) : this.findReferencePosition(offset, this.peekChar(offset));
        if (unit == -1) {
            return null;
        }
        return this.getLeadingWhitespace(unit);
    }

    public StringBuffer computeIndentation(int offset) {
        return this.computeIndentation(offset, false);
    }

    public StringBuffer computeIndentation(int offset, boolean assumeOpeningBrace) {
        StringBuffer indent = this.getReferenceIndentation(offset, assumeOpeningBrace);
        if (this.fAlign != -1) {
            try {
                IRegion line = this.fDocument.getLineInformationOfOffset(this.fAlign);
                int lineOffset = line.getOffset();
                return this.createIndent(lineOffset, this.fAlign);
            }
            catch (BadLocationException e) {
                return null;
            }
        }
        if (indent == null) {
            return null;
        }
        indent.append(this.createIndent(this.fIndent));
        if (this.fIndent < 0) {
            this.unindent(indent);
        }
        return indent;
    }

    private StringBuffer getLeadingWhitespace(int offset) {
        StringBuffer indent = new StringBuffer();
        try {
            IRegion line = this.fDocument.getLineInformationOfOffset(offset);
            int lineOffset = line.getOffset();
            int nonWS = this.fScanner.findNonWhitespaceForwardInAnyPartition(lineOffset, lineOffset + line.getLength());
            indent.append(this.fDocument.get(lineOffset, nonWS - lineOffset));
            return indent;
        }
        catch (BadLocationException e) {
            return indent;
        }
    }

    private void unindent(StringBuffer indent) {
        StringBuffer oneIndent = this.createIndent();
        int i = indent.lastIndexOf(((Object)oneIndent).toString());
        if (i != -1) {
            indent.delete(i, i + oneIndent.length());
        }
    }

    private StringBuffer createIndent(int start, int indent) {
        int tabLen = this.prefTabLength();
        StringBuffer ret = new StringBuffer();
        try {
            int spaces = 0;
            while (start < indent) {
                char ch = this.fDocument.getChar(start);
                if (ch == '\t') {
                    ret.append('\t');
                    spaces = 0;
                } else if (tabLen == -1) {
                    ret.append(' ');
                } else if (++spaces == tabLen) {
                    ret.append('\t');
                    spaces = 0;
                }
                ++start;
            }
            if (spaces == tabLen) {
                ret.append('\t');
            } else {
                while (spaces-- > 0) {
                    ret.append(' ');
                }
            }
        }
        catch (BadLocationException e) {
            // empty catch block
        }
        return ret;
    }

    private StringBuffer createIndent(int indent) {
        StringBuffer oneIndent = this.createIndent();
        StringBuffer ret = new StringBuffer();
        while (indent-- > 0) {
            ret.append(oneIndent);
        }
        return ret;
    }

    private StringBuffer createIndent() {
        StringBuffer oneIndent = new StringBuffer();
        JavaCore plugin = JavaCore.getJavaCore();
        if (plugin == null) {
            oneIndent.append('\t');
        } else if ("space".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.tabulation.char"))) {
            int tabLen = Integer.parseInt(JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.tabulation.size"));
            for (int i = 0; i < tabLen; ++i) {
                oneIndent.append(' ');
            }
        } else if ("tab".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.tabulation.char"))) {
            oneIndent.append('\t');
        } else {
            oneIndent.append('\t');
        }
        return oneIndent;
    }

    public int findReferencePosition(int offset) {
        return this.findReferencePosition(offset, this.peekChar(offset));
    }

    private int peekChar(int offset) {
        if (offset < this.fDocument.getLength()) {
            try {
                IRegion line = this.fDocument.getLineInformationOfOffset(offset);
                int lineOffset = line.getOffset();
                int next = this.fScanner.nextToken(offset, lineOffset + line.getLength());
                return next;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int findReferencePosition(int offset, int nextToken) {
        boolean danglingElse = false;
        boolean unindent = false;
        boolean indent = false;
        boolean matchBrace = false;
        boolean matchParen = false;
        boolean matchCase = false;
        if (offset < this.fDocument.getLength()) {
            try {
                IRegion line = this.fDocument.getLineInformationOfOffset(offset);
                int lineOffset = line.getOffset();
                int prevPos = Math.max(offset - 1, 0);
                boolean isFirstTokenOnLine = this.fDocument.get(lineOffset, prevPos + 1 - lineOffset).trim().length() == 0;
                int prevToken = this.fScanner.previousToken(prevPos, -2);
                boolean bracelessBlockStart = this.fScanner.isBracelessBlockStart(prevPos, -2);
                switch (nextToken) {
                    case -1: 
                    case 1014: {
                        danglingElse = true;
                        break;
                    }
                    case 1013: 
                    case 1024: {
                        if (!isFirstTokenOnLine) break;
                        matchCase = true;
                        break;
                    }
                    case 1: {
                        if (bracelessBlockStart && !this.prefIndentBracesForBlocks()) {
                            unindent = true;
                            break;
                        }
                        if (!(prevToken != 9 && prevToken != 12 && prevToken != 4 || this.prefIndentBracesForArrays())) {
                            unindent = true;
                            break;
                        }
                        if (bracelessBlockStart || !this.prefIndentBracesForMethods()) break;
                        indent = true;
                        break;
                    }
                    case 2: {
                        if (!isFirstTokenOnLine) break;
                        matchBrace = true;
                        break;
                    }
                    case 6: {
                        if (!isFirstTokenOnLine) break;
                        matchParen = true;
                    }
                }
            }
            catch (BadLocationException e) {}
        } else {
            danglingElse = true;
        }
        int ref = this.findReferencePosition(offset, danglingElse, matchBrace, matchParen, matchCase);
        if (unindent) {
            --this.fIndent;
        }
        if (indent) {
            ++this.fIndent;
        }
        return ref;
    }

    public int findReferencePosition(int offset, boolean danglingElse, boolean matchBrace, boolean matchParen, boolean matchCase) {
        this.fIndent = 0;
        this.fAlign = -1;
        this.fPosition = offset;
        if (matchBrace) {
            if (this.skipScope(1, 2)) {
                try {
                    int lineOffset = this.fDocument.getLineOffset(this.fLine);
                    if (lineOffset <= this.fPosition && this.fDocument.get(lineOffset, this.fPosition - lineOffset).trim().length() == 0) {
                        return this.fPosition;
                    }
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
                int pos = this.skipToStatementStart(true, true);
                this.fIndent = 0;
                return pos;
            }
            int pos = this.findReferencePosition(offset, danglingElse, false, matchParen, matchCase);
            --this.fIndent;
            return pos;
        }
        if (matchParen) {
            if (this.skipScope(5, 6)) {
                return this.fPosition;
            }
            int pos = this.findReferencePosition(offset, danglingElse, matchBrace, false, matchCase);
            --this.fIndent;
            return pos;
        }
        if (matchCase) {
            return this.matchCaseAlignment();
        }
        this.nextToken();
        switch (this.fToken) {
            case 2: {
                int pos = this.fPosition;
                if (!this.skipScope()) {
                    this.fPosition = pos;
                }
            }
            case 7: {
                return this.skipToStatementStart(danglingElse, false);
            }
            case 1: 
            case 3: 
            case 5: {
                return this.handleScopeIntroduction(offset + 1);
            }
            case -1: {
                return 0;
            }
            case 12: {
                this.fIndent = this.prefAssignmentIndent();
                return this.fPosition;
            }
            case 9: {
                this.fIndent = this.prefCaseBlockIndent();
                return this.fPosition;
            }
            case 10: {
                if (this.prefTernaryDeepAlign()) {
                    this.setFirstElementAlignment(this.fPosition, offset + 1);
                    return this.fPosition;
                }
                this.fIndent = this.prefTernaryIndent();
                return this.fPosition;
            }
            case 1010: 
            case 1014: 
            case 1017: {
                this.fIndent = this.prefSimpleIndent();
                return this.fPosition;
            }
            case 6: {
                int line = this.fLine;
                if (this.skipScope(5, 6)) {
                    int scope = this.fPosition;
                    this.nextToken();
                    if (this.fToken == 109 || this.fToken == 1017 || this.fToken == 1011) {
                        this.fIndent = this.prefSimpleIndent();
                        return this.fPosition;
                    }
                    this.fPosition = scope;
                    if (this.looksLikeMethodDecl()) {
                        return this.skipToStatementStart(danglingElse, false);
                    }
                }
                this.fPosition = offset;
                this.fLine = line;
            }
        }
        return this.skipToPreviousListItemOrListStart();
    }

    private int skipToStatementStart(boolean danglingElse, boolean isInBlock) {
        block14: while (true) {
            this.nextToken();
            if (isInBlock) {
                switch (this.fToken) {
                    case 9: 
                    case 109: 
                    case 1010: 
                    case 1011: 
                    case 1012: 
                    case 1014: 
                    case 1016: 
                    case 1017: 
                    case 1019: 
                    case 1021: 
                    case 1022: {
                        return this.fPosition;
                    }
                    case 1020: {
                        this.fIndent = this.prefCaseIndent();
                        return this.fPosition;
                    }
                }
            }
            switch (this.fToken) {
                case -1: 
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    return this.fPreviousPos;
                }
                case 9: {
                    int pos = this.fPreviousPos;
                    if (this.isConditional()) continue block14;
                    return pos;
                }
                case 2: {
                    int pos = this.fPreviousPos;
                    if (this.skipScope() && this.looksLikeArrayInitializerIntro()) continue block14;
                    return pos;
                }
                case 4: 
                case 6: {
                    int pos = this.fPreviousPos;
                    if (this.skipScope()) continue block14;
                    return pos;
                }
                case 109: {
                    if (!danglingElse) continue block14;
                    return this.fPosition;
                }
                case 1014: {
                    int pos = this.fPosition;
                    if (this.skipNextIF()) continue block14;
                    return pos;
                }
                case 1010: {
                    return this.fPosition;
                }
                case 1017: {
                    int pos = this.fPosition;
                    if (this.hasMatchingDo()) continue block14;
                    this.fPosition = pos;
                    continue block14;
                }
            }
        }
    }

    private boolean isConditional() {
        block4: while (true) {
            this.nextToken();
            switch (this.fToken) {
                case 2000: {
                    continue block4;
                }
                case 1013: {
                    return false;
                }
            }
            break;
        }
        return true;
    }

    private int matchCaseAlignment() {
        block6: while (true) {
            this.nextToken();
            switch (this.fToken) {
                case -1: 
                case 3: 
                case 5: {
                    return this.fPosition;
                }
                case 1: {
                    this.fIndent = this.prefCaseIndent();
                    return this.fPosition;
                }
                case 1013: 
                case 1024: {
                    this.fIndent = 0;
                    return this.fPosition;
                }
                case 2: 
                case 4: 
                case 6: {
                    this.skipScope();
                    continue block6;
                }
            }
        }
    }

    private int skipToPreviousListItemOrListStart() {
        int startLine = this.fLine;
        int startPosition = this.fPosition;
        while (true) {
            this.nextToken();
            if (this.fLine < startLine) {
                try {
                    int lineOffset = this.fDocument.getLineOffset(startLine);
                    int bound = Math.min(this.fDocument.getLength(), startPosition + 1);
                    this.fAlign = this.fScanner.findNonWhitespaceForwardInAnyPartition(lineOffset, bound);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                return startPosition;
            }
            switch (this.fToken) {
                case 2: 
                case 4: 
                case 6: {
                    this.skipScope();
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    return this.handleScopeIntroduction(startPosition + 1);
                }
                case 7: {
                    return this.fPosition;
                }
                case 10: {
                    if (this.prefTernaryDeepAlign()) {
                        this.setFirstElementAlignment(this.fPosition - 1, this.fPosition + 1);
                        return this.fPosition;
                    }
                    this.fIndent = this.prefTernaryIndent();
                    return this.fPosition;
                }
                case -1: {
                    return 0;
                }
            }
        }
    }

    private boolean skipScope() {
        switch (this.fToken) {
            case 6: {
                return this.skipScope(5, 6);
            }
            case 4: {
                return this.skipScope(3, 4);
            }
            case 2: {
                return this.skipScope(1, 2);
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    private int handleScopeIntroduction(int bound) {
        switch (this.fToken) {
            case 5: {
                int pos = this.fPosition;
                if (this.looksLikeMethodDecl()) {
                    if (this.prefMethodDeclDeepIndent()) {
                        return this.setFirstElementAlignment(pos, bound);
                    }
                    this.fIndent = this.prefMethodDeclIndent();
                    return pos;
                }
                this.fPosition = pos;
                if (this.looksLikeMethodCall()) {
                    if (this.prefMethodCallDeepIndent()) {
                        return this.setFirstElementAlignment(pos, bound);
                    }
                    this.fIndent = this.prefMethodCallIndent();
                    return pos;
                }
                if (this.prefParenthesisDeepIndent()) {
                    return this.setFirstElementAlignment(pos, bound);
                }
                this.fIndent = this.prefParenthesisIndent();
                return pos;
            }
            case 1: {
                int pos = this.fPosition;
                if (this.looksLikeArrayInitializerIntro()) {
                    if (this.prefArrayDeepIndent()) {
                        return this.setFirstElementAlignment(pos, bound);
                    }
                    this.fIndent = this.prefArrayIndent();
                } else {
                    this.fIndent = this.prefBlockIndent();
                }
                this.fPosition = pos;
                return this.skipToStatementStart(true, true);
            }
            case 3: {
                int pos = this.fPosition;
                if (this.prefArrayDimensionsDeepIndent()) {
                    return this.setFirstElementAlignment(pos, bound);
                }
                this.fIndent = this.prefBracketIndent();
                return pos;
            }
        }
        Assert.isTrue((boolean)false);
        return -1;
    }

    private int setFirstElementAlignment(int scopeIntroducerOffset, int bound) {
        int firstPossible = scopeIntroducerOffset + 1;
        this.fAlign = this.fScanner.findNonWhitespaceForwardInAnyPartition(firstPossible, bound);
        if (this.fAlign == -1) {
            this.fAlign = firstPossible;
        }
        return this.fAlign;
    }

    private boolean looksLikeArrayInitializerIntro() {
        this.nextToken();
        return this.fToken == 12 || this.skipBrackets();
    }

    private boolean skipNextIF() {
        Assert.isTrue((this.fToken == 1014 ? 1 : 0) != 0);
        while (true) {
            this.nextToken();
            switch (this.fToken) {
                case 2: 
                case 4: 
                case 6: {
                    this.skipScope();
                    break;
                }
                case 109: {
                    return true;
                }
                case 1014: {
                    this.skipNextIF();
                    break;
                }
                case -1: 
                case 1: 
                case 3: 
                case 5: {
                    return false;
                }
            }
        }
    }

    private boolean hasMatchingDo() {
        Assert.isTrue((this.fToken == 1017 ? 1 : 0) != 0);
        this.nextToken();
        switch (this.fToken) {
            case 2: {
                this.skipScope();
            }
            case 7: {
                this.skipToStatementStart(false, false);
                return this.fToken == 1010;
            }
        }
        return false;
    }

    private boolean skipBrackets() {
        if (this.fToken == 4) {
            this.nextToken();
            if (this.fToken == 3) {
                return true;
            }
        }
        return false;
    }

    private void nextToken() {
        this.nextToken(this.fPosition);
    }

    private void nextToken(int start) {
        this.fToken = this.fScanner.previousToken(start - 1, -2);
        this.fPreviousPos = start;
        this.fPosition = this.fScanner.getPosition() + 1;
        try {
            this.fLine = this.fDocument.getLineOfOffset(this.fPosition);
        }
        catch (BadLocationException e) {
            this.fLine = -1;
        }
    }

    private boolean looksLikeMethodDecl() {
        this.nextToken();
        if (this.fToken == 2000) {
            do {
                this.nextToken();
            } while (this.skipBrackets());
            return this.fToken == 2000;
        }
        return false;
    }

    private boolean looksLikeMethodCall() {
        this.nextToken();
        return this.fToken == 2000;
    }

    private boolean skipScope(int openToken, int closeToken) {
        int depth = 1;
        while (true) {
            this.nextToken();
            if (this.fToken == closeToken) {
                ++depth;
                continue;
            }
            if (this.fToken == openToken) {
                if (--depth != 0) continue;
                return true;
            }
            if (this.fToken == -1) break;
        }
        return false;
    }

    private int prefTabLength() {
        JavaCore core = JavaCore.getJavaCore();
        JavaPlugin plugin = JavaPlugin.getDefault();
        int tabLen = core != null && plugin != null ? ("space".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.tabulation.char")) ? -1 : plugin.getPreferenceStore().getInt("tabWidth")) : 4;
        return tabLen;
    }

    private boolean prefArrayDimensionsDeepIndent() {
        return true;
    }

    private int prefArrayIndent() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            String option = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.alignment_for_expressions_in_array_initializer");
            try {
                if (DefaultCodeFormatterConstants.getIndentStyle((String)option) == 2) {
                    return 1;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.prefContinuationIndent();
    }

    private boolean prefArrayDeepIndent() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            String option = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.alignment_for_expressions_in_array_initializer");
            try {
                return DefaultCodeFormatterConstants.getIndentStyle((String)option) == 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return true;
    }

    private boolean prefTernaryDeepAlign() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            String option = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.alignment_for_conditional_expression");
            try {
                return DefaultCodeFormatterConstants.getIndentStyle((String)option) == 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    private int prefTernaryIndent() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            String option = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.alignment_for_conditional_expression");
            try {
                if (DefaultCodeFormatterConstants.getIndentStyle((String)option) == 2) {
                    return 1;
                }
                return this.prefContinuationIndent();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.prefContinuationIndent();
    }

    private int prefCaseIndent() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            if ("true".equals(JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.indent_switchstatements_compare_to_switch"))) {
                return this.prefBlockIndent();
            }
            return 0;
        }
        return 0;
    }

    private int prefAssignmentIndent() {
        return this.prefBlockIndent();
    }

    private int prefCaseBlockIndent() {
        return this.prefBlockIndent();
    }

    private int prefSimpleIndent() {
        return this.prefBlockIndent();
    }

    private int prefBracketIndent() {
        return this.prefBlockIndent();
    }

    private boolean prefMethodDeclDeepIndent() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            String option = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.alignment_for_parameters_in_method_declaration");
            try {
                return DefaultCodeFormatterConstants.getIndentStyle((String)option) == 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return true;
    }

    private int prefMethodDeclIndent() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            String option = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.alignment_for_parameters_in_method_declaration");
            try {
                if (DefaultCodeFormatterConstants.getIndentStyle((String)option) == 2) {
                    return 1;
                }
                return this.prefContinuationIndent();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return 1;
    }

    private boolean prefMethodCallDeepIndent() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            String option = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.alignment_for_arguments_in_method_invocation");
            try {
                return DefaultCodeFormatterConstants.getIndentStyle((String)option) == 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return false;
    }

    private int prefMethodCallIndent() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            String option = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.alignment_for_arguments_in_method_invocation");
            try {
                if (DefaultCodeFormatterConstants.getIndentStyle((String)option) == 2) {
                    return 1;
                }
                return this.prefContinuationIndent();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return 1;
    }

    private boolean prefParenthesisDeepIndent() {
        return false;
    }

    private int prefParenthesisIndent() {
        return this.prefContinuationIndent();
    }

    private int prefBlockIndent() {
        return 1;
    }

    private boolean prefIndentBracesForBlocks() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            String option = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.brace_position_for_block");
            return option.equals("next_line_shifted");
        }
        return false;
    }

    private boolean prefIndentBracesForArrays() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            String option = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.brace_position_for_array_initializer");
            return option.equals("next_line_shifted");
        }
        return false;
    }

    private boolean prefIndentBracesForMethods() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            String option = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.brace_position_for_method_declaration");
            return option.equals("next_line_shifted");
        }
        return false;
    }

    private int prefContinuationIndent() {
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            String option = JavaCore.getOption((String)"org.eclipse.jdt.core.formatter.continuation_indentation");
            try {
                return Integer.parseInt(option);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 2;
    }
}

