/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.text.MessageFormat;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.search.JavaSearchResultPage;
import org.eclipse.jdt.internal.ui.search.LevelTreeContentProvider;
import org.eclipse.jdt.internal.ui.search.SearchLabelProvider;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Image;

public class PostfixLabelProvider
extends SearchLabelProvider {
    private ITreeContentProvider fContentProvider = new LevelTreeContentProvider.FastJavaElementProvider();

    public PostfixLabelProvider(JavaSearchResultPage page) {
        super(page, new AppearanceAwareLabelProvider(1627389961, 1));
    }

    public Image getImage(Object element) {
        Image image = this.getLabelProvider().getImage(element);
        if (image != null) {
            return image;
        }
        return this.getParticipantImage(element);
    }

    public String getText(Object element) {
        ITreeContentProvider provider = (ITreeContentProvider)this.fPage.getViewer().getContentProvider();
        Object visibleParent = provider.getParent(element);
        Object realParent = this.fContentProvider.getParent(element);
        Object lastElement = element;
        StringBuffer postfix = new StringBuffer();
        while (realParent != null && !(realParent instanceof IJavaModel) && !realParent.equals(visibleParent)) {
            if (!this.isSameInformation(realParent, lastElement)) {
                postfix.append(" - ");
                postfix.append(this.internalGetText(realParent));
            }
            lastElement = realParent;
            realParent = this.fContentProvider.getParent(realParent);
        }
        int matchCount = this.fPage.getDisplayedMatchCount(element);
        String text = this.internalGetText(element);
        if (this.hasShownChildren(element) && matchCount == 1) {
            String label = this.getSingularLabel(element);
            return MessageFormat.format(label, text, postfix.toString());
        }
        if (matchCount < 2) {
            String label = this.getNoCountLabel(element);
            return MessageFormat.format(label, text, postfix.toString());
        }
        String label = this.getPluralLabel(element);
        return MessageFormat.format(label, text, new Integer(matchCount), postfix.toString());
    }

    private boolean hasShownChildren(Object element) {
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.fPage.getViewer().getContentProvider();
        return contentProvider.hasChildren(element);
    }

    private String getNoCountLabel(Object element) {
        if (this.hasPotentialMatches(element)) {
            return SearchMessages.getString("PostfixLabelProvider.potential_noCount");
        }
        return SearchMessages.getString("PostfixLabelProvider.exact_noCount");
    }

    private String getSingularLabel(Object element) {
        if (this.hasPotentialMatches(element)) {
            return SearchMessages.getString("PostfixLabelProvider.potential_singular");
        }
        return SearchMessages.getString("PostfixLabelProvider.exact_singular");
    }

    private String getPluralLabel(Object element) {
        if (this.hasPotentialMatches(element)) {
            return SearchMessages.getString("PostfixLabelProvider.potential_plural");
        }
        return SearchMessages.getString("PostfixLabelProvider.exact_plural");
    }

    private String internalGetText(Object element) {
        String text = this.getLabelProvider().getText(element);
        if (text != null && !"".equals(text)) {
            return text;
        }
        return this.getParticipantText(element);
    }

    private boolean isSameInformation(Object realParent, Object lastElement) {
        if (lastElement instanceof IType) {
            IType type = (IType)lastElement;
            if (realParent instanceof IClassFile ? type.getClassFile().equals(realParent) : realParent instanceof ICompilationUnit && type.getCompilationUnit().equals(realParent)) {
                return true;
            }
        }
        return false;
    }
}

