/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.util.TabFolderLayout;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class CompilerConfigurationBlock
extends OptionsConfigurationBlock {
    private static final String PREF_LOCAL_VARIABLE_ATTR = "org.eclipse.jdt.core.compiler.debug.localVariable";
    private static final String PREF_LINE_NUMBER_ATTR = "org.eclipse.jdt.core.compiler.debug.lineNumber";
    private static final String PREF_SOURCE_FILE_ATTR = "org.eclipse.jdt.core.compiler.debug.sourceFile";
    private static final String PREF_CODEGEN_UNUSED_LOCAL = "org.eclipse.jdt.core.compiler.codegen.unusedLocal";
    private static final String PREF_CODEGEN_TARGET_PLATFORM = "org.eclipse.jdt.core.compiler.codegen.targetPlatform";
    private static final String PREF_CODEGEN_INLINE_JSR_BYTECODE = "org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode";
    private static final String PREF_PB_OVERRIDING_PACKAGE_DEFAULT_METHOD = "org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod";
    private static final String PREF_PB_METHOD_WITH_CONSTRUCTOR_NAME = "org.eclipse.jdt.core.compiler.problem.methodWithConstructorName";
    private static final String PREF_PB_DEPRECATION = "org.eclipse.jdt.core.compiler.problem.deprecation";
    private static final String PREF_PB_DEPRECATION_WHEN_OVERRIDING = "org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod";
    private static final String PREF_PB_HIDDEN_CATCH_BLOCK = "org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock";
    private static final String PREF_PB_UNUSED_LOCAL = "org.eclipse.jdt.core.compiler.problem.unusedLocal";
    private static final String PREF_PB_UNUSED_PARAMETER = "org.eclipse.jdt.core.compiler.problem.unusedParameter";
    private static final String PREF_PB_SIGNAL_PARAMETER_IN_OVERRIDING = "org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete";
    private static final String PREF_PB_SIGNAL_PARAMETER_IN_ABSTRACT = "org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract";
    private static final String PREF_PB_SYNTHETIC_ACCESS_EMULATION = "org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation";
    private static final String PREF_PB_NON_EXTERNALIZED_STRINGS = "org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral";
    private static final String PREF_PB_ASSERT_AS_IDENTIFIER = "org.eclipse.jdt.core.compiler.problem.assertIdentifier";
    private static final String PREF_PB_MAX_PER_UNIT = "org.eclipse.jdt.core.compiler.maxProblemPerUnit";
    private static final String PREF_PB_UNUSED_IMPORT = "org.eclipse.jdt.core.compiler.problem.unusedImport";
    private static final String PREF_PB_UNUSED_PRIVATE = "org.eclipse.jdt.core.compiler.problem.unusedPrivateMember";
    private static final String PREF_PB_STATIC_ACCESS_RECEIVER = "org.eclipse.jdt.core.compiler.problem.staticAccessReceiver";
    private static final String PREF_PB_NO_EFFECT_ASSIGNMENT = "org.eclipse.jdt.core.compiler.problem.noEffectAssignment";
    private static final String PREF_PB_CHAR_ARRAY_IN_CONCAT = "org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion";
    private static final String PREF_PB_POSSIBLE_ACCIDENTAL_BOOLEAN_ASSIGNMENT = "org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment";
    private static final String PREF_PB_LOCAL_VARIABLE_HIDING = "org.eclipse.jdt.core.compiler.problem.localVariableHiding";
    private static final String PREF_PB_FIELD_HIDING = "org.eclipse.jdt.core.compiler.problem.fieldHiding";
    private static final String PREF_PB_SPECIAL_PARAMETER_HIDING_FIELD = "org.eclipse.jdt.core.compiler.problem.specialParameterHidingField";
    private static final String PREF_PB_INDIRECT_STATIC_ACCESS = "org.eclipse.jdt.core.compiler.problem.indirectStaticAccess";
    private static final String PREF_PB_EMPTY_STATEMENT = "org.eclipse.jdt.core.compiler.problem.emptyStatement";
    private static final String PREF_PB_UNNECESSARY_ELSE = "org.eclipse.jdt.core.compiler.problem.unnecessaryElse";
    private static final String PREF_PB_UNNECESSARY_TYPE_CHECK = "org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck";
    private static final String PREF_JAVADOC_SUPPORT = "org.eclipse.jdt.core.compiler.doc.comment.support";
    private static final String PREF_PB_INVALID_JAVADOC = "org.eclipse.jdt.core.compiler.problem.invalidJavadoc";
    private static final String PREF_PB_INVALID_JAVADOC_TAGS = "org.eclipse.jdt.core.compiler.problem.invalidJavadocTags";
    private static final String PREF_PB_INVALID_JAVADOC_TAGS_VISIBILITY = "org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility";
    private static final String PREF_PB_MISSING_JAVADOC_TAGS = "org.eclipse.jdt.core.compiler.problem.missingJavadocTags";
    private static final String PREF_PB_MISSING_JAVADOC_TAGS_VISIBILITY = "org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility";
    private static final String PREF_PB_MISSING_JAVADOC_TAGS_OVERRIDING = "org.eclipse.jdt.core.compiler.problem.missingJavadocTagsOverriding";
    private static final String PREF_PB_MISSING_JAVADOC_COMMENTS = "org.eclipse.jdt.core.compiler.problem.missingJavadocComments";
    private static final String PREF_PB_MISSING_JAVADOC_COMMENTS_VISIBILITY = "org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsVisibility";
    private static final String PREF_PB_MISSING_JAVADOC_COMMENTS_OVERRIDING = "org.eclipse.jdt.core.compiler.problem.missingJavadocCommentsOverriding";
    private static final String PREF_SOURCE_COMPATIBILITY = "org.eclipse.jdt.core.compiler.source";
    private static final String PREF_COMPLIANCE = "org.eclipse.jdt.core.compiler.compliance";
    private static final String PREF_RESOURCE_FILTER = "org.eclipse.jdt.core.builder.resourceCopyExclusionFilter";
    private static final String PREF_BUILD_INVALID_CLASSPATH = "org.eclipse.jdt.core.builder.invalidClasspath";
    private static final String PREF_BUILD_CLEAN_OUTPUT_FOLDER = "org.eclipse.jdt.core.builder.cleanOutputFolder";
    private static final String PREF_ENABLE_EXCLUSION_PATTERNS = "org.eclipse.jdt.core.classpath.exclusionPatterns";
    private static final String PREF_ENABLE_MULTIPLE_OUTPUT_LOCATIONS = "org.eclipse.jdt.core.classpath.multipleOutputLocations";
    private static final String PREF_PB_INCOMPLETE_BUILDPATH = "org.eclipse.jdt.core.incompleteClasspath";
    private static final String PREF_PB_CIRCULAR_BUILDPATH = "org.eclipse.jdt.core.circularClasspath";
    private static final String PREF_PB_INCOMPATIBLE_JDK_LEVEL = "org.eclipse.jdt.core.incompatibleJDKLevel";
    private static final String PREF_PB_DUPLICATE_RESOURCE = "org.eclipse.jdt.core.builder.duplicateResourceTask";
    private static final String PREF_PB_DEPRECATION_IN_DEPRECATED_CODE = "org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode";
    private static final String PREF_PB_INCOMPATIBLE_INTERFACE_METHOD = "org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod";
    private static final String PREF_PB_UNDOCUMENTED_EMPTY_BLOCK = "org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock";
    private static final String PREF_PB_FINALLY_BLOCK_NOT_COMPLETING = "org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally";
    private static final String PREF_PB_UNUSED_DECLARED_THROWN_EXCEPTION = "org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException";
    private static final String PREF_PB_UNUSED_DECLARED_THROWN_EXCEPTION_WHEN_OVERRIDING = "org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownExceptionWhenOverriding";
    private static final String PREF_PB_UNQUALIFIED_FIELD_ACCESS = "org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess";
    private static final String PREF_15_PB_UNSAVE_TYPE_OPERATION = "org.eclipse.jdt.core.compiler.problem.unsafeTypeOperation";
    private static final String PREF_15_PB_FINAL_PARAM_BOUND = "org.eclipse.jdt.core.compiler.problem.finalParameterBound";
    private static final String INTR_DEFAULT_COMPLIANCE = "internal.default.compliance";
    private static final String GENERATE = "generate";
    private static final String DO_NOT_GENERATE = "do not generate";
    private static final String PRESERVE = "preserve";
    private static final String OPTIMIZE_OUT = "optimize out";
    private static final String VERSION_1_1 = "1.1";
    private static final String VERSION_1_2 = "1.2";
    private static final String VERSION_1_3 = "1.3";
    private static final String VERSION_1_4 = "1.4";
    private static final String VERSION_1_5 = "1.5";
    private static final String ERROR = "error";
    private static final String WARNING = "warning";
    private static final String IGNORE = "ignore";
    private static final String ABORT = "abort";
    private static final String CLEAN = "clean";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private static final String PUBLIC = "public";
    private static final String PROTECTED = "protected";
    private static final String DEFAULT = "default";
    private static final String PRIVATE = "private";
    private static final String DEFAULT_CONF = "default";
    private static final String USER_CONF = "user";
    private ArrayList fComplianceControls = new ArrayList();
    private PixelConverter fPixelConverter;
    private Composite fJavadocComposite;
    private String[] fRememberedUserCompliance;
    private IStatus fComplianceStatus = new StatusInfo();
    private IStatus fMaxNumberProblemsStatus = new StatusInfo();
    private IStatus fResourceFilterStatus = new StatusInfo();

    public CompilerConfigurationBlock(IStatusChangeListener context, IJavaProject project) {
        super(context, project, CompilerConfigurationBlock.getKeys());
        if (ENABLED.equals(this.fWorkingValues.get(PREF_PB_SIGNAL_PARAMETER_IN_ABSTRACT))) {
            this.fWorkingValues.put(PREF_PB_SIGNAL_PARAMETER_IN_OVERRIDING, ENABLED);
        }
        this.fRememberedUserCompliance = new String[]{(String)this.fWorkingValues.get(PREF_PB_ASSERT_AS_IDENTIFIER), (String)this.fWorkingValues.get(PREF_SOURCE_COMPATIBILITY), (String)this.fWorkingValues.get(PREF_CODEGEN_TARGET_PLATFORM), (String)this.fWorkingValues.get(PREF_COMPLIANCE)};
    }

    private static String[] getKeys() {
        String[] keys = new String[]{PREF_LOCAL_VARIABLE_ATTR, PREF_LINE_NUMBER_ATTR, PREF_SOURCE_FILE_ATTR, PREF_CODEGEN_UNUSED_LOCAL, PREF_CODEGEN_INLINE_JSR_BYTECODE, PREF_CODEGEN_TARGET_PLATFORM, PREF_PB_OVERRIDING_PACKAGE_DEFAULT_METHOD, PREF_PB_METHOD_WITH_CONSTRUCTOR_NAME, PREF_PB_DEPRECATION, PREF_PB_HIDDEN_CATCH_BLOCK, PREF_PB_UNUSED_LOCAL, PREF_PB_UNUSED_PARAMETER, PREF_PB_SYNTHETIC_ACCESS_EMULATION, PREF_PB_NON_EXTERNALIZED_STRINGS, PREF_PB_ASSERT_AS_IDENTIFIER, PREF_PB_UNUSED_IMPORT, PREF_PB_MAX_PER_UNIT, PREF_SOURCE_COMPATIBILITY, PREF_COMPLIANCE, PREF_PB_STATIC_ACCESS_RECEIVER, PREF_PB_DEPRECATION_IN_DEPRECATED_CODE, PREF_PB_NO_EFFECT_ASSIGNMENT, PREF_PB_INCOMPATIBLE_INTERFACE_METHOD, PREF_PB_UNUSED_PRIVATE, PREF_PB_CHAR_ARRAY_IN_CONCAT, PREF_PB_UNNECESSARY_ELSE, PREF_PB_POSSIBLE_ACCIDENTAL_BOOLEAN_ASSIGNMENT, PREF_PB_LOCAL_VARIABLE_HIDING, PREF_PB_FIELD_HIDING, PREF_PB_SPECIAL_PARAMETER_HIDING_FIELD, PREF_PB_INDIRECT_STATIC_ACCESS, PREF_PB_EMPTY_STATEMENT, PREF_PB_SIGNAL_PARAMETER_IN_OVERRIDING, PREF_PB_SIGNAL_PARAMETER_IN_ABSTRACT, PREF_PB_UNNECESSARY_TYPE_CHECK, PREF_PB_UNUSED_DECLARED_THROWN_EXCEPTION, PREF_PB_UNQUALIFIED_FIELD_ACCESS, PREF_PB_UNDOCUMENTED_EMPTY_BLOCK, PREF_PB_FINALLY_BLOCK_NOT_COMPLETING, PREF_PB_DEPRECATION_WHEN_OVERRIDING, PREF_PB_UNUSED_DECLARED_THROWN_EXCEPTION_WHEN_OVERRIDING, PREF_JAVADOC_SUPPORT, PREF_PB_INVALID_JAVADOC, PREF_PB_INVALID_JAVADOC_TAGS_VISIBILITY, PREF_PB_INVALID_JAVADOC_TAGS_VISIBILITY, PREF_PB_MISSING_JAVADOC_TAGS, PREF_PB_MISSING_JAVADOC_TAGS_VISIBILITY, PREF_PB_MISSING_JAVADOC_TAGS_OVERRIDING, PREF_PB_MISSING_JAVADOC_COMMENTS, PREF_PB_MISSING_JAVADOC_COMMENTS_VISIBILITY, PREF_PB_MISSING_JAVADOC_COMMENTS_OVERRIDING, PREF_RESOURCE_FILTER, PREF_BUILD_INVALID_CLASSPATH, PREF_PB_INCOMPLETE_BUILDPATH, PREF_PB_CIRCULAR_BUILDPATH, PREF_BUILD_CLEAN_OUTPUT_FOLDER, PREF_PB_DUPLICATE_RESOURCE, PREF_PB_INCOMPATIBLE_JDK_LEVEL, PREF_ENABLE_EXCLUSION_PATTERNS, PREF_ENABLE_MULTIPLE_OUTPUT_LOCATIONS};
        if (JavaModelUtil.isJDTCore_1_5()) {
            String[] newKeys = new String[]{PREF_15_PB_UNSAVE_TYPE_OPERATION, PREF_15_PB_FINAL_PARAM_BOUND};
            String[] merged = new String[keys.length + newKeys.length];
            System.arraycopy(keys, 0, merged, 0, keys.length);
            System.arraycopy(newKeys, 0, merged, keys.length, newKeys.length);
            keys = merged;
        }
        return keys;
    }

    protected final Map getOptions(boolean inheritJavaCoreOptions) {
        Map map = super.getOptions(inheritJavaCoreOptions);
        map.put(INTR_DEFAULT_COMPLIANCE, CompilerConfigurationBlock.getCurrentCompliance(map));
        return map;
    }

    protected final Map getDefaultOptions() {
        Map map = super.getDefaultOptions();
        map.put(INTR_DEFAULT_COMPLIANCE, CompilerConfigurationBlock.getCurrentCompliance(map));
        return map;
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.setShell(parent.getShell());
        TabFolder folder = new TabFolder(parent, 0);
        folder.setLayout((Layout)new TabFolderLayout());
        folder.setLayoutData((Object)new GridData(1808));
        Composite commonComposite = this.createStyleTabContent((Composite)folder);
        Composite unusedComposite = this.createUnusedCodeTabContent(folder);
        Composite advancedComposite = this.createAdvancedTabContent(folder);
        Composite javadocComposite = this.createJavadocTabContent(folder);
        Composite complianceComposite = this.createComplianceTabContent((Composite)folder);
        Composite othersComposite = this.createBuildPathTabContent(folder);
        TabItem item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("CompilerConfigurationBlock.common.tabtitle"));
        item.setControl((Control)commonComposite);
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("CompilerConfigurationBlock.advanced.tabtitle"));
        item.setControl((Control)advancedComposite);
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("CompilerConfigurationBlock.unused.tabtitle"));
        item.setControl((Control)unusedComposite);
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("CompilerConfigurationBlock.javadoc.tabtitle"));
        item.setControl((Control)javadocComposite);
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("CompilerConfigurationBlock.compliance.tabtitle"));
        item.setControl((Control)complianceComposite);
        item = new TabItem(folder, 0);
        item.setText(PreferencesMessages.getString("CompilerConfigurationBlock.others.tabtitle"));
        item.setControl((Control)othersComposite);
        if (JavaModelUtil.isJDTCore_1_5()) {
            Composite extraComposite = this.create15TabContent(folder);
            item = new TabItem(folder, 0);
            item.setText(PreferencesMessages.getString("CompilerConfigurationBlock.15.tabtitle"));
            item.setControl((Control)extraComposite);
        }
        this.validateSettings(null, null);
        return folder;
    }

    private Composite createStyleTabContent(Composite folder) {
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.error"), PreferencesMessages.getString("CompilerConfigurationBlock.warning"), PreferencesMessages.getString("CompilerConfigurationBlock.ignore")};
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        Composite composite = new Composite(folder, 0);
        composite.setLayout((Layout)layout);
        Label description = new Label(composite, 64);
        description.setText(PreferencesMessages.getString("CompilerConfigurationBlock.common.description"));
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        description.setLayoutData((Object)gd);
        String label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_overriding_pkg_dflt.label");
        this.addComboBox(composite, label, PREF_PB_OVERRIDING_PACKAGE_DEFAULT_METHOD, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_method_naming.label");
        this.addComboBox(composite, label, PREF_PB_METHOD_WITH_CONSTRUCTOR_NAME, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_static_access_receiver.label");
        this.addComboBox(composite, label, PREF_PB_STATIC_ACCESS_RECEIVER, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_indirect_access_to_static.label");
        this.addComboBox(composite, label, PREF_PB_INDIRECT_STATIC_ACCESS, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_no_effect_assignment.label");
        this.addComboBox(composite, label, PREF_PB_NO_EFFECT_ASSIGNMENT, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_accidential_assignement.label");
        this.addComboBox(composite, label, PREF_PB_POSSIBLE_ACCIDENTAL_BOOLEAN_ASSIGNMENT, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_unqualified_field_access.label");
        this.addComboBox(composite, label, PREF_PB_UNQUALIFIED_FIELD_ACCESS, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_finally_block_not_completing.label");
        this.addComboBox(composite, label, PREF_PB_FINALLY_BLOCK_NOT_COMPLETING, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_empty_statement.label");
        this.addComboBox(composite, label, PREF_PB_EMPTY_STATEMENT, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_undocumented_empty_block.label");
        this.addComboBox(composite, label, PREF_PB_UNDOCUMENTED_EMPTY_BLOCK, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        return composite;
    }

    private Composite createAdvancedTabContent(TabFolder folder) {
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.error"), PreferencesMessages.getString("CompilerConfigurationBlock.warning"), PreferencesMessages.getString("CompilerConfigurationBlock.ignore")};
        String[] enabledDisabled = new String[]{ENABLED, DISABLED};
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)layout);
        Label description = new Label(composite, 64);
        description.setText(PreferencesMessages.getString("CompilerConfigurationBlock.advanced.description"));
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        description.setLayoutData((Object)gd);
        String label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_synth_access_emul.label");
        this.addComboBox(composite, label, PREF_PB_SYNTHETIC_ACCESS_EMULATION, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_local_variable_hiding.label");
        this.addComboBox(composite, label, PREF_PB_LOCAL_VARIABLE_HIDING, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        int indent = this.fPixelConverter.convertWidthInCharsToPixels(2);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_special_param_hiding.label");
        this.addCheckBox(composite, label, PREF_PB_SPECIAL_PARAMETER_HIDING_FIELD, enabledDisabled, indent);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_field_hiding.label");
        this.addComboBox(composite, label, PREF_PB_FIELD_HIDING, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_incompatible_interface_method.label");
        this.addComboBox(composite, label, PREF_PB_INCOMPATIBLE_INTERFACE_METHOD, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_char_array_in_concat.label");
        this.addComboBox(composite, label, PREF_PB_CHAR_ARRAY_IN_CONCAT, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_deprecation.label");
        this.addComboBox(composite, label, PREF_PB_DEPRECATION, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_deprecation_in_deprecation.label");
        this.addCheckBox(composite, label, PREF_PB_DEPRECATION_IN_DEPRECATED_CODE, enabledDisabled, indent);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_deprecation_when_overriding.label");
        this.addCheckBox(composite, label, PREF_PB_DEPRECATION_WHEN_OVERRIDING, enabledDisabled, indent);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_non_externalized_strings.label");
        this.addComboBox(composite, label, PREF_PB_NON_EXTERNALIZED_STRINGS, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        gd = new GridData();
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(6);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_max_per_unit.label");
        Text text = this.addTextField(composite, label, PREF_PB_MAX_PER_UNIT, 0, 0);
        text.setTextLimit(6);
        text.setLayoutData((Object)gd);
        return composite;
    }

    private Composite createUnusedCodeTabContent(TabFolder folder) {
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.error"), PreferencesMessages.getString("CompilerConfigurationBlock.warning"), PreferencesMessages.getString("CompilerConfigurationBlock.ignore")};
        String[] enabledDisabled = new String[]{ENABLED, DISABLED};
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)layout);
        Label description = new Label(composite, 64);
        description.setText(PreferencesMessages.getString("CompilerConfigurationBlock.unused.description"));
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        description.setLayoutData((Object)gd);
        String label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_unused_local.label");
        this.addComboBox(composite, label, PREF_PB_UNUSED_LOCAL, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_unused_parameter.label");
        this.addComboBox(composite, label, PREF_PB_UNUSED_PARAMETER, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        int indent = this.fPixelConverter.convertWidthInCharsToPixels(2);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_signal_param_in_overriding.label");
        this.addCheckBox(composite, label, PREF_PB_SIGNAL_PARAMETER_IN_OVERRIDING, enabledDisabled, indent);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_unused_imports.label");
        this.addComboBox(composite, label, PREF_PB_UNUSED_IMPORT, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_unused_private.label");
        this.addComboBox(composite, label, PREF_PB_UNUSED_PRIVATE, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_unnecessary_else.label");
        this.addComboBox(composite, label, PREF_PB_UNNECESSARY_ELSE, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_unnecessary_type_check.label");
        this.addComboBox(composite, label, PREF_PB_UNNECESSARY_TYPE_CHECK, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_hidden_catchblock.label");
        this.addComboBox(composite, label, PREF_PB_HIDDEN_CATCH_BLOCK, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_unused_throwing_exception.label");
        this.addComboBox(composite, label, PREF_PB_UNUSED_DECLARED_THROWN_EXCEPTION, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_unused_throwing_exception_when_overriding.label");
        this.addCheckBox(composite, label, PREF_PB_UNUSED_DECLARED_THROWN_EXCEPTION_WHEN_OVERRIDING, enabledDisabled, indent);
        return composite;
    }

    private Composite createJavadocTabContent(TabFolder folder) {
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.error"), PreferencesMessages.getString("CompilerConfigurationBlock.warning"), PreferencesMessages.getString("CompilerConfigurationBlock.ignore")};
        String[] enabledDisabled = new String[]{ENABLED, DISABLED};
        String[] visibilities = new String[]{PUBLIC, PROTECTED, "default", PRIVATE};
        String[] visibilitiesLabels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.public"), PreferencesMessages.getString("CompilerConfigurationBlock.protected"), PreferencesMessages.getString("CompilerConfigurationBlock.default"), PreferencesMessages.getString("CompilerConfigurationBlock.private")};
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        Composite outer = new Composite((Composite)folder, 0);
        outer.setLayout((Layout)layout);
        String label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_javadoc_support.label");
        this.addCheckBox(outer, label, PREF_JAVADOC_SUPPORT, enabledDisabled, 0);
        layout = new GridLayout();
        layout.numColumns = nColumns;
        layout.marginHeight = 0;
        Composite composite = new Composite(outer, 0);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.fJavadocComposite = composite;
        Label description = new Label(composite, 64);
        description.setText(PreferencesMessages.getString("CompilerConfigurationBlock.javadoc.description"));
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        description.setLayoutData((Object)gd);
        int indent = this.fPixelConverter.convertWidthInCharsToPixels(2);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_invalid_javadoc.label");
        this.addComboBox(composite, label, PREF_PB_INVALID_JAVADOC, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_invalid_javadoc_tags_visibility.label");
        this.addComboBox(composite, label, PREF_PB_INVALID_JAVADOC_TAGS_VISIBILITY, visibilities, visibilitiesLabels, indent);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_invalid_javadoc_tags.label");
        this.addCheckBox(composite, label, PREF_PB_INVALID_JAVADOC_TAGS, enabledDisabled, indent);
        Label separator = new Label(composite, 256);
        gd = new GridData(256);
        gd.horizontalSpan = nColumns;
        separator.setLayoutData((Object)gd);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_missing_javadoc.label");
        this.addComboBox(composite, label, PREF_PB_MISSING_JAVADOC_TAGS, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_missing_javadoc_tags_visibility.label");
        this.addComboBox(composite, label, PREF_PB_MISSING_JAVADOC_TAGS_VISIBILITY, visibilities, visibilitiesLabels, indent);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_missing_javadoc_tags_overriding.label");
        this.addCheckBox(composite, label, PREF_PB_MISSING_JAVADOC_TAGS_OVERRIDING, enabledDisabled, indent);
        separator = new Label(composite, 256);
        gd = new GridData(256);
        gd.horizontalSpan = nColumns;
        separator.setLayoutData((Object)gd);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_missing_comments.label");
        this.addComboBox(composite, label, PREF_PB_MISSING_JAVADOC_COMMENTS, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_missing_comments_visibility.label");
        this.addComboBox(composite, label, PREF_PB_MISSING_JAVADOC_COMMENTS_VISIBILITY, visibilities, visibilitiesLabels, indent);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_missing_comments_overriding.label");
        this.addCheckBox(composite, label, PREF_PB_MISSING_JAVADOC_COMMENTS_OVERRIDING, enabledDisabled, indent);
        return outer;
    }

    private Composite createBuildPathTabContent(TabFolder folder) {
        String[] abortIgnoreValues = new String[]{ABORT, IGNORE};
        String[] cleanIgnoreValues = new String[]{CLEAN, IGNORE};
        String[] enableDisableValues = new String[]{ENABLED, DISABLED};
        String[] errorWarning = new String[]{ERROR, WARNING};
        String[] errorWarningLabels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.error"), PreferencesMessages.getString("CompilerConfigurationBlock.warning")};
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        Composite othersComposite = new Composite((Composite)folder, 0);
        othersComposite.setLayout((Layout)layout);
        Label description = new Label(othersComposite, 64);
        description.setText(PreferencesMessages.getString("CompilerConfigurationBlock.build_warnings.description"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = nColumns;
        description.setLayoutData((Object)gd);
        String label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_incomplete_build_path.label");
        this.addComboBox(othersComposite, label, PREF_PB_INCOMPLETE_BUILDPATH, errorWarning, errorWarningLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_build_path_cycles.label");
        this.addComboBox(othersComposite, label, PREF_PB_CIRCULAR_BUILDPATH, errorWarning, errorWarningLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_duplicate_resources.label");
        this.addComboBox(othersComposite, label, PREF_PB_DUPLICATE_RESOURCE, errorWarning, errorWarningLabels, 0);
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.error"), PreferencesMessages.getString("CompilerConfigurationBlock.warning"), PreferencesMessages.getString("CompilerConfigurationBlock.ignore")};
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_check_prereq_binary_level.label");
        this.addComboBox(othersComposite, label, PREF_PB_INCOMPATIBLE_JDK_LEVEL, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.build_invalid_classpath.label");
        this.addCheckBox(othersComposite, label, PREF_BUILD_INVALID_CLASSPATH, abortIgnoreValues, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.build_clean_outputfolder.label");
        this.addCheckBox(othersComposite, label, PREF_BUILD_CLEAN_OUTPUT_FOLDER, cleanIgnoreValues, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.enable_exclusion_patterns.label");
        this.addCheckBox(othersComposite, label, PREF_ENABLE_EXCLUSION_PATTERNS, enableDisableValues, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.enable_multiple_outputlocations.label");
        this.addCheckBox(othersComposite, label, PREF_ENABLE_MULTIPLE_OUTPUT_LOCATIONS, enableDisableValues, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.resource_filter.label");
        Text text = this.addTextField(othersComposite, label, PREF_RESOURCE_FILTER, 0, 0);
        gd = (GridData)text.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(10);
        description = new Label(othersComposite, 64);
        description.setText(PreferencesMessages.getString("CompilerConfigurationBlock.resource_filter.description"));
        gd = new GridData(256);
        gd.horizontalSpan = nColumns;
        gd.widthHint = this.fPixelConverter.convertWidthInCharsToPixels(60);
        description.setLayoutData((Object)gd);
        return othersComposite;
    }

    private Composite createComplianceTabContent(Composite folder) {
        String[] values14Labels;
        String[] values14;
        String[] values34Labels;
        String[] values34;
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        if (JavaModelUtil.isJDTCore_1_5()) {
            values34 = new String[]{VERSION_1_3, VERSION_1_4, VERSION_1_5};
            values34Labels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.version13"), PreferencesMessages.getString("CompilerConfigurationBlock.version14"), PreferencesMessages.getString("CompilerConfigurationBlock.version15")};
        } else {
            values34 = new String[]{VERSION_1_3, VERSION_1_4};
            values34Labels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.version13"), PreferencesMessages.getString("CompilerConfigurationBlock.version14")};
        }
        Composite compComposite = new Composite(folder, 0);
        compComposite.setLayout((Layout)layout);
        int nColumns = 3;
        layout = new GridLayout();
        layout.numColumns = nColumns;
        Group group = new Group(compComposite, 0);
        group.setText(PreferencesMessages.getString("CompilerConfigurationBlock.compliance.group.label"));
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)layout);
        String label = PreferencesMessages.getString("CompilerConfigurationBlock.compiler_compliance.label");
        this.addComboBox((Composite)group, label, PREF_COMPLIANCE, values34, values34Labels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.default_settings.label");
        this.addCheckBox((Composite)group, label, INTR_DEFAULT_COMPLIANCE, new String[]{"default", USER_CONF}, 0);
        int indent = this.fPixelConverter.convertWidthInCharsToPixels(2);
        Control[] otherChildren = group.getChildren();
        if (JavaModelUtil.isJDTCore_1_5()) {
            values14 = new String[]{VERSION_1_1, VERSION_1_2, VERSION_1_3, VERSION_1_4, VERSION_1_5};
            values14Labels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.version11"), PreferencesMessages.getString("CompilerConfigurationBlock.version12"), PreferencesMessages.getString("CompilerConfigurationBlock.version13"), PreferencesMessages.getString("CompilerConfigurationBlock.version14"), PreferencesMessages.getString("CompilerConfigurationBlock.version15")};
        } else {
            values14 = new String[]{VERSION_1_1, VERSION_1_2, VERSION_1_3, VERSION_1_4};
            values14Labels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.version11"), PreferencesMessages.getString("CompilerConfigurationBlock.version12"), PreferencesMessages.getString("CompilerConfigurationBlock.version13"), PreferencesMessages.getString("CompilerConfigurationBlock.version14")};
        }
        label = PreferencesMessages.getString("CompilerConfigurationBlock.codegen_targetplatform.label");
        this.addComboBox((Composite)group, label, PREF_CODEGEN_TARGET_PLATFORM, values14, values14Labels, indent);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.source_compatibility.label");
        this.addComboBox((Composite)group, label, PREF_SOURCE_COMPATIBILITY, values34, values34Labels, indent);
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.error"), PreferencesMessages.getString("CompilerConfigurationBlock.warning"), PreferencesMessages.getString("CompilerConfigurationBlock.ignore")};
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_assert_as_identifier.label");
        this.addComboBox((Composite)group, label, PREF_PB_ASSERT_AS_IDENTIFIER, errorWarningIgnore, errorWarningIgnoreLabels, indent);
        Control[] allChildren = group.getChildren();
        this.fComplianceControls.addAll(Arrays.asList(allChildren));
        this.fComplianceControls.removeAll(Arrays.asList(otherChildren));
        layout = new GridLayout();
        layout.numColumns = nColumns;
        group = new Group(compComposite, 0);
        group.setText(PreferencesMessages.getString("CompilerConfigurationBlock.classfiles.group.label"));
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)layout);
        String[] generateValues = new String[]{GENERATE, DO_NOT_GENERATE};
        String[] enableDisableValues = new String[]{ENABLED, DISABLED};
        label = PreferencesMessages.getString("CompilerConfigurationBlock.variable_attr.label");
        this.addCheckBox((Composite)group, label, PREF_LOCAL_VARIABLE_ATTR, generateValues, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.line_number_attr.label");
        this.addCheckBox((Composite)group, label, PREF_LINE_NUMBER_ATTR, generateValues, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.source_file_attr.label");
        this.addCheckBox((Composite)group, label, PREF_SOURCE_FILE_ATTR, generateValues, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.codegen_unused_local.label");
        this.addCheckBox((Composite)group, label, PREF_CODEGEN_UNUSED_LOCAL, new String[]{PRESERVE, OPTIMIZE_OUT}, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.codegen_inline_jsr_bytecode.label");
        this.addCheckBox((Composite)group, label, PREF_CODEGEN_INLINE_JSR_BYTECODE, enableDisableValues, 0);
        return compComposite;
    }

    private Composite create15TabContent(TabFolder folder) {
        String[] errorWarningIgnore = new String[]{ERROR, WARNING, IGNORE};
        String[] errorWarningIgnoreLabels = new String[]{PreferencesMessages.getString("CompilerConfigurationBlock.error"), PreferencesMessages.getString("CompilerConfigurationBlock.warning"), PreferencesMessages.getString("CompilerConfigurationBlock.ignore")};
        int nColumns = 3;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        Composite composite = new Composite((Composite)folder, 0);
        composite.setLayout((Layout)layout);
        Label description = new Label(composite, 64);
        description.setText(PreferencesMessages.getString("CompilerConfigurationBlock.15.description"));
        GridData gd = new GridData();
        gd.horizontalSpan = nColumns;
        description.setLayoutData((Object)gd);
        String label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_unsafe_type_op.label");
        this.addComboBox(composite, label, PREF_15_PB_UNSAVE_TYPE_OPERATION, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        label = PreferencesMessages.getString("CompilerConfigurationBlock.pb_final_param_bound.label");
        this.addComboBox(composite, label, PREF_15_PB_FINAL_PARAM_BOUND, errorWarningIgnore, errorWarningIgnoreLabels, 0);
        return composite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void validateSettings(String changedKey, String newValue) {
        if (changedKey != null) {
            if (INTR_DEFAULT_COMPLIANCE.equals(changedKey)) {
                this.updateComplianceEnableState();
                this.updateComplianceDefaultSettings(true);
                this.fComplianceStatus = this.validateCompliance();
            } else if (PREF_COMPLIANCE.equals(changedKey)) {
                if (this.checkValue(INTR_DEFAULT_COMPLIANCE, "default")) {
                    this.updateComplianceDefaultSettings(false);
                }
                this.fComplianceStatus = this.validateCompliance();
            } else if (PREF_SOURCE_COMPATIBILITY.equals(changedKey)) {
                this.updateAssertAsIdentifierEnableState();
                this.fComplianceStatus = this.validateCompliance();
            } else if (PREF_CODEGEN_TARGET_PLATFORM.equals(changedKey) || PREF_PB_ASSERT_AS_IDENTIFIER.equals(changedKey)) {
                this.fComplianceStatus = this.validateCompliance();
            } else if (PREF_PB_MAX_PER_UNIT.equals(changedKey)) {
                this.fMaxNumberProblemsStatus = this.validateMaxNumberProblems();
            } else if (PREF_RESOURCE_FILTER.equals(changedKey)) {
                this.fResourceFilterStatus = this.validateResourceFilters();
            } else if (PREF_PB_UNUSED_PARAMETER.equals(changedKey) || PREF_PB_DEPRECATION.equals(changedKey) || PREF_PB_INVALID_JAVADOC.equals(changedKey) || PREF_PB_MISSING_JAVADOC_TAGS.equals(changedKey) || PREF_PB_MISSING_JAVADOC_COMMENTS.equals(changedKey) || PREF_PB_LOCAL_VARIABLE_HIDING.equals(changedKey) || PREF_JAVADOC_SUPPORT.equals(changedKey) || PREF_PB_UNUSED_DECLARED_THROWN_EXCEPTION.equals(changedKey)) {
                this.updateEnableStates();
            } else {
                if (!PREF_PB_SIGNAL_PARAMETER_IN_OVERRIDING.equals(changedKey)) return;
                this.fWorkingValues.put(PREF_PB_SIGNAL_PARAMETER_IN_ABSTRACT, newValue);
            }
        } else {
            this.updateEnableStates();
            this.updateComplianceEnableState();
            this.updateAssertAsIdentifierEnableState();
            this.fComplianceStatus = this.validateCompliance();
            this.fMaxNumberProblemsStatus = this.validateMaxNumberProblems();
            this.fResourceFilterStatus = this.validateResourceFilters();
        }
        IStatus status = StatusUtil.getMostSevere(new IStatus[]{this.fComplianceStatus, this.fMaxNumberProblemsStatus, this.fResourceFilterStatus});
        this.fContext.statusChanged(status);
    }

    private void updateEnableStates() {
        boolean enableUnusedParams = !this.checkValue(PREF_PB_UNUSED_PARAMETER, IGNORE);
        this.getCheckBox(PREF_PB_SIGNAL_PARAMETER_IN_OVERRIDING).setEnabled(enableUnusedParams);
        boolean enableDeprecation = !this.checkValue(PREF_PB_DEPRECATION, IGNORE);
        this.getCheckBox(PREF_PB_DEPRECATION_IN_DEPRECATED_CODE).setEnabled(enableDeprecation);
        this.getCheckBox(PREF_PB_DEPRECATION_WHEN_OVERRIDING).setEnabled(enableDeprecation);
        boolean enableThrownExceptions = !this.checkValue(PREF_PB_UNUSED_DECLARED_THROWN_EXCEPTION, IGNORE);
        this.getCheckBox(PREF_PB_UNUSED_DECLARED_THROWN_EXCEPTION_WHEN_OVERRIDING).setEnabled(enableThrownExceptions);
        boolean enableHiding = !this.checkValue(PREF_PB_LOCAL_VARIABLE_HIDING, IGNORE);
        this.getCheckBox(PREF_PB_SPECIAL_PARAMETER_HIDING_FIELD).setEnabled(enableHiding);
        boolean enableJavadoc = this.checkValue(PREF_JAVADOC_SUPPORT, ENABLED);
        this.fJavadocComposite.setVisible(enableJavadoc);
        boolean enableInvalidTagsErrors = !this.checkValue(PREF_PB_INVALID_JAVADOC, IGNORE);
        this.getCheckBox(PREF_PB_INVALID_JAVADOC_TAGS).setEnabled(enableInvalidTagsErrors);
        this.setComboEnabled(PREF_PB_INVALID_JAVADOC_TAGS_VISIBILITY, enableInvalidTagsErrors);
        boolean enableMissingTagsErrors = !this.checkValue(PREF_PB_MISSING_JAVADOC_TAGS, IGNORE);
        this.getCheckBox(PREF_PB_MISSING_JAVADOC_TAGS_OVERRIDING).setEnabled(enableMissingTagsErrors);
        this.setComboEnabled(PREF_PB_MISSING_JAVADOC_TAGS_VISIBILITY, enableMissingTagsErrors);
        boolean enableMissingCommentsErrors = !this.checkValue(PREF_PB_MISSING_JAVADOC_COMMENTS, IGNORE);
        this.getCheckBox(PREF_PB_MISSING_JAVADOC_COMMENTS_OVERRIDING).setEnabled(enableMissingCommentsErrors);
        this.setComboEnabled(PREF_PB_MISSING_JAVADOC_COMMENTS_VISIBILITY, enableMissingCommentsErrors);
    }

    private IStatus validateCompliance() {
        StatusInfo status = new StatusInfo();
        String compliance = (String)this.fWorkingValues.get(PREF_COMPLIANCE);
        String source = (String)this.fWorkingValues.get(PREF_SOURCE_COMPATIBILITY);
        String target = (String)this.fWorkingValues.get(PREF_CODEGEN_TARGET_PLATFORM);
        if (VERSION_1_3.equals(compliance)) {
            if (VERSION_1_4.equals(source) || VERSION_1_5.equals(source)) {
                status.setError(PreferencesMessages.getString("CompilerConfigurationBlock.cpl13src145.error"));
                return status;
            }
            if (VERSION_1_4.equals(target) || VERSION_1_5.equals(target)) {
                status.setError(PreferencesMessages.getString("CompilerConfigurationBlock.cpl13trg145.error"));
                return status;
            }
        } else if (VERSION_1_4.equals(compliance)) {
            if (VERSION_1_5.equals(source)) {
                status.setError(PreferencesMessages.getString("CompilerConfigurationBlock.cpl14src15.error"));
                return status;
            }
            if (VERSION_1_5.equals(target)) {
                status.setError(PreferencesMessages.getString("CompilerConfigurationBlock.cpl14trg15.error"));
                return status;
            }
        }
        if (VERSION_1_4.equals(source) && !VERSION_1_4.equals(target)) {
            status.setError(PreferencesMessages.getString("CompilerConfigurationBlock.src14tgt14.error"));
            return status;
        }
        return status;
    }

    private IStatus validateMaxNumberProblems() {
        String number = (String)this.fWorkingValues.get(PREF_PB_MAX_PER_UNIT);
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError(PreferencesMessages.getString("CompilerConfigurationBlock.empty_input"));
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value <= 0) {
                    status.setError(PreferencesMessages.getFormattedString("CompilerConfigurationBlock.invalid_input", number));
                }
            }
            catch (NumberFormatException e) {
                status.setError(PreferencesMessages.getFormattedString("CompilerConfigurationBlock.invalid_input", number));
            }
        }
        return status;
    }

    private IStatus validateResourceFilters() {
        String text = (String)this.fWorkingValues.get(PREF_RESOURCE_FILTER);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String[] filters = this.getTokens(text, ",");
        for (int i = 0; i < filters.length; ++i) {
            IStatus status;
            String fileName = filters[i].replace('*', 'x');
            int resourceType = 1;
            int lastCharacter = fileName.length() - 1;
            if (lastCharacter >= 0 && fileName.charAt(lastCharacter) == '/') {
                fileName = fileName.substring(0, lastCharacter);
                resourceType = 2;
            }
            if (!(status = workspace.validateName(fileName, resourceType)).matches(4)) continue;
            String message = PreferencesMessages.getFormattedString("CompilerConfigurationBlock.filter.invalidsegment.error", status.getMessage());
            return new StatusInfo(4, message);
        }
        return new StatusInfo();
    }

    private void updateComplianceEnableState() {
        boolean enabled = this.checkValue(INTR_DEFAULT_COMPLIANCE, USER_CONF);
        for (int i = this.fComplianceControls.size() - 1; i >= 0; --i) {
            Control curr = (Control)this.fComplianceControls.get(i);
            curr.setEnabled(enabled);
        }
    }

    private void updateAssertAsIdentifierEnableState() {
        if (this.checkValue(INTR_DEFAULT_COMPLIANCE, USER_CONF)) {
            boolean enabled = this.checkValue(PREF_SOURCE_COMPATIBILITY, VERSION_1_3);
            Combo combo = this.getComboBox(PREF_PB_ASSERT_AS_IDENTIFIER);
            combo.setEnabled(enabled);
            if (!enabled) {
                String val = (String)this.fWorkingValues.get(PREF_PB_ASSERT_AS_IDENTIFIER);
                if (!ERROR.equals(val)) {
                    this.fWorkingValues.put(PREF_PB_ASSERT_AS_IDENTIFIER, ERROR);
                    this.updateCombo(combo);
                    this.fRememberedUserCompliance[0] = val;
                }
            } else {
                String val = this.fRememberedUserCompliance[0];
                if (!ERROR.equals(val)) {
                    this.fWorkingValues.put(PREF_PB_ASSERT_AS_IDENTIFIER, val);
                    this.updateCombo(combo);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateComplianceDefaultSettings(boolean rememberOld) {
        void var4_6;
        void var3_5;
        void var2_4;
        String target;
        String source;
        String assertAsId;
        String complianceLevel = (String)this.fWorkingValues.get(PREF_COMPLIANCE);
        boolean isDefault = this.checkValue(INTR_DEFAULT_COMPLIANCE, "default");
        if (isDefault) {
            if (rememberOld) {
                this.fRememberedUserCompliance[0] = (String)this.fWorkingValues.get(PREF_PB_ASSERT_AS_IDENTIFIER);
                this.fRememberedUserCompliance[1] = (String)this.fWorkingValues.get(PREF_SOURCE_COMPATIBILITY);
                this.fRememberedUserCompliance[2] = (String)this.fWorkingValues.get(PREF_CODEGEN_TARGET_PLATFORM);
                this.fRememberedUserCompliance[3] = complianceLevel;
            }
            if (VERSION_1_4.equals(complianceLevel)) {
                assertAsId = WARNING;
                source = VERSION_1_3;
                target = VERSION_1_2;
            } else if (VERSION_1_5.equals(complianceLevel)) {
                assertAsId = ERROR;
                source = VERSION_1_5;
                target = VERSION_1_5;
            } else {
                assertAsId = IGNORE;
                source = VERSION_1_3;
                target = VERSION_1_1;
            }
        } else if (rememberOld && complianceLevel.equals(this.fRememberedUserCompliance[3])) {
            assertAsId = this.fRememberedUserCompliance[0];
            source = this.fRememberedUserCompliance[1];
            target = this.fRememberedUserCompliance[2];
        } else {
            return;
        }
        this.fWorkingValues.put(PREF_PB_ASSERT_AS_IDENTIFIER, var2_4);
        this.fWorkingValues.put(PREF_SOURCE_COMPATIBILITY, var3_5);
        this.fWorkingValues.put(PREF_CODEGEN_TARGET_PLATFORM, var4_6);
        this.updateControls();
    }

    private static String getCurrentCompliance(Map map) {
        Object complianceLevel = map.get(PREF_COMPLIANCE);
        if (VERSION_1_3.equals(complianceLevel) && IGNORE.equals(map.get(PREF_PB_ASSERT_AS_IDENTIFIER)) && VERSION_1_3.equals(map.get(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_1.equals(map.get(PREF_CODEGEN_TARGET_PLATFORM)) || VERSION_1_4.equals(complianceLevel) && WARNING.equals(map.get(PREF_PB_ASSERT_AS_IDENTIFIER)) && VERSION_1_3.equals(map.get(PREF_SOURCE_COMPATIBILITY)) && VERSION_1_2.equals(map.get(PREF_CODEGEN_TARGET_PLATFORM))) {
            return "default";
        }
        return USER_CONF;
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        String title = PreferencesMessages.getString("CompilerConfigurationBlock.needsbuild.title");
        String message = workspaceSettings ? PreferencesMessages.getString("CompilerConfigurationBlock.needsfullbuild.message") : PreferencesMessages.getString("CompilerConfigurationBlock.needsprojectbuild.message");
        return new String[]{title, message};
    }
}

