/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.javaeditor.SemanticHighlightingManager;
import org.eclipse.jdt.internal.ui.text.JavaPresentationReconciler;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;

public class SemanticHighlightingPresenter
implements ITextPresentationListener,
ITextInputListener,
IDocumentListener {
    private IPositionUpdater fPositionUpdater = new HighlightingPositionUpdater(this.getPositionCategory());
    private JavaSourceViewer fSourceViewer;
    private JavaPresentationReconciler fPresentationReconciler;
    private List fPositions = new ArrayList();
    private Object fPositionLock = new Object();
    private boolean fIsCanceled = false;

    public SemanticHighlightingManager.HighlightedPosition createHighlightedPosition(int offset, int length, SemanticHighlightingManager.Highlighting highlighting) {
        return new SemanticHighlightingManager.HighlightedPosition(offset, length, highlighting, this.fPositionUpdater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllPositions(List list) {
        Object object = this.fPositionLock;
        synchronized (object) {
            list.addAll(this.fPositions);
        }
    }

    public TextPresentation createPresentation(List addedPositions, List removedPositions) {
        int offset;
        Position position;
        int i;
        JavaSourceViewer sourceViewer = this.fSourceViewer;
        JavaPresentationReconciler presentationReconciler = this.fPresentationReconciler;
        if (sourceViewer == null || presentationReconciler == null) {
            return null;
        }
        if (this.isCanceled()) {
            return null;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return null;
        }
        int minStart = Integer.MAX_VALUE;
        int maxEnd = Integer.MIN_VALUE;
        int n = removedPositions.size();
        for (i = 0; i < n; ++i) {
            position = (Position)removedPositions.get(i);
            offset = position.getOffset();
            minStart = Math.min(minStart, offset);
            maxEnd = Math.max(maxEnd, offset + position.getLength());
        }
        n = addedPositions.size();
        for (i = 0; i < n; ++i) {
            position = (Position)addedPositions.get(i);
            offset = position.getOffset();
            minStart = Math.min(minStart, offset);
            maxEnd = Math.max(maxEnd, offset + position.getLength());
        }
        if (minStart < maxEnd) {
            try {
                return presentationReconciler.createRepairDescription((IRegion)new Region(minStart, maxEnd - minStart), document);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        return null;
    }

    public Runnable createUpdateRunnable(final TextPresentation textPresentation, List addedPositions, List removedPositions) {
        if (this.fSourceViewer == null || textPresentation == null) {
            return null;
        }
        final SemanticHighlightingManager.HighlightedPosition[] added = new SemanticHighlightingManager.HighlightedPosition[addedPositions.size()];
        addedPositions.toArray(added);
        final SemanticHighlightingManager.HighlightedPosition[] removed = new SemanticHighlightingManager.HighlightedPosition[removedPositions.size()];
        removedPositions.toArray(removed);
        if (this.isCanceled()) {
            return null;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                SemanticHighlightingPresenter.this.updatePresentation(textPresentation, added, removed);
            }
        };
        return runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePresentation(TextPresentation textPresentation, SemanticHighlightingManager.HighlightedPosition[] addedPositions, SemanticHighlightingManager.HighlightedPosition[] removedPositions) {
        if (this.fSourceViewer == null) {
            return;
        }
        if (this.isCanceled()) {
            return;
        }
        IDocument document = this.fSourceViewer.getDocument();
        if (document == null) {
            return;
        }
        String positionCategory = this.getPositionCategory();
        List<SemanticHighlightingManager.HighlightedPosition> removedPositionsList = Arrays.asList(removedPositions);
        try {
            Object object = this.fPositionLock;
            synchronized (object) {
                List oldPositions = this.fPositions;
                int newSize = this.fPositions.size() + addedPositions.length - removedPositions.length;
                ArrayList<Position> newPositions = new ArrayList<Position>(newSize);
                Position position = null;
                SemanticHighlightingManager.HighlightedPosition addedPosition = null;
                int i = 0;
                int j = 0;
                int n = oldPositions.size();
                int m = addedPositions.length;
                while (i < n || j < m) {
                    while (position == null && i < n) {
                        if (!(position = (Position)oldPositions.get(i++)).isDeleted() && !this.contain(removedPositionsList, position)) continue;
                        document.removePosition(positionCategory, position);
                        position = null;
                    }
                    if (addedPosition == null && j < m) {
                        addedPosition = addedPositions[j++];
                        document.addPosition(positionCategory, (Position)addedPosition);
                    }
                    if (position != null) {
                        if (addedPosition != null) {
                            if (position.getOffset() <= addedPosition.getOffset()) {
                                newPositions.add(position);
                                position = null;
                                continue;
                            }
                            newPositions.add(addedPosition);
                            addedPosition = null;
                            continue;
                        }
                        newPositions.add(position);
                        position = null;
                        continue;
                    }
                    if (addedPosition == null) continue;
                    newPositions.add(addedPosition);
                    addedPosition = null;
                }
                this.fPositions = newPositions;
            }
        }
        catch (BadPositionCategoryException e) {
            JavaPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
        if (textPresentation != null) {
            this.fSourceViewer.changeTextPresentation(textPresentation, false);
        } else {
            this.fSourceViewer.invalidateTextPresentation();
        }
    }

    private boolean contain(List positions, Position position) {
        return this.indexOf(positions, position) != -1;
    }

    private int indexOf(List positions, Position position) {
        int index = this.computeIndexAtOffset(positions, position.getOffset());
        return index < positions.size() && positions.get(index) == position ? index : -1;
    }

    private void insertPosition(Position position) {
        int i = this.computeIndexAfterOffset(this.fPositions, position.getOffset());
        this.fPositions.add(i, position);
    }

    private int computeIndexAfterOffset(List positions, int offset) {
        int i = -1;
        int j = positions.size();
        while (j - i > 1) {
            int k = i + j >> 1;
            Position position = (Position)positions.get(k);
            if (position.getOffset() > offset) {
                j = k;
                continue;
            }
            i = k;
        }
        return j;
    }

    private int computeIndexAtOffset(List positions, int offset) {
        int i = -1;
        int j = positions.size();
        while (j - i > 1) {
            int k = i + j >> 1;
            Position position = (Position)positions.get(k);
            if (position.getOffset() >= offset) {
                j = k;
                continue;
            }
            i = k;
        }
        return j;
    }

    public void applyTextPresentation(TextPresentation textPresentation) {
        int i;
        IRegion region = textPresentation.getExtent();
        int n = this.computeIndexAtOffset(this.fPositions, region.getOffset() + region.getLength());
        if (n - i > 2) {
            ArrayList<StyleRange> ranges = new ArrayList<StyleRange>(n - i);
            for (i = this.computeIndexAtOffset(this.fPositions, region.getOffset()); i < n; ++i) {
                SemanticHighlightingManager.HighlightedPosition position = (SemanticHighlightingManager.HighlightedPosition)((Object)this.fPositions.get(i));
                if (position.isDeleted()) continue;
                ranges.add(position.createStyleRange());
            }
            StyleRange[] array = new StyleRange[ranges.size()];
            array = ranges.toArray(array);
            textPresentation.replaceStyleRanges(array);
        } else {
            while (i < n) {
                SemanticHighlightingManager.HighlightedPosition position = (SemanticHighlightingManager.HighlightedPosition)((Object)this.fPositions.get(i));
                if (!position.isDeleted()) {
                    textPresentation.replaceStyleRange(position.createStyleRange());
                }
                ++i;
            }
        }
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        this.setCanceled(true);
        this.releaseDocument(oldInput);
        this.resetState();
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        this.manageDocument(newInput);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.setCanceled(true);
    }

    public void documentChanged(DocumentEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        IDocument document;
        IDocument iDocument = document = this.fSourceViewer != null ? this.fSourceViewer.getDocument() : null;
        if (document == null) {
            return this.fIsCanceled;
        }
        Object object = this.getLockObject(document);
        synchronized (object) {
            return this.fIsCanceled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanceled(boolean isCanceled) {
        IDocument document;
        IDocument iDocument = document = this.fSourceViewer != null ? this.fSourceViewer.getDocument() : null;
        if (document == null) {
            this.fIsCanceled = isCanceled;
            return;
        }
        Object object = this.getLockObject(document);
        synchronized (object) {
            this.fIsCanceled = isCanceled;
        }
    }

    private Object getLockObject(IDocument document) {
        if (document instanceof ISynchronizable) {
            return ((ISynchronizable)document).getLockObject();
        }
        return document;
    }

    public void install(JavaSourceViewer sourceViewer, JavaPresentationReconciler backgroundPresentationReconciler) {
        this.fSourceViewer = sourceViewer;
        this.fPresentationReconciler = backgroundPresentationReconciler;
        this.fSourceViewer.prependTextPresentationListener(this);
        this.fSourceViewer.addTextInputListener(this);
        this.manageDocument(this.fSourceViewer.getDocument());
    }

    public void uninstall() {
        this.setCanceled(true);
        if (this.fSourceViewer != null) {
            this.fSourceViewer.removeTextPresentationListener(this);
            this.releaseDocument(this.fSourceViewer.getDocument());
            this.invalidateTextPresentation();
            this.resetState();
            this.fSourceViewer.removeTextInputListener(this);
            this.fSourceViewer = null;
        }
    }

    public void highlightingStyleChanged(SemanticHighlightingManager.Highlighting highlighting) {
        int n = this.fPositions.size();
        for (int i = 0; i < n; ++i) {
            SemanticHighlightingManager.HighlightedPosition position = (SemanticHighlightingManager.HighlightedPosition)((Object)this.fPositions.get(i));
            if (position.getHighlighting() != highlighting) continue;
            this.fSourceViewer.invalidateTextPresentation(position.getOffset(), position.getLength());
        }
    }

    private void invalidateTextPresentation() {
        int n = this.fPositions.size();
        for (int i = 0; i < n; ++i) {
            Position position = (Position)this.fPositions.get(i);
            this.fSourceViewer.invalidateTextPresentation(position.getOffset(), position.getLength());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPositionFromUI(int offset, int length, SemanticHighlightingManager.Highlighting highlighting) {
        SemanticHighlightingManager.HighlightedPosition position = this.createHighlightedPosition(offset, length, highlighting);
        Object object = this.fPositionLock;
        synchronized (object) {
            this.insertPosition(position);
        }
        IDocument document = this.fSourceViewer.getDocument();
        if (document == null) {
            return;
        }
        String positionCategory = this.getPositionCategory();
        try {
            document.addPosition(positionCategory, (Position)position);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
        catch (BadPositionCategoryException e) {
            JavaPlugin.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetState() {
        Object object = this.fPositionLock;
        synchronized (object) {
            this.fPositions.clear();
        }
    }

    private void manageDocument(IDocument document) {
        if (document != null) {
            document.addPositionCategory(this.getPositionCategory());
            document.addPositionUpdater(this.fPositionUpdater);
            document.addDocumentListener((IDocumentListener)this);
        }
    }

    private void releaseDocument(IDocument document) {
        if (document != null) {
            document.removeDocumentListener((IDocumentListener)this);
            document.removePositionUpdater(this.fPositionUpdater);
            try {
                document.removePositionCategory(this.getPositionCategory());
            }
            catch (BadPositionCategoryException e) {
                JavaPlugin.log(e);
            }
        }
    }

    private String getPositionCategory() {
        return this.toString();
    }

    private class HighlightingPositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public HighlightingPositionUpdater(String category) {
            this.fCategory = category;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventEnd = eventOffset + eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.fCategory);
                for (int i = 0; i != positions.length; ++i) {
                    SemanticHighlightingManager.HighlightedPosition position = (SemanticHighlightingManager.HighlightedPosition)positions[i];
                    int offset = position.getOffset();
                    int length = position.getLength();
                    int end = offset + length;
                    if (offset > eventEnd) {
                        this.updateWithPrecedingEvent(position, event);
                        continue;
                    }
                    if (end < eventOffset) {
                        this.updateWithSucceedingEvent(position, event);
                        continue;
                    }
                    if (offset <= eventOffset && end >= eventEnd) {
                        this.updateWithIncludedEvent(position, event);
                        continue;
                    }
                    if (offset <= eventOffset) {
                        this.updateWithOverEndEvent(position, event);
                        continue;
                    }
                    if (end >= eventEnd) {
                        this.updateWithOverStartEvent(position, event);
                        continue;
                    }
                    this.updateWithIncludingEvent(position, event);
                }
            }
            catch (BadPositionCategoryException e) {
                // empty catch block
            }
        }

        private void updateWithPrecedingEvent(SemanticHighlightingManager.HighlightedPosition position, DocumentEvent event) {
            String newText = event.getText();
            int eventNewLength = newText != null ? newText.length() : 0;
            int deltaLength = eventNewLength - event.getLength();
            position.setOffset(position.getOffset() + deltaLength);
        }

        private void updateWithSucceedingEvent(SemanticHighlightingManager.HighlightedPosition position, DocumentEvent event) {
        }

        private void updateWithIncludedEvent(SemanticHighlightingManager.HighlightedPosition position, DocumentEvent event) {
            int includedLength;
            int eventOffset = event.getOffset();
            String newText = event.getText();
            if (newText == null) {
                newText = "";
            }
            int eventNewLength = newText.length();
            int deltaLength = eventNewLength - event.getLength();
            int offset = position.getOffset();
            int length = position.getLength();
            int end = offset + length;
            for (includedLength = 0; includedLength < eventNewLength && Character.isJavaIdentifierPart(newText.charAt(includedLength)); ++includedLength) {
            }
            if (includedLength == eventNewLength) {
                position.setLength(length + deltaLength);
            } else {
                int excludedLength;
                int newLeftLength = eventOffset - offset + includedLength;
                for (excludedLength = eventNewLength; excludedLength > 0 && Character.isJavaIdentifierPart(newText.charAt(excludedLength - 1)); --excludedLength) {
                }
                int newRightOffset = eventOffset + excludedLength;
                int newRightLength = end + deltaLength - newRightOffset;
                if (newRightLength == 0) {
                    position.setLength(newLeftLength);
                } else if (newLeftLength == 0) {
                    position.update(newRightOffset, newRightLength);
                } else {
                    position.setLength(newLeftLength);
                    SemanticHighlightingPresenter.this.addPositionFromUI(newRightOffset, newRightLength, position.getHighlighting());
                }
            }
        }

        private void updateWithOverEndEvent(SemanticHighlightingManager.HighlightedPosition position, DocumentEvent event) {
            int includedLength;
            String newText = event.getText();
            if (newText == null) {
                newText = "";
            }
            int eventNewLength = newText.length();
            for (includedLength = 0; includedLength < eventNewLength && Character.isJavaIdentifierPart(newText.charAt(includedLength)); ++includedLength) {
            }
            position.setLength(event.getOffset() - position.getOffset() + includedLength);
        }

        private void updateWithOverStartEvent(SemanticHighlightingManager.HighlightedPosition position, DocumentEvent event) {
            int eventNewLength;
            int excludedLength;
            int eventOffset = event.getOffset();
            int eventEnd = eventOffset + event.getLength();
            String newText = event.getText();
            if (newText == null) {
                newText = "";
            }
            for (excludedLength = eventNewLength = newText.length(); excludedLength > 0 && Character.isJavaIdentifierPart(newText.charAt(excludedLength - 1)); --excludedLength) {
            }
            int deleted = eventEnd - position.getOffset();
            int inserted = eventNewLength - excludedLength;
            position.update(eventOffset + excludedLength, position.getLength() - deleted + inserted);
        }

        private void updateWithIncludingEvent(SemanticHighlightingManager.HighlightedPosition position, DocumentEvent event) {
            position.delete();
            position.update(event.getOffset(), 0);
        }
    }
}

