/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportReferencesCollector;

public class ImportRemover {
    private Set fAddedImports;
    private List fRemovedNodes;
    private final CompilationUnit fRoot;

    public ImportRemover(CompilationUnit root) {
        this.fRoot = root;
        this.fAddedImports = new HashSet();
        this.fRemovedNodes = new ArrayList();
    }

    public void registerAddedImport(String typeName) {
        int dot = typeName.indexOf(46);
        if (dot == -1) {
            this.fAddedImports.add(typeName);
        } else {
            this.fAddedImports.add(typeName.substring(dot + 1));
        }
    }

    public void registerRemovedNode(ASTNode removed) {
        this.fRemovedNodes.add(removed);
    }

    public boolean hasRemovedNodes() {
        return this.fRemovedNodes.size() != 0;
    }

    public ITypeBinding[] getImportsToRemove() {
        ArrayList simpleNames = new ArrayList();
        this.fRoot.accept((ASTVisitor)new ImportReferencesCollector(null, simpleNames));
        ArrayList removedTypeRefs = new ArrayList();
        ArrayList notRemovedTypeRefs = new ArrayList();
        this.divideTypeRefs(simpleNames, removedTypeRefs, notRemovedTypeRefs);
        if (removedTypeRefs.size() == 0) {
            return new ITypeBinding[0];
        }
        HashMap potentialRemoves = this.getPotentialRemoves(removedTypeRefs);
        Iterator iter = notRemovedTypeRefs.iterator();
        while (iter.hasNext()) {
            SimpleName name = (SimpleName)iter.next();
            potentialRemoves.remove(name.getIdentifier());
        }
        Collection importsToRemove = potentialRemoves.values();
        return importsToRemove.toArray(new ITypeBinding[importsToRemove.size()]);
    }

    private HashMap getPotentialRemoves(List removedTypeRefs) {
        HashMap<String, IBinding> potentialRemoves = new HashMap<String, IBinding>();
        Iterator iter = removedTypeRefs.iterator();
        while (iter.hasNext()) {
            IBinding binding;
            SimpleName name = (SimpleName)iter.next();
            if (this.fAddedImports.contains(name.getIdentifier()) || (binding = name.resolveBinding()) == null || !(binding instanceof ITypeBinding)) continue;
            potentialRemoves.put(name.getIdentifier(), binding);
        }
        return potentialRemoves;
    }

    private void divideTypeRefs(List simpleNames, List removedTypeRefs, List notRemovedTypeRefs) {
        int[] removedStartsEnds = new int[2 * this.fRemovedNodes.size()];
        for (int i = 0; i < this.fRemovedNodes.size(); ++i) {
            int start;
            ASTNode node = (ASTNode)this.fRemovedNodes.get(i);
            removedStartsEnds[2 * i] = start = node.getStartPosition();
            removedStartsEnds[2 * i + 1] = start + node.getLength();
        }
        Iterator iter = simpleNames.iterator();
        while (iter.hasNext()) {
            SimpleName ref = (SimpleName)iter.next();
            if (this.isInRemoved(ref, removedStartsEnds)) {
                removedTypeRefs.add(ref);
                continue;
            }
            notRemovedTypeRefs.add(ref);
        }
    }

    private boolean isInRemoved(SimpleName ref, int[] removedStartsEnds) {
        int start = ref.getStartPosition();
        int end = start + ref.getLength();
        for (int i = 0; i < removedStartsEnds.length; i += 2) {
            if (start < removedStartsEnds[i] || end > removedStartsEnds[i + 1]) continue;
            return true;
        }
        return false;
    }
}

