/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;

public class ParentChecker {
    private IResource[] fResources;
    private IJavaElement[] fJavaElements;

    public ParentChecker(IResource[] resources, IJavaElement[] javaElements) {
        Assert.isNotNull(resources);
        Assert.isNotNull(javaElements);
        this.fResources = resources;
        this.fJavaElements = javaElements;
    }

    public boolean haveCommonParent() {
        return this.getCommonParent() != null;
    }

    public Object getCommonParent() {
        if (this.fJavaElements.length == 0 && this.fResources.length == 0) {
            return null;
        }
        if (!this.resourcesHaveCommonParent() || !this.javaElementsHaveCommonParent()) {
            return null;
        }
        if (this.fJavaElements.length == 0) {
            IResource commonResourceParent = this.getCommonResourceParent();
            Assert.isNotNull(commonResourceParent);
            IJavaElement convertedToJava = JavaCore.create((IResource)commonResourceParent);
            if (convertedToJava != null && convertedToJava.exists()) {
                return convertedToJava;
            }
            return commonResourceParent;
        }
        if (this.fResources.length == 0) {
            return this.getCommonJavaElementParent();
        }
        IResource commonResourceParent = this.getCommonResourceParent();
        IJavaElement commonJavaElementParent = this.getCommonJavaElementParent();
        Assert.isNotNull(commonJavaElementParent);
        Assert.isNotNull(commonResourceParent);
        IJavaElement convertedToJava = JavaCore.create((IResource)commonResourceParent);
        if (convertedToJava == null || !convertedToJava.exists() || !commonJavaElementParent.equals(ReorgUtils.toWorkingCopy(convertedToJava))) {
            return null;
        }
        return commonJavaElementParent;
    }

    private IJavaElement getCommonJavaElementParent() {
        Assert.isNotNull(this.fJavaElements);
        Assert.isTrue(this.fJavaElements.length > 0);
        return this.fJavaElements[0].getParent();
    }

    private IResource getCommonResourceParent() {
        Assert.isNotNull(this.fResources);
        Assert.isTrue(this.fResources.length > 0);
        return this.fResources[0].getParent();
    }

    private boolean javaElementsHaveCommonParent() {
        if (this.fJavaElements.length == 0) {
            return true;
        }
        IJavaElement[] javaElements = ReorgUtils.toWorkingCopies(this.fJavaElements);
        IJavaElement firstParent = javaElements[0].getParent();
        Assert.isNotNull(firstParent);
        for (int i = 1; i < javaElements.length; ++i) {
            if (firstParent.equals(javaElements[i].getParent())) continue;
            return false;
        }
        return true;
    }

    private boolean resourcesHaveCommonParent() {
        if (this.fResources.length == 0) {
            return true;
        }
        IContainer firstParent = this.fResources[0].getParent();
        Assert.isNotNull(firstParent);
        for (int i = 1; i < this.fResources.length; ++i) {
            if (firstParent.equals(this.fResources[i].getParent())) continue;
            return false;
        }
        return true;
    }

    public IResource[] getResources() {
        return this.fResources;
    }

    public IJavaElement[] getJavaElements() {
        return this.fJavaElements;
    }

    public void removeElementsWithAncestorsOnList(boolean removeOnlyJavaElements) {
        if (!removeOnlyJavaElements) {
            this.removeResourcesDescendantsOfResources();
            this.removeResourcesDescendantsOfJavaElements();
        }
        this.removeJavaElementsDescendantsOfJavaElements();
    }

    private void removeResourcesDescendantsOfJavaElements() {
        ArrayList<IResource> subResources = new ArrayList<IResource>(3);
        for (int i = 0; i < this.fResources.length; ++i) {
            IResource subResource = this.fResources[i];
            for (int j = 0; j < this.fJavaElements.length; ++j) {
                IJavaElement superElements = this.fJavaElements[j];
                if (!ParentChecker.isDescendantOf(subResource, superElements)) continue;
                subResources.add(subResource);
            }
        }
        this.removeFromSetToDelete(subResources.toArray(new IResource[subResources.size()]));
    }

    private void removeJavaElementsDescendantsOfJavaElements() {
        ArrayList<IJavaElement> subElements = new ArrayList<IJavaElement>(3);
        for (int i = 0; i < this.fJavaElements.length; ++i) {
            IJavaElement subElement = this.fJavaElements[i];
            for (int j = 0; j < this.fJavaElements.length; ++j) {
                IJavaElement superElement = this.fJavaElements[j];
                if (!ParentChecker.isDescendantOf(subElement, superElement)) continue;
                subElements.add(subElement);
            }
        }
        this.removeFromSetToDelete(subElements.toArray(new IJavaElement[subElements.size()]));
    }

    private void removeResourcesDescendantsOfResources() {
        ArrayList<IResource> subResources = new ArrayList<IResource>(3);
        for (int i = 0; i < this.fResources.length; ++i) {
            IResource subResource = this.fResources[i];
            for (int j = 0; j < this.fResources.length; ++j) {
                IResource superResource = this.fResources[j];
                if (!ParentChecker.isDescendantOf(subResource, superResource)) continue;
                subResources.add(subResource);
            }
        }
        this.removeFromSetToDelete(subResources.toArray(new IResource[subResources.size()]));
    }

    public static boolean isDescendantOf(IResource subResource, IJavaElement superElement) {
        for (IContainer parent = subResource.getParent(); parent != null; parent = parent.getParent()) {
            IJavaElement el = JavaCore.create((IResource)parent);
            if (el == null || !el.exists() || !el.equals(superElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDescendantOf(IJavaElement subElement, IJavaElement superElement) {
        if (subElement.equals(superElement)) {
            return false;
        }
        for (IJavaElement parent = subElement.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.equals(superElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDescendantOf(IResource subResource, IResource superResource) {
        return !subResource.equals(superResource) && superResource.getFullPath().isPrefixOf(subResource.getFullPath());
    }

    private void removeFromSetToDelete(IResource[] resourcesToNotDelete) {
        this.fResources = ReorgUtils.setMinus(this.fResources, resourcesToNotDelete);
    }

    private void removeFromSetToDelete(IJavaElement[] elementsToNotDelete) {
        this.fJavaElements = ReorgUtils.setMinus(this.fJavaElements, elementsToNotDelete);
    }
}

