/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.CreateTextFileChange;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class CreateCopyOfCompilationUnitChange
extends CreateTextFileChange {
    private ICompilationUnit fOldCu;
    private INewNameQuery fNameQuery;

    public CreateCopyOfCompilationUnitChange(IPath path, String source, ICompilationUnit oldCu, INewNameQuery nameQuery) {
        super(path, source, null, "java");
        this.fOldCu = oldCu;
        this.fNameQuery = nameQuery;
        this.setEncoding(oldCu);
    }

    private void setEncoding(ICompilationUnit cunit) {
        IResource resource = cunit.getResource();
        if (!(resource instanceof IFile)) {
            return;
        }
        IFile file = (IFile)resource;
        try {
            String encoding = file.getCharset(false);
            if (encoding != null) {
                this.setEncoding(encoding, true);
            } else {
                encoding = file.getCharset(true);
                if (encoding != null) {
                    this.setEncoding(encoding, false);
                }
            }
        }
        catch (CoreException e) {
            // empty catch block
        }
    }

    protected IFile getOldFile(IProgressMonitor pm) {
        pm.beginTask("", 10);
        String oldSource = super.getSource();
        IPath oldPath = super.getPath();
        String newTypeName = this.fNameQuery.getNewName();
        try {
            String newSource = CreateCopyOfCompilationUnitChange.getCopiedFileSource((IProgressMonitor)new SubProgressMonitor(pm, 9), this.fOldCu, newTypeName);
            this.setSource(newSource);
            this.setPath(this.constructNewPath(newTypeName));
            return super.getOldFile((IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        catch (CoreException e) {
            this.setSource(oldSource);
            this.setPath(oldPath);
            return super.getOldFile(pm);
        }
    }

    private IPath constructNewPath(String newTypeName) throws JavaModelException {
        return ResourceUtil.getResource(this.fOldCu).getParent().getFullPath().append(newTypeName + ".java");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCopiedFileSource(IProgressMonitor pm, ICompilationUnit cu, String newTypeName) throws CoreException {
        ICompilationUnit wc = WorkingCopyUtil.getNewWorkingCopy(cu);
        try {
            String result;
            TextChangeManager manager = CreateCopyOfCompilationUnitChange.createChangeManager(pm, wc, newTypeName);
            String string = result = manager.get(wc).getPreviewContent((IProgressMonitor)new NullProgressMonitor());
            return string;
        }
        finally {
            wc.destroy();
        }
    }

    private static TextChangeManager createChangeManager(IProgressMonitor pm, ICompilationUnit wc, String newName) throws CoreException {
        TextChangeManager manager = new TextChangeManager();
        SearchResultGroup refs = CreateCopyOfCompilationUnitChange.getReferences(wc, pm);
        if (refs == null) {
            return manager;
        }
        if (refs.getCompilationUnit() == null) {
            return manager;
        }
        String name = RefactoringCoreMessages.getString("CopyRefactoring.update_ref");
        SearchMatch[] results = refs.getSearchResults();
        for (int j = 0; j < results.length; ++j) {
            SearchMatch searchResult = results[j];
            if (searchResult.getAccuracy() == 1) continue;
            String oldName = wc.findPrimaryType().getElementName();
            int length = oldName.length();
            int offset = searchResult.getOffset() + searchResult.getLength() - length;
            TextChangeCompatibility.addTextEdit(manager.get(wc), name, (TextEdit)new ReplaceEdit(offset, length, newName));
        }
        return manager;
    }

    private static SearchResultGroup getReferences(ICompilationUnit wc, IProgressMonitor pm) throws JavaModelException {
        pm.subTask(RefactoringCoreMessages.getString("CopyRefactoring.searching"));
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{wc});
        if (wc.findPrimaryType() == null) {
            return null;
        }
        SearchPattern pattern = CreateCopyOfCompilationUnitChange.createSearchPattern(wc.findPrimaryType());
        SearchResultGroup[] groups = RefactoringSearchEngine.search(pattern, scope, pm, new ICompilationUnit[]{wc}, new RefactoringStatus());
        Assert.isTrue(groups.length <= 1);
        if (groups.length == 0) {
            return null;
        }
        return groups[0];
    }

    private static SearchPattern createSearchPattern(IType type) throws JavaModelException {
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)type, (int)3);
        IMethod[] constructors = JavaElementUtil.getAllConstructors(type);
        if (constructors.length == 0) {
            return pattern;
        }
        SearchPattern constructorDeclarationPattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])constructors, 0);
        return SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)constructorDeclarationPattern);
    }
}

