/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.search.FieldDeclarationMatch;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.text.edits.TextEdit;

class RenameAnalyzeUtil {
    private RenameAnalyzeUtil() {
    }

    static RefactoringStatus analyzeRenameChanges(TextChangeManager manager, SearchResultGroup[] oldOccurrences, SearchResultGroup[] newOccurrences) {
        RefactoringStatus result = new RefactoringStatus();
        for (int i = 0; i < oldOccurrences.length; ++i) {
            SearchResultGroup oldGroup = oldOccurrences[i];
            SearchMatch[] oldSearchResults = oldGroup.getSearchResults();
            ICompilationUnit cunit = oldGroup.getCompilationUnit();
            if (cunit == null) continue;
            for (int j = 0; j < oldSearchResults.length; ++j) {
                SearchMatch oldSearchResult = oldSearchResults[j];
                if (RenameAnalyzeUtil.existsInNewOccurrences(oldSearchResult, newOccurrences, manager)) continue;
                RenameAnalyzeUtil.addShadowsError(cunit, oldSearchResult, result);
            }
        }
        return result;
    }

    static ICompilationUnit findWorkingCopyForCu(ICompilationUnit[] newWorkingCopies, ICompilationUnit cu) {
        ICompilationUnit originalDeclaringCu = WorkingCopyUtil.getOriginal(cu);
        for (int i = 0; i < newWorkingCopies.length; ++i) {
            if (!newWorkingCopies[i].getPrimary().equals(originalDeclaringCu)) continue;
            return newWorkingCopies[i];
        }
        return null;
    }

    static ICompilationUnit[] getNewWorkingCopies(ICompilationUnit[] compilationUnitsToModify, TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        pm.beginTask("", compilationUnitsToModify.length);
        ICompilationUnit[] newWorkingCopies = new ICompilationUnit[compilationUnitsToModify.length];
        for (int i = 0; i < compilationUnitsToModify.length; ++i) {
            ICompilationUnit cu = compilationUnitsToModify[i];
            newWorkingCopies[i] = WorkingCopyUtil.getNewWorkingCopy(cu);
            String previewContent = manager.get(cu).getPreviewContent((IProgressMonitor)new NullProgressMonitor());
            newWorkingCopies[i].getBuffer().setContents(previewContent);
            newWorkingCopies[i].reconcile(0, false, null, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        return newWorkingCopies;
    }

    static ICompilationUnit[] createNewWorkingCopies(ICompilationUnit[] compilationUnitsToModify, TextChangeManager manager, WorkingCopyOwner owner, SubProgressMonitor pm) throws CoreException {
        pm.beginTask("", compilationUnitsToModify.length);
        ICompilationUnit[] newWorkingCopies = new ICompilationUnit[compilationUnitsToModify.length];
        for (int i = 0; i < compilationUnitsToModify.length; ++i) {
            ICompilationUnit cu = compilationUnitsToModify[i];
            newWorkingCopies[i] = RenameAnalyzeUtil.createNewWorkingCopy(cu, manager, owner, new SubProgressMonitor((IProgressMonitor)pm, 1));
        }
        pm.done();
        return newWorkingCopies;
    }

    static ICompilationUnit createNewWorkingCopy(ICompilationUnit cu, TextChangeManager manager, WorkingCopyOwner owner, SubProgressMonitor pm) throws CoreException {
        ICompilationUnit newWc = cu.getWorkingCopy(owner, null, null);
        String previewContent = manager.get(cu).getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        newWc.getBuffer().setContents(previewContent);
        newWc.reconcile(0, false, owner, (IProgressMonitor)pm);
        return newWc;
    }

    private static boolean existsInNewOccurrences(SearchMatch searchResult, SearchResultGroup[] newOccurrences, TextChangeManager manager) {
        SearchResultGroup newGroup = RenameAnalyzeUtil.findOccurrenceGroup(searchResult.getResource(), newOccurrences);
        if (newGroup == null) {
            return false;
        }
        IRegion oldEditRange = RenameAnalyzeUtil.getCorrespondingEditChangeRange(searchResult, manager);
        if (oldEditRange == null) {
            return false;
        }
        SearchMatch[] newSearchResults = newGroup.getSearchResults();
        int oldRangeOffset = oldEditRange.getOffset();
        for (int i = 0; i < newSearchResults.length; ++i) {
            if (newSearchResults[i].getOffset() != oldRangeOffset) continue;
            return true;
        }
        return false;
    }

    private static IRegion getCorrespondingEditChangeRange(SearchMatch searchResult, TextChangeManager manager) {
        TextChange change = RenameAnalyzeUtil.getTextChange(searchResult, manager);
        if (change == null) {
            return null;
        }
        IRegion oldMatchRange = RenameAnalyzeUtil.createTextRange(searchResult);
        TextEditChangeGroup[] editChanges = change.getTextEditChangeGroups();
        for (int i = 0; i < editChanges.length; ++i) {
            if (!oldMatchRange.equals(editChanges[i].getRegion())) continue;
            return TextEdit.getCoverage((TextEdit[])change.getPreviewEdits(editChanges[i].getTextEdits()));
        }
        return null;
    }

    private static TextChange getTextChange(SearchMatch searchResult, TextChangeManager manager) {
        ICompilationUnit cu = SearchUtils.getCompilationUnit(searchResult);
        if (cu == null) {
            return null;
        }
        return manager.get(cu);
    }

    private static IRegion createTextRange(SearchMatch searchResult) {
        return new Region(searchResult.getOffset(), searchResult.getLength());
    }

    private static SearchResultGroup findOccurrenceGroup(IResource resource, SearchResultGroup[] newOccurrences) {
        for (int i = 0; i < newOccurrences.length; ++i) {
            if (!newOccurrences[i].getResource().equals(resource)) continue;
            return newOccurrences[i];
        }
        return null;
    }

    static RefactoringStatus analyzeRenameChanges2(TextChangeManager manager, SearchResultGroup[] oldReferences, SearchResultGroup[] newReferences, String newElementName) {
        RefactoringStatus result = new RefactoringStatus();
        HashMap<ICompilationUnit, SearchMatch[]> cuToNewResults = new HashMap<ICompilationUnit, SearchMatch[]>(newReferences.length);
        for (int i1 = 0; i1 < newReferences.length; ++i1) {
            ICompilationUnit cu = newReferences[i1].getCompilationUnit();
            if (cu == null) continue;
            cuToNewResults.put(cu.getPrimary(), newReferences[i1].getSearchResults());
        }
        for (int i = 0; i < oldReferences.length; ++i) {
            SearchResultGroup oldGroup = oldReferences[i];
            SearchMatch[] oldMatches = oldGroup.getSearchResults();
            ICompilationUnit cu = oldGroup.getCompilationUnit();
            if (cu == null) continue;
            SearchMatch[] newSearchMatches = (SearchMatch[])cuToNewResults.remove(cu);
            if (newSearchMatches == null) {
                for (int j = 0; j < oldMatches.length; ++j) {
                    SearchMatch oldMatch = oldMatches[j];
                    RenameAnalyzeUtil.addShadowsError(cu, oldMatch, result);
                }
                continue;
            }
            RenameAnalyzeUtil.analyzeChanges(cu, manager.get(cu), oldMatches, newSearchMatches, newElementName, result);
        }
        Iterator iter = cuToNewResults.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            ICompilationUnit cu = (ICompilationUnit)entry.getKey();
            SearchMatch[] newSearchMatches = (SearchMatch[])entry.getValue();
            for (int i = 0; i < newSearchMatches.length; ++i) {
                SearchMatch newMatch = newSearchMatches[i];
                RenameAnalyzeUtil.addReferenceShadowedError(cu, newMatch, newElementName, result);
            }
        }
        return result;
    }

    private static void analyzeChanges(ICompilationUnit cu, TextChange change, SearchMatch[] oldMatches, SearchMatch[] newMatches, String newElementName, RefactoringStatus result) {
        Map updatedOldOffsets = RenameAnalyzeUtil.getUpdatedChangeOffsets(change, oldMatches);
        for (int i = 0; i < newMatches.length; ++i) {
            SearchMatch newMatch = newMatches[i];
            Integer offsetInNew = new Integer(newMatch.getOffset());
            SearchMatch oldMatch = (SearchMatch)updatedOldOffsets.remove(offsetInNew);
            if (oldMatch != null) continue;
            RenameAnalyzeUtil.addReferenceShadowedError(cu, newMatch, newElementName, result);
        }
        Iterator iter = updatedOldOffsets.values().iterator();
        while (iter.hasNext()) {
            SearchMatch oldMatch = (SearchMatch)iter.next();
            RenameAnalyzeUtil.addShadowsError(cu, oldMatch, result);
        }
    }

    private static Map getUpdatedChangeOffsets(TextChange change, SearchMatch[] oldMatches) {
        HashMap<Integer, SearchMatch> updatedOffsets = new HashMap<Integer, SearchMatch>();
        Map oldToUpdatedOffsets = RenameAnalyzeUtil.getEditChangeOffsetUpdates(change);
        for (int i = 0; i < oldMatches.length; ++i) {
            SearchMatch oldMatch = oldMatches[i];
            Integer updatedOffset = (Integer)oldToUpdatedOffsets.get(new Integer(oldMatch.getOffset()));
            if (updatedOffset == null) {
                updatedOffset = new Integer(-1);
            }
            updatedOffsets.put(updatedOffset, oldMatch);
        }
        return updatedOffsets;
    }

    private static Map getEditChangeOffsetUpdates(TextChange change) {
        TextEditChangeGroup[] editChanges = change.getTextEditChangeGroups();
        HashMap<Integer, Integer> offsetUpdates = new HashMap<Integer, Integer>(editChanges.length);
        for (int i = 0; i < editChanges.length; ++i) {
            IRegion updatedRegion;
            TextEditChangeGroup editChange = editChanges[i];
            IRegion oldRegion = editChange.getRegion();
            if (oldRegion == null || (updatedRegion = TextEdit.getCoverage((TextEdit[])change.getPreviewEdits(editChange.getTextEdits()))) == null) continue;
            offsetUpdates.put(new Integer(oldRegion.getOffset()), new Integer(updatedRegion.getOffset()));
        }
        return offsetUpdates;
    }

    private static void addReferenceShadowedError(ICompilationUnit cu, SearchMatch newMatch, String newElementName, RefactoringStatus result) {
        if (newMatch instanceof MethodDeclarationMatch || newMatch instanceof FieldDeclarationMatch) {
            return;
        }
        ISourceRange range = RenameAnalyzeUtil.getOldSourceRange(newMatch);
        RefactoringStatusContext context = JavaStatusContext.create(cu, range);
        String message = RefactoringCoreMessages.getFormattedString("RenameAnalyzeUtil.reference_shadowed", new String[]{cu.getElementName(), newElementName});
        result.addError(message, context);
    }

    private static ISourceRange getOldSourceRange(SearchMatch newMatch) {
        IJavaElement newMatchElement = (IJavaElement)newMatch.getElement();
        IJavaElement primaryElement = newMatchElement.getPrimaryElement();
        ISourceRange range = null;
        if (primaryElement.exists() && primaryElement instanceof ISourceReference) {
            try {
                range = ((ISourceReference)primaryElement).getSourceRange();
            }
            catch (JavaModelException e) {
                // empty catch block
            }
        }
        return range;
    }

    private static void addShadowsError(ICompilationUnit cu, SearchMatch oldMatch, RefactoringStatus result) {
        if (oldMatch instanceof MethodDeclarationMatch || oldMatch instanceof FieldDeclarationMatch) {
            return;
        }
        SourceRange range = new SourceRange(oldMatch.getOffset(), oldMatch.getLength());
        RefactoringStatusContext context = JavaStatusContext.create(cu, range);
        String message = RefactoringCoreMessages.getFormattedString("RenameAnalyzeUtil.shadows", cu.getElementName());
        result.addError(message, context);
    }
}

