/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.io.PrintWriter;
import java.util.Vector;
import org.eclipse.pde.core.IWritable;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.schema.RepeatableSchemaObject;
import org.eclipse.pde.internal.core.schema.SchemaElementReference;

public class SchemaCompositor
extends RepeatableSchemaObject
implements ISchemaCompositor {
    public static final String P_KIND = "p_kind";
    private int kind;
    private Vector children = new Vector();

    public SchemaCompositor(ISchemaObject parent, int kind) {
        super(parent, "");
        this.kind = kind;
        switch (kind) {
            case 0: {
                this.name = PDECore.getResourceString("SchemaCompositor.all");
                break;
            }
            case 1: {
                this.name = PDECore.getResourceString("SchemaCompositor.choice");
                break;
            }
            case 3: {
                this.name = PDECore.getResourceString("SchemaCompositor.group");
                break;
            }
            case 2: {
                this.name = PDECore.getResourceString("SchemaCompositor.sequence");
            }
        }
    }

    public SchemaCompositor(ISchemaObject parent, String id, int kind) {
        super(parent, id);
        this.kind = kind;
    }

    public void addChild(ISchemaObject child) {
        this.children.addElement(child);
        child.setParent(this);
        this.getSchema().fireModelChanged(new ModelChangedEvent(this.getSchema(), 1, new Object[]{child}, null));
    }

    public int getChildCount() {
        return this.children.size();
    }

    public ISchemaObject[] getChildren() {
        Object[] result = new ISchemaObject[this.children.size()];
        this.children.copyInto(result);
        return result;
    }

    public void setParent(ISchemaObject parent) {
        super.setParent(parent);
        for (int i = 0; i < this.children.size(); ++i) {
            ISchemaObject child = (ISchemaObject)this.children.get(i);
            child.setParent(this);
        }
    }

    public int getKind() {
        return this.kind;
    }

    public void removeChild(ISchemaObject child) {
        this.children.removeElement(child);
        this.getSchema().fireModelChanged(new ModelChangedEvent(this.getSchema(), 2, new Object[]{child}, null));
    }

    public void setKind(int kind) {
        if (this.kind != kind) {
            Integer oldValue = new Integer(this.kind);
            this.kind = kind;
            switch (kind) {
                case 0: {
                    this.name = PDECore.getResourceString("SchemaCompositor.all");
                    break;
                }
                case 1: {
                    this.name = PDECore.getResourceString("SchemaCompositor.choice");
                    break;
                }
                case 3: {
                    this.name = PDECore.getResourceString("SchemaCompositor.group");
                    break;
                }
                case 2: {
                    this.name = PDECore.getResourceString("SchemaCompositor.sequence");
                }
            }
            this.getSchema().fireModelObjectChanged(this, P_KIND, oldValue, new Integer(kind));
        }
    }

    public void updateReferencesFor(ISchemaElement element, int kind) {
        for (int i = 0; i < this.children.size(); ++i) {
            Object child = this.children.elementAt(i);
            if (child instanceof SchemaElementReference) {
                SchemaElementReference ref = (SchemaElementReference)child;
                String refName = ref.getReferenceName();
                switch (kind) {
                    case 1: {
                        if (!element.getName().equals(refName)) break;
                        ref.setReferencedObject(element);
                        this.getSchema().fireModelObjectChanged(ref, null, null, null);
                        break;
                    }
                    case 2: {
                        if (!element.getName().equals(refName)) break;
                        ref.setReferencedObject(null);
                        this.getSchema().fireModelObjectChanged(ref, null, null, null);
                        break;
                    }
                    case 3: {
                        if (ref.getReferencedElement() == element) {
                            ref.setReferenceName(element.getName());
                            break;
                        }
                        if (!element.getName().equals(refName)) break;
                        ref.setReferencedObject(element);
                        this.getSchema().fireModelObjectChanged(ref, null, null, null);
                    }
                }
                continue;
            }
            SchemaCompositor compositor = (SchemaCompositor)child;
            compositor.updateReferencesFor(element, kind);
        }
    }

    public void write(String indent, PrintWriter writer) {
        this.writeComments(writer);
        String tag = null;
        switch (this.kind) {
            case 0: {
                tag = "all";
                break;
            }
            case 1: {
                tag = "choice";
                break;
            }
            case 3: {
                tag = "group";
                break;
            }
            case 2: {
                tag = "sequence";
            }
        }
        if (tag == null) {
            return;
        }
        writer.print(indent + "<" + tag);
        if (this.getMinOccurs() != 1 && this.getMaxOccurs() != 1) {
            String min = "" + this.getMinOccurs();
            String max = this.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : "" + this.getMaxOccurs();
            writer.print(" minOccurs=\"" + min + "\" maxOccurs=\"" + max + "\"");
        }
        writer.println(">");
        String indent2 = indent + "   ";
        for (int i = 0; i < this.children.size(); ++i) {
            Object obj = this.children.elementAt(i);
            if (!(obj instanceof IWritable)) continue;
            ((IWritable)obj).write(indent2, writer);
        }
        writer.println(indent + "</" + tag + ">");
    }
}

