/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.schema.DevelopmentSchemaDescriptor;

public class ExternalSchemaDescriptor
extends DevelopmentSchemaDescriptor {
    private IPluginExtensionPoint info;
    private File file;
    private String fullId;
    private boolean enabled;

    public ExternalSchemaDescriptor(IPluginExtensionPoint info) {
        this.info = info;
        this.fullId = info.getFullId();
    }

    public ExternalSchemaDescriptor(File file, String fullId, boolean enabled) {
        this.file = file;
        this.fullId = fullId;
        this.enabled = enabled;
    }

    public String getPointId() {
        return this.fullId;
    }

    private File getInstallLocationFile() {
        IPluginModelBase model = this.info.getPluginModel();
        String installLocation = model.getInstallLocation() + File.separator;
        return new File(installLocation + this.info.getSchema());
    }

    private File getSourceLocationFile() {
        SourceLocationManager sourceManager = PDECore.getDefault().getSourceLocationManager();
        return sourceManager.findSourceFile(this.info.getPluginBase(), (IPath)new Path(this.info.getSchema()));
    }

    public URL getSchemaURL() {
        try {
            if (this.file != null) {
                return new URL("file:" + this.file.getPath());
            }
            File installFile = this.getInstallLocationFile();
            if (installFile != null && installFile.exists()) {
                return new URL("file:" + installFile.getPath());
            }
            File sourceLocationFile = this.getSourceLocationFile();
            if (sourceLocationFile != null && sourceLocationFile.exists()) {
                return new URL("file:" + sourceLocationFile.getPath());
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    public boolean isEnabled() {
        return this.info != null ? this.info.getPluginModel().isEnabled() : this.enabled;
    }
}

