/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.feature;

import java.io.PrintWriter;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IMatchRules;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.feature.VersionableObject;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.w3c.dom.Node;

public class FeatureImport
extends VersionableObject
implements IFeatureImport {
    private int match = 0;
    private int idMatch = 3;
    private IPlugin plugin;
    private IFeature feature;
    private int type = 0;
    private boolean patch = false;
    private String os;
    private String ws;
    private String arch;

    public IPlugin getPlugin() {
        return this.plugin;
    }

    public IFeature getFeature() {
        return this.feature;
    }

    public int getIdMatch() {
        return this.idMatch;
    }

    public void setPlugin(IPlugin plugin) {
        this.plugin = plugin;
    }

    public void setFeature(IFeature feature) {
        this.feature = feature;
    }

    public String getOS() {
        return this.os;
    }

    public String getWS() {
        return this.ws;
    }

    public String getArch() {
        return this.arch;
    }

    protected void reset() {
        super.reset();
        this.patch = false;
        this.type = 0;
        this.match = 0;
        this.idMatch = 3;
        this.arch = null;
        this.os = null;
        this.ws = null;
    }

    protected void parse(Node node, Hashtable lineTable) {
        super.parse(node, lineTable);
        this.bindSourceLocation(node, lineTable);
        this.id = this.getNodeAttribute(node, "plugin");
        if (this.id != null) {
            this.type = 0;
        } else {
            this.id = this.getNodeAttribute(node, "feature");
            if (this.id != null) {
                this.type = 1;
            }
        }
        this.os = this.getNodeAttribute(node, "os");
        this.ws = this.getNodeAttribute(node, "ws");
        this.arch = this.getNodeAttribute(node, "arch");
        String mvalue = this.getNodeAttribute(node, "match");
        if (mvalue != null && mvalue.length() > 0) {
            String[] choices = IMatchRules.RULE_NAME_TABLE;
            for (int i = 0; i < choices.length; ++i) {
                if (!mvalue.equalsIgnoreCase(choices[i])) continue;
                this.match = i;
                break;
            }
        }
        if ((mvalue = this.getNodeAttribute(node, "id-match")) != null && mvalue.length() > 0 && mvalue.equalsIgnoreCase("prefix")) {
            this.idMatch = 5;
        }
        this.patch = this.getBooleanAttribute(node, "patch");
        if (this.id != null) {
            if (this.type == 0) {
                this.setPlugin(PDECore.getDefault().findPlugin(this.id, this.getVersion(), this.match));
            } else {
                this.setFeature(PDECore.getDefault().findFeature(this.id, this.getVersion(), this.match));
            }
        }
    }

    public void loadFrom(IFeature feature) {
        this.reset();
        this.feature = feature;
        this.type = 1;
        this.id = feature.getId();
        this.version = feature.getVersion();
    }

    public int getMatch() {
        return this.match;
    }

    public void setMatch(int match) throws CoreException {
        this.ensureModelEditable();
        Integer oldValue = new Integer(this.match);
        this.match = match;
        this.firePropertyChanged("match", oldValue, new Integer(match));
    }

    public void setIdMatch(int idMatch) throws CoreException {
        this.ensureModelEditable();
        Integer oldValue = new Integer(this.idMatch);
        this.idMatch = idMatch;
        this.firePropertyChanged("id-match", oldValue, new Integer(idMatch));
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) throws CoreException {
        this.ensureModelEditable();
        Integer oldValue = new Integer(this.type);
        this.type = type;
        this.firePropertyChanged("type", oldValue, new Integer(type));
    }

    public boolean isPatch() {
        return this.patch;
    }

    public void setPatch(boolean patch) throws CoreException {
        this.ensureModelEditable();
        Boolean oldValue = new Boolean(this.patch);
        this.patch = patch;
        this.firePropertyChanged("patch", oldValue, new Boolean(patch));
    }

    public void setOS(String os) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.os;
        this.os = os;
        this.firePropertyChanged("os", oldValue, os);
    }

    public void setWS(String ws) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.ws;
        this.ws = ws;
        this.firePropertyChanged("ws", oldValue, ws);
    }

    public void setArch(String arch) throws CoreException {
        this.ensureModelEditable();
        String oldValue = this.arch;
        this.arch = arch;
        this.firePropertyChanged("arch", oldValue, arch);
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("match")) {
            this.setMatch(newValue != null ? (Integer)newValue : 0);
        } else if (name.equals("id-match")) {
            this.setIdMatch(newValue != null ? (Integer)newValue : 0);
        } else if (name.equals("type")) {
            this.setType(newValue != null ? (Integer)newValue : 0);
        } else if (name.equals("patch")) {
            this.setPatch(newValue != null ? (Boolean)newValue : false);
        } else if (name.equals("os")) {
            this.setOS((String)newValue);
        } else if (name.equals("ws")) {
            this.setWS((String)newValue);
        } else if (name.equals("arch")) {
            this.setArch((String)newValue);
        } else {
            super.restoreProperty(name, oldValue, newValue);
        }
    }

    public void write(String indent, PrintWriter writer) {
        String typeAtt = this.type == 1 ? "feature" : "plugin";
        writer.print(indent + "<import " + typeAtt + "=\"" + this.getId() + "\"");
        if (this.getVersion() != null) {
            writer.print(" version=\"" + this.getVersion() + "\"");
        }
        if (!this.patch && this.match != 0) {
            writer.print(" match=\"" + IMatchRules.RULE_NAME_TABLE[this.match] + "\"");
        }
        if (this.idMatch == 5) {
            writer.print(" id-match=\"prefix\"");
        }
        if (this.os != null) {
            writer.print(" os=\"" + this.getOS() + "\"");
        }
        if (this.ws != null) {
            writer.print(" ws=\"" + this.getWS() + "\"");
        }
        if (this.arch != null) {
            writer.print(" arch=\"" + this.getArch() + "\"");
        }
        if (this.patch) {
            writer.print(" patch=\"true\"");
        }
        writer.println("/>");
    }

    public String toString() {
        if (this.plugin != null) {
            return this.plugin.getTranslatedName();
        }
        if (this.feature != null) {
            return this.feature.getLabel();
        }
        return this.getId();
    }
}

