/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.team.core.RepositoryProvider;

public class BinaryRepositoryProvider
extends RepositoryProvider {
    private IMoveDeleteHook moveDeleteHook = new BinaryMoveDeleteHook();
    private IFileModificationValidator fileModificationValidator = new BinaryFileModificationValidator();

    public void configureProject() throws CoreException {
        IProject project = this.getProject();
        project.setPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY, "external");
    }

    public void deconfigure() throws CoreException {
        IProject project = this.getProject();
        project.setPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY, null);
    }

    public IFileModificationValidator getFileModificationValidator() {
        return this.fileModificationValidator;
    }

    public String getID() {
        return "org.eclipse.pde.core.BinaryRepositoryProvider";
    }

    public IMoveDeleteHook getMoveDeleteHook() {
        return this.moveDeleteHook;
    }

    private boolean isBinaryResource(IResource resource, boolean excludeProjectChildren) {
        IContainer parent = resource.getParent();
        if (!(excludeProjectChildren && parent instanceof IProject || !resource.isLinked())) {
            return true;
        }
        while (parent instanceof IFolder) {
            IFolder folder = (IFolder)parent;
            if (folder.isLinked()) {
                return true;
            }
            parent = folder.getParent();
        }
        return false;
    }

    private IStatus createProblemStatus() {
        String message = PDECore.getResourceString("BinaryRepositoryProvider.veto");
        return new Status(4, "org.eclipse.pde.core", 0, message, null);
    }

    private IStatus createOKStatus() {
        return new Status(0, "org.eclipse.pde.core", 0, "", null);
    }

    public boolean canHandleLinkedResources() {
        return true;
    }

    class BinaryFileModificationValidator
    implements IFileModificationValidator {
        BinaryFileModificationValidator() {
        }

        public IStatus validateEdit(IFile[] files, Object context) {
            for (int i = 0; i < files.length; ++i) {
                if (!BinaryRepositoryProvider.this.isBinaryResource((IResource)files[i], false)) continue;
                return BinaryRepositoryProvider.this.createProblemStatus();
            }
            return BinaryRepositoryProvider.this.createOKStatus();
        }

        public IStatus validateSave(IFile file) {
            if (BinaryRepositoryProvider.this.isBinaryResource((IResource)file, false)) {
                return BinaryRepositoryProvider.this.createProblemStatus();
            }
            return BinaryRepositoryProvider.this.createOKStatus();
        }
    }

    class BinaryMoveDeleteHook
    implements IMoveDeleteHook {
        BinaryMoveDeleteHook() {
        }

        public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
            if (BinaryRepositoryProvider.this.isBinaryResource((IResource)file, true)) {
                tree.failed(BinaryRepositoryProvider.this.createProblemStatus());
            } else {
                tree.standardDeleteFile(file, updateFlags, monitor);
            }
            return true;
        }

        public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
            if (BinaryRepositoryProvider.this.isBinaryResource((IResource)folder, true)) {
                tree.failed(BinaryRepositoryProvider.this.createProblemStatus());
            } else {
                tree.standardDeleteFolder(folder, updateFlags, monitor);
            }
            return true;
        }

        public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
            return false;
        }

        public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
            if (BinaryRepositoryProvider.this.isBinaryResource((IResource)source, false)) {
                tree.failed(BinaryRepositoryProvider.this.createProblemStatus());
            } else {
                tree.standardMoveFile(source, destination, updateFlags, monitor);
            }
            return true;
        }

        public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
            if (BinaryRepositoryProvider.this.isBinaryResource((IResource)source, false)) {
                tree.failed(BinaryRepositoryProvider.this.createProblemStatus());
            } else {
                tree.standardMoveFolder(source, destination, updateFlags, monitor);
            }
            return true;
        }

        public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
            return false;
        }
    }
}

