/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dependencies;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.internal.dependencies.Dependency;
import org.eclipse.core.internal.dependencies.Element;
import org.eclipse.core.internal.dependencies.ElementSet;
import org.eclipse.core.internal.dependencies.IElementSetVisitor;

public class SatisfactionVisitor
implements IElementSetVisitor {
    private int order;

    public SatisfactionVisitor(int order) {
        this.order = order;
    }

    public Collection getAncestors(ElementSet elementSet) {
        return elementSet.getRequired();
    }

    public Collection getDescendants(ElementSet elementSet) {
        return elementSet.getRequiring();
    }

    public int getOrder() {
        return this.order;
    }

    public void update(ElementSet elementSet) {
        if (elementSet.getRequired().isEmpty()) {
            elementSet.setSatisfied(elementSet.getAvailable());
            return;
        }
        HashSet<Element> satisfied = new HashSet<Element>();
        Iterator elementsIter = elementSet.getAvailable().iterator();
        while (elementsIter.hasNext()) {
            Element element = (Element)elementsIter.next();
            Dependency[] dependencies = element.getDependencies();
            boolean versionSatisfied = true;
            for (int i = 0; i < dependencies.length; ++i) {
                if (dependencies[i].isOptional()) continue;
                ElementSet requiredNode = elementSet.getSystem().getElementSet(dependencies[i].getRequiredObjectId());
                Set requiredNodeSatisfiedVersions = requiredNode.getSatisfied();
                boolean depSatisfied = false;
                Iterator requiredNodeSatisfiedVersionsIter = requiredNodeSatisfiedVersions.iterator();
                while (requiredNodeSatisfiedVersionsIter.hasNext()) {
                    Element requiredSatisfiedVersion = (Element)requiredNodeSatisfiedVersionsIter.next();
                    if (!dependencies[i].getMatchRule().isSatisfied(dependencies[i].getUserObject(), requiredSatisfiedVersion.getVersionId())) continue;
                    depSatisfied = true;
                    break;
                }
                if (depSatisfied) continue;
                versionSatisfied = false;
                break;
            }
            if (!versionSatisfied) continue;
            satisfied.add(element);
        }
        elementSet.setSatisfied(satisfied);
    }
}

