/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.ui.text.Match;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text.Highlighter;
import org.eclipse.search2.internal.ui.text.PositionTracker;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationTypeLookup;

public class AnnotationHighlighter
extends Highlighter {
    private IAnnotationModel fModel;
    private IDocument fDocument;
    private Map fMatchesToAnnotations;
    private AnnotationTypeLookup fAnnotationTypeLookup = EditorsUI.getAnnotationTypeLookup();

    public AnnotationHighlighter(IAnnotationModel model, IDocument document) {
        this.fModel = model;
        this.fDocument = document;
        this.fMatchesToAnnotations = new HashMap();
    }

    public void addHighlights(Match[] matches) {
        HashMap<Annotation, Position> map = new HashMap<Annotation, Position>(matches.length);
        for (int i = 0; i < matches.length; ++i) {
            int offset = matches[i].getOffset();
            int length = matches[i].getLength();
            if (offset < 0 || length < 0) continue;
            try {
                Position position = this.createPosition(matches[i]);
                if (position == null) continue;
                Annotation annotation = new Annotation(this.fAnnotationTypeLookup.getAnnotationType("org.eclipse.search.searchmarker", 0), true, null);
                this.fMatchesToAnnotations.put(matches[i], annotation);
                map.put(annotation, position);
                continue;
            }
            catch (BadLocationException e) {
                SearchPlugin.log((IStatus)new Status(4, SearchPlugin.getID(), 0, SearchMessages.getString("AnnotationHighlighter.error.badLocation"), (Throwable)e));
            }
        }
        this.addAnnotations(map);
    }

    private Position createPosition(Match match) throws BadLocationException {
        Position position = InternalSearchUI.getInstance().getPositionTracker().getCurrentPosition(match);
        position = position == null ? new Position(match.getOffset(), match.getLength()) : new Position(position.getOffset(), position.getLength());
        if (match.getBaseUnit() == 1) {
            if (this.fDocument != null) {
                position = PositionTracker.convertToCharacterPosition(position, this.fDocument);
            } else {
                SearchPlugin.log((IStatus)new Status(4, SearchPlugin.getID(), 0, SearchMessages.getString("AnnotationHighlighter.error.noDocument"), null));
                return null;
            }
        }
        return position;
    }

    public void removeHighlights(Match[] matches) {
        HashSet<Annotation> annotations = new HashSet<Annotation>(matches.length);
        for (int i = 0; i < matches.length; ++i) {
            Annotation annotation = (Annotation)this.fMatchesToAnnotations.remove(matches[i]);
            if (annotation == null) continue;
            annotations.add(annotation);
        }
        this.removeAnnotations(annotations);
    }

    private void addAnnotations(Map annotationToPositionMap) {
        if (this.fModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension ame = (IAnnotationModelExtension)this.fModel;
            ame.replaceAnnotations(new Annotation[0], annotationToPositionMap);
        } else {
            Iterator elements = annotationToPositionMap.keySet().iterator();
            while (elements.hasNext()) {
                Annotation element = (Annotation)elements.next();
                Position p = (Position)annotationToPositionMap.get(element);
                this.fModel.addAnnotation(element, p);
            }
        }
    }

    private void removeAnnotations(Set annotations) {
        if (this.fModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension ame = (IAnnotationModelExtension)this.fModel;
            Annotation[] annotationArray = new Annotation[annotations.size()];
            ame.replaceAnnotations(annotations.toArray(annotationArray), Collections.EMPTY_MAP);
        } else {
            Iterator iter = annotations.iterator();
            while (iter.hasNext()) {
                Annotation element = (Annotation)iter.next();
                this.fModel.removeAnnotation(element);
            }
        }
    }

    public void removeAll() {
        Set matchSet = this.fMatchesToAnnotations.keySet();
        Match[] matches = new Match[matchSet.size()];
        this.removeHighlights(matchSet.toArray(matches));
    }

    protected void handleContentReplaced(IFileBuffer buffer) {
        if (!(buffer instanceof ITextFileBuffer)) {
            return;
        }
        ITextFileBuffer textBuffer = (ITextFileBuffer)buffer;
        if (this.fDocument != null && this.fDocument.equals(textBuffer.getDocument())) {
            Match[] matches = new Match[this.fMatchesToAnnotations.keySet().size()];
            this.fMatchesToAnnotations.keySet().toArray(matches);
            this.removeAll();
            this.addHighlights(matches);
        }
    }
}

