/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.jobs;

import java.util.ArrayList;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class MultiRule
implements ISchedulingRule {
    private ISchedulingRule[] rules;

    public static ISchedulingRule combine(ISchedulingRule rule1, ISchedulingRule rule2) {
        if (rule1 == rule2) {
            return rule1;
        }
        if (rule1 == null) {
            return rule2;
        }
        if (rule2 == null) {
            return rule1;
        }
        if (rule1.contains(rule2)) {
            return rule1;
        }
        if (rule2.contains(rule1)) {
            return rule2;
        }
        MultiRule result = new MultiRule();
        result.rules = new ISchedulingRule[]{rule1, rule2};
        return result;
    }

    public MultiRule(ISchedulingRule[] nestedRules) {
        this.rules = this.flatten(nestedRules);
    }

    private MultiRule() {
    }

    private ISchedulingRule[] flatten(ISchedulingRule[] nestedRules) {
        ArrayList<ISchedulingRule> myRules = new ArrayList<ISchedulingRule>(nestedRules.length);
        for (int i = 0; i < nestedRules.length; ++i) {
            if (nestedRules[i] instanceof MultiRule) {
                ISchedulingRule[] children = ((MultiRule)nestedRules[i]).getChildren();
                for (int j = 0; j < children.length; ++j) {
                    myRules.add(children[j]);
                }
                continue;
            }
            myRules.add(nestedRules[i]);
        }
        return myRules.toArray(new ISchedulingRule[myRules.size()]);
    }

    public ISchedulingRule[] getChildren() {
        return (ISchedulingRule[])this.rules.clone();
    }

    public boolean contains(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (rule instanceof MultiRule) {
            ISchedulingRule[] otherRules = ((MultiRule)rule).getChildren();
            for (int other = 0; other < otherRules.length; ++other) {
                boolean found = false;
                for (int mine = 0; !found && mine < this.rules.length; ++mine) {
                    found = this.rules[mine].contains(otherRules[other]);
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.rules.length; ++i) {
            if (!this.rules[i].contains(rule)) continue;
            return true;
        }
        return false;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (rule instanceof MultiRule) {
            ISchedulingRule[] otherRules = ((MultiRule)rule).getChildren();
            for (int j = 0; j < otherRules.length; ++j) {
                for (int i = 0; i < this.rules.length; ++i) {
                    if (!this.rules[i].isConflicting(otherRules[j])) continue;
                    return true;
                }
            }
        } else {
            for (int i = 0; i < this.rules.length; ++i) {
                if (!this.rules[i].isConflicting(rule)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("MultiRule[");
        int last = this.rules.length - 1;
        for (int i = 0; i < this.rules.length; ++i) {
            buffer.append(this.rules[i]);
            if (i == last) continue;
            buffer.append(',');
        }
        buffer.append(']');
        return buffer.toString();
    }
}

