/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.ArrayList;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;

public class PlatformLogWriter
implements ILogListener {
    public synchronized void logging(IStatus status, String plugin) {
        FrameworkLogEntry logEntry = this.getLog(status);
        InternalPlatform.getDefault().getFrameworkLog().log(logEntry);
    }

    protected FrameworkLogEntry getLog(IStatus status) {
        IStatus[] children;
        IStatus coreStatus;
        int stackCode;
        StringBuffer entry = new StringBuffer();
        entry.append(status.getPlugin()).append(" ");
        entry.append(Integer.toString(status.getSeverity())).append(" ");
        entry.append(Integer.toString(status.getCode()));
        Throwable t = status.getException();
        ArrayList<FrameworkLogEntry> childlist = new ArrayList<FrameworkLogEntry>();
        int n = stackCode = t instanceof CoreException ? 1 : 0;
        if (stackCode == 1 && (coreStatus = ((CoreException)t).getStatus()) != null) {
            childlist.add(this.getLog(coreStatus));
        }
        if (status.isMultiStatus()) {
            children = status.getChildren();
            for (int i = 0; i < children.length; ++i) {
                childlist.add(this.getLog(children[i]));
            }
        }
        children = childlist.size() == 0 ? null : childlist.toArray(new FrameworkLogEntry[childlist.size()]);
        return new FrameworkLogEntry(entry.toString(), status.getMessage(), stackCode, t, (FrameworkLogEntry[])children);
    }
}

