/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.internal.preferences.RootPreferences;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.ListenerList;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.eclipse.core.runtime.preferences.IScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class EclipsePreferences
implements IEclipsePreferences,
IScope {
    public static final String DEFAULT_PREFERENCES_DIRNAME = ".settings";
    public static final String PREFS_FILE_EXTENSION = "prefs";
    protected static final IEclipsePreferences[] EMPTY_NODE_ARRAY = new IEclipsePreferences[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    protected static final String VERSION_KEY = "eclipse.preferences.version";
    protected static final String VERSION_VALUE = "1";
    protected static final String PATH_SEPARATOR = String.valueOf('/');
    protected static final String DOUBLE_SLASH = "//";
    protected static final String EMPTY_STRING = "";
    private String cachedPath;
    protected Map children;
    protected boolean dirty = false;
    protected boolean loading = false;
    protected final String name;
    protected ListenerList nodeListeners;
    protected final IEclipsePreferences parent;
    protected ListenerList preferenceListeners;
    protected Properties properties;
    protected boolean removed = false;

    public EclipsePreferences() {
        this(null, null);
    }

    protected EclipsePreferences(IEclipsePreferences parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public String absolutePath() {
        if (this.cachedPath == null) {
            String parentPath;
            this.cachedPath = this.parent == null ? PATH_SEPARATOR : ((parentPath = this.parent.absolutePath()).length() == 1 ? parentPath + this.name() : parentPath + PATH_SEPARATOR + this.name());
        }
        return this.cachedPath;
    }

    public void accept(IPreferenceNodeVisitor visitor) throws BackingStoreException {
        if (!visitor.visit(this)) {
            return;
        }
        IEclipsePreferences[] toVisit = this.getChildren();
        for (int i = 0; i < toVisit.length; ++i) {
            toVisit[i].accept(visitor);
        }
    }

    protected synchronized void addChild(String childName, IEclipsePreferences child) {
        if (this.children == null) {
            this.children = Collections.synchronizedMap(new HashMap());
        }
        this.children.put(childName, child == null ? childName : child);
    }

    public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        this.checkRemoved();
        if (this.nodeListeners == null) {
            this.nodeListeners = new ListenerList();
        }
        this.nodeListeners.add(listener);
        if (InternalPlatform.DEBUG_PREFERENCES) {
            Policy.debug("Added preference node change listener: " + listener + " to: " + this.absolutePath());
        }
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        this.checkRemoved();
        if (this.preferenceListeners == null) {
            this.preferenceListeners = new ListenerList();
        }
        this.preferenceListeners.add(listener);
        if (InternalPlatform.DEBUG_PREFERENCES) {
            Policy.debug("Added preference property change listener: " + listener + " to: " + this.absolutePath());
        }
    }

    private IEclipsePreferences calculateRoot() {
        IEclipsePreferences result = this;
        while (result.parent() != null) {
            result = (IEclipsePreferences)result.parent();
        }
        return result;
    }

    protected void checkRemoved() {
        if (this.removed) {
            String message = Policy.bind("preferences.removedNode", this.name);
            throw new IllegalStateException(message);
        }
    }

    public String[] childrenNames() {
        this.checkRemoved();
        return this.internalChildNames();
    }

    protected String[] internalChildNames() {
        Map temp = this.children;
        if (temp == null || temp.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return temp.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.checkRemoved();
        Properties temp = this.properties;
        if (temp == null) {
            return;
        }
        String[] keys = temp.keySet().toArray(EMPTY_STRING_ARRAY);
        for (int i = 0; i < keys.length; ++i) {
            this.remove(keys[i]);
        }
        EclipsePreferences eclipsePreferences = this;
        synchronized (eclipsePreferences) {
            this.properties = null;
        }
        this.makeDirty();
    }

    protected String[] computeChildren(IPath root) {
        if (root == null) {
            return EMPTY_STRING_ARRAY;
        }
        IPath dir = root.append(DEFAULT_PREFERENCES_DIRNAME);
        final ArrayList result = new ArrayList();
        String extension = ".prefs";
        File file = dir.toFile();
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File directory, String child) {
                if (new File(directory, child).isDirectory()) {
                    return false;
                }
                if (child.endsWith(".prefs")) {
                    String shortName = child.substring(0, child.length() - ".prefs".length());
                    result.add(shortName);
                }
                return false;
            }
        };
        file.list(filter);
        return result.toArray(EMPTY_STRING_ARRAY);
    }

    protected IPath computeLocation(IPath root, String qualifier) {
        return root == null ? null : root.append(DEFAULT_PREFERENCES_DIRNAME).append(qualifier).addFileExtension(PREFS_FILE_EXTENSION);
    }

    protected void convertFromProperties(Properties table) {
        String version = table.getProperty(VERSION_KEY);
        if (version == null || !VERSION_VALUE.equals(version)) {
            // empty if block
        }
        table.remove(VERSION_KEY);
        Iterator<Object> i = table.keySet().iterator();
        while (i.hasNext()) {
            String fullKey = (String)i.next();
            String value = table.getProperty(fullKey);
            if (value == null) continue;
            String[] splitPath = EclipsePreferences.decodePath(fullKey);
            String path = splitPath[0];
            path = EclipsePreferences.makeRelative(path);
            String key = splitPath[1];
            EclipsePreferences childNode = (EclipsePreferences)this.internalNode(path, false, null);
            if (InternalPlatform.DEBUG_PREFERENCES) {
                Policy.debug("Setting preference: " + childNode.absolutePath() + '/' + key + '=' + value);
            }
            childNode.internalPut(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties convertToProperties(Properties result, String prefix) throws BackingStoreException {
        boolean addSeparator;
        Properties temp = this.properties;
        boolean bl = addSeparator = prefix.length() != 0;
        if (temp != null) {
            Properties properties = temp;
            synchronized (properties) {
                String[] keys = temp.keySet().toArray(EMPTY_STRING_ARRAY);
                for (int i = 0; i < keys.length; ++i) {
                    String value = temp.getProperty(keys[i], null);
                    if (value == null) continue;
                    result.put(EclipsePreferences.encodePath(prefix, keys[i]), value);
                }
            }
        }
        IEclipsePreferences[] childNodes = this.getChildren();
        for (int i = 0; i < childNodes.length; ++i) {
            EclipsePreferences child = (EclipsePreferences)childNodes[i];
            String fullPath = addSeparator ? prefix + PATH_SEPARATOR + child.name() : child.name();
            child.convertToProperties(result, fullPath);
        }
        return result;
    }

    public IEclipsePreferences create(IEclipsePreferences nodeParent, String nodeName) {
        return this.create(nodeParent, nodeName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEclipsePreferences create(IEclipsePreferences nodeParent, String nodeName, Plugin context) {
        EclipsePreferences result = this.internalCreate(nodeParent, nodeName, context);
        ((EclipsePreferences)nodeParent).addChild(nodeName, result);
        IEclipsePreferences loadLevel = result.getLoadLevel();
        if (loadLevel == null) {
            return result;
        }
        if (result != loadLevel) {
            return result;
        }
        if (this.isAlreadyLoaded(result)) {
            return result;
        }
        if (this.loading) {
            return result;
        }
        try {
            this.loading = true;
            result.loadLegacy();
            result.load();
            result.loaded();
            result.flush();
        }
        catch (BackingStoreException e) {
            IPath location = result.getLocation();
            String message = Policy.bind("preferences.loadException", location == null ? EMPTY_STRING : ((Object)location).toString());
            Status status = new Status(4, "org.eclipse.core.runtime", 4, message, e);
            InternalPlatform.getDefault().log(status);
        }
        finally {
            this.loading = false;
        }
        return result;
    }

    public void flush() throws BackingStoreException {
        this.checkRemoved();
        IEclipsePreferences loadLevel = this.getLoadLevel();
        if (loadLevel == null) {
            String[] childrenNames = this.childrenNames();
            for (int i = 0; i < childrenNames.length; ++i) {
                this.node(childrenNames[i]).flush();
            }
            return;
        }
        if (this != loadLevel) {
            loadLevel.flush();
            return;
        }
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        try {
            this.save();
        }
        catch (BackingStoreException e) {
            this.dirty = true;
            throw e;
        }
    }

    public String get(String key, String defaultValue) {
        String value = this.internalGet(key);
        return value == null ? defaultValue : value;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.internalGet(key);
        return value == null ? defaultValue : TRUE.equalsIgnoreCase(value);
    }

    public byte[] getByteArray(String key, byte[] defaultValue) {
        String value = this.internalGet(key);
        return value == null ? defaultValue : Base64.decode(value.getBytes());
    }

    protected synchronized IEclipsePreferences getChild(String key, Plugin context) {
        if (this.children == null) {
            return null;
        }
        Object value = this.children.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof IEclipsePreferences) {
            return (IEclipsePreferences)value;
        }
        value = this.create(this, key, context);
        this.addChild(key, (IEclipsePreferences)value);
        return (IEclipsePreferences)value;
    }

    protected synchronized IEclipsePreferences[] getChildren() {
        ArrayList<IEclipsePreferences> result = new ArrayList<IEclipsePreferences>();
        String[] names = this.internalChildNames();
        for (int i = 0; i < names.length; ++i) {
            result.add(this.getChild(names[i], null));
        }
        return result.toArray(EMPTY_NODE_ARRAY);
    }

    public double getDouble(String key, double defaultValue) {
        String value = this.internalGet(key);
        double result = defaultValue;
        if (value != null) {
            try {
                result = Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    public float getFloat(String key, float defaultValue) {
        String value = this.internalGet(key);
        float result = defaultValue;
        if (value != null) {
            try {
                result = Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    public int getInt(String key, int defaultValue) {
        String value = this.internalGet(key);
        int result = defaultValue;
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    protected IEclipsePreferences getLoadLevel() {
        return null;
    }

    protected IPath getLocation() {
        return null;
    }

    public long getLong(String key, long defaultValue) {
        String value = this.internalGet(key);
        long result = defaultValue;
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    protected EclipsePreferences internalCreate(IEclipsePreferences nodeParent, String nodeName, Plugin context) {
        return new EclipsePreferences(nodeParent, nodeName);
    }

    protected String internalGet(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.checkRemoved();
        Properties temp = this.properties;
        if (temp == null) {
            if (InternalPlatform.DEBUG_PREFERENCES) {
                Policy.debug("Getting preference value: " + this.absolutePath() + '/' + key + "->null");
            }
            return null;
        }
        String result = temp.getProperty(key);
        if (InternalPlatform.DEBUG_PREFERENCES) {
            Policy.debug("Getting preference value: " + this.absolutePath() + '/' + key + "->" + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IEclipsePreferences internalNode(String path, boolean notify, Plugin context) {
        IEclipsePreferences child;
        this.checkRemoved();
        if (path.length() == 0) {
            return this;
        }
        if (path.charAt(0) == '/') {
            return (IEclipsePreferences)this.calculateRoot().node(path.substring(1));
        }
        int index = path.indexOf(47);
        String key = index == -1 ? path : path.substring(0, index);
        boolean added = false;
        EclipsePreferences eclipsePreferences = this;
        synchronized (eclipsePreferences) {
            child = this.getChild(key, context);
            if (child == null) {
                child = this.create(this, key, context);
                added = true;
            }
        }
        if (added && notify) {
            this.nodeAdded(child);
        }
        return (IEclipsePreferences)child.node(index == -1 ? EMPTY_STRING : path.substring(index + 1));
    }

    protected synchronized String internalPut(String key, String newValue) {
        this.checkRemoved();
        if (this.properties == null) {
            this.properties = new Properties();
        }
        String oldValue = this.properties.getProperty(key);
        if (InternalPlatform.DEBUG_PREFERENCES) {
            Policy.debug("Setting preference: " + this.absolutePath() + '/' + key + '=' + newValue);
        }
        this.properties.setProperty(key, newValue);
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRemove(String key, Object oldValue) {
        boolean wasRemoved = false;
        EclipsePreferences eclipsePreferences = this;
        synchronized (eclipsePreferences) {
            if (this.properties == null) {
                return;
            }
            boolean bl = wasRemoved = this.properties.remove(key) != null;
            if (this.properties.size() == 0) {
                this.properties = null;
            }
            if (wasRemoved) {
                this.makeDirty();
            }
        }
        if (wasRemoved) {
            this.preferenceChanged(key, oldValue, null);
        }
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return true;
    }

    public String[] keys() {
        this.checkRemoved();
        Properties temp = this.properties;
        if (temp == null || temp.size() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        return temp.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    protected void load() throws BackingStoreException {
        this.load(this.getLocation());
    }

    /*
     * Unable to fully structure code
     */
    protected void load(IPath location) throws BackingStoreException {
        block16: {
            if (location == null) {
                if (InternalPlatform.DEBUG_PREFERENCES) {
                    Policy.debug("Unable to determine location of preference file for node: " + this.absolutePath());
                }
                return;
            }
            if (InternalPlatform.DEBUG_PREFERENCES) {
                Policy.debug("Loading preferences from file: " + location);
            }
            input = null;
            fromDisk = new Properties();
            try {
                input = new BufferedInputStream(new FileInputStream(location.toFile()));
                fromDisk.load(input);
                var7_4 = null;
                ** if (input == null) goto lbl-1000
            }
            catch (Throwable var6_13) {
                var7_6 = null;
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var6_13;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block16;
                catch (FileNotFoundException e) {
                    if (InternalPlatform.DEBUG_PREFERENCES) {
                        Policy.debug("Preference file does not exist: " + location);
                    }
                    var7_5 = null;
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    message = Policy.bind("preferences.loadException", location.toString());
                    this.log(new Status(1, "org.eclipse.core.runtime", 1, message, e));
                    throw new BackingStoreException(message);
                }
            }
        }
        this.convertFromProperties(fromDisk);
    }

    protected void loaded() {
    }

    protected void loadLegacy() {
    }

    protected void log(IStatus status) {
        InternalPlatform.getDefault().log(status);
    }

    protected void makeDirty() {
        for (EclipsePreferences node = this; node != null && !node.removed; node = (EclipsePreferences)node.parent()) {
            node.dirty = true;
        }
    }

    public String name() {
        return this.name;
    }

    public Preferences node(String pathName) {
        return this.internalNode(pathName, true, null);
    }

    protected void nodeAdded(IEclipsePreferences child) {
        if (this.nodeListeners == null) {
            return;
        }
        Object[] listeners = this.nodeListeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            final IEclipsePreferences.NodeChangeEvent event = new IEclipsePreferences.NodeChangeEvent(this, child);
            final IEclipsePreferences.INodeChangeListener listener = (IEclipsePreferences.INodeChangeListener)listeners[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.added(event);
                }
            };
            Platform.run(job);
        }
    }

    public boolean nodeExists(String path) throws BackingStoreException {
        if (path.length() == 0) {
            return !this.removed;
        }
        this.checkRemoved();
        if (path.charAt(0) == '/') {
            return this.calculateRoot().nodeExists(path.substring(1));
        }
        int index = path.indexOf(47);
        String childName = index == -1 ? path : path.substring(0, index);
        IEclipsePreferences child = this.getChild(childName, null);
        if (child == null) {
            return false;
        }
        return child.nodeExists(index == -1 ? EMPTY_STRING : path.substring(index + 1));
    }

    protected void nodeRemoved(IEclipsePreferences child) {
        if (this.nodeListeners == null) {
            return;
        }
        Object[] listeners = this.nodeListeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            final IEclipsePreferences.NodeChangeEvent event = new IEclipsePreferences.NodeChangeEvent(this, child);
            final IEclipsePreferences.INodeChangeListener listener = (IEclipsePreferences.INodeChangeListener)listeners[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.removed(event);
                }
            };
            Platform.run(job);
        }
    }

    public Preferences parent() {
        this.checkRemoved();
        return this.parent;
    }

    protected void preferenceChanged(String key, Object oldValue, Object newValue) {
        if (this.preferenceListeners == null) {
            return;
        }
        Object[] listeners = this.preferenceListeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            final IEclipsePreferences.PreferenceChangeEvent event = new IEclipsePreferences.PreferenceChangeEvent(this, key, oldValue, newValue);
            final IEclipsePreferences.IPreferenceChangeListener listener = (IEclipsePreferences.IPreferenceChangeListener)listeners[i];
            ISafeRunnable job = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    listener.preferenceChange(event);
                }
            };
            Platform.run(job);
        }
    }

    public void put(String key, String newValue) {
        String oldValue = this.internalPut(key, newValue);
        if (!newValue.equals(oldValue)) {
            this.makeDirty();
            this.preferenceChanged(key, oldValue, newValue);
        }
    }

    public void putBoolean(String key, boolean value) {
        String oldValue;
        String newValue = value ? TRUE : FALSE;
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.makeDirty();
            this.preferenceChanged(key, oldValue == null ? null : new Boolean(oldValue), value ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public void putByteArray(String key, byte[] value) {
        String oldValue;
        String newValue = new String(Base64.encode(value));
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.makeDirty();
            this.preferenceChanged(key, oldValue == null ? null : Base64.decode(oldValue.getBytes()), value);
        }
    }

    public void putDouble(String key, double value) {
        Object oldValue;
        String newValue = Double.toString(value);
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.makeDirty();
            if (oldValue != null) {
                try {
                    oldValue = new Double((String)oldValue);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            this.preferenceChanged(key, oldValue, new Double(value));
        }
    }

    public void putFloat(String key, float value) {
        Object oldValue;
        String newValue = Float.toString(value);
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.makeDirty();
            if (oldValue != null) {
                try {
                    oldValue = new Float((String)oldValue);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            this.preferenceChanged(key, oldValue, new Float(value));
        }
    }

    public void putInt(String key, int value) {
        Object oldValue;
        String newValue = Integer.toString(value);
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.makeDirty();
            if (oldValue != null) {
                try {
                    oldValue = new Integer((String)oldValue);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            this.preferenceChanged(key, oldValue, new Integer(value));
        }
    }

    public void putLong(String key, long value) {
        Object oldValue;
        String newValue = Long.toString(value);
        if (!newValue.equals(oldValue = this.internalPut(key, newValue))) {
            this.makeDirty();
            if (oldValue != null) {
                try {
                    oldValue = new Long((String)oldValue);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            this.preferenceChanged(key, oldValue, new Long(value));
        }
    }

    public void remove(String key) {
        String oldValue = this.internalGet(key);
        if (oldValue != null) {
            this.internalRemove(key, oldValue);
        }
    }

    void removeBoolean(String key) {
        String oldValue = this.internalGet(key);
        if (oldValue != null) {
            this.internalRemove(key, Boolean.valueOf(oldValue));
        }
    }

    void removeDouble(String key) {
        Object oldValue = this.internalGet(key);
        if (oldValue != null) {
            try {
                oldValue = Double.valueOf((String)oldValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.internalRemove(key, oldValue);
        }
    }

    void removeFloat(String key) {
        Object oldValue = this.internalGet(key);
        if (oldValue != null) {
            try {
                oldValue = Float.valueOf((String)oldValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.internalRemove(key, oldValue);
        }
    }

    void removeInt(String key) {
        Object oldValue = this.internalGet(key);
        if (oldValue != null) {
            try {
                oldValue = Integer.valueOf((String)oldValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.internalRemove(key, oldValue);
        }
    }

    void removeLong(String key) {
        Object oldValue = this.internalGet(key);
        if (oldValue != null) {
            try {
                oldValue = Long.valueOf((String)oldValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.internalRemove(key, oldValue);
        }
    }

    public void removeNode() throws BackingStoreException {
        this.checkRemoved();
        String[] keys = this.keys();
        for (int i = 0; i < keys.length; ++i) {
            this.remove(keys[i]);
        }
        if (!(this.parent instanceof RootPreferences)) {
            if (this.parent instanceof EclipsePreferences) {
                this.removed = true;
                ((EclipsePreferences)this.parent).removeNode(this);
            } else {
                String message = Policy.bind("preferences.invalidParentClass", this.absolutePath(), this.parent.getClass().getName());
                throw new BackingStoreException(message);
            }
        }
        IEclipsePreferences[] childNodes = this.getChildren();
        for (int i = 0; i < childNodes.length; ++i) {
            try {
                childNodes[i].removeNode();
                continue;
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNode(IEclipsePreferences child) {
        boolean wasRemoved = false;
        EclipsePreferences eclipsePreferences = this;
        synchronized (eclipsePreferences) {
            if (this.children != null) {
                boolean bl = wasRemoved = this.children.remove(child.name()) != null;
                if (wasRemoved) {
                    this.makeDirty();
                }
                if (this.children.isEmpty()) {
                    this.children = null;
                }
            }
        }
        if (wasRemoved) {
            this.nodeRemoved(child);
        }
    }

    public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        this.checkRemoved();
        if (this.nodeListeners == null) {
            return;
        }
        this.nodeListeners.remove(listener);
        if (this.nodeListeners.size() == 0) {
            this.nodeListeners = null;
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            Policy.debug("Removed preference node change listener: " + listener + " from: " + this.absolutePath());
        }
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        this.checkRemoved();
        if (this.preferenceListeners == null) {
            return;
        }
        this.preferenceListeners.remove(listener);
        if (this.preferenceListeners.size() == 0) {
            this.preferenceListeners = null;
        }
        if (InternalPlatform.DEBUG_PREFERENCES) {
            Policy.debug("Removed preference property change listener: " + listener + " from: " + this.absolutePath());
        }
    }

    protected void save() throws BackingStoreException {
        this.save(this.getLocation());
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void save(IPath location) throws BackingStoreException {
        block14: {
            block13: {
                if (location == null) {
                    if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                    Policy.debug("Unable to determine location of preference file for node: " + this.absolutePath());
                    return;
                }
                if (InternalPlatform.DEBUG_PREFERENCES) {
                    Policy.debug("Saving preferences to file: " + location);
                }
                if ((table = this.convertToProperties(new Properties(), "")).isEmpty()) {
                    if (location.toFile().exists() == false) return;
                    if (location.toFile().delete() != false) return;
                    message = Policy.bind("preferences.failedDelete", location.toString());
                    this.log(new Status(2, "org.eclipse.core.runtime", 2, message, null));
                    return;
                }
                table.put("eclipse.preferences.version", "1");
                output = null;
                try {
                    try {
                        parentFile = location.toFile().getParentFile();
                        if (parentFile == null) {
                            var7_7 = null;
                            if (output == null) return;
                            break block13;
                        }
                        parentFile.mkdirs();
                        output = new BufferedOutputStream(new FileOutputStream(location.toOSString(), false));
                        table.store(output, null);
                        break block14;
                    }
                    catch (IOException e) {
                        message = Policy.bind("preferences.saveException", location.toString());
                        this.log(new Status(4, "org.eclipse.core.runtime", 4, message, e));
                        throw new BackingStoreException(message);
                    }
                }
                catch (Throwable var6_14) {
                    var7_9 = null;
                    if (output == null) throw var6_14;
                    try {
                        output.close();
                        throw var6_14;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw var6_14;
                }
            }
            ** try [egrp 2[TRYBLOCK] [5 : 264->271)] { 
lbl45:
            // 1 sources

            output.close();
            return;
lbl47:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        var7_8 = null;
        if (output == null) return;
        try {}
        catch (IOException e) {}
        output.close();
        return;
    }

    public static String encodePath(String path, String key) {
        int pathLength;
        int n = pathLength = path == null ? 0 : path.length();
        String result = key.indexOf(47) == -1 ? (pathLength == 0 ? key : path + '/' + key) : (pathLength == 0 ? DOUBLE_SLASH + key : path + DOUBLE_SLASH + key);
        return result;
    }

    public static String getSegment(String path, int segment) {
        int start = path.indexOf(47) == 0 ? 1 : 0;
        int end = path.indexOf(47, start);
        if (end == path.length() - 1) {
            end = -1;
        }
        for (int i = 0; i < segment; ++i) {
            if (end == -1) {
                return null;
            }
            start = end + 1;
            end = path.indexOf(47, start);
        }
        if (end == -1) {
            end = path.length();
        }
        return path.substring(start, end);
    }

    public static int getSegmentCount(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, String.valueOf('/'));
        return tokenizer.countTokens();
    }

    public static String makeRelative(String path) {
        String result = path;
        if (path == null) {
            return EMPTY_STRING;
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            result = path.length() == 0 ? EMPTY_STRING : path.substring(1);
        }
        return result;
    }

    public static String[] decodePath(String fullPath) {
        String key = null;
        String path = null;
        int index = fullPath.indexOf(DOUBLE_SLASH);
        if (index == -1) {
            int lastIndex = fullPath.lastIndexOf(47);
            if (lastIndex == -1) {
                key = fullPath;
            } else {
                path = fullPath.substring(0, lastIndex);
                key = fullPath.substring(lastIndex + 1);
            }
        } else {
            path = fullPath.substring(0, index);
            key = fullPath.substring(index + 2);
        }
        if (path != null) {
            if (path.length() == 0) {
                path = null;
            } else if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
        }
        return new String[]{path, key};
    }

    public void sync() throws BackingStoreException {
        this.checkRemoved();
        IEclipsePreferences node = this.getLoadLevel();
        if (node == null) {
            if (InternalPlatform.DEBUG_PREFERENCES) {
                Policy.debug("Preference node is not a load root: " + this.absolutePath());
            }
            return;
        }
        if (node instanceof EclipsePreferences) {
            ((EclipsePreferences)node).load();
            node.flush();
        }
    }

    public String toDeepDebugString() {
        final StringBuffer buffer = new StringBuffer();
        IPreferenceNodeVisitor visitor = new IPreferenceNodeVisitor(){

            public boolean visit(IEclipsePreferences node) throws BackingStoreException {
                buffer.append(node);
                buffer.append('\n');
                String[] keys = node.keys();
                for (int i = 0; i < keys.length; ++i) {
                    buffer.append(node.absolutePath());
                    buffer.append(PATH_SEPARATOR);
                    buffer.append(keys[i]);
                    buffer.append('=');
                    buffer.append(node.get(keys[i], "*default*"));
                    buffer.append('\n');
                }
                return true;
            }
        };
        try {
            this.accept(visitor);
        }
        catch (BackingStoreException e) {
            System.out.println("Exception while calling #toDeepDebugString()");
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public String toString() {
        return this.absolutePath();
    }
}

