/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.ResourceRegistry;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontRegistry
extends ResourceRegistry {
    private Map stringToFontRecord = new HashMap(7);
    private Map stringToFontData = new HashMap(7);
    private List staleFonts = new ArrayList();
    protected Runnable displayRunnable = new Runnable(){

        public void run() {
            FontRegistry.this.clearCaches();
        }
    };

    public FontRegistry() {
        Display display = Display.getCurrent();
        Assert.isNotNull(display);
        this.hookDisplayDispose(display);
    }

    public FontRegistry(String location, ClassLoader loader) throws MissingResourceException {
        Display display = Display.getCurrent();
        Assert.isNotNull(display);
        this.readResourceBundle(location);
        this.hookDisplayDispose(display);
    }

    public FontRegistry(String location) throws MissingResourceException {
        this(location, null);
    }

    private void readResourceBundle(String location) {
        block7: {
            String osname = System.getProperty("os.name").trim();
            String wsname = SWT.getPlatform();
            osname = StringConverter.removeWhiteSpaces(osname).toLowerCase();
            wsname = StringConverter.removeWhiteSpaces(wsname).toLowerCase();
            String OSLocation = location;
            String WSLocation = location;
            ResourceBundle bundle = null;
            if (osname != null) {
                OSLocation = location + "_" + osname;
                if (wsname != null) {
                    WSLocation = OSLocation + "_" + wsname;
                }
            }
            try {
                bundle = ResourceBundle.getBundle(WSLocation);
                this.readResourceBundle(bundle, WSLocation);
            }
            catch (MissingResourceException wsException) {
                try {
                    bundle = ResourceBundle.getBundle(OSLocation);
                    this.readResourceBundle(bundle, WSLocation);
                }
                catch (MissingResourceException osException) {
                    if (location != OSLocation) {
                        bundle = ResourceBundle.getBundle(location);
                        this.readResourceBundle(bundle, WSLocation);
                        break block7;
                    }
                    throw osException;
                }
            }
        }
    }

    public FontRegistry(Display display) {
        Assert.isNotNull(display);
        this.hookDisplayDispose(display);
    }

    public FontData bestData(FontData[] fonts, Display display) {
        FontData fd;
        for (int i = 0; i < fonts.length && (fd = fonts[i]) != null; ++i) {
            FontData[] fixedFonts = display.getFontList(fd.getName(), false);
            if (this.isFixedFont(fixedFonts, fd)) {
                return fd;
            }
            FontData[] scalableFonts = display.getFontList(fd.getName(), true);
            if (scalableFonts.length <= 0) continue;
            return fd;
        }
        if (fonts.length > 0) {
            return fonts[0];
        }
        return null;
    }

    public FontData[] bestDataArray(FontData[] fonts, Display display) {
        FontData bestData = this.bestData(fonts, display);
        if (bestData == null) {
            return null;
        }
        FontData[] datas = new FontData[]{bestData};
        return datas;
    }

    private FontRecord createFont(String symbolicName, FontData[] fonts) {
        Display display = Display.getCurrent();
        if (display == null) {
            return null;
        }
        FontData[] validData = this.bestDataArray(fonts, display);
        if (validData == null) {
            return null;
        }
        this.put(symbolicName, validData, false);
        Font newFont = new Font((Device)display, validData);
        return new FontRecord(newFont, validData);
    }

    Font calculateDefaultFont() {
        Display current = Display.getCurrent();
        if (current == null) {
            Shell shell = new Shell();
            Font font = new Font(null, shell.getFont().getFontData());
            shell.dispose();
            return font;
        }
        return new Font((Device)current, current.getSystemFont().getFontData());
    }

    public Font defaultFont() {
        return this.defaultFontRecord().getBaseFont();
    }

    private FontRecord defaultFontRecord() {
        FontRecord record = (FontRecord)this.stringToFontRecord.get("org.eclipse.jface.defaultfont");
        if (record == null) {
            Font defaultFont = this.calculateDefaultFont();
            record = this.createFont("org.eclipse.jface.defaultfont", defaultFont.getFontData());
            this.stringToFontRecord.put("org.eclipse.jface.defaultfont", record);
        }
        return record;
    }

    private FontData[] defaultFontData() {
        return this.defaultFontRecord().baseData;
    }

    public FontData[] getFontData(String symbolicName) {
        Assert.isNotNull(symbolicName);
        Object result = this.stringToFontData.get(symbolicName);
        if (result == null) {
            return this.defaultFontData();
        }
        return (FontData[])result;
    }

    public Font get(String symbolicName) {
        return this.getFontRecord(symbolicName).getBaseFont();
    }

    public Font getBold(String symbolicName) {
        return this.getFontRecord(symbolicName).getBoldFont();
    }

    public Font getItalic(String symbolicName) {
        return this.getFontRecord(symbolicName).getItalicFont();
    }

    private FontRecord getFontRecord(String symbolicName) {
        Assert.isNotNull(symbolicName);
        Object result = this.stringToFontRecord.get(symbolicName);
        if (result != null) {
            return (FontRecord)result;
        }
        result = this.stringToFontData.get(symbolicName);
        FontRecord fontRecord = result == null ? this.defaultFontRecord() : this.createFont(symbolicName, (FontData[])result);
        if (fontRecord == null) {
            fontRecord = this.defaultFontRecord();
        }
        this.stringToFontRecord.put(symbolicName, fontRecord);
        return fontRecord;
    }

    public Set getKeySet() {
        return Collections.unmodifiableSet(this.stringToFontData.keySet());
    }

    public boolean hasValueFor(String fontKey) {
        return this.stringToFontData.containsKey(fontKey);
    }

    protected void clearCaches() {
        Iterator iterator = this.stringToFontRecord.values().iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            ((FontRecord)next).dispose();
        }
        this.disposeFonts(this.staleFonts.iterator());
        this.stringToFontRecord.clear();
        this.staleFonts.clear();
    }

    private void disposeFonts(Iterator iterator) {
        while (iterator.hasNext()) {
            Object next = iterator.next();
            ((Font)next).dispose();
        }
    }

    private void hookDisplayDispose(Display display) {
        display.disposeExec(this.displayRunnable);
    }

    private boolean isFixedFont(FontData[] fixedFonts, FontData fd) {
        int height = fd.getHeight();
        String name = fd.getName();
        for (int i = 0; i < fixedFonts.length; ++i) {
            FontData fixed = fixedFonts[i];
            if (fixed.getHeight() != height || !fixed.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private FontData makeFontData(String value) throws MissingResourceException {
        try {
            return StringConverter.asFontData(value.trim());
        }
        catch (DataFormatException e) {
            throw new MissingResourceException("Wrong font data format. Value is: \"" + value + "\"", this.getClass().getName(), value);
        }
    }

    public void put(String symbolicName, FontData[] fontData) {
        this.put(symbolicName, fontData, true);
    }

    private void put(String symbolicName, FontData[] fontData, boolean update) {
        Assert.isNotNull(symbolicName);
        Assert.isNotNull(fontData);
        Object[] existing = (FontData[])this.stringToFontData.get(symbolicName);
        if (Arrays.equals(existing, fontData)) {
            return;
        }
        FontRecord oldFont = (FontRecord)this.stringToFontRecord.remove(symbolicName);
        this.stringToFontData.put(symbolicName, fontData);
        if (update) {
            this.fireMappingChanged(symbolicName, existing, fontData);
        }
        if (oldFont != null) {
            oldFont.addAllocatedFontsToStale(this.defaultFontRecord().getBaseFont());
        }
    }

    private void readResourceBundle(ResourceBundle bundle, String bundleName) throws MissingResourceException {
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            int pos = key.lastIndexOf(46);
            if (pos == -1) {
                this.stringToFontData.put(key, new FontData[]{this.makeFontData(bundle.getString(key))});
                continue;
            }
            String name = key.substring(0, pos);
            int i = 0;
            try {
                i = Integer.parseInt(key.substring(pos + 1));
            }
            catch (NumberFormatException e) {
                throw new MissingResourceException("Wrong key format ", bundleName, key);
            }
            FontData[] elements = (FontData[])this.stringToFontData.get(name);
            if (elements == null) {
                elements = new FontData[8];
                this.stringToFontData.put(name, elements);
            }
            if (i > elements.length) {
                FontData[] na = new FontData[i + 8];
                System.arraycopy(elements, 0, na, 0, elements.length);
                elements = na;
                this.stringToFontData.put(name, elements);
            }
            elements[i] = this.makeFontData(bundle.getString(key));
        }
    }

    private class FontRecord {
        Font baseFont;
        Font boldFont;
        Font italicFont;
        FontData[] baseData;

        FontRecord(Font plainFont, FontData[] data) {
            this.baseFont = plainFont;
            this.baseData = data;
        }

        void dispose() {
            this.baseFont.dispose();
            if (this.boldFont != null) {
                this.boldFont.dispose();
            }
            if (this.italicFont != null) {
                this.italicFont.dispose();
            }
        }

        public Font getBaseFont() {
            return this.baseFont;
        }

        public Font getBoldFont() {
            if (this.boldFont != null) {
                return this.boldFont;
            }
            FontData[] boldData = this.getModifiedFontData(1);
            this.boldFont = new Font((Device)Display.getCurrent(), boldData);
            return this.boldFont;
        }

        private FontData[] getModifiedFontData(int style) {
            FontData[] styleData = new FontData[this.baseData.length];
            for (int i = 0; i < styleData.length; ++i) {
                FontData base = this.baseData[i];
                styleData[i] = new FontData(base.getName(), base.getHeight(), base.getStyle() | style);
            }
            return styleData;
        }

        public Font getItalicFont() {
            if (this.italicFont != null) {
                return this.italicFont;
            }
            FontData[] italicData = this.getModifiedFontData(2);
            this.italicFont = new Font((Device)Display.getCurrent(), italicData);
            return this.italicFont;
        }

        void addAllocatedFontsToStale(Font defaultFont) {
            if (defaultFont != this.baseFont) {
                FontRegistry.this.staleFonts.add(this.baseFont);
            }
            if (defaultFont != this.boldFont) {
                FontRegistry.this.staleFonts.add(this.baseFont);
            }
            if (defaultFont != this.italicFont) {
                FontRegistry.this.staleFonts.add(this.baseFont);
            }
        }
    }
}

