/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.security;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Security;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.security.KeystoreHandle;

public class KeyStores {
    private static final String JAVA_POLICY_URL = "policy.url.";
    private static final String DEFAULT_KEYSTORE_TYPE = "keystore.type";
    private List listOfKeyStores;
    private Iterator iterator;

    public KeyStores() {
        this.initializeDefaultKeyStores();
    }

    private Iterator getIterator() {
        if (this.iterator == null) {
            this.iterator = this.listOfKeyStores.iterator();
        }
        return this.iterator;
    }

    public boolean hasNext() {
        return this.getIterator().hasNext();
    }

    private void initializeDefaultKeyStores() {
        URL url;
        this.listOfKeyStores = new ArrayList(5);
        try {
            url = new URL("file", null, 0, System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts");
            this.listOfKeyStores.add(new KeystoreHandle(url, Security.getProperty(DEFAULT_KEYSTORE_TYPE)));
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        try {
            url = new URL("file", null, 0, System.getProperty("user.home") + File.separator + ".keystore");
            this.listOfKeyStores.add(new KeystoreHandle(url, Security.getProperty(DEFAULT_KEYSTORE_TYPE)));
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        int index = 1;
        String java_policy = Security.getProperty(JAVA_POLICY_URL + index);
        while (java_policy != null) {
            KeystoreHandle keystore = this.getKeystoreFromLocation(java_policy);
            if (keystore != null) {
                this.listOfKeyStores.add(keystore);
            }
            java_policy = Security.getProperty(JAVA_POLICY_URL + ++index);
        }
    }

    public KeystoreHandle next() {
        return (KeystoreHandle)this.getIterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeystoreHandle getKeystoreFromLocation(String location) {
        block15: {
            in = null;
            buff = new char[4096];
            indexOf$ = location.indexOf("${");
            indexOfCurly = location.indexOf(125, indexOf$);
            if (indexOf$ != -1 && indexOfCurly != -1) {
                prop = System.getProperty(location.substring(indexOf$ + 2, indexOfCurly));
                location2 = location.substring(0, indexOf$);
                location2 = location2 + prop;
                location = location2 = location2 + location.substring(indexOfCurly + 1);
            }
            try {
                try {
                    url = new URL(location);
                    in = UpdateCore.getPlugin().get(url).getInputStream();
                    reader = new InputStreamReader(in);
                    result = reader.read(buff);
                    contentBuff = new StringBuffer();
                    while (result != -1) {
                        contentBuff.append(buff, 0, result);
                        result = reader.read(buff);
                    }
                    if (contentBuff.length() <= 0 || (indexOfKeystore = (content = new String(contentBuff)).indexOf("keystore")) == -1) break block15;
                    indexOfSemiColumn = content.indexOf(59, indexOfKeystore);
                    var13_15 = this.getKeystoreFromString(content.substring(indexOfKeystore, indexOfSemiColumn), url);
                    var15_16 = null;
                    if (in == null) return var13_15;
                }
                catch (MalformedURLException e) {
                    this.log(e);
                    var15_18 = null;
                    if (in == null) return null;
                    try {
                        in.close();
                        return null;
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                catch (IOException e) {
                    this.log(e);
                    var15_19 = null;
                    if (in == null) return null;
                    try {}
                    catch (IOException e) {
                        return null;
                    }
                    in.close();
                    return null;
                }
            }
            catch (Throwable var14_26) {
                var15_20 = null;
                if (in == null) throw var14_26;
                ** try [egrp 2[TRYBLOCK] [7 : 309->316)] { 
lbl54:
                // 1 sources

                in.close();
                throw var14_26;
lbl56:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                throw var14_26;
            }
            try {}
            catch (IOException e) {
                // empty catch block
                return var13_15;
            }
            in.close();
            return var13_15;
        }
        var15_17 = null;
        if (in == null) return null;
        try {}
        catch (IOException e) {}
        in.close();
        return null;
        return null;
    }

    private KeystoreHandle getKeystoreFromString(String content, URL rootURL) {
        KeystoreHandle handle = null;
        String keyStoreType = Security.getProperty(DEFAULT_KEYSTORE_TYPE);
        int indexOfSpace = content.indexOf(32);
        if (indexOfSpace == -1) {
            return null;
        }
        int secondSpace = content.lastIndexOf(44);
        if (secondSpace == -1) {
            secondSpace = content.length();
        } else {
            keyStoreType = content.substring(secondSpace + 1, content.length()).trim();
        }
        URL url = null;
        try {
            url = new URL(content.substring(indexOfSpace, secondSpace));
        }
        catch (MalformedURLException e) {
            this.log(e);
            try {
                url = new URL(rootURL, content.substring(indexOfSpace, secondSpace));
            }
            catch (MalformedURLException e1) {
                this.log(e1);
            }
        }
        if (url != null) {
            handle = new KeystoreHandle(url, keyStoreType);
        }
        return handle;
    }

    private void log(Exception e) {
        UpdateCore.warn("Cannot retrieve a KeyStore", e);
    }
}

