/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.internal.core.FeaturePlugin;
import org.eclipse.update.internal.core.UpdateCore;

public class PatchedFeature {
    private IFeatureReference feature;
    private Collection patches = new HashSet();

    public PatchedFeature(IFeatureReference feature) {
        this.feature = feature;
    }

    public void addPatch(IFeatureReference patch) {
        this.patches.add(patch);
    }

    public IFeatureReference getFeature() {
        return this.feature;
    }

    public IFeatureReference[] getPatches() {
        return this.patches.toArray(new IFeatureReference[this.patches.size()]);
    }

    public IFeatureReference[] getFeatureAndPatches() {
        IFeatureReference[] features = new IFeatureReference[this.patches.size() + 1];
        features[0] = this.feature;
        System.arraycopy(this.getPatches(), 0, features, 1, this.patches.size());
        return features;
    }

    public FeaturePlugin[] getPlugins() {
        HashMap<String, FeaturePlugin> plugins = new HashMap<String, FeaturePlugin>();
        IFeatureReference[] featureRefs = this.getFeatureAndPatches();
        for (int i = 0; i < featureRefs.length; ++i) {
            try {
                IFeature feature = featureRefs[i].getFeature(null);
                if (feature == null) {
                    UpdateCore.warn("Null Feature", new Exception());
                    continue;
                }
                IPluginEntry[] entries = feature.getPluginEntries();
                for (int entr = 0; entr < entries.length; ++entr) {
                    String pluginId = entries[entr].getVersionedIdentifier().getIdentifier();
                    PluginVersionIdentifier pluginVersion = entries[entr].getVersionedIdentifier().getVersion();
                    FeaturePlugin existingPlugin = (FeaturePlugin)plugins.get(pluginId);
                    if (existingPlugin != null && existingPlugin.getEntry().getVersionedIdentifier().getVersion().isGreaterOrEqualTo(pluginVersion)) continue;
                    plugins.put(pluginId, new FeaturePlugin(entries[entr], feature));
                }
                continue;
            }
            catch (CoreException e) {
                UpdateCore.warn(null, e);
            }
        }
        return plugins.values().toArray(new FeaturePlugin[plugins.size()]);
    }

    public String toString() {
        StringBuffer str = new StringBuffer(this.feature.toString());
        IFeatureReference[] patches = this.getFeatureAndPatches();
        for (int i = 0; i < patches.length; ++i) {
            str.append(" +patch=" + patches[i].toString() + " ");
        }
        return str.toString();
    }
}

