/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.index.EntryResult;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchPattern;

public class ConstructorPattern
extends JavaSearchPattern
implements IIndexConstants {
    protected boolean findDeclarations;
    protected boolean findReferences;
    public char[] declaringQualification;
    public char[] declaringSimpleName;
    public char[][] parameterQualifications;
    public char[][] parameterSimpleNames;
    public int parameterCount;
    protected static char[][] REF_CATEGORIES = new char[][]{IIndexConstants.CONSTRUCTOR_REF};
    protected static char[][] REF_AND_DECL_CATEGORIES = new char[][]{IIndexConstants.CONSTRUCTOR_REF, IIndexConstants.CONSTRUCTOR_DECL};
    protected static char[][] DECL_CATEGORIES = new char[][]{IIndexConstants.CONSTRUCTOR_DECL};

    public static char[] createIndexKey(char[] typeName, int argCount) {
        char[] countChars = argCount < 10 ? IIndexConstants.COUNTS[argCount] : ("/" + String.valueOf(argCount)).toCharArray();
        return CharOperation.concat(typeName, countChars);
    }

    public ConstructorPattern(boolean findDeclarations, boolean findReferences, char[] declaringSimpleName, char[] declaringQualification, char[][] parameterQualifications, char[][] parameterSimpleNames, int matchRule) {
        this(matchRule);
        this.findDeclarations = findDeclarations;
        this.findReferences = findReferences;
        this.declaringQualification = this.isCaseSensitive() ? declaringQualification : CharOperation.toLowerCase(declaringQualification);
        char[] cArray = this.declaringSimpleName = this.isCaseSensitive() ? declaringSimpleName : CharOperation.toLowerCase(declaringSimpleName);
        if (parameterSimpleNames != null) {
            this.parameterCount = parameterSimpleNames.length;
            this.parameterQualifications = new char[this.parameterCount][];
            this.parameterSimpleNames = new char[this.parameterCount][];
            for (int i = 0; i < this.parameterCount; ++i) {
                this.parameterQualifications[i] = this.isCaseSensitive() ? parameterQualifications[i] : CharOperation.toLowerCase(parameterQualifications[i]);
                this.parameterSimpleNames[i] = this.isCaseSensitive() ? parameterSimpleNames[i] : CharOperation.toLowerCase(parameterSimpleNames[i]);
            }
        } else {
            this.parameterCount = -1;
        }
        this.mustResolve = this.mustResolve();
    }

    ConstructorPattern(int matchRule) {
        super(32, matchRule);
    }

    public void decodeIndexKey(char[] key) {
        int size = key.length;
        int lastSeparatorIndex = CharOperation.lastIndexOf('/', key);
        this.parameterCount = Integer.parseInt(new String(key, lastSeparatorIndex + 1, size - lastSeparatorIndex - 1));
        this.declaringSimpleName = CharOperation.subarray(key, 0, lastSeparatorIndex);
    }

    public SearchPattern getBlankPattern() {
        return new ConstructorPattern(8);
    }

    public char[][] getIndexCategories() {
        if (this.findReferences) {
            return this.findDeclarations ? REF_AND_DECL_CATEGORIES : REF_CATEGORIES;
        }
        if (this.findDeclarations) {
            return DECL_CATEGORIES;
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        ConstructorPattern pattern = (ConstructorPattern)decodedPattern;
        return (this.parameterCount == pattern.parameterCount || this.parameterCount == -1) && this.matchesName(this.declaringSimpleName, pattern.declaringSimpleName);
    }

    protected boolean mustResolve() {
        if (this.declaringQualification != null) {
            return true;
        }
        if (this.parameterSimpleNames != null) {
            int max = this.parameterSimpleNames.length;
            for (int i = 0; i < max; ++i) {
                if (this.parameterQualifications[i] == null) continue;
                return true;
            }
        }
        return this.findReferences;
    }

    EntryResult[] queryIn(Index index) throws IOException {
        char[] key = this.declaringSimpleName;
        int matchRule = this.getMatchRule();
        switch (this.getMatchMode()) {
            case 0: {
                if (this.declaringSimpleName != null && this.parameterCount >= 0) {
                    key = ConstructorPattern.createIndexKey(this.declaringSimpleName, this.parameterCount);
                    break;
                }
                matchRule = matchRule - 0 + 1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.parameterCount >= 0) {
                    key = ConstructorPattern.createIndexKey(this.declaringSimpleName == null ? IIndexConstants.ONE_STAR : this.declaringSimpleName, this.parameterCount);
                    break;
                }
                if (this.declaringSimpleName == null || this.declaringSimpleName[this.declaringSimpleName.length - 1] == '*') break;
                key = CharOperation.concat(this.declaringSimpleName, IIndexConstants.ONE_STAR, '/');
            }
        }
        return index.query(this.getIndexCategories(), key, matchRule);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(20);
        if (this.findDeclarations) {
            buffer.append(this.findReferences ? "ConstructorCombinedPattern: " : "ConstructorDeclarationPattern: ");
        } else {
            buffer.append("ConstructorReferencePattern: ");
        }
        if (this.declaringQualification != null) {
            buffer.append(this.declaringQualification).append('.');
        }
        if (this.declaringSimpleName != null) {
            buffer.append(this.declaringSimpleName);
        } else if (this.declaringQualification != null) {
            buffer.append("*");
        }
        buffer.append('(');
        if (this.parameterSimpleNames == null) {
            buffer.append("...");
        } else {
            int max = this.parameterSimpleNames.length;
            for (int i = 0; i < max; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                if (this.parameterQualifications[i] != null) {
                    buffer.append(this.parameterQualifications[i]).append('.');
                }
                if (this.parameterSimpleNames[i] == null) {
                    buffer.append('*');
                    continue;
                }
                buffer.append(this.parameterSimpleNames[i]);
            }
        }
        buffer.append(')');
        buffer.append(", ");
        switch (this.getMatchMode()) {
            case 0: {
                buffer.append("exact match, ");
                break;
            }
            case 1: {
                buffer.append("prefix match, ");
                break;
            }
            case 2: {
                buffer.append("pattern match, ");
            }
        }
        buffer.append(this.isCaseSensitive() ? "case sensitive" : "case insensitive");
        return buffer.toString();
    }
}

