/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Locale;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.ISourceType;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.parser.SourceTypeConverter;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.JavaProject;

public class CompilationUnitVisitor
extends Compiler {
    public CompilationUnitVisitor(INameEnvironment environment, IErrorHandlingPolicy policy, Map settings, ICompilerRequestor requestor, IProblemFactory problemFactory) {
        super(environment, policy, settings, requestor, problemFactory);
    }

    public void accept(ISourceType[] sourceTypes, PackageBinding packageBinding) {
        CompilationResult result = new CompilationResult(sourceTypes[0].getFileName(), 1, 1, this.options.maxProblemsPerUnit);
        CompilationUnitDeclaration unit = SourceTypeConverter.buildCompilationUnit(sourceTypes, 15, this.lookupEnvironment.problemReporter, result);
        if (unit != null) {
            this.lookupEnvironment.buildTypeBindings(unit);
            this.lookupEnvironment.completeTypeBindings(unit, true);
        }
    }

    protected static IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(){

            public boolean stopOnFirstError() {
                return false;
            }

            public boolean proceedOnErrors() {
                return false;
            }
        };
    }

    protected static ICompilerRequestor getRequestor() {
        return new ICompilerRequestor(){

            public void acceptResult(CompilationResult compilationResult) {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void visit(ICompilationUnit unitElement, ASTVisitor visitor) throws JavaModelException {
        JavaProject project = (JavaProject)unitElement.getJavaProject();
        CompilationUnitVisitor compilationUnitVisitor = new CompilationUnitVisitor(project.newSearchableNameEnvironment(unitElement.getOwner()), CompilationUnitVisitor.getHandlingPolicy(), project.getOptions(true), CompilationUnitVisitor.getRequestor(), CompilationUnitVisitor.getProblemFactory(visitor));
        CompilationUnitDeclaration unit = null;
        try {
            IPackageFragment packageFragment = (IPackageFragment)unitElement.getAncestor(4);
            char[][] expectedPackageName = null;
            if (packageFragment != null) {
                expectedPackageName = CharOperation.splitOn('.', packageFragment.getElementName().toCharArray());
            }
            if ((unit = compilationUnitVisitor.resolve(new BasicCompilationUnit(unitElement.getSource().toCharArray(), expectedPackageName, unitElement.getElementName(), unitElement), true, false, false)) != null) {
                unit.traverse(visitor, unit.scope);
            }
        }
        finally {
            if (unit != null) {
                unit.cleanUp();
            }
        }
    }

    protected static IProblemFactory getProblemFactory(final ASTVisitor visitor) {
        return new DefaultProblemFactory(Locale.getDefault()){

            public IProblem createProblem(char[] originatingFileName, int problemId, String[] problemArguments, String[] messageArguments, int severity, int startPosition, int endPosition, int lineNumber) {
                IProblem problem = super.createProblem(originatingFileName, problemId, problemArguments, messageArguments, severity, startPosition, endPosition, lineNumber);
                visitor.acceptProblem(problem);
                return problem;
            }
        };
    }
}

