/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class FlowContext
implements TypeConstants {
    public ASTNode associatedNode;
    public FlowContext parent;
    public static final FlowContext NotContinuableContext = new FlowContext(null, null);

    public FlowContext(FlowContext parent, ASTNode associatedNode) {
        this.parent = parent;
        this.associatedNode = associatedNode;
    }

    public Label breakLabel() {
        return null;
    }

    public void checkExceptionHandlers(TypeBinding[] raisedExceptions, ASTNode location, FlowInfo flowInfo, BlockScope scope) {
        int raisedCount;
        if (raisedExceptions == null || (raisedCount = raisedExceptions.length) == 0) {
            return;
        }
        int remainingCount = raisedCount;
        TypeBinding[] typeBindingArray = raisedExceptions;
        raisedExceptions = new TypeBinding[raisedCount];
        System.arraycopy(typeBindingArray, 0, raisedExceptions, 0, raisedCount);
        FlowContext traversedContext = this;
        while (traversedContext != null) {
            SubRoutineStatement sub = traversedContext.subRoutine();
            if (sub != null && sub.isSubRoutineEscaping()) {
                return;
            }
            if (traversedContext instanceof ExceptionHandlingFlowContext) {
                ExceptionHandlingFlowContext exceptionContext = (ExceptionHandlingFlowContext)traversedContext;
                ReferenceBinding[] caughtExceptions = exceptionContext.handledExceptions;
                if (exceptionContext.handledExceptions != TypeConstants.NoExceptions) {
                    int caughtCount = caughtExceptions.length;
                    boolean[] locallyCaught = new boolean[raisedCount];
                    for (int caughtIndex = 0; caughtIndex < caughtCount; ++caughtIndex) {
                        ReferenceBinding caughtException = caughtExceptions[caughtIndex];
                        block6: for (int raisedIndex = 0; raisedIndex < raisedCount; ++raisedIndex) {
                            TypeBinding raisedException = raisedExceptions[raisedIndex];
                            if (raisedException == null) continue;
                            int state = caughtException == null ? -1 : Scope.compareTypes(raisedException, caughtException);
                            switch (state) {
                                case -1: {
                                    exceptionContext.recordHandlingException(caughtException, flowInfo.unconditionalInits(), raisedException, location, locallyCaught[raisedIndex]);
                                    if (locallyCaught[raisedIndex]) continue block6;
                                    locallyCaught[raisedIndex] = true;
                                    --remainingCount;
                                    continue block6;
                                }
                                case 1: {
                                    exceptionContext.recordHandlingException(caughtException, flowInfo.unconditionalInits(), raisedException, location, false);
                                }
                            }
                        }
                    }
                    for (int i = 0; i < raisedCount; ++i) {
                        if (!locallyCaught[i]) continue;
                        raisedExceptions[i] = null;
                    }
                }
                if (exceptionContext.isMethodContext) {
                    AbstractMethodDeclaration method;
                    for (int i = 0; i < raisedCount; ++i) {
                        TypeBinding raisedException = raisedExceptions[i];
                        if (raisedException == null || !raisedException.isCompatibleWith(scope.getJavaLangRuntimeException()) && !raisedException.isCompatibleWith(scope.getJavaLangError())) continue;
                        --remainingCount;
                        raisedExceptions[i] = null;
                    }
                    if (!(exceptionContext.associatedNode instanceof AbstractMethodDeclaration) || !(method = (AbstractMethodDeclaration)exceptionContext.associatedNode).isConstructor() || !method.binding.declaringClass.isAnonymousType()) break;
                    for (int i = 0; i < raisedCount; ++i) {
                        TypeBinding raisedException = raisedExceptions[i];
                        if (raisedException == null) continue;
                        exceptionContext.mergeUnhandledException(raisedException);
                    }
                    return;
                }
            }
            if (remainingCount == 0) {
                return;
            }
            traversedContext.recordReturnFrom(flowInfo.unconditionalInits());
            if (traversedContext.associatedNode instanceof TryStatement) {
                flowInfo = flowInfo.copy().addInitializationsFrom(((TryStatement)traversedContext.associatedNode).subRoutineInits);
            }
            traversedContext = traversedContext.parent;
        }
        block10: for (int i = 0; i < raisedCount; ++i) {
            TypeBinding exception = raisedExceptions[i];
            if (exception == null) continue;
            for (int j = 0; j < i; ++j) {
                if (raisedExceptions[j] == exception) continue block10;
            }
            scope.problemReporter().unhandledException(exception, location);
        }
    }

    public void checkExceptionHandlers(TypeBinding raisedException, ASTNode location, FlowInfo flowInfo, BlockScope scope) {
        FlowContext traversedContext = this;
        while (traversedContext != null) {
            SubRoutineStatement sub = traversedContext.subRoutine();
            if (sub != null && sub.isSubRoutineEscaping()) {
                return;
            }
            if (traversedContext instanceof ExceptionHandlingFlowContext) {
                ExceptionHandlingFlowContext exceptionContext = (ExceptionHandlingFlowContext)traversedContext;
                ReferenceBinding[] caughtExceptions = exceptionContext.handledExceptions;
                if (exceptionContext.handledExceptions != TypeConstants.NoExceptions) {
                    boolean definitelyCaught = false;
                    int caughtCount = caughtExceptions.length;
                    block5: for (int caughtIndex = 0; caughtIndex < caughtCount; ++caughtIndex) {
                        ReferenceBinding caughtException = caughtExceptions[caughtIndex];
                        int state = caughtException == null ? -1 : Scope.compareTypes(raisedException, caughtException);
                        switch (state) {
                            case -1: {
                                exceptionContext.recordHandlingException(caughtException, flowInfo.unconditionalInits(), raisedException, location, definitelyCaught);
                                definitelyCaught = true;
                                continue block5;
                            }
                            case 1: {
                                exceptionContext.recordHandlingException(caughtException, flowInfo.unconditionalInits(), raisedException, location, false);
                            }
                        }
                    }
                    if (definitelyCaught) {
                        return;
                    }
                }
                if (exceptionContext.isMethodContext) {
                    AbstractMethodDeclaration method;
                    if (raisedException.isCompatibleWith(scope.getJavaLangRuntimeException()) || raisedException.isCompatibleWith(scope.getJavaLangError())) {
                        return;
                    }
                    if (!(exceptionContext.associatedNode instanceof AbstractMethodDeclaration) || !(method = (AbstractMethodDeclaration)exceptionContext.associatedNode).isConstructor() || !method.binding.declaringClass.isAnonymousType()) break;
                    exceptionContext.mergeUnhandledException(raisedException);
                    return;
                }
            }
            traversedContext.recordReturnFrom(flowInfo.unconditionalInits());
            if (traversedContext.associatedNode instanceof TryStatement) {
                flowInfo = flowInfo.copy().addInitializationsFrom(((TryStatement)traversedContext.associatedNode).subRoutineInits);
            }
            traversedContext = traversedContext.parent;
        }
        scope.problemReporter().unhandledException(raisedException, location);
    }

    public Label continueLabel() {
        return null;
    }

    public FlowContext getTargetContextForBreakLabel(char[] labelName) {
        FlowContext current = this;
        FlowContext lastNonReturningSubRoutine = null;
        while (current != null) {
            char[] currentLabelName;
            if (current.isNonReturningContext()) {
                lastNonReturningSubRoutine = current;
            }
            if ((currentLabelName = current.labelName()) != null && CharOperation.equals(currentLabelName, labelName)) {
                if (lastNonReturningSubRoutine == null) {
                    return current;
                }
                return lastNonReturningSubRoutine;
            }
            current = current.parent;
        }
        return null;
    }

    public FlowContext getTargetContextForContinueLabel(char[] labelName) {
        FlowContext current = this;
        FlowContext lastContinuable = null;
        FlowContext lastNonReturningSubRoutine = null;
        while (current != null) {
            if (current.isNonReturningContext()) {
                lastNonReturningSubRoutine = current;
            } else if (current.isContinuable()) {
                lastContinuable = current;
            }
            char[] currentLabelName = current.labelName();
            if (currentLabelName != null && CharOperation.equals(currentLabelName, labelName)) {
                if (lastContinuable != null && current.associatedNode.concreteStatement() == lastContinuable.associatedNode) {
                    if (lastNonReturningSubRoutine == null) {
                        return lastContinuable;
                    }
                    return lastNonReturningSubRoutine;
                }
                return NotContinuableContext;
            }
            current = current.parent;
        }
        return null;
    }

    public FlowContext getTargetContextForDefaultBreak() {
        FlowContext current = this;
        FlowContext lastNonReturningSubRoutine = null;
        while (current != null) {
            if (current.isNonReturningContext()) {
                lastNonReturningSubRoutine = current;
            }
            if (current.isBreakable() && current.labelName() == null) {
                if (lastNonReturningSubRoutine == null) {
                    return current;
                }
                return lastNonReturningSubRoutine;
            }
            current = current.parent;
        }
        return null;
    }

    public FlowContext getTargetContextForDefaultContinue() {
        FlowContext current = this;
        FlowContext lastNonReturningSubRoutine = null;
        while (current != null) {
            if (current.isNonReturningContext()) {
                lastNonReturningSubRoutine = current;
            }
            if (current.isContinuable()) {
                if (lastNonReturningSubRoutine == null) {
                    return current;
                }
                return lastNonReturningSubRoutine;
            }
            current = current.parent;
        }
        return null;
    }

    public String individualToString() {
        return "Flow context";
    }

    public FlowInfo initsOnBreak() {
        return FlowInfo.DEAD_END;
    }

    public UnconditionalFlowInfo initsOnReturn() {
        return FlowInfo.DEAD_END;
    }

    public boolean isBreakable() {
        return false;
    }

    public boolean isContinuable() {
        return false;
    }

    public boolean isNonReturningContext() {
        return false;
    }

    public boolean isSubRoutine() {
        return false;
    }

    public char[] labelName() {
        return null;
    }

    public void recordBreakFrom(FlowInfo flowInfo) {
    }

    public void recordContinueFrom(FlowInfo flowInfo) {
    }

    boolean recordFinalAssignment(VariableBinding variable, Reference finalReference) {
        return true;
    }

    public void recordReturnFrom(FlowInfo flowInfo) {
    }

    public void recordSettingFinal(VariableBinding variable, Reference finalReference, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        FlowContext context = this;
        while (context != null && context.recordFinalAssignment(variable, finalReference)) {
            context = context.parent;
        }
    }

    void removeFinalAssignmentIfAny(Reference reference) {
    }

    public SubRoutineStatement subRoutine() {
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        FlowContext current = this;
        int parentsCount = 0;
        while ((current = current.parent) != null) {
            ++parentsCount;
        }
        FlowContext[] parents = new FlowContext[parentsCount + 1];
        current = this;
        int index = parentsCount;
        while (index >= 0) {
            parents[index--] = current;
            current = current.parent;
        }
        for (int i = 0; i < parentsCount; ++i) {
            for (int j = 0; j < i; ++j) {
                buffer.append('\t');
            }
            buffer.append(parents[i].individualToString()).append('\n');
        }
        buffer.append('*');
        for (int j = 0; j < parentsCount + 1; ++j) {
            buffer.append('\t');
        }
        buffer.append(this.individualToString()).append('\n');
        return buffer.toString();
    }
}

