/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.IProjectSetSerializer;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.Policy;

public abstract class ProjectSetCapability {
    private IProjectSetSerializer serializer;

    public static void ensureBackwardsCompatible(RepositoryProviderType type, ProjectSetCapability capability) {
        IProjectSetSerializer oldSerializer;
        if (capability != null && (oldSerializer = Team.getProjectSetSerializer(type.getID())) != null) {
            capability.setSerializer(oldSerializer);
        }
    }

    public void projectSetCreated(File file, Object context, IProgressMonitor monitor) {
    }

    public void projectSetCreated(File file, ProjectSetSerializationContext context, IProgressMonitor monitor) {
        this.projectSetCreated(file, context.getShell(), monitor);
    }

    public String[] asReference(IProject[] providerProjects, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        if (this.serializer != null) {
            return this.serializer.asReference(providerProjects, context.getShell(), monitor);
        }
        throw new TeamException(Policy.bind("ProjectSetCapability.0"));
    }

    public IProject[] addToWorkspace(String[] referenceStrings, ProjectSetSerializationContext context, IProgressMonitor monitor) throws TeamException {
        if (this.serializer != null) {
            return this.serializer.addToWorkspace(referenceStrings, context.getFilename(), context.getShell(), monitor);
        }
        throw new TeamException(Policy.bind("ProjectSetCapability.1"));
    }

    protected IProject[] confirmOverwrite(ProjectSetSerializationContext context, IProject[] projects) throws TeamException {
        ArrayList<IProject> existingProjects = new ArrayList<IProject>();
        for (int i = 0; i < projects.length; ++i) {
            IProject eachProj = projects[i];
            if (!eachProj.exists()) continue;
            existingProjects.add(eachProj);
        }
        if (existingProjects.size() == 0) {
            return projects;
        }
        IProject[] confirmed = context.confirmOverwrite(existingProjects.toArray(new IProject[existingProjects.size()]));
        if (confirmed == null) {
            return null;
        }
        if (existingProjects.size() == confirmed.length) {
            return projects;
        }
        ArrayList<IProject> result = new ArrayList<IProject>(projects.length);
        result.addAll(Arrays.asList(projects));
        result.removeAll(existingProjects);
        for (int i = 0; i < confirmed.length; ++i) {
            IProject eachProj = confirmed[i];
            if (!existingProjects.contains(eachProj)) continue;
            result.add(eachProj);
        }
        return result.toArray(new IProject[result.size()]);
    }

    void setSerializer(IProjectSetSerializer serializer) {
        this.serializer = serializer;
    }
}

