/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public abstract class RegistryManager
implements IRegistryChangeListener {
    private String elementId;
    private String extPtId;
    private HashMap cache;
    public static final int REGISTRY_CACHE_STATE_UNKNOWN = 0;
    public static final int REGISTRY_CACHE_STATE_ACTIVE = 1;
    public static final int REGISTRY_CACHE_STATE_DELETED = 2;
    public static final int REGISTRY_CACHE_STATE_MAX = 2;
    public static final String INTERNAL_REGISTRY_ADDITION = "InternalRegistryAddition";

    public RegistryManager(String elementId, String extPtId) {
        this.elementId = elementId;
        this.extPtId = extPtId;
        this.cache = new HashMap();
    }

    public RegistryManager getCache() {
        return this;
    }

    public Object[] getRegistryObjects() {
        Object[] regElements = this.cache.values().toArray();
        if (regElements.length == 0) {
            return null;
        }
        ArrayList retList = new ArrayList();
        for (int i = 0; i < regElements.length; ++i) {
            ArrayList listElement = ((RegistryElement)regElements[i]).getRealObjects();
            if (listElement == null) continue;
            ListIterator iter = listElement.listIterator();
            while (iter.hasNext()) {
                retList.add(iter.next());
            }
        }
        retList.trimToSize();
        Object[] ret = retList.toArray();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registryChanged(IRegistryChangeEvent event) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        int numDeltas = 0;
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        try {
            IExtensionDelta[] delta = event.getExtensionDeltas(this.elementId, this.extPtId);
            numDeltas = delta.length;
            for (int i = 0; i < numDeltas; ++i) {
                this.doAdd(display, delta[i]);
            }
        }
        finally {
            if (numDeltas > 0) {
                this.postChangeProcessing();
            }
        }
    }

    private void doAdd(Display display, final IExtensionDelta delta) {
        Runnable run = new Runnable(){

            public void run() {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                RegistryManager.this.add(delta);
            }
        };
        display.syncExec(run);
    }

    public void add(IExtensionDelta delta) {
        IExtensionPoint extPt = delta.getExtensionPoint();
        IExtension ext = delta.getExtension();
        String pluginId = ext.getNamespace();
        this.add(this.buildNewCacheObject(delta), pluginId);
    }

    public void add(Object element, String pluginId) {
        RegistryElement regElement;
        if (element == null) {
            return;
        }
        String toUsePluginId = pluginId;
        if (pluginId == null || pluginId.length() == 0) {
            toUsePluginId = INTERNAL_REGISTRY_ADDITION;
        }
        if ((regElement = (RegistryElement)this.cache.get(toUsePluginId)) == null) {
            regElement = new RegistryElement(element);
            this.cache.put(toUsePluginId, regElement);
        } else {
            regElement.addNewObject(element);
        }
    }

    public abstract Object buildNewCacheObject(IExtensionDelta var1);

    public abstract void postChangeProcessing();

    public void remove(String[] plugins) {
        for (int i = 0; i < plugins.length; ++i) {
            this.remove(plugins[i]);
        }
    }

    public void remove(String pluginId) {
        RegistryElement element = (RegistryElement)this.cache.get(pluginId);
        if (element != null) {
            element.changeState(2);
        }
    }

    public void remove(String pluginId, Object object) {
        RegistryElement element;
        if (pluginId == null) {
            pluginId = INTERNAL_REGISTRY_ADDITION;
        }
        if ((element = (RegistryElement)this.cache.get(pluginId)) != null) {
            ArrayList realObjects = element.getRealObjects();
            realObjects.remove(object);
        }
    }

    public void cleanRegistry() {
        Set elements = this.cache.keySet();
        HashSet keysToRemove = new HashSet();
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object pluginId = iter.next();
            RegistryElement elem = (RegistryElement)this.cache.get(pluginId);
            if (elem == null || elem.state != 2) continue;
            keysToRemove.add(pluginId);
        }
        Iterator removeIterator = keysToRemove.iterator();
        while (removeIterator.hasNext()) {
            this.cache.remove(removeIterator.next());
        }
    }

    private class RegistryElement {
        private int state = 0;
        private ArrayList realObjects = null;

        public RegistryElement(Object obj) {
            if (this.realObjects == null) {
                this.realObjects = new ArrayList();
            }
            this.realObjects.add(obj);
        }

        public void addNewObject(Object obj) {
            if (this.realObjects == null) {
                this.realObjects = new ArrayList();
            }
            this.realObjects.add(obj);
        }

        public void changeState(int newState) {
            if (newState > 0 && newState <= 2) {
                this.state = newState;
            }
        }

        public ArrayList getRealObjects() {
            return this.realObjects;
        }
    }
}

