/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.layout.SizeCache;

public class LayoutCache {
    private SizeCache[] caches = new SizeCache[0];

    public LayoutCache() {
    }

    public LayoutCache(Control[] controls) {
        this.rebuildCache(controls);
    }

    public SizeCache getCache(int idx) {
        return this.caches[idx];
    }

    public void setControls(Control[] controls) {
        if (controls.length != this.caches.length) {
            this.rebuildCache(controls);
            return;
        }
        for (int idx = 0; idx < controls.length; ++idx) {
            this.caches[idx].setControl(controls[idx]);
        }
    }

    private void rebuildCache(Control[] controls) {
        SizeCache[] newCache = new SizeCache[controls.length];
        for (int idx = 0; idx < controls.length; ++idx) {
            if (idx < this.caches.length) {
                newCache[idx] = this.caches[idx];
                newCache[idx].setControl(controls[idx]);
                continue;
            }
            newCache[idx] = new SizeCache(controls[idx]);
        }
        this.caches = newCache;
    }

    public Point computeSize(int controlIndex, int widthHint, int heightHint) {
        return this.caches[controlIndex].computeSize(widthHint, heightHint);
    }

    public void flush(int controlIndex) {
        this.caches[controlIndex].flush();
    }

    public void flush() {
        for (int idx = 0; idx < this.caches.length; ++idx) {
            this.caches[idx].flush();
        }
    }
}

