/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.WorkbenchMessages;

public class RectangleAnimation
extends Job {
    private static final int LINE_WIDTH = 2;
    private Rectangle start;
    private int elapsed;
    private int duration;
    private long startTime = 0L;
    private Rectangle end;
    private boolean done = false;
    private Shell theShell;
    private Display display;
    private Region shellRegion;
    private boolean first = true;
    private Runnable paintJob = new Runnable(){

        public void run() {
            if (RectangleAnimation.this.startTime == 0L) {
                RectangleAnimation.this.startTime = System.currentTimeMillis();
            }
            if (RectangleAnimation.this.theShell == null || RectangleAnimation.this.theShell.isDisposed()) {
                RectangleAnimation.this.done = true;
                return;
            }
            long currentTime = System.currentTimeMillis();
            double amount = (double)(currentTime - RectangleAnimation.this.startTime) / (double)RectangleAnimation.this.duration;
            if (amount > 1.0) {
                amount = 1.0;
                RectangleAnimation.this.done = true;
            }
            Rectangle toPaint = RectangleAnimation.interpolate(RectangleAnimation.this.start, RectangleAnimation.this.end, amount);
            RectangleAnimation.this.theShell.setBounds(toPaint);
            if (RectangleAnimation.this.shellRegion != null) {
                RectangleAnimation.this.shellRegion.dispose();
                RectangleAnimation.this.shellRegion = new Region((Device)RectangleAnimation.this.display);
            }
            Rectangle rect = RectangleAnimation.this.theShell.getClientArea();
            RectangleAnimation.this.shellRegion.add(rect);
            rect.x += 2;
            rect.y += 2;
            rect.width = Math.max(0, rect.width - 4);
            rect.height = Math.max(0, rect.height - 4);
            RectangleAnimation.this.shellRegion.subtract(rect);
            RectangleAnimation.this.theShell.setRegion(RectangleAnimation.this.shellRegion);
            RectangleAnimation.this.display.update();
            if (RectangleAnimation.this.first) {
                RectangleAnimation.this.theShell.setVisible(true);
            }
            RectangleAnimation.this.first = false;
        }
    };

    private static Rectangle interpolate(Rectangle start, Rectangle end, double amount) {
        double initialWeight = 1.0 - amount;
        Rectangle result = new Rectangle((int)((double)start.x * initialWeight + (double)end.x * amount), (int)((double)start.y * initialWeight + (double)end.y * amount), (int)((double)start.width * initialWeight + (double)end.width * amount), (int)((double)start.height * initialWeight + (double)end.height * amount));
        return result;
    }

    public RectangleAnimation(Shell parentShell, Rectangle start, Rectangle end) {
        this(parentShell, start, end, 400);
    }

    public RectangleAnimation(Shell parentShell, Rectangle start, Rectangle end, int duration) {
        super(WorkbenchMessages.getString("RectangleAnimation.Animating_Rectangle"));
        this.duration = duration;
        this.start = start;
        this.end = end;
        this.display = parentShell.getDisplay();
        this.setSystem(true);
        this.theShell = new Shell(parentShell, 16392);
        Color color = this.display.getSystemColor(21);
        this.theShell.setBackground(color);
        this.theShell.setBounds(start);
        this.shellRegion = new Region((Device)this.display);
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.theShell == null) {
            return Status.OK_STATUS;
        }
        this.startTime = 0L;
        while (!this.done) {
            if (this.theShell.isDisposed()) continue;
            this.display.syncExec(this.paintJob);
            Thread.yield();
        }
        if (!this.theShell.isDisposed()) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    RectangleAnimation.this.theShell.dispose();
                }
            });
        }
        if (!this.shellRegion.isDisposed()) {
            this.display.syncExec(new Runnable(){

                public void run() {
                    RectangleAnimation.this.shellRegion.dispose();
                }
            });
        }
        return Status.OK_STATUS;
    }
}

