/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.LayoutTree;
import org.eclipse.ui.internal.LayoutTreeNode;
import org.eclipse.ui.internal.PartSashContainer;

class LayoutPartSash
extends LayoutPart {
    private Sash sash;
    private PartSashContainer rootContainer;
    private int style;
    private LayoutPartSash preLimit;
    private LayoutPartSash postLimit;
    SelectionListener selectionListener;
    private int left = 300;
    private int right = 300;
    private float minRatio;
    private float maxRatio;

    LayoutPartSash(PartSashContainer rootContainer, int style) {
        super(null);
        this.style = style;
        this.rootContainer = rootContainer;
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 1) {
                    LayoutPartSash.this.checkDragLimit(e);
                } else {
                    LayoutPartSash.this.widgetSelected(e.x, e.y, e.width, e.height);
                }
            }
        };
        this.initDragRatios();
    }

    private void checkDragLimit(SelectionEvent event) {
        LayoutTree root = this.rootContainer.getLayoutTree();
        LayoutTreeNode node = root.findSash(this);
        Rectangle nodeBounds = node.getBounds();
        if (this.minRatio < 0.0f) {
            this.minRatio = node.getMinimumRatioFor(nodeBounds);
        }
        if (this.maxRatio < 0.0f) {
            this.maxRatio = node.getMaximumRatioFor(nodeBounds);
        }
        if (this.style == 512) {
            float width;
            if (event.x < nodeBounds.x) {
                event.x = nodeBounds.x;
            }
            if (event.x + event.width > nodeBounds.x + nodeBounds.width) {
                event.x = nodeBounds.x + nodeBounds.width - event.width;
            }
            if ((float)(event.x - nodeBounds.x) < (width = (float)nodeBounds.width) * this.minRatio) {
                event.x = nodeBounds.x + (int)(width * this.minRatio);
            }
            if ((float)(event.x - nodeBounds.x) > width * this.maxRatio) {
                event.x = nodeBounds.x + (int)(width * this.maxRatio);
            }
        } else {
            float height;
            if (event.y < nodeBounds.y) {
                event.y = nodeBounds.y;
            }
            if (event.y + event.height > nodeBounds.y + nodeBounds.height) {
                event.y = nodeBounds.y + nodeBounds.height - event.height;
            }
            if ((float)(event.y - nodeBounds.y) < (height = (float)nodeBounds.height) * this.minRatio) {
                event.y = nodeBounds.y + (int)(height * this.minRatio);
            }
            if ((float)(event.y - nodeBounds.y) > height * this.maxRatio) {
                event.y = nodeBounds.y + (int)(height * this.maxRatio);
            }
        }
    }

    public void createControl(Composite parent) {
        if (this.sash == null) {
            this.sash = new Sash(parent, this.style);
            this.sash.addSelectionListener(this.selectionListener);
        }
    }

    public void dispose() {
        if (this.sash != null) {
            this.sash.dispose();
        }
        this.sash = null;
    }

    public Rectangle getBounds() {
        if (this.sash == null) {
            return super.getBounds();
        }
        return this.sash.getBounds();
    }

    public Control getControl() {
        return this.sash;
    }

    public String getID() {
        return null;
    }

    LayoutPartSash getPostLimit() {
        return this.postLimit;
    }

    LayoutPartSash getPreLimit() {
        return this.preLimit;
    }

    int getLeft() {
        return this.left;
    }

    int getRight() {
        return this.right;
    }

    boolean isHorizontal() {
        return (this.style & 0x100) == 256;
    }

    boolean isVertical() {
        return (this.style & 0x200) == 512;
    }

    void setPostLimit(LayoutPartSash newPostLimit) {
        this.postLimit = newPostLimit;
    }

    void setPreLimit(LayoutPartSash newPreLimit) {
        this.preLimit = newPreLimit;
    }

    void setRatio(float newRatio) {
        int total = this.left + this.right;
        this.left = (int)((float)total * newRatio);
        this.right = total - this.left;
    }

    void setSizes(int left, int right) {
        this.left = left;
        this.right = right;
    }

    private void widgetSelected(int x, int y, int width, int height) {
        LayoutTree root = this.rootContainer.getLayoutTree();
        LayoutTreeNode node = root.findSash(this);
        Rectangle nodeBounds = node.getBounds();
        x -= nodeBounds.x;
        y -= nodeBounds.y;
        if (this.style == 512) {
            this.setSizes(x, nodeBounds.width - x - 3);
        } else {
            this.setSizes(y, nodeBounds.height - y - 3);
        }
        node.setBounds(nodeBounds);
        this.initDragRatios();
    }

    private void initDragRatios() {
        this.maxRatio = -1.0f;
        this.minRatio = -1.0f;
    }
}

