/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.nls.NLSRefactoring;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.nls.ExternalizeWizard;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.help.WorkbenchHelp;

public class ExternalizeStringsAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public ExternalizeStringsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.getString("ExternalizeStringsAction.label"));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.jdt.ui.externalize_strings_action");
    }

    public ExternalizeStringsAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.checkEnabledEditor());
    }

    public void selectionChanged(ITextSelection selection) {
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor);
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(ExternalizeStringsAction.canEnable(selection));
    }

    private static boolean canEnable(IStructuredSelection selection) {
        return NLSRefactoring.isAvailable(ExternalizeStringsAction.getCompilationUnit(selection));
    }

    public void run(ITextSelection selection) {
        IJavaElement element = SelectionConverter.getInput(this.fEditor);
        if (!(element instanceof ICompilationUnit)) {
            return;
        }
        this.run((ICompilationUnit)element);
    }

    public void run(IStructuredSelection selection) {
        if (ExternalizeStringsAction.canEnable(selection)) {
            this.run(ExternalizeStringsAction.getCompilationUnit(selection));
        }
    }

    public void run(final ICompilationUnit unit) {
        if (!ActionUtil.isProcessable(this.getShell(), unit)) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    ExternalizeStringsAction.openExternalizeStringsWizard(ExternalizeStringsAction.this.getShell(), unit);
                }
                catch (JavaModelException e) {
                    ExceptionHandler.handle((CoreException)((Object)e), ExternalizeStringsAction.this.getShell(), ExternalizeStringsAction.getDialogTitle(), ActionMessages.getString("ExternalizeStringsAction.dialog.message"));
                }
            }
        });
    }

    private static ICompilationUnit getCompilationUnit(IStructuredSelection selection) {
        if (selection.isEmpty() || selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (first instanceof ICompilationUnit) {
            return (ICompilationUnit)first;
        }
        if (first instanceof IType) {
            return ((IType)first).getCompilationUnit();
        }
        return null;
    }

    private static NLSRefactoring createNewRefactoringInstance(ICompilationUnit cu) {
        return NLSRefactoring.create(cu);
    }

    static void openExternalizeStringsWizard(Shell parentShell, ICompilationUnit unit) throws JavaModelException {
        if (!NLSRefactoring.isAvailable(unit)) {
            return;
        }
        NLSRefactoring refactoring = ExternalizeStringsAction.createNewRefactoringInstance(unit);
        if (refactoring == null) {
            return;
        }
        ExternalizeWizard wizard = new ExternalizeWizard(refactoring);
        new RefactoringStarter().activate(refactoring, wizard, parentShell, ExternalizeStringsAction.getDialogTitle(), true);
    }

    private static String getDialogTitle() {
        return ActionMessages.getString("ExternalizeStringsAction.dialog.title");
    }
}

