/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;

public class BuildPathSupport {
    private BuildPathSupport() {
    }

    public static IPath guessSourceAttachment(CPListElement elem) {
        if (elem.getEntryKind() == 5) {
            return null;
        }
        IJavaProject currProject = elem.getJavaProject();
        try {
            IJavaModel jmodel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            IJavaProject[] jprojects = jmodel.getJavaProjects();
            for (int i = 0; i < jprojects.length; ++i) {
                IJavaProject curr = jprojects[i];
                if (curr.equals(currProject)) continue;
                IClasspathEntry[] entries = curr.getRawClasspath();
                for (int k = 0; k < entries.length; ++k) {
                    IPath attachPath;
                    IClasspathEntry entry = entries[k];
                    if (entry.getEntryKind() != elem.getEntryKind() || !entry.getPath().equals(elem.getPath()) || (attachPath = entry.getSourceAttachmentPath()) == null || attachPath.isEmpty()) continue;
                    return attachPath;
                }
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e.getStatus());
        }
        return null;
    }
}

