/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.ClassPathDetector;
import org.eclipse.jdt.internal.ui.wizards.JavaProjectWizardFirstPage;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.JavaCapabilityConfigurationPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

public class JavaProjectWizardSecondPage
extends JavaCapabilityConfigurationPage {
    private final JavaProjectWizardFirstPage fFirstPage;
    protected IPath fCurrProjectLocation;
    protected IProject fCurrProject;
    protected boolean fKeepContent;

    public JavaProjectWizardSecondPage(JavaProjectWizardFirstPage mainPage) {
        this.fFirstPage = mainPage;
        this.fCurrProjectLocation = null;
        this.fCurrProject = null;
        this.fKeepContent = true;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.changeToNewProject();
        } else {
            this.removeProject();
        }
        super.setVisible(visible);
    }

    private void changeToNewProject() {
        IProject newProjectHandle = this.fFirstPage.getProjectHandle();
        IPath newProjectLocation = this.fFirstPage.getLocationPath();
        this.fKeepContent = this.fFirstPage.getDetect();
        final boolean initialize = !newProjectHandle.equals(this.fCurrProject) || !newProjectLocation.equals(this.fCurrProjectLocation);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    JavaProjectWizardSecondPage.this.updateProject(initialize, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
                catch (OperationCanceledException e) {
                    throw new InterruptedException();
                }
            }
        };
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.getString("JavaProjectWizardSecondPage.error.title");
            String message = NewWizardMessages.getString("JavaProjectWizardSecondPage.error.message");
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateProject(boolean initialize, IProgressMonitor monitor) throws CoreException {
        boolean noProgressMonitor;
        this.fCurrProject = this.fFirstPage.getProjectHandle();
        this.fCurrProjectLocation = this.fFirstPage.getLocationPath();
        boolean bl = noProgressMonitor = !initialize && !this.fFirstPage.getDetect();
        if (monitor == null || noProgressMonitor) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.getString("JavaProjectWizardSecondPage.operation.initialize"), 2);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            JavaProjectWizardSecondPage.createProject(this.fCurrProject, this.fCurrProjectLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (initialize) {
                IClasspathEntry[] entries = null;
                IPath outputLocation = null;
                if (this.fFirstPage.getDetect()) {
                    if (!this.fCurrProject.getFile(".classpath").exists()) {
                        ClassPathDetector detector = new ClassPathDetector(this.fCurrProject);
                        entries = detector.getClasspath();
                        outputLocation = detector.getOutputLocation();
                    }
                } else if (this.fFirstPage.isSrcBin()) {
                    IFolder folder;
                    IPreferenceStore store = PreferenceConstants.getPreferenceStore();
                    Path srcPath = new Path(store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName"));
                    Path binPath = new Path(store.getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName"));
                    if (srcPath.segmentCount() > 0) {
                        folder = this.fCurrProject.getFolder((IPath)srcPath);
                        CoreUtility.createFolder(folder, true, true, null);
                    }
                    if (binPath.segmentCount() > 0 && !binPath.equals(srcPath)) {
                        folder = this.fCurrProject.getFolder((IPath)binPath);
                        CoreUtility.createFolder(folder, true, true, null);
                    }
                    IPath projectPath = this.fCurrProject.getFullPath();
                    ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
                    cpEntries.add(JavaCore.newSourceEntry((IPath)projectPath.append((IPath)srcPath)));
                    cpEntries.addAll(Arrays.asList(PreferenceConstants.getDefaultJRELibrary()));
                    entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
                    outputLocation = projectPath.append((IPath)binPath);
                } else {
                    IPath projectPath = this.fCurrProject.getFullPath();
                    ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
                    cpEntries.add(JavaCore.newSourceEntry((IPath)projectPath));
                    cpEntries.addAll(Arrays.asList(PreferenceConstants.getDefaultJRELibrary()));
                    entries = cpEntries.toArray(new IClasspathEntry[cpEntries.size()]);
                    outputLocation = projectPath;
                }
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                this.init(JavaCore.create((IProject)this.fCurrProject), outputLocation, entries, false);
            }
            monitor.worked(1);
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            monitor.beginTask(NewWizardMessages.getString("JavaProjectWizardSecondPage.operation.create"), 3);
            if (this.fCurrProject == null) {
                this.updateProject(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
        }
    }

    private void removeProject() {
        if (this.fCurrProject == null || !this.fCurrProject.exists()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                boolean noProgressMonitor = Platform.getLocation().equals(JavaProjectWizardSecondPage.this.fCurrProjectLocation);
                if (monitor == null || noProgressMonitor) {
                    monitor = new NullProgressMonitor();
                }
                monitor.beginTask(NewWizardMessages.getString("JavaProjectWizardSecondPage.operation.remove"), 3);
                try {
                    try {
                        boolean removeContent = !JavaProjectWizardSecondPage.this.fKeepContent && JavaProjectWizardSecondPage.this.fCurrProject.isSynchronized(2);
                        JavaProjectWizardSecondPage.this.fCurrProject.delete(removeContent, false, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    Object var5_5 = null;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    monitor.done();
                    JavaProjectWizardSecondPage.this.fCurrProject = null;
                    JavaProjectWizardSecondPage.this.fKeepContent = false;
                    throw throwable;
                }
                monitor.done();
                JavaProjectWizardSecondPage.this.fCurrProject = null;
                JavaProjectWizardSecondPage.this.fKeepContent = false;
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.getString("JavaProjectWizardSecondPage.error.remove.title");
            String message = NewWizardMessages.getString("JavaProjectWizardSecondPage.error.remove.message");
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void performCancel() {
        this.removeProject();
    }
}

