/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.folding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.ClassFileEditor;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.text.folding.IJavaFoldingStructureProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class DefaultJavaFoldingStructureProvider
implements IProjectionListener,
IJavaFoldingStructureProvider {
    private IDocument fCachedDocument;
    private ITextEditor fEditor;
    private ProjectionViewer fViewer;
    private IJavaElement fInput;
    private IElementChangedListener fElementListener;
    private boolean fAllowCollapsing = false;
    private boolean fCollapseJavadoc = false;
    private boolean fCollapseImportContainer = true;
    private boolean fCollapseInnerTypes = true;
    private boolean fCollapseMethods = false;
    static /* synthetic */ Class class$org$eclipse$jface$text$source$projection$ProjectionAnnotationModel;

    public void install(ITextEditor editor, ProjectionViewer viewer) {
        if (editor instanceof JavaEditor) {
            this.fEditor = editor;
            this.fViewer = viewer;
            this.fViewer.addProjectionListener((IProjectionListener)this);
        }
    }

    public void uninstall() {
        if (this.isInstalled()) {
            this.projectionDisabled();
            this.fViewer.removeProjectionListener((IProjectionListener)this);
            this.fViewer = null;
            this.fEditor = null;
        }
    }

    protected boolean isInstalled() {
        return this.fEditor != null;
    }

    public void projectionEnabled() {
        this.projectionDisabled();
        if (this.fEditor instanceof JavaEditor) {
            this.initialize();
            this.fElementListener = new ElementChangedListener();
            JavaCore.addElementChangedListener((IElementChangedListener)this.fElementListener);
        }
    }

    public void projectionDisabled() {
        this.fCachedDocument = null;
        if (this.fElementListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fElementListener);
            this.fElementListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        block13: {
            if (!this.isInstalled()) {
                return;
            }
            this.initializePreferences();
            try {
                ProjectionAnnotationModel model;
                IDocumentProvider provider = this.fEditor.getDocumentProvider();
                this.fCachedDocument = provider.getDocument((Object)this.fEditor.getEditorInput());
                this.fAllowCollapsing = true;
                if (this.fEditor instanceof CompilationUnitEditor) {
                    IWorkingCopyManager manager = JavaPlugin.getDefault().getWorkingCopyManager();
                    this.fInput = manager.getWorkingCopy(this.fEditor.getEditorInput());
                } else if (this.fEditor instanceof ClassFileEditor) {
                    IClassFileEditorInput editorInput = (IClassFileEditorInput)this.fEditor.getEditorInput();
                    this.fInput = editorInput.getClassFile();
                }
                if (this.fInput == null || (model = (ProjectionAnnotationModel)this.fEditor.getAdapter(class$org$eclipse$jface$text$source$projection$ProjectionAnnotationModel == null ? (class$org$eclipse$jface$text$source$projection$ProjectionAnnotationModel = DefaultJavaFoldingStructureProvider.class$("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel")) : class$org$eclipse$jface$text$source$projection$ProjectionAnnotationModel)) == null) break block13;
                if (this.fInput instanceof ICompilationUnit) {
                    ICompilationUnit unit;
                    ICompilationUnit iCompilationUnit = unit = (ICompilationUnit)this.fInput;
                    synchronized (iCompilationUnit) {
                        try {
                            unit.reconcile(0, false, null, null);
                        }
                        catch (JavaModelException x) {
                            // empty catch block
                        }
                    }
                }
                Map additions = this.computeAdditions((IParent)this.fInput);
                model.removeAllAnnotations();
                model.replaceAnnotations(null, additions);
            }
            finally {
                this.fCachedDocument = null;
                this.fAllowCollapsing = false;
            }
        }
    }

    private void initializePreferences() {
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        this.fCollapseInnerTypes = store.getBoolean("editor_folding_default_innertypes");
        this.fCollapseImportContainer = store.getBoolean("editor_folding_default_imports");
        this.fCollapseJavadoc = store.getBoolean("editor_folding_default_javadoc");
        this.fCollapseMethods = store.getBoolean("editor_folding_default_methods");
    }

    private Map computeAdditions(IParent parent) {
        HashMap map = new HashMap();
        try {
            this.computeAdditions(parent.getChildren(), map);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return map;
    }

    private void computeAdditions(IJavaElement[] elements, Map map) throws JavaModelException {
        for (int i = 0; i < elements.length; ++i) {
            IJavaElement element = elements[i];
            this.computeAdditions(element, map);
            if (!(element instanceof IParent)) continue;
            IParent parent = (IParent)element;
            this.computeAdditions(parent.getChildren(), map);
        }
    }

    private void computeAdditions(IJavaElement element, Map map) {
        IRegion[] regions;
        boolean createProjection = false;
        boolean collapse = false;
        switch (element.getElementType()) {
            case 12: {
                collapse = this.fAllowCollapsing && this.fCollapseImportContainer;
                createProjection = true;
                break;
            }
            case 7: {
                collapse = this.fAllowCollapsing && this.fCollapseInnerTypes && this.isInnerType((IType)element);
                createProjection = true;
                break;
            }
            case 9: {
                collapse = this.fAllowCollapsing && this.fCollapseMethods;
                createProjection = true;
            }
        }
        if (createProjection && (regions = this.computeProjectionRanges(element)) != null) {
            for (int i = 0; i < regions.length - 1; ++i) {
                Position position = this.createProjectionPosition(regions[i]);
                if (position == null) continue;
                map.put(new JavaProjectionAnnotation(element, this.fAllowCollapsing && this.fCollapseJavadoc, true), position);
            }
            Position position = this.createProjectionPosition(regions[regions.length - 1]);
            if (position != null) {
                map.put(new JavaProjectionAnnotation(element, collapse, false), position);
            }
        }
    }

    private boolean isInnerType(IType type) {
        try {
            return type.isMember();
        }
        catch (JavaModelException x) {
            IJavaElement parent = type.getParent();
            if (parent != null) {
                int parentType = parent.getElementType();
                return parentType != 5 && parentType != 6;
            }
            return false;
        }
    }

    private IRegion[] computeProjectionRanges(IJavaElement element) {
        try {
            if (element instanceof ISourceReference) {
                int shift;
                ISourceReference reference = (ISourceReference)element;
                ISourceRange range = reference.getSourceRange();
                String contents = reference.getSource();
                if (contents == null) {
                    return null;
                }
                IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
                scanner.setSource(contents.toCharArray());
                ArrayList<Region> regions = new ArrayList<Region>();
                int start = shift = range.getOffset();
                block7: while (true) {
                    int token = scanner.getNextToken();
                    start = shift + scanner.getCurrentTokenStartPosition();
                    switch (token) {
                        case 1002: 
                        case 1003: {
                            int end = shift + scanner.getCurrentTokenEndPosition() + 1;
                            regions.add(new Region(start, end - start));
                        }
                        case 1001: {
                            continue block7;
                        }
                    }
                    break;
                }
                regions.add(new Region(start, range.getOffset() + range.getLength() - start));
                if (regions.size() > 0) {
                    IRegion[] result = new IRegion[regions.size()];
                    regions.toArray(result);
                    return result;
                }
            }
        }
        catch (JavaModelException e) {
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        return null;
    }

    private Position createProjectionPosition(IRegion region) {
        if (this.fCachedDocument == null) {
            return null;
        }
        try {
            int start = this.fCachedDocument.getLineOfOffset(region.getOffset());
            int end = this.fCachedDocument.getLineOfOffset(region.getOffset() + region.getLength());
            if (start != end) {
                int offset = this.fCachedDocument.getLineOffset(start);
                int endOffset = this.fCachedDocument.getLineOffset(end + 1);
                return new Position(offset, endOffset - offset);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processDelta(IJavaElementDelta delta) {
        if (!this.isInstalled()) {
            return;
        }
        ProjectionAnnotationModel model = (ProjectionAnnotationModel)this.fEditor.getAdapter(class$org$eclipse$jface$text$source$projection$ProjectionAnnotationModel == null ? (class$org$eclipse$jface$text$source$projection$ProjectionAnnotationModel = DefaultJavaFoldingStructureProvider.class$("org.eclipse.jface.text.source.projection.ProjectionAnnotationModel")) : class$org$eclipse$jface$text$source$projection$ProjectionAnnotationModel);
        if (model == null) {
            return;
        }
        try {
            IDocumentProvider provider = this.fEditor.getDocumentProvider();
            this.fCachedDocument = provider.getDocument((Object)this.fEditor.getEditorInput());
            this.fAllowCollapsing = false;
            HashMap<JavaProjectionAnnotation, Position> additions = new HashMap<JavaProjectionAnnotation, Position>();
            ArrayList deletions = new ArrayList();
            ArrayList<JavaProjectionAnnotation> updates = new ArrayList<JavaProjectionAnnotation>();
            Map updated = this.computeAdditions((IParent)this.fInput);
            Map previous = this.createAnnotationMap((IAnnotationModel)model);
            Iterator<Object> e = updated.keySet().iterator();
            while (e.hasNext()) {
                JavaProjectionAnnotation annotation = (JavaProjectionAnnotation)((Object)e.next());
                IJavaElement element = annotation.getElement();
                Position position = (Position)updated.get((Object)annotation);
                List annotations = (List)previous.get(element);
                if (annotations == null) {
                    additions.put(annotation, position);
                    continue;
                }
                Iterator x = annotations.iterator();
                while (x.hasNext()) {
                    JavaProjectionAnnotation a = (JavaProjectionAnnotation)((Object)x.next());
                    if (annotation.isComment() != a.isComment()) continue;
                    Position p = model.getPosition((Annotation)a);
                    if (p != null && !position.equals((Object)p)) {
                        p.setOffset(position.getOffset());
                        p.setLength(position.getLength());
                        updates.add(a);
                    }
                    x.remove();
                    break;
                }
                if (!annotations.isEmpty()) continue;
                previous.remove(element);
            }
            e = previous.values().iterator();
            while (e.hasNext()) {
                List list = (List)e.next();
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    deletions.add(list.get(i));
                }
            }
            this.match(model, deletions, additions, updates);
            Annotation[] removals = new Annotation[deletions.size()];
            deletions.toArray(removals);
            Annotation[] changes = new Annotation[updates.size()];
            updates.toArray(changes);
            model.modifyAnnotations(removals, additions, changes);
        }
        finally {
            this.fCachedDocument = null;
            this.fAllowCollapsing = true;
        }
    }

    private void match(ProjectionAnnotationModel model, List deletions, Map additions, List changes) {
        if (deletions.isEmpty() || additions.isEmpty() && changes.isEmpty()) {
            return;
        }
        ArrayList<JavaProjectionAnnotation> newDeletions = new ArrayList<JavaProjectionAnnotation>();
        ArrayList<JavaProjectionAnnotation> newChanges = new ArrayList<JavaProjectionAnnotation>();
        Iterator deletionIterator = deletions.iterator();
        block0: while (deletionIterator.hasNext()) {
            JavaProjectionAnnotation deleted = (JavaProjectionAnnotation)((Object)deletionIterator.next());
            Position deletedPosition = model.getPosition((Annotation)deleted);
            if (deletedPosition == null) continue;
            Iterator changesIterator = changes.iterator();
            while (changesIterator.hasNext()) {
                Position changedPosition;
                JavaProjectionAnnotation changed = (JavaProjectionAnnotation)((Object)changesIterator.next());
                if (deleted.isComment() != changed.isComment() || (changedPosition = model.getPosition((Annotation)changed)) == null || deletedPosition.getOffset() != changedPosition.getOffset()) continue;
                deletedPosition.setLength(changedPosition.getLength());
                deleted.setElement(changed.getElement());
                deletionIterator.remove();
                newChanges.add(deleted);
                changesIterator.remove();
                newDeletions.add(changed);
                continue block0;
            }
            Iterator additionsIterator = additions.keySet().iterator();
            while (additionsIterator.hasNext()) {
                JavaProjectionAnnotation added = (JavaProjectionAnnotation)((Object)additionsIterator.next());
                if (deleted.isComment() != added.isComment()) continue;
                Position addedPosition = (Position)additions.get((Object)added);
                if (deletedPosition.getOffset() != addedPosition.getOffset()) continue;
                deletedPosition.setLength(addedPosition.getLength());
                deleted.setElement(added.getElement());
                deletionIterator.remove();
                newChanges.add(deleted);
                additionsIterator.remove();
                continue block0;
            }
        }
        deletions.addAll(newDeletions);
        changes.addAll(newChanges);
    }

    private Map createAnnotationMap(IAnnotationModel model) {
        HashMap<IJavaElement, ArrayList<JavaProjectionAnnotation>> map = new HashMap<IJavaElement, ArrayList<JavaProjectionAnnotation>>();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            Object annotation = e.next();
            if (!(annotation instanceof JavaProjectionAnnotation)) continue;
            JavaProjectionAnnotation java = (JavaProjectionAnnotation)((Object)annotation);
            ArrayList<JavaProjectionAnnotation> list = (ArrayList<JavaProjectionAnnotation>)map.get(java.getElement());
            if (list == null) {
                list = new ArrayList<JavaProjectionAnnotation>(2);
                map.put(java.getElement(), list);
            }
            list.add(java);
        }
        return map;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        private ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent e) {
            IJavaElementDelta delta = this.findElement(DefaultJavaFoldingStructureProvider.this.fInput, e.getDelta());
            if (delta != null) {
                DefaultJavaFoldingStructureProvider.this.processDelta(delta);
            }
        }

        private IJavaElementDelta findElement(IJavaElement target, IJavaElementDelta delta) {
            if (delta == null || target == null) {
                return null;
            }
            IJavaElement element = delta.getElement();
            if (element.getElementType() > 6) {
                return null;
            }
            if (target.equals(element)) {
                return delta;
            }
            IJavaElementDelta[] children = delta.getAffectedChildren();
            if (children == null || children.length == 0) {
                return null;
            }
            for (int i = 0; i < children.length; ++i) {
                IJavaElementDelta d = this.findElement(target, children[i]);
                if (d == null) continue;
                return d;
            }
            return null;
        }
    }

    private static class JavaProjectionAnnotation
    extends ProjectionAnnotation {
        private IJavaElement fJavaElement;
        private boolean fIsComment;

        public JavaProjectionAnnotation(IJavaElement element, boolean isCollapsed, boolean isComment) {
            super(isCollapsed);
            this.fJavaElement = element;
            this.fIsComment = isComment;
        }

        public IJavaElement getElement() {
            return this.fJavaElement;
        }

        public void setElement(IJavaElement element) {
            this.fJavaElement = element;
        }

        public boolean isComment() {
            return this.fIsComment;
        }

        public void setIsComment(boolean isComment) {
            this.fIsComment = isComment;
        }
    }
}

