/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ConcurrentModificationException;
import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.correction.AssistContext;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.internal.ui.viewsupport.ISelectionListenerWithAST;
import org.eclipse.jdt.internal.ui.viewsupport.SelectionListenerWithASTManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ITextEditor;

public class QuickAssistLightBulbUpdater {
    private final Annotation fAnnotation;
    private boolean fIsAnnotationShown;
    private ITextEditor fEditor;
    private ITextViewer fViewer;
    private ISelectionListenerWithAST fListener;
    private IPropertyChangeListener fPropertyChangeListener;
    static /* synthetic */ Class class$org$eclipse$jdt$core$IJavaElement;

    public QuickAssistLightBulbUpdater(ITextEditor part, ITextViewer viewer) {
        this.fEditor = part;
        this.fViewer = viewer;
        this.fAnnotation = new AssistAnnotation();
        this.fIsAnnotationShown = false;
        this.fPropertyChangeListener = null;
    }

    public boolean isSetInPreferences() {
        return PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.quickassist.lightbulb");
    }

    private void installSelectionListener() {
        this.fListener = new ISelectionListenerWithAST(){

            public void selectionChanged(IEditorPart part, ITextSelection selection, CompilationUnit astRoot) {
                QuickAssistLightBulbUpdater.this.doSelectionChanged(selection.getOffset(), selection.getLength(), astRoot);
            }
        };
        SelectionListenerWithASTManager.getDefault().addListener(this.fEditor, this.fListener);
    }

    private void uninstallSelectionListener() {
        IAnnotationModel model;
        if (this.fListener != null) {
            SelectionListenerWithASTManager.getDefault().removeListener(this.fEditor, this.fListener);
            this.fListener = null;
        }
        if ((model = this.getAnnotationModel()) != null) {
            this.removeLightBulb(model);
        }
    }

    public void install() {
        if (this.isSetInPreferences()) {
            this.installSelectionListener();
        }
        if (this.fPropertyChangeListener == null) {
            this.fPropertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    QuickAssistLightBulbUpdater.this.doPropertyChanged(event.getProperty());
                }
            };
            PreferenceConstants.getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
        }
    }

    public void uninstall() {
        this.uninstallSelectionListener();
        if (this.fPropertyChangeListener != null) {
            PreferenceConstants.getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
    }

    protected void doPropertyChanged(String property) {
        if (property.equals("org.eclipse.jdt.quickassist.lightbulb")) {
            if (this.isSetInPreferences()) {
                ICompilationUnit cu = this.getCompilationUnit();
                if (cu != null) {
                    this.installSelectionListener();
                    Point point = this.fViewer.getSelectedRange();
                    ASTParser parser = ASTParser.newParser((int)2);
                    parser.setSource(cu);
                    parser.setResolveBindings(true);
                    CompilationUnit astRoot = (CompilationUnit)parser.createAST(null);
                    this.doSelectionChanged(point.x, point.y, astRoot);
                }
            } else {
                this.uninstallSelectionListener();
            }
        }
    }

    private ICompilationUnit getCompilationUnit() {
        IEditorInput input = this.fEditor.getEditorInput();
        Object elem = input.getAdapter(class$org$eclipse$jdt$core$IJavaElement == null ? (class$org$eclipse$jdt$core$IJavaElement = QuickAssistLightBulbUpdater.class$("org.eclipse.jdt.core.IJavaElement")) : class$org$eclipse$jdt$core$IJavaElement);
        if (elem instanceof ICompilationUnit) {
            return (ICompilationUnit)elem;
        }
        return null;
    }

    private IAnnotationModel getAnnotationModel() {
        return JavaUI.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
    }

    private IDocument getDocument() {
        return JavaUI.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
    }

    private void doSelectionChanged(int offset, int length, CompilationUnit astRoot) {
        IAnnotationModel model = this.getAnnotationModel();
        ICompilationUnit cu = this.getCompilationUnit();
        if (model == null || cu == null) {
            return;
        }
        AssistContext context = new AssistContext(cu, offset, length);
        context.setASTRoot(astRoot);
        boolean hasQuickFix = this.hasQuickFixLightBulb(model, context.getSelectionOffset());
        if (hasQuickFix) {
            this.removeLightBulb(model);
            return;
        }
        this.calculateLightBulb(model, context);
    }

    private void calculateLightBulb(IAnnotationModel model, IInvocationContext context) {
        boolean needsAnnotation = JavaCorrectionProcessor.hasAssists(context);
        if (this.fIsAnnotationShown) {
            model.removeAnnotation(this.fAnnotation);
        }
        if (needsAnnotation) {
            model.addAnnotation(this.fAnnotation, new Position(context.getSelectionOffset(), context.getSelectionLength()));
        }
        this.fIsAnnotationShown = needsAnnotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeLightBulb(IAnnotationModel model) {
        QuickAssistLightBulbUpdater quickAssistLightBulbUpdater = this;
        synchronized (quickAssistLightBulbUpdater) {
            if (this.fIsAnnotationShown) {
                model.removeAnnotation(this.fAnnotation);
                this.fIsAnnotationShown = false;
            }
        }
    }

    private boolean hasQuickFixLightBulb(IAnnotationModel model, int offset) {
        try {
            IDocument document = this.getDocument();
            if (document == null) {
                return false;
            }
            int currLine = document.getLineOfOffset(offset);
            Iterator iter = model.getAnnotationIterator();
            while (iter.hasNext()) {
                int startLine;
                Position pos;
                Annotation annot = (Annotation)iter.next();
                if (!JavaCorrectionProcessor.isQuickFixableType(annot) || (pos = model.getPosition(annot)) == null || (startLine = document.getLineOfOffset(pos.getOffset())) != currLine || !JavaCorrectionProcessor.hasCorrections(annot)) continue;
                return true;
            }
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
        catch (IndexOutOfBoundsException e) {
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class AssistAnnotation
    extends Annotation
    implements IAnnotationPresentation {
        private static final int LAYER;
        private Image fImage;

        public int getLayer() {
            return LAYER;
        }

        private Image getImage() {
            if (this.fImage == null) {
                this.fImage = JavaPluginImages.get("org.eclipse.jdt.ui.quickassist_obj.gif");
            }
            return this.fImage;
        }

        public void paint(GC gc, Canvas canvas, Rectangle r) {
            ImageUtilities.drawImage((Image)this.getImage(), (GC)gc, (Canvas)canvas, (Rectangle)r, (int)0x1000000, (int)128);
        }

        static {
            Annotation annotation = new Annotation("org.eclipse.jdt.ui.warning", false, null);
            AnnotationPreference preference = EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
            LAYER = preference != null ? preference.getPresentationLayer() - 1 : 0;
        }
    }
}

