/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.internal.ui.text.AbstractJavaScanner;
import org.eclipse.jdt.internal.ui.text.CombinedWordRule;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;

public class JavaCommentScanner
extends AbstractJavaScanner {
    private static final String COMPILER_TASK_TAGS = "org.eclipse.jdt.core.compiler.taskTags";
    protected static final String TASK_TAG = "java_comment_task_tag";
    private static final String COMPILER_TASK_CASE_SENSITIVE = "org.eclipse.jdt.core.compiler.taskCaseSensitive";
    private static final String ENABLED = "enabled";
    private TaskTagMatcher fTaskTagMatcher;
    private Preferences fCorePreferenceStore;
    private String fDefaultTokenProperty;
    private String[] fTokenProperties;

    public JavaCommentScanner(IColorManager manager, IPreferenceStore store, Preferences coreStore, String defaultTokenProperty) {
        this(manager, store, coreStore, defaultTokenProperty, new String[]{defaultTokenProperty, TASK_TAG});
    }

    public JavaCommentScanner(IColorManager manager, IPreferenceStore store, Preferences coreStore, String defaultTokenProperty, String[] tokenProperties) {
        super(manager, store);
        this.fCorePreferenceStore = coreStore;
        this.fDefaultTokenProperty = defaultTokenProperty;
        this.fTokenProperties = tokenProperties;
        this.initialize();
    }

    public JavaCommentScanner(IColorManager manager, IPreferenceStore store, String defaultTokenProperty) {
        this(manager, store, null, defaultTokenProperty, new String[]{defaultTokenProperty, TASK_TAG});
    }

    public JavaCommentScanner(IColorManager manager, IPreferenceStore store, String defaultTokenProperty, String[] tokenProperties) {
        this(manager, store, null, defaultTokenProperty, tokenProperties);
    }

    protected List createRules() {
        ArrayList<CombinedWordRule> list = new ArrayList<CombinedWordRule>();
        Token defaultToken = this.getToken(this.fDefaultTokenProperty);
        List matchers = this.createMatchers();
        if (matchers.size() > 0) {
            CombinedWordRule combinedWordRule = new CombinedWordRule((IWordDetector)new AtJavaIdentifierDetector(), (IToken)defaultToken);
            int n = matchers.size();
            for (int i = 0; i < n; ++i) {
                combinedWordRule.addWordMatcher((CombinedWordRule.WordMatcher)matchers.get(i));
            }
            list.add(combinedWordRule);
        }
        this.setDefaultReturnToken((IToken)defaultToken);
        return list;
    }

    protected List createMatchers() {
        ArrayList<TaskTagMatcher> list = new ArrayList<TaskTagMatcher>();
        boolean isCaseSensitive = true;
        String tasks = null;
        if (this.getPreferenceStore().contains(COMPILER_TASK_TAGS)) {
            tasks = this.getPreferenceStore().getString(COMPILER_TASK_TAGS);
            isCaseSensitive = ENABLED.equals(this.getPreferenceStore().getString(COMPILER_TASK_CASE_SENSITIVE));
        } else if (this.fCorePreferenceStore != null) {
            tasks = this.fCorePreferenceStore.getString(COMPILER_TASK_TAGS);
            isCaseSensitive = ENABLED.equals(this.fCorePreferenceStore.getString(COMPILER_TASK_CASE_SENSITIVE));
        }
        if (tasks != null) {
            this.fTaskTagMatcher = new TaskTagMatcher((IToken)this.getToken(TASK_TAG));
            this.fTaskTagMatcher.addTaskTags(tasks);
            this.fTaskTagMatcher.setCaseSensitive(isCaseSensitive);
            list.add(this.fTaskTagMatcher);
        }
        return list;
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return event.getProperty().equals(COMPILER_TASK_TAGS) || event.getProperty().equals(COMPILER_TASK_CASE_SENSITIVE) || super.affectsBehavior(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fTaskTagMatcher != null && event.getProperty().equals(COMPILER_TASK_TAGS)) {
            Object value = event.getNewValue();
            if (value instanceof String) {
                TaskTagMatcher taskTagMatcher = this.fTaskTagMatcher;
                synchronized (taskTagMatcher) {
                    this.fTaskTagMatcher.clearWords();
                    this.fTaskTagMatcher.addTaskTags((String)value);
                }
            }
        } else if (this.fTaskTagMatcher != null && event.getProperty().equals(COMPILER_TASK_CASE_SENSITIVE)) {
            Object value = event.getNewValue();
            if (value instanceof String) {
                this.fTaskTagMatcher.setCaseSensitive(ENABLED.equals(value));
            }
        } else if (super.affectsBehavior(event)) {
            super.adaptToPreferenceChange(event);
        }
    }

    protected String[] getTokenProperties() {
        return this.fTokenProperties;
    }

    private class TaskTagMatcher
    extends CombinedWordRule.WordMatcher {
        private IToken fToken;
        private Map fUppercaseWords = new HashMap();
        private boolean fCaseSensitive = true;
        private CombinedWordRule.CharacterBuffer fBuffer = new CombinedWordRule.CharacterBuffer(16);

        public TaskTagMatcher(IToken token) {
            this.fToken = token;
        }

        public synchronized void clearWords() {
            super.clearWords();
            this.fUppercaseWords.clear();
        }

        public synchronized void addTaskTags(String value) {
            String[] tasks = this.split(value, ",");
            for (int i = 0; i < tasks.length; ++i) {
                if (tasks[i].length() <= 0) continue;
                this.addWord(tasks[i], this.fToken);
            }
        }

        private String[] split(String value, String delimiters) {
            StringTokenizer tokenizer = new StringTokenizer(value, delimiters);
            int size = tokenizer.countTokens();
            String[] tokens = new String[size];
            int i = 0;
            while (i < size) {
                tokens[i++] = tokenizer.nextToken();
            }
            return tokens;
        }

        public synchronized void addWord(String word, IToken token) {
            Assert.isNotNull((Object)word);
            Assert.isNotNull((Object)token);
            super.addWord(word, token);
            this.fUppercaseWords.put(new CombinedWordRule.CharacterBuffer(word.toUpperCase()), token);
        }

        public synchronized IToken evaluate(ICharacterScanner scanner, CombinedWordRule.CharacterBuffer word) {
            if (this.fCaseSensitive) {
                return super.evaluate(scanner, word);
            }
            this.fBuffer.clear();
            int n = word.length();
            for (int i = 0; i < n; ++i) {
                this.fBuffer.append(Character.toUpperCase(word.charAt(i)));
            }
            IToken token = (IToken)this.fUppercaseWords.get(this.fBuffer);
            if (token != null) {
                return token;
            }
            return Token.UNDEFINED;
        }

        public boolean isCaseSensitive() {
            return this.fCaseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.fCaseSensitive = caseSensitive;
        }
    }

    private static class AtJavaIdentifierDetector
    implements IWordDetector {
        private AtJavaIdentifierDetector() {
        }

        public boolean isWordStart(char c) {
            return c == '@' || Character.isJavaIdentifierStart(c);
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }
    }
}

