/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.contentassist;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.refactoring.contentassist.CUPositionCompletionProcessor;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jface.resource.ImageDescriptor;

public class JavaTypeCompletionProcessor
extends CUPositionCompletionProcessor {
    private static final String DUMMY_CLASS_NAME = "$$__$$";
    public static final String DUMMY_CU_NAME = "$$__$$.java";
    private static final String CU_START = "public class $$__$$ { ";
    private static final String CU_END = " }";

    public JavaTypeCompletionProcessor(boolean enableBaseTypes, boolean enableVoid) {
        super(new TypeCompletionRequestor(enableBaseTypes, enableVoid));
    }

    public void setPackageFragment(IPackageFragment packageFragment) {
        if (packageFragment == null) {
            this.setCompletionContext(null, null, null);
        } else {
            this.setCompletionContext(packageFragment.getCompilationUnit(DUMMY_CU_NAME), CU_START, CU_END);
        }
    }

    public void setExtendsCompletionContext(IPackageFragment packageFragment) {
        ICompilationUnit cu = packageFragment.getCompilationUnit(DUMMY_CU_NAME);
        this.setCompletionContext(cu, "public class $$__$$ extends ", " {}");
    }

    public void setImplementsCompletionContext(IPackageFragment packageFragment) {
        ICompilationUnit cu = packageFragment.getCompilationUnit(DUMMY_CU_NAME);
        this.setCompletionContext(cu, "public class $$__$$ implements ", " {}");
    }

    protected static class TypeCompletionRequestor
    extends CUPositionCompletionProcessor.CUPositionCompletionRequestor {
        private static final String VOID = "void";
        private static final List BASE_TYPES = Arrays.asList("boolean", "byte", "char", "double", "float", "int", "long", "short");
        private boolean fEnableBaseTypes;
        private boolean fEnableVoid;

        public TypeCompletionRequestor(boolean enableBaseTypes, boolean enableVoid) {
            this.fEnableBaseTypes = enableBaseTypes;
            this.fEnableVoid = enableVoid;
        }

        public void acceptClass(char[] packageName, char[] typeName, char[] completionName, int modifiers, int start, int end, int relevance) {
            if (TypeCompletionRequestor.isDummyClass(typeName)) {
                return;
            }
            ImageDescriptor descriptor = JavaElementImageProvider.getTypeImageDescriptor(false, false, false, modifiers);
            this.addAdjustedTypeCompletion(packageName, typeName, completionName, start, end, relevance, descriptor);
        }

        public void acceptInterface(char[] packageName, char[] typeName, char[] completionName, int modifiers, int start, int end, int relevance) {
            if (TypeCompletionRequestor.isDummyClass(typeName)) {
                return;
            }
            ImageDescriptor descriptor = JavaElementImageProvider.getTypeImageDescriptor(true, false, false, modifiers);
            this.addAdjustedTypeCompletion(packageName, typeName, completionName, start, end, relevance, descriptor);
        }

        public void acceptKeyword(char[] keywordName, int start, int end, int relevance) {
            if (!this.fEnableBaseTypes) {
                return;
            }
            String keyword = new String(keywordName);
            if (this.fEnableVoid && VOID.equals(keyword) || this.fEnableBaseTypes && BASE_TYPES.contains(keyword)) {
                this.addAdjustedCompletion(keyword, keyword, start, end, relevance, null);
            }
        }

        public void acceptPackage(char[] packageName, char[] completionName, int start, int end, int relevance) {
            this.addAdjustedCompletion(new String(packageName), new String(completionName), start, end, relevance, JavaPluginImages.DESC_OBJS_PACKAGE);
        }

        public void acceptType(char[] packageName, char[] typeName, char[] completionName, int start, int end, int relevance) {
            if (TypeCompletionRequestor.isDummyClass(typeName)) {
                return;
            }
            this.addAdjustedTypeCompletion(packageName, typeName, completionName, start, end, relevance, JavaPluginImages.DESC_OBJS_CLASS);
        }

        private static boolean isDummyClass(char[] typeName) {
            return new String(typeName).equals(JavaTypeCompletionProcessor.DUMMY_CLASS_NAME);
        }
    }
}

