/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeTypeRefactoring;
import org.eclipse.jdt.internal.ui.refactoring.ChangeTypeContentProvider;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ChangeTypeWizard
extends RefactoringWizard {
    public ChangeTypeWizard(ChangeTypeRefactoring ref) {
        super((Refactoring)ref, 4);
        this.setDefaultPageTitle(RefactoringMessages.getString("ChangeTypeWizard.title"));
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new ChangeTypeInputPage());
    }

    static String print(Collection types) {
        if (types.isEmpty()) {
            return "{ }";
        }
        String result = "{ ";
        Iterator it = types.iterator();
        while (it.hasNext()) {
            IType type = (IType)it.next();
            result = result + type.getFullyQualifiedName();
            if (it.hasNext()) {
                result = result + ", ";
                continue;
            }
            result = result + " }";
        }
        return result;
    }

    private class ChangeTypeInputPage
    extends UserInputWizardPage {
        public static final String PAGE_NAME = "ChangeTypeInputPage";
        private final String MESSAGE = RefactoringMessages.getString("ChangeTypeInputPage.Select_Type");
        private ChangeTypeLabelProvider fLabelProvider;
        private TreeViewer fTreeViewer;
        private boolean fTreeUpdated = false;

        public ChangeTypeInputPage() {
            super(PAGE_NAME);
            this.setMessage(this.MESSAGE);
        }

        private TreeItem getInitialSelection(Collection types) {
            IType type = (IType)types.iterator().next();
            Iterator it = types.iterator();
            while (it.hasNext()) {
                IType other = (IType)it.next();
                if (!this.getGeneralizeTypeRefactoring().isSubTypeOf(type, other)) continue;
                type = other;
            }
            return this.findItem(this.fTreeViewer.getTree().getItems(), type);
        }

        private TreeItem findItem(TreeItem[] items, IType type) {
            int i;
            for (i = 0; i < items.length; ++i) {
                if (!items[i].getData().equals(type)) continue;
                return items[i];
            }
            for (i = 0; i < items.length; ++i) {
                TreeItem item = this.findItem(items[i].getItems(), type);
                if (item == null) continue;
                return item;
            }
            return null;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            this.setControl((Control)composite);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData());
            Label label = new Label(composite, 0);
            label.setText(RefactoringMessages.getString("ChangeTypeWizard.pleaseChooseType"));
            label.setLayoutData((Object)new GridData());
            this.addTreeComponent(composite);
            Dialog.applyDialogFont((Control)composite);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void addTreeComponent(Composite parent) {
            GridData gd;
            block3: {
                this.fTreeViewer = new TreeViewer(parent, 2820);
                gd = new GridData(1808);
                gd.grabExcessHorizontalSpace = true;
                gd.grabExcessVerticalSpace = true;
                GC gc = null;
                try {
                    gc = new GC((Drawable)parent);
                    gc.setFont(gc.getFont());
                    gd.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)6);
                    Object var5_4 = null;
                    if (gc == null) break block3;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (gc != null) {
                        gc.dispose();
                        gc = null;
                    }
                    throw throwable;
                }
                gc.dispose();
                gc = null;
            }
            this.fTreeViewer.getTree().setLayoutData((Object)gd);
            this.fTreeViewer.setContentProvider((IContentProvider)new ChangeTypeContentProvider((ChangeTypeRefactoring)this.getRefactoring()));
            this.fLabelProvider = new ChangeTypeLabelProvider();
            this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
            ISelectionChangedListener listener = new ISelectionChangedListener(this){
                private final /* synthetic */ ChangeTypeInputPage this$1;
                {
                    this.this$1 = this$1;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    ChangeTypeInputPage.access$700(this.this$1, (IType)selection.getFirstElement());
                }
            };
            this.fTreeViewer.addSelectionChangedListener(listener);
            this.fTreeViewer.setInput((Object)new ChangeTypeContentProvider.RootType(this.getGeneralizeTypeRefactoring().getOriginalType()));
            this.fTreeViewer.expandToLevel(10);
        }

        private void typeSelected(IType type) {
            boolean isValid = this.getGeneralizeTypeRefactoring().getValidTypes().contains(type);
            this.setPageComplete(isValid);
            if (isValid) {
                this.setMessage("");
            } else if (this.getGeneralizeTypeRefactoring().getOriginalType().equals(type)) {
                this.setMessage(RefactoringMessages.getFormattedString("ChangeTypeWizard.with_itself", type.getElementName()));
            } else {
                this.setMessage(RefactoringMessages.getFormattedString("ChangeTypeWizard.grayed_types", new Object[]{type.getElementName(), this.getGeneralizeTypeRefactoring().getOriginalType().getElementName()}));
            }
        }

        private void grayOutInvalidTypes(TreeItem[] items) {
            for (int i = 0; i < items.length; ++i) {
                TreeItem item = items[i];
                String itemName = ((IType)item.getData()).getFullyQualifiedName();
                ChangeTypeRefactoring ct = (ChangeTypeRefactoring)this.getRefactoring();
                Collection validTypeNames = ct.getValidTypeNames();
                if (!validTypeNames.contains(itemName)) {
                    item.setForeground(Display.getCurrent().getSystemColor(18));
                }
                this.grayOutInvalidTypes(items[i].getItems());
            }
        }

        private ChangeTypeRefactoring getGeneralizeTypeRefactoring() {
            return (ChangeTypeRefactoring)this.getRefactoring();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            return super.getNextPage();
        }

        private IType getSelectedType() {
            IStructuredSelection ss = (IStructuredSelection)this.fTreeViewer.getSelection();
            return (IType)ss.getFirstElement();
        }

        public boolean performFinish() {
            this.initializeRefactoring();
            return super.performFinish();
        }

        private void initializeRefactoring() {
            this.getGeneralizeTypeRefactoring().setSelectedType(this.getSelectedType());
        }

        public void dispose() {
            this.fTreeViewer = null;
            super.dispose();
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible && this.fTreeViewer != null) {
                this.fTreeViewer.getTree().setFocus();
            }
            if (!this.fTreeUpdated) {
                this.fTreeViewer.getTree().getDisplay().asyncExec((Runnable)new ValidTypesTask());
                this.fTreeUpdated = true;
            }
        }

        static /* synthetic */ ChangeTypeWizard access$100(ChangeTypeInputPage x0) {
            return x0.ChangeTypeWizard.this;
        }

        static /* synthetic */ void access$700(ChangeTypeInputPage x0, IType x1) {
            x0.typeSelected(x1);
        }

        private class ValidTypesTask
        implements Runnable {
            private Collection fInvalidTypes;
            private Collection fValidTypes;

            private ValidTypesTask() {
            }

            public void run() {
                IRunnableWithProgress runnable = new IRunnableWithProgress(this){
                    private final /* synthetic */ ValidTypesTask this$2;
                    {
                        this.this$2 = this$2;
                    }

                    public void run(IProgressMonitor pm) {
                        pm.beginTask(RefactoringMessages.getString("ChangeTypeWizard.analyzing"), 1000);
                        ChangeTypeRefactoring ct = (ChangeTypeRefactoring)ChangeTypeInputPage.access$100(ValidTypesTask.access$000(this.this$2)).getRefactoring();
                        ValidTypesTask.access$202(this.this$2, new HashSet<E>());
                        ValidTypesTask.access$200(this.this$2).addAll(Arrays.asList(ct.getTypeHierarchy().getAllSupertypes(ct.getOriginalType())));
                        ValidTypesTask.access$302(this.this$2, ct.computeValidTypes((IProgressMonitor)new SubProgressMonitor(pm, 950)));
                        ValidTypesTask.access$200(this.this$2).add(ct.getOriginalType());
                        ValidTypesTask.access$200(this.this$2).removeAll(ValidTypesTask.access$300(this.this$2));
                        pm.worked(50);
                        pm.done();
                    }
                };
                try {
                    ChangeTypeInputPage.this.getWizard().getContainer().run(true, true, runnable);
                }
                catch (InvocationTargetException e) {
                    ChangeTypeInputPage.this.setErrorMessage(RefactoringMessages.getString("ChangeTypeWizard.internalError"));
                }
                catch (InterruptedException e) {
                    ChangeTypeInputPage.this.setMessage(RefactoringMessages.getString("ChangeTypeWizard.computationInterrupted"));
                }
                Tree tree = ChangeTypeInputPage.this.fTreeViewer.getTree();
                ChangeTypeInputPage.this.fTreeViewer.expandToLevel(10);
                ChangeTypeInputPage.this.grayOutInvalidTypes(tree.getItems());
                if (this.fValidTypes == null || this.fValidTypes.size() == 0) {
                    ChangeTypeInputPage.this.setErrorMessage(RefactoringMessages.getString("ChangeTypeWizard.declCannotBeChanged"));
                    ChangeTypeInputPage.this.setPageComplete(false);
                } else {
                    TreeItem selection = ChangeTypeInputPage.this.getInitialSelection(this.fValidTypes);
                    ChangeTypeInputPage.this.fTreeViewer.getTree().setSelection(new TreeItem[]{selection});
                    ChangeTypeInputPage.this.setPageComplete(true);
                    ChangeTypeInputPage.this.setMessage("");
                }
            }

            static /* synthetic */ ChangeTypeInputPage access$000(ValidTypesTask x0) {
                return x0.ChangeTypeInputPage.this;
            }

            static /* synthetic */ Collection access$202(ValidTypesTask x0, Collection x1) {
                x0.fInvalidTypes = x1;
                return x0.fInvalidTypes;
            }

            static /* synthetic */ Collection access$200(ValidTypesTask x0) {
                return x0.fInvalidTypes;
            }

            static /* synthetic */ Collection access$302(ValidTypesTask x0, Collection x1) {
                x0.fValidTypes = x1;
                return x0.fValidTypes;
            }

            static /* synthetic */ Collection access$300(ValidTypesTask x0) {
                return x0.fValidTypes;
            }
        }
    }

    private class ChangeTypeLabelProvider
    extends JavaElementLabelProvider
    implements IColorProvider {
        private Collection fInvalidTypes;
        private Color fGrayColor = Display.getCurrent().getSystemColor(18);
        private Color fCurrentBackgroundColor;

        public void grayOut(Collection invalidTypes) {
            this.fInvalidTypes = invalidTypes;
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this, this.fInvalidTypes.toArray()));
        }

        public Color getForeground(Object element) {
            if (this.fInvalidTypes == null) {
                return null;
            }
            if (this.fInvalidTypes.contains(element)) {
                return this.fGrayColor;
            }
            return null;
        }

        public Color getBackground(Object element) {
            return this.fCurrentBackgroundColor;
        }
    }
}

